/*
 * Decompiled with CFR 0.152.
 */
package org.clinicacolonial.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModCCDivideInvoice
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCCDivideInvoice.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        MInvoice inv;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 8 && po.get_Table_ID() == MInvoice.Table_ID && (inv = (MInvoice)((Object)po)).getC_Order_ID() > 0) {
            int charge_ID;
            MOrder ord = new MOrder(po.getCtx(), inv.getC_Order_ID(), po.get_TrxName());
            BigDecimal amtSplit = (BigDecimal)ord.get_Value("AmountSplit");
            if (amtSplit == null) {
                amtSplit = Env.ZERO;
            }
            if (ord.isSOTrx() && amtSplit.compareTo(Env.ZERO) > 0 && (charge_ID = DB.getSQLValue((String)po.get_TrxName(), (String)"SELECT C_Charge_ID FROM C_Charge WHERE IsActive='Y' AND description like 'atencion medica'")) > 0) {
                DB.executeUpdate((String)("DELETE FROM C_InvoiceLine WHERE C_Invoice_ID=" + inv.get_ID()), (String)po.get_TrxName());
                MInvoiceLine iLine = new MInvoiceLine(inv);
                iLine.setC_Charge_ID(charge_ID);
                iLine.setQty(Env.ONE);
                iLine.setPrice(ord.getTotalLines().subtract(amtSplit));
                iLine.setC_Tax_ID(2000002);
                if (!iLine.save(po.get_TrxName())) {
                    throw new AdempiereException("Could not create Invoice Line");
                }
                int ID_BPIs = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT ci.C_Bpartner_ID FROM CC_Isapre ci INNER JOIN C_Bpartner bp ON (ci.CC_Isapre_ID = bp.CC_Isapre_ID) AND bp.C_BPartner_ID=" + ord.getC_BPartner_ID()));
                if (ID_BPIs <= 0) {
                    ID_BPIs = ord.getC_BPartner_ID();
                }
                MDocType dt = MDocType.get((Properties)po.getCtx(), (int)ord.getC_DocType_ID());
                MInvoice inv2 = this.createInvoice(dt, inv.getDateInvoiced(), ord, po, inv, ID_BPIs);
                MInvoiceLine iLine2 = new MInvoiceLine(inv2);
                iLine2.setC_Charge_ID(charge_ID);
                iLine2.setQty(Env.ONE);
                iLine2.setPrice(amtSplit);
                iLine2.setC_Tax_ID(2000002);
                if (!iLine2.save(po.get_TrxName())) {
                    throw new AdempiereException("Could not create Invoice Line");
                }
                DB.executeUpdate((String)("UPDATE C_OrderLine SET QtyInvoiced=QtyEntered WHERE C_Order_ID=" + ord.get_ID()), (String)po.get_TrxName());
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }

    private MInvoice createInvoice(MDocType dt, Timestamp invoiceDate, MOrder order, PO po, MInvoice inv, int ID_BPIs) {
        log.info(dt.toString());
        MInvoice invoice = new MInvoice(order, dt.getC_DocTypeInvoice_ID(), invoiceDate);
        invoice.setDescription("Generado desde factura " + inv.getDocumentNo() + " y orden " + order.getDocumentNo());
        invoice.setC_BPartner_ID(ID_BPIs);
        if (!invoice.save(po.get_TrxName())) {
            throw new AdempiereException("Could not create Invoice");
        }
        return invoice;
    }
}

