/*
 * Decompiled with CFR 0.152.
 */
package org.cencosud.process;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class LoadFileQ
extends SvrProcess {
    private int p_ID_Order;
    private String p_PathFile;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("archivo")) {
                    this.p_PathFile = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_ID_Order = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        String rutaArchivo;
        MOrder order = new MOrder(this.getCtx(), this.p_ID_Order, this.get_TrxName());
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setGroupingSeparator('.');
        symbols.setDecimalSeparator(',');
        String pattern = "#,##0.0#";
        DecimalFormat decimalFormat = new DecimalFormat(pattern, symbols);
        decimalFormat.setParseBigDecimal(true);
        String pFile = rutaArchivo = this.p_PathFile;
        ArrayList<String[]> datos = new ArrayList<String[]>();
        int cantLines = 0;
        try {
            FileInputStream fis = new FileInputStream(pFile);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "ISO-8859-1");
            BufferedReader br = new BufferedReader(isr);
            String linea = br.readLine();
            while (linea != null) {
                datos.add(linea.split(";"));
                linea = br.readLine();
                ++cantLines;
            }
            br.close();
            isr.close();
            fis.close();
            int x = 0;
            while (x < cantLines) {
                int ID_Locator = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT MAX(M_Locator_ID) FROM M_Locator WHERE IsActive = 'Y' AND value like '" + ((String[])datos.get(x))[2] + "'"));
                int ID_PGroup = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT MAX(M_Product_Group_ID) FROM M_Product_Group WHERE IsActive = 'Y' AND value like '" + ((String[])datos.get(x))[0] + "'"));
                if (ID_Locator > 0 && ID_PGroup > 0) {
                    BigDecimal qty = (BigDecimal)decimalFormat.parse(((String[])datos.get(x))[13].trim());
                    int ID_OLine = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT MAX(C_OrderLine_ID) FROM C_OrderLine WHERE IsActive = 'Y' AND C_Order_ID=" + this.p_ID_Order + " AND M_Locator_ID=" + ID_Locator + " AND M_Product_Group_ID=" + ID_PGroup));
                    BigDecimal qtyBox = DB.getSQLValueBD((String)this.get_TrxName(), (String)("SELECT Qty FROM M_Product_Group WHERE M_Product_Group_ID=" + ID_PGroup), (Object[])new Object[0]);
                    if (qtyBox == null) {
                        qtyBox = Env.ONE;
                    }
                    qtyBox = qty.divide(qtyBox, 0, RoundingMode.HALF_EVEN);
                    if (ID_OLine > 0) {
                        DB.executeUpdate((String)("UPDATE C_OrderLine SET qpFinal=" + qty + " WHERE C_OrderLine_ID = " + ID_OLine), (String)this.get_TrxName());
                        DB.executeUpdate((String)("UPDATE C_OrderLine SET qpFinalBox=" + qtyBox + " WHERE C_OrderLine_ID = " + ID_OLine), (String)this.get_TrxName());
                    } else {
                        MOrderLine line = new MOrderLine(order);
                        int NoLine = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT MAX(Line) FROM C_OrderLine WHERE C_Order_ID=" + this.p_ID_Order));
                        line.setLine(NoLine + 10);
                        line.setM_Product_ID(2004195);
                        line.setQty(qty);
                        line.setPrice();
                        line.setTax();
                        line.setLineNetAmt();
                        line.setC_Tax_ID(2000002);
                        line.setDescription("Linea Creada por importacion de q");
                        line.set_CustomColumn("M_Locator_ID", ID_Locator);
                        line.set_CustomColumn("qpc", qty);
                        line.set_CustomColumn("M_Product_Group_ID", ID_PGroup);
                        line.saveEx(this.get_TrxName());
                    }
                }
                ++x;
            }
            datos = null;
        }
        catch (Exception e) {
            this.log.config("ERROR: " + e);
        }
        return "PROCESADO";
    }
}

