/*
 * Decompiled with CFR 0.152.
 */
package org.cencosud.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.X_I_VendorCencosud;
import org.compiere.model.X_M_VendorCencosud;
import org.compiere.model.X_M_VendorCencosudLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

public class ImportVendorCencosud
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private int p_AD_Org_ID = 0;
    private boolean p_DeleteOldImported = false;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Client_ID")) {
                    this.p_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("DeleteOldImported")) {
                    this.p_DeleteOldImported = "Y".equals(para[i].getParameter());
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = " AND AD_Client_ID=" + this.p_AD_Client_ID;
        if (this.p_DeleteOldImported) {
            sql = new StringBuffer("DELETE I_VendorCencosud WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.log.fine("Delete Old Imported=" + no);
        }
        sql = new StringBuffer("UPDATE I_VendorCencosud SET AD_Client_ID = COALESCE (AD_Client_ID,").append(this.p_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID,").append(this.p_AD_Org_ID).append("),");
        sql.append(" IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = ' ', I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.info("Reset=" + no);
        sql = new StringBuffer("UPDATE I_VendorCencosud o SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Org, 'WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0 OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N'))) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Org=" + no);
        }
        sql = new StringBuffer("UPDATE I_VendorCencosud i SET M_Locator_ID=(SELECT MAX(M_Locator_ID) FROM M_Locator l WHERE i.LocatorValue=l.Value AND i.AD_Client_ID=l.AD_Client_ID) WHERE M_Locator_ID IS NULL AND LocatorValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Locator from Value =" + no);
        this.log.fine("Set Locator from X,Y,Z =" + no);
        sql = new StringBuffer("UPDATE I_VendorCencosud SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Location, ' WHERE M_Locator_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("No Location=" + no);
        }
        sql = new StringBuffer("UPDATE I_VendorCencosud i SET M_Product_Group_ID=(SELECT MAX(M_Product_Group_ID) FROM M_Product_Group p WHERE i.ProductGroupValue=p.Value AND i.AD_Client_ID=p.AD_Client_ID) WHERE M_Product_Group_ID IS NULL AND ProductGroupValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Product Group from Value=" + no);
        if (no != 0) {
            this.log.warning("No Product Group=" + no);
        }
        this.commitEx();
        Object inventory = null;
        X_M_VendorCencosud vcenco = null;
        int noInsert = 0;
        int noInsertLine = 0;
        sql = new StringBuffer("SELECT * FROM I_VendorCencosud WHERE I_IsImported='N'").append(clientCheck).append(" ORDER BY M_Locator_ID, TRUNC(Datetrx), I_VendorCencosud_ID");
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            int x_M_Locator_ID = -1;
            Timestamp x_Datetrx = null;
            while (rs.next()) {
                X_I_VendorCencosud imp = new X_I_VendorCencosud(this.getCtx(), rs, this.get_TrxName());
                Timestamp Datetrx = TimeUtil.getDay((Timestamp)imp.getDateTrx());
                if (vcenco == null || imp.getM_Locator_ID() != x_M_Locator_ID || !Datetrx.equals(x_Datetrx)) {
                    String sqlgetid = "SELECT coalesce(max(m_vendorcencosud_id),0) from m_vendorcencosud  where m_locator_id = " + imp.getM_Locator_ID() + " and " + " m_product_group_id = " + imp.getM_Product_Group_ID() + " and " + " datetrx = '" + imp.getDateTrx() + "'";
                    int id = DB.getSQLValue((String)this.get_TrxName(), (String)sqlgetid);
                    vcenco = id > 0 ? new X_M_VendorCencosud(this.getCtx(), id, this.get_TrxName()) : new X_M_VendorCencosud(this.getCtx(), 0, this.get_TrxName());
                    vcenco.setAD_Org_ID(imp.getAD_Org_ID());
                    vcenco.setM_Locator_ID(imp.getM_Locator_ID());
                    vcenco.setDateTrx(Datetrx);
                    vcenco.setM_Product_Group_ID(imp.getM_Product_Group_ID());
                    if (!vcenco.save()) {
                        this.log.log(Level.SEVERE, "Vcenco not saved");
                        break;
                    }
                    x_M_Locator_ID = imp.getM_Locator_ID();
                    x_Datetrx = Datetrx;
                    ++noInsert;
                }
                X_M_VendorCencosudLine line = new X_M_VendorCencosudLine(this.getCtx(), 0, this.get_TrxName());
                line.setM_VendorCencosud_ID(vcenco.getM_VendorCencosud_ID());
                line.setDateStart(imp.getDateStart());
                line.setDateEnd(imp.getDateEnd());
                line.setRutOC(imp.getRutOC());
                line.setRutOT(imp.getRutOT());
                line.setPercentage(imp.getPercentage());
                line.setWeight(imp.getWeight());
                line.setWeightedAmt(imp.getWeightedAmt());
                line.saveEx();
                line.saveEx();
                imp.setI_IsImported(true);
                imp.setM_VendorCencosud_ID(line.getM_VendorCencosud_ID());
                imp.setProcessed(true);
                imp.saveEx();
                ++noInsertLine;
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        sql = new StringBuffer("UPDATE I_VendorCencosud SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@M_VendorCencosud_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noInsertLine), "@M_VendorCencosudLine_ID@: @Inserted@");
        return "";
    }
}

