/*
 * Decompiled with CFR 0.152.
 */
package org.blumos.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.compiere.model.MBPartner;
import org.compiere.model.X_C_ProjectOFB;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.ofb.process.CXFConnector;
import org.ofb.utils.DateUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSProyecto
extends SvrProcess {
    private Properties m_ctx;
    private int p_Projecto_ID = 0;

    protected void prepare() {
        this.p_Projecto_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    protected String doIt() throws Exception {
        Timestamp dataDepto;
        BigDecimal costo_max;
        String statuslegal;
        BigDecimal pVolumen;
        BigDecimal pvalor;
        Timestamp dataEntrega;
        X_C_ProjectOFB pro = new X_C_ProjectOFB(this.m_ctx, this.p_Projecto_ID, this.get_TrxName());
        MBPartner cli = new MBPartner(this.getCtx(), pro.getC_BPartner_ID(), this.get_TrxName());
        Timestamp dataEntrada = pro.getCreated();
        if (dataEntrada == null) {
            dataEntrada = DateUtils.today();
        }
        if ((dataEntrega = (Timestamp)pro.get_Value("DateFinish")) == null) {
            dataEntrega = DateUtils.today();
        }
        if ((pvalor = (BigDecimal)pro.get_Value("PlannedMarginAmt")) == null) {
            pvalor = Env.ZERO;
        }
        if ((pVolumen = (BigDecimal)pro.get_Value("PlannedAmt")) == null) {
            pVolumen = Env.ZERO;
        }
        if ((statuslegal = pro.get_ValueAsString("status_legal")) != null && statuslegal.compareTo("No Aplica") == 0) {
            statuslegal = "NA";
        }
        if ((costo_max = (BigDecimal)pro.get_Value("costo_dosis")) == null) {
            costo_max = Env.ZERO;
        }
        if ((dataDepto = (Timestamp)pro.get_Value("DateContractSignature")) == null) {
            dataDepto = DateUtils.today();
        }
        BigDecimal potSuceso = (BigDecimal)pro.get_Value("CompletePercentage");
        String salida = this.llamarWSProyecto(Integer.toString(pro.get_ID()), String.valueOf(cli.getValue()) + "-" + cli.get_ValueAsString("Digito"), pro.getSalesRep().getName(), this.convertDate(dataEntrada), this.convertDate(dataEntrega), pvalor, pro.getName(), pro.get_ValueAsString("proceso_productivo_cliente"), pVolumen, statuslegal, pro.getNote(), costo_max, pro.get_ValueAsString("Aplicacion_solutec"), this.convertDate(dataDepto), this.convertDate(dataDepto), pro.getAD_User().getName(), pro.get_ValueAsString("estado_aplicacion"), Integer.toString(potSuceso.intValue()));
        pro.set_CustomColumn("StatusWS", salida);
        pro.set_CustomColumn("iswebservicefs", true);
        pro.saveEx(this.get_TrxName());
        return salida;
    }

    private String llamarWSProyecto(String prAdempiere, String rut, String codVendedor, String dataEntrada, String dataEntrega, BigDecimal PValor, String desProjeto, String codAplicacion, BigDecimal PotVolume, String statusLegal, String briefing, BigDecimal custoMax, String depto, String dataDepto, String dataStatus, String usuario, String tipoProduto, String potSucesso) throws Exception {
        String token = "";
        String request = "<soapenv:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:urn=\"urn:ProjetoIntIntf-IProjetoInt\">   <soapenv:Header/>   <soapenv:Body>      <urn:InserirProyecto soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">         <numero_projeto_adempiere xsi:type=\"xsd:string\">" + prAdempiere + "</numero_projeto_adempiere>" + "         <rut_cliente xsi:type=\"xsd:string\">" + rut + "</rut_cliente>" + "         <codigo_vendedor_adempiere xsi:type=\"xsd:string\">" + codVendedor + "</codigo_vendedor_adempiere>" + "         <data_entrada xsi:type=\"xsd:string\">" + dataEntrada + "</data_entrada>" + "         <data_entrega xsi:type=\"xsd:string\">" + dataEntrega + "</data_entrega>" + "         <Potencial_Valor xsi:type=\"xsd:double\">" + PValor + "</Potencial_Valor>" + "         <descricao_projeto xsi:type=\"xsd:string\">" + desProjeto + "</descricao_projeto>" + "         <codigo_aplicacao xsi:type=\"xsd:string\">" + codAplicacion + "</codigo_aplicacao>" + "         <Potencial_Volume xsi:type=\"xsd:double\">" + PotVolume.doubleValue() + "</Potencial_Volume>" + "         <status_legal>" + statusLegal + "</status_legal>" + "         <briefing>" + briefing + "</briefing>" + "         <custo_max>" + custoMax.doubleValue() + "</custo_max>" + "         <depto>" + depto + "</depto>" + "         <data_depto>" + dataDepto + "</data_depto>" + "         <data_status>" + dataStatus + "</data_status>" + "         <usuario>" + usuario + "</usuario>" + "         <tipo_produto>" + tipoProduto + "</tipo_produto>" + "         <potencial_sucesso>" + potSucesso + "</potencial_sucesso>" + "      </urn:InserirProyecto>" + "   </soapenv:Body>" + "</soapenv:Envelope>";
        Source response = null;
        this.log.config("request: " + request);
        CXFConnector wsc = new CXFConnector();
        wsc.setSoapAction("urn:ProjetoIntIntf-IProjetoInt#InserirProyecto");
        wsc.setRequest(request);
        wsc.setBinding("http://schemas.xmlsoap.org/wsdl/soap/http");
        wsc.setEndpointAddress("http://100.100.100.111:8080/soap/IProjetoInt");
        wsc.setServiceName("IProjetoIntservice");
        wsc.setPortName("IProjetoIntPort");
        wsc.setTargetNS("urn:ProjetoIntIntf-IProjetoInt");
        wsc.executeConnector();
        response = wsc.getResponse();
        try {
            DocumentBuilderFactory.newInstance().newDocumentBuilder();
            SAXSource output = (SAXSource)response;
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            DOMResult result = new DOMResult();
            tf.transform(output, result);
            Document doc = (Document)result.getNode();
            Node datos = this.findReturn(doc.getChildNodes().item(0));
            if (datos != null) {
                NodeList att = datos.getChildNodes();
                int x = 0;
                while (x < att.getLength()) {
                    this.log.config(att.item(x).getLocalName());
                    if (att.item(x).getLocalName().equals("return") || att.item(x).getNodeName().equals("return")) {
                        token = att.item(x).getFirstChild().getNodeValue();
                    }
                    ++x;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return token;
    }

    public Node findReturn(Node node) {
        Node value = null;
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node childNode = list.item(i);
            if (childNode.getNodeName().equals("NS1:InserirProyectoResponse")) {
                value = childNode;
                break;
            }
            value = this.findReturn(childNode);
            ++i;
        }
        return value;
    }

    public String findText(String cadena, String fragmentoIni, String fragmentoFin) {
        String newText = "";
        int indiceIni = 0;
        int indiceFin = 0;
        boolean flag = cadena.contains(fragmentoIni);
        if (flag) {
            indiceIni = cadena.indexOf(fragmentoIni);
            indiceFin = cadena.indexOf(fragmentoFin);
            newText = cadena.substring(indiceIni += fragmentoIni.length(), indiceFin);
        } else {
            newText = "Error - No existe Cadena Especificada";
        }
        return newText;
    }

    public String convertDate(Timestamp fecha) {
        String salida = "";
        salida = fecha.getMonth() + 1 < 10 ? "0" + (fecha.getMonth() + 1) : Integer.toString(fecha.getMonth() + 1);
        salida = fecha.getDate() < 10 ? String.valueOf(salida) + "/0" + fecha.getDate() : String.valueOf(salida) + "/" + Integer.toString(fecha.getDate());
        salida = String.valueOf(salida) + "/" + (fecha.getYear() + 1900);
        return salida;
    }
}

