/*
 * Decompiled with CFR 0.152.
 */
package org.blumos.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.compiere.acct.FactLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MInOut;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModBlumosAcctShipmentSonutra
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModBlumosAcctShipmentSonutra.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("Fact_Acct", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        FactLine fact;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 4 && po.get_Table_ID() == FactLine.Table_ID && (fact = (FactLine)((Object)po)).getAD_Client_ID() == 1000022 && fact.getAD_Table_ID() == 319) {
            int schema_ID = DB.getSQLValue((String)po.get_TrxName(), (String)("select MAX(C_AcctSchema1_ID) FROM AD_ClientInfo  where AD_Client_ID = " + fact.getAD_Client_ID()));
            MInOut inOut = new MInOut(po.getCtx(), fact.getRecord_ID(), po.get_TrxName());
            if (schema_ID > 0 && inOut.isSOTrx()) {
                MAcctSchema schemaPr = new MAcctSchema(po.getCtx(), schema_ID, po.get_TrxName());
                if (fact.getC_AcctSchema_ID() != schema_ID) {
                    BigDecimal rate = MConversionRate.getRate(schemaPr.getC_Currency_ID(), fact.getC_Currency_ID(), fact.getDateAcct(), 114, fact.getAD_Client_ID(), fact.getAD_Org_ID());
                    if (rate == null) {
                        rate = Env.ONE;
                    }
                    BigDecimal amtDr = Env.ZERO;
                    BigDecimal amtCr = Env.ZERO;
                    if (fact.getAmtSourceDr().compareTo(Env.ZERO) > 0) {
                        amtDr = fact.getAmtSourceDr().multiply(rate);
                        amtDr = amtDr.setScale(schemaPr.getC_Currency().getStdPrecision(), RoundingMode.HALF_EVEN);
                    }
                    if (fact.getAmtSourceCr().compareTo(Env.ZERO) > 0) {
                        amtCr = fact.getAmtSourceCr().multiply(rate);
                        amtCr = amtCr.setScale(schemaPr.getC_Currency().getStdPrecision(), RoundingMode.HALF_EVEN);
                    }
                    String sql = "UPDATE Fact_Acct SET amtsourcedr= ?, amtacctdr= ?,amtsourcecr= ?, amtacctcr= ?  WHERE Fact_Acct_ID =" + fact.get_ID();
                    CPreparedStatement pstmt = null;
                    pstmt = DB.prepareStatement((String)sql, (String)po.get_TrxName());
                    pstmt.setBigDecimal(1, amtDr);
                    pstmt.setBigDecimal(2, amtDr);
                    pstmt.setBigDecimal(3, amtCr);
                    pstmt.setBigDecimal(4, amtCr);
                    pstmt.executeQuery();
                }
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

