/*
 * Decompiled with CFR 0.152.
 */
package org.artilec.process;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import org.compiere.model.MOrder;
import org.compiere.model.X_C_OrderTracking;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.ofb.model.OFBForward;

public class ProcessOrderTracking
extends SvrProcess {
    private int p_OrderTracking_ID = 0;
    private String p_Action = "PR";

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("Action")) {
                this.p_Action = para[i].getParameterAsString();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.p_OrderTracking_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.p_OrderTracking_ID > 0) {
            X_C_OrderTracking ot = new X_C_OrderTracking(this.getCtx(), this.p_OrderTracking_ID, this.get_TrxName());
            String newStatus = "DR";
            String newAction = "DR";
            this.log.config("paction " + this.p_Action);
            if (ot.getDocStatus().compareTo("IP") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "IP";
                newAction = "CO";
            }
            if (newAction.compareTo("CO") != 0) {
                ot.setDocStatus(newAction);
                ot.save();
            } else if (newAction.compareTo("CO") == 0) {
                ot.setDocStatus("CO");
                ot.setProcessed(true);
                ot.save();
                String docstatus = ot.getDocStatus();
                String clStatus = ot.getCloseStatus();
                String email = "";
                String phone = "";
                int days = OFBForward.TgExpirationDays();
                if (clStatus == null) {
                    MOrder order = new MOrder(this.getCtx(), ot.getC_Order_ID(), this.get_TrxName());
                    X_C_OrderTracking ot2 = new X_C_OrderTracking(this.getCtx(), 0, this.get_TrxName());
                    ot2.setAD_Org_ID(order.getAD_Org_ID());
                    ot2.setC_Order_ID(order.get_ID());
                    ot2.setC_BPartner_ID(order.getC_BPartner_ID());
                    Calendar c = Calendar.getInstance();
                    c.setTimeInMillis(c.getTimeInMillis());
                    if (c.get(7) == 6) {
                        c.add(6, days + 2);
                    } else {
                        c.setTimeInMillis(ot.getDueDate().getTime());
                        c.add(6, days);
                    }
                    Timestamp date = new Timestamp(c.getTimeInMillis());
                    ot2.setDueDate(date);
                    ot2.setContact("");
                    email = DB.getSQLValueString((String)this.get_TrxName(), (String)("select coalesce(EMail,'') from AD_User where isactive = 'Y' and C_BPartner_ID = " + order.getC_BPartner_ID()), (Object[])new Object[0]);
                    if (email != null) {
                        ot2.setEMail(email);
                    }
                    if ((phone = DB.getSQLValueString((String)this.get_TrxName(), (String)("select coalesce(Phone,Phone2,'') from AD_User where isactive = 'Y' and C_BPartner_ID = " + order.getC_BPartner_ID()), (Object[])new Object[0])) != null) {
                        ot2.setPhone(phone);
                    }
                    ot2.setLink_Whats_App("");
                    ot2.setAnswer("");
                    ot2.setProbabilityClose("0");
                    ot2.setDocStatus("IP");
                    ot2.setText("");
                    ot2.save();
                } else if (clStatus.equals("L")) {
                    MOrder order = new MOrder(this.getCtx(), ot.getC_Order_ID(), this.get_TrxName());
                    order.setDocStatus("VO");
                    order.voidIt();
                    order.save();
                }
            }
        }
        return "Procesado";
    }
}

