/*
 * Decompiled with CFR 0.152.
 */
package org.artilec.model;

import org.compiere.model.MClient;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ModelArtPriceLimit
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelArtPriceLimit.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_OrderLine", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        MOrderLine ordl;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 2 || type == 1) && po.get_Table_ID() == MOrderLine.Table_ID && (ordl = (MOrderLine)((Object)po)).getC_Order().isSOTrx() && ordl.getPriceLimit().compareTo(Env.ZERO) > 0 && ordl.getPriceEntered().compareTo(ordl.getPriceLimit()) < 0) {
            ordl.setPriceEntered(ordl.getPriceLimit());
            ordl.setLineNetAmt(ordl.getPriceLimit().multiply(ordl.getQtyEntered()));
            ordl.setPriceActual(ordl.getPriceLimit());
            ordl.save();
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

