/*
 * Decompiled with CFR 0.152.
 */
package org.artilec.model;

import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModelArtCreatePaymentInvoice
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelArtCreatePaymentInvoice.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MInvoice.Table_ID) {
            MInvoice inv = (MInvoice)((Object)po);
            log.config("estado " + inv.getDocStatus());
            String isflagws = DB.getSQLValueString((String)po.get_TrxName(), (String)("select coalesce(max(flagws),'N') from c_order ord join c_invoice inv on ord.c_order_id = inv.c_order_id where ord.isactive like 'Y' and inv.c_invoice_id = " + inv.getC_Invoice_ID()), (Object[])new Object[0]);
            if (inv.isSOTrx() && inv.getC_DocType().getDocBaseType().compareTo("CDC") != 0 && inv.getC_DocType_ID() != 2000143 && inv.getC_DocType_ID() != 2000096 && isflagws.compareTo("N") == 0 && inv.getPaymentRule().compareTo("B") != 0 && inv.getPaymentRule().compareTo("G") != 0) {
                int bankaccount = DB.getSQLValue((String)po.get_TrxName(), (String)"SELECT coalesce(max(c_bankaccount_id),0)  FROM c_bankaccount where ad_Client_id = 2000006 and isactive='Y'");
                MPayment pay = new MPayment(po.getCtx(), 0, po.get_TrxName());
                pay.setC_BPartner_ID(inv.getC_BPartner_ID());
                pay.setDescription(inv.getDescription());
                pay.setC_DocType_ID(2000100);
                pay.setDateTrx(inv.getDateInvoiced());
                pay.setDateAcct(inv.getDateAcct());
                pay.setC_Invoice_ID(inv.get_ID());
                pay.setPayAmt(inv.getGrandTotal());
                if (inv.getPaymentRule().compareTo("S") == 0) {
                    pay.setTenderType("K");
                } else if (inv.getPaymentRule().compareTo("P") == 0) {
                    pay.setTenderType("K");
                } else if (inv.getPaymentRule().compareTo("M") == 0) {
                    log.config("payment term " + inv.getC_PaymentTerm().getName());
                    if (inv.getC_PaymentTerm().getName().compareTo("Efectivo") == 0) {
                        pay.setTenderType("T");
                    }
                    if (inv.getC_PaymentTerm().getName().compareTo("Tarjeta de credito") == 0) {
                        pay.setTenderType("C");
                    }
                    if (inv.getC_PaymentTerm().getName().compareTo("Tarjeta de debito") == 0) {
                        pay.setTenderType("D");
                    }
                    if (inv.getC_PaymentTerm().getName().compareTo("Transferencia") == 0) {
                        pay.setTenderType("A");
                    }
                    if (inv.getC_PaymentTerm().getName().compareTo("Webpay Plus") == 0) {
                        pay.setTenderType("A");
                    }
                } else if (inv.getPaymentRule().compareTo("C") == 0) {
                    pay.setTenderType("C");
                } else {
                    pay.setTenderType("D");
                }
                int totalDues = DB.getSQLValue(null, (String)(" select count(1) from C_PaySchedule  where  C_PaymentTerm_ID=" + inv.getC_PaymentTerm_ID()));
                if (totalDues == 0) {
                    totalDues = 1;
                }
                pay.setCreditCardExpYY(totalDues);
                log.config(inv.getPaymentRule());
                pay.setC_Currency_ID(inv.getC_Currency_ID());
                pay.setC_BankAccount_ID(2000083);
                pay.setIsOverUnderPayment(true);
                pay.setAD_Org_ID(inv.getAD_Org_ID());
                pay.save();
                pay.setAD_Org_ID(inv.getAD_Org_ID());
                pay.save();
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

