/*
 * Decompiled with CFR 0.152.
 */
package org.windsor.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MStorage;
import org.compiere.model.MWarehouse;
import org.compiere.model.X_M_StorageReservation;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class UpdateSalesReqStock
extends SvrProcess {
    private int p_COrder_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_Order_ID")) {
                    this.p_COrder_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        int count = 0;
        if (this.p_COrder_ID > 0) {
            MOrder order = new MOrder(this.getCtx(), this.p_COrder_ID, this.get_TrxName());
            if (!order.get_ValueAsBoolean("IsSalesReversed")) {
                MOrderLine[] oLines = order.getLines(false, null);
                int i = 0;
                while (i < oLines.length) {
                    MOrderLine line = oLines[i];
                    if (line.get_ValueAsInt("M_RequisitionLine_ID") > 0) {
                        DB.executeUpdate("UPDATE M_RequisitionLine SET QtyUsed = QtyUsed-" + line.getQtyEntered() + "," + " QtyReserved = QtyReserved+" + line.getQtyEntered() + " WHERE M_RequisitionLine_ID = " + line.get_ValueAsInt("M_RequisitionLine_ID"), this.get_TrxName());
                        MWarehouse wh = new MWarehouse(this.getCtx(), order.getM_Warehouse_ID(), this.get_TrxName());
                        if (this.existReservationTable(order.get_TrxName())) {
                            this.OFBReservation(order.getM_Warehouse_ID(), line.getM_Product_ID(), Env.ZERO, line.getQtyOrdered());
                            MStorage.add(this.getCtx(), order.getM_Warehouse_ID(), wh.getDefaultLocator().getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.getM_AttributeSetInstance_ID(), Env.ZERO, line.getQtyOrdered(), Env.ZERO, order.get_TrxName());
                        } else {
                            MStorage.add(wh.getCtx(), wh.getM_Warehouse_ID(), wh.getDefaultLocator().getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.getM_AttributeSetInstance_ID(), Env.ZERO, line.getQtyOrdered(), Env.ZERO, order.get_TrxName());
                        }
                    }
                    ++count;
                    ++i;
                }
                DB.executeUpdate("UPDATE C_Order SET IsSalesReversed = 'Y'  WHERE C_Order_ID = " + order.get_ID(), this.get_TrxName());
            } else {
                return "ERROR: Ya se ha devuelto la reserva de solicitud en esta nota de venta";
            }
        }
        return "Se ha actualizado " + count + " lineas de la orden de venta";
    }

    public void OFBReservation(int M_WareHouse_ID, int M_Product_ID, BigDecimal ordered, BigDecimal reserved) {
        CPreparedStatement pstmt = null;
        String mysql = "SELECT * from M_StorageReservation where M_WareHouse_ID = ? and M_Product_ID = ?";
        try {
            pstmt = DB.prepareStatement(mysql, this.get_TrxName());
            pstmt.setInt(1, M_WareHouse_ID);
            pstmt.setInt(2, M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                X_M_StorageReservation storage = new X_M_StorageReservation(this.getCtx(), rs, this.get_TrxName());
                storage.setQtyReserved(storage.getQtyReserved().subtract(reserved));
                storage.save();
            } else {
                X_M_StorageReservation storage = new X_M_StorageReservation(this.getCtx(), 0, this.get_TrxName());
                storage.setQtyReserved(reserved.negate());
                storage.setM_Product_ID(M_Product_ID);
                storage.setM_Warehouse_ID(M_WareHouse_ID);
                storage.save();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public boolean existReservationTable(String Trx2) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean val = false;
        String mysql = "SELECT count(1) from M_StorageReservation";
        if (!DB.isOracle()) {
            mysql = "select count(1) from AD_Table where tablename='M_StorageReservation'";
        }
        try {
            pstmt = DB.prepareStatement(mysql, Trx2);
            rs = pstmt.executeQuery();
            if (rs.next() && rs.getInt(1) > 0) {
                val = true;
            }
        }
        catch (Exception e) {
            val = false;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return val;
    }
}

