/*
 * Decompiled with CFR 0.152.
 */
package org.windsor.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MStorage;
import org.compiere.model.MWarehouse;
import org.compiere.model.X_M_StorageReservation;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class SaldarRequisitionWindsor
extends SvrProcess {
    private int p_M_Requisition_ID = 0;
    private int p_M_RequisitionLine_ID = 0;

    @Override
    protected void prepare() {
        this.p_M_Requisition_ID = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_RequisitionLine_ID")) {
                    this.p_M_RequisitionLine_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        String sql = "SELECT * FROM M_RequisitionLine WHERE IsActive = 'Y' AND M_Requisition_ID = " + this.p_M_Requisition_ID;
        if (this.p_M_RequisitionLine_ID > 0) {
            sql = String.valueOf(sql) + " AND M_RequisitionLine_ID = " + this.p_M_RequisitionLine_ID;
        }
        CPreparedStatement pstmt = null;
        try {
            MRequisitionLine rLine;
            BigDecimal qtyDif;
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next() && (qtyDif = (rLine = new MRequisitionLine(this.getCtx(), rs, this.get_TrxName())).getQty().subtract((BigDecimal)rLine.get_Value("QtyUsed"))) != null && qtyDif.compareTo(Env.ZERO) > 0) {
                MWarehouse wh = MWarehouse.get(rLine.getCtx(), rLine.getM_Requisition().getM_Warehouse_ID());
                if (this.existReservationTable(rLine.get_TrxName())) {
                    this.OFBReservation(wh.get_ID(), rLine.getM_Product_ID(), Env.ZERO, qtyDif.negate());
                    MStorage.add(wh.getCtx(), wh.getM_Warehouse_ID(), wh.getDefaultLocator().getM_Locator_ID(), rLine.getM_Product_ID(), rLine.getM_AttributeSetInstance_ID(), rLine.getM_AttributeSetInstance_ID(), Env.ZERO, qtyDif.negate(), Env.ZERO, rLine.get_TrxName());
                } else {
                    MStorage.add(wh.getCtx(), wh.getM_Warehouse_ID(), wh.getDefaultLocator().getM_Locator_ID(), rLine.getM_Product_ID(), rLine.getM_AttributeSetInstance_ID(), rLine.getM_AttributeSetInstance_ID(), Env.ZERO, qtyDif.negate(), Env.ZERO, rLine.get_TrxName());
                }
                DB.executeUpdate("UPDATE M_RequisitionLine SET QtyUsed = Qty, QtyReserved = 0  WHERE M_RequisitionLine_ID = " + rs.getInt("M_RequisitionLine_ID"), this.get_TrxName());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return "actualizado";
    }

    public void OFBReservation(int M_WareHouse_ID, int M_Product_ID, BigDecimal ordered, BigDecimal reserved) {
        CPreparedStatement pstmt = null;
        String mysql = "SELECT * from M_StorageReservation where M_WareHouse_ID = ? and M_Product_ID = ?";
        try {
            pstmt = DB.prepareStatement(mysql, this.get_TrxName());
            pstmt.setInt(1, M_WareHouse_ID);
            pstmt.setInt(2, M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                X_M_StorageReservation storage = new X_M_StorageReservation(this.getCtx(), rs, this.get_TrxName());
                storage.setQtyReserved(storage.getQtyReserved().subtract(reserved));
                storage.save();
            } else {
                X_M_StorageReservation storage = new X_M_StorageReservation(this.getCtx(), 0, this.get_TrxName());
                storage.setQtyReserved(reserved.negate());
                storage.setM_Product_ID(M_Product_ID);
                storage.setM_Warehouse_ID(M_WareHouse_ID);
                storage.save();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public boolean existReservationTable(String Trx2) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean val = false;
        String mysql = "SELECT count(1) from M_StorageReservation";
        if (!DB.isOracle()) {
            mysql = "select count(1) from AD_Table where tablename='M_StorageReservation'";
        }
        try {
            pstmt = DB.prepareStatement(mysql, Trx2);
            rs = pstmt.executeQuery();
            if (rs.next() && rs.getInt(1) > 0) {
                val = true;
            }
        }
        catch (Exception e) {
            val = false;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return val;
    }
}

