/*
 * Decompiled with CFR 0.152.
 */
package org.windsor.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_M_StorageReservation;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModWindsorQtyReq
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModWindsorQtyReq.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_OrderLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        BigDecimal qtyAv;
        MRequisitionLine rline;
        MOrderLine oLine;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 1 && po.get_Table_ID() == MOrderLine.Table_ID && (oLine = (MOrderLine)po).getParent().isSOTrx() && oLine.get_ValueAsInt("M_RequisitionLine_ID") > 0) {
            rline = new MRequisitionLine(po.getCtx(), oLine.get_ValueAsInt("M_RequisitionLine_ID"), po.get_TrxName());
            BigDecimal qtyUsed = (BigDecimal)rline.get_Value("QtyUsed");
            qtyUsed = qtyUsed.setScale(4, RoundingMode.HALF_EVEN);
            qtyAv = rline.getQty();
            qtyAv = qtyAv.setScale(4, RoundingMode.HALF_EVEN);
            if ((qtyAv = qtyAv.subtract(qtyUsed)).subtract(oLine.getQtyOrdered()).compareTo(Env.ZERO) < 0) {
                return "Error: Cantidad supera cantidad de solicitud. Favor ingrese otra linea";
            }
        }
        if (type == 2 && po.get_Table_ID() == MOrderLine.Table_ID && (oLine = (MOrderLine)po).getParent().isSOTrx() && oLine.get_ValueAsInt("M_RequisitionLine_ID") > 0) {
            rline = new MRequisitionLine(po.getCtx(), oLine.get_ValueAsInt("M_RequisitionLine_ID"), po.get_TrxName());
            BigDecimal qtyUse = DB.getSQLValueBD(po.get_TrxName(), "SELECT COALESCE(SUM(QtyOrdered),0) FROM C_OrderLine col INNER JOIN C_Order co ON (col.C_Order_ID = co.C_Order_ID) WHERE co.DocStatus IN ('CO','DR','IP','IN') AND M_RequisitionLine_ID = " + oLine.get_ValueAsInt("M_RequisitionLine_ID") + " AND C_OrderLine_ID <> " + oLine.get_ID(), new Object[0]);
            if (qtyUse == null) {
                qtyUse = Env.ZERO;
            }
            qtyUse = qtyUse.add(oLine.getQtyOrdered());
            qtyAv = rline.getQty().subtract(qtyUse);
            if (qtyAv.compareTo(Env.ZERO) < 0) {
                return "Error: Cantidad supera cantidad de solicitud. Favor ingrese otra linea";
            }
        }
        return null;
    }

    public static String rtrim(String s, char c) {
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) == c) {
            --i;
        }
        return s.substring(0, i + 1);
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }

    public void OFBReservation(int M_WareHouse_ID, int M_Product_ID, BigDecimal ordered, BigDecimal reserved, PO po) {
        CPreparedStatement pstmt = null;
        String mysql = "SELECT * from M_StorageReservation where M_WareHouse_ID = ? and M_Product_ID = ?";
        try {
            pstmt = DB.prepareStatement(mysql, po.get_TrxName());
            pstmt.setInt(1, M_WareHouse_ID);
            pstmt.setInt(2, M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                X_M_StorageReservation storage = new X_M_StorageReservation(po.getCtx(), rs, po.get_TrxName());
                storage.setQtyReserved(storage.getQtyReserved().subtract(reserved));
                storage.save();
            } else {
                X_M_StorageReservation storage = new X_M_StorageReservation(po.getCtx(), 0, po.get_TrxName());
                storage.setQtyReserved(reserved.negate());
                storage.setM_Product_ID(M_Product_ID);
                storage.setM_Warehouse_ID(M_WareHouse_ID);
                storage.save();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public boolean existReservationTable(String Trx2) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean val = false;
        String mysql = "SELECT count(1) from M_StorageReservation";
        if (!DB.isOracle()) {
            mysql = "select count(1) from AD_Table where tablename='M_StorageReservation'";
        }
        try {
            pstmt = DB.prepareStatement(mysql, Trx2);
            rs = pstmt.executeQuery();
            if (rs.next() && rs.getInt(1) > 0) {
                val = true;
            }
        }
        catch (Exception e) {
            val = false;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return val;
    }
}

