/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.X_TP_Refund;
import org.compiere.model.X_TP_RefundHeader;
import org.compiere.model.X_TP_RefundLine;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ProcessRefundHeader
extends SvrProcess {
    private int p_TP_Viatico_ID = 0;

    @Override
    protected void prepare() {
        this.p_TP_Viatico_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_TP_Viatico_ID > 0) {
            X_TP_RefundHeader viaticoHeader = new X_TP_RefundHeader(this.getCtx(), this.p_TP_Viatico_ID, this.get_TrxName());
            if (viaticoHeader.getDocStatus().compareTo("WC") == 0 && (viaticoHeader.getType().compareTo("01") == 0 ? !viaticoHeader.isSignature2() || !viaticoHeader.isSignature3() : viaticoHeader.getType().compareTo("02") == 0 && (!viaticoHeader.isSignature1() || !viaticoHeader.isSignature2() || !viaticoHeader.isSignature3()))) {
                throw new AdempiereException("Error: No se puede completar sin las firmas necesarias");
            }
            if (viaticoHeader.get_ValueAsBoolean("overwrite")) {
                viaticoHeader.setDocStatus("CO");
                viaticoHeader.setProcessed(true);
                DB.executeUpdate("UPDATE TP_Refund SET Processed = 'Y' WHERE TP_RefundHeader_ID = " + viaticoHeader.get_ID(), this.get_TrxName());
                DB.executeUpdate("UPDATE TP_Refund SET DocStatus = 'CO' WHERE TP_RefundHeader_ID = " + viaticoHeader.get_ID(), this.get_TrxName());
                DB.executeUpdate("UPDATE TP_RefundLine SET Processed = 'Y' WHERE TP_Refund_ID IN  (SELECT TP_Refund_ID FROM TP_Refund WHERE TP_RefundHeader_ID = " + viaticoHeader.get_ID() + ")", this.get_TrxName());
            } else {
                CPreparedStatement pstmt = null;
                String sqlRefund = "SELECT TP_Refund_ID FROM TP_Refund WHERE TP_RefundHeader_ID = ?";
                pstmt = DB.prepareStatement(sqlRefund, this.get_TrxName());
                pstmt.setInt(1, viaticoHeader.get_ID());
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    X_TP_Refund refund = new X_TP_Refund(this.getCtx(), rs.getInt("TP_Refund_ID"), this.get_TrxName());
                    this.CompleteRefund(refund);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
                if (viaticoHeader.getDocStatus().compareTo("DR") == 0) {
                    viaticoHeader.setDocStatus("WC");
                } else if (viaticoHeader.getDocStatus().compareTo("WC") == 0) {
                    viaticoHeader.setDocStatus("CO");
                    viaticoHeader.setProcessed(true);
                }
            }
            viaticoHeader.save();
        }
        return "Procesado ";
    }

    private void CompleteRefund(X_TP_Refund viatico) throws AdempiereException, SQLException {
        String sqlLine = "SELECT TP_RefundLine_ID FROM TP_RefundLine WHERE IsActive = 'Y' AND TP_Refund_ID = ?";
        CPreparedStatement pstmt = null;
        pstmt = DB.prepareStatement(sqlLine, this.get_TrxName());
        pstmt.setInt(1, viatico.get_ID());
        ResultSet rs = pstmt.executeQuery();
        while (rs.next()) {
            int cantRepLine;
            X_TP_RefundLine rLine = new X_TP_RefundLine(this.getCtx(), rs.getInt("TP_RefundLine_ID"), this.get_TrxName());
            if (rLine.getM_Movement_ID() > 0) {
                Timestamp MaxDate = DB.getSQLValueTS(this.get_TrxName(), "SELECT MAX(TP_InicialHR) FROM M_MovementLine WHERE M_Movement_ID = " + rLine.getM_Movement_ID(), new Object[0]);
                Timestamp MinDate = DB.getSQLValueTS(this.get_TrxName(), "SELECT MIN(TP_FinalHR) FROM M_MovementLine WHERE M_Movement_ID = " + rLine.getM_Movement_ID(), new Object[0]);
                MinDate.setHours(0);
                MinDate.setMinutes(0);
                MinDate.setSeconds(0);
                if (rLine.getDateTrx().compareTo(MaxDate) > 0 || rLine.getDateTrx().compareTo(MinDate) < 0) {
                    throw new AdempiereException("ERROR: Fecha de HR no coincide con fecha de viatico");
                }
            }
            if (rLine.getM_Movement_ID() > 0 && (cantRepLine = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM TP_RefundLine rl INNER JOIN TP_Refund r ON (rl.TP_Refund_ID = r.TP_Refund_ID)  WHERE r.type = '" + viatico.getType() + "' AND Pre_M_Movement_ID > 0 AND r.C_BPartner_ID = " + viatico.getC_BPartner_ID() + " AND rl.DateTrx = ?", rLine.getDateTrx())) > 0) {
                throw new AdempiereException("ERROR: Ya existe un viatico por disponibilidad para la misma fecha y conductor");
            }
            if (rLine.get_ValueAsInt("Pre_M_Movement_ID") > 0 && (cantRepLine = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM TP_RefundLine rl INNER JOIN TP_Refund r ON (rl.TP_Refund_ID = r.TP_Refund_ID)  WHERE  r.type = '" + viatico.getType() + "' AND M_Movement_ID > 0 AND r.C_BPartner_ID = " + viatico.getC_BPartner_ID() + " AND rl.DateTrx = ?", rLine.getDateTrx())) > 0) {
                throw new AdempiereException("ERROR: Ya existe un viatico por hoja de ruta para la misma fecha y conductor");
            }
            if (viatico.getType().compareTo("02") != 0) continue;
            int cant = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM TP_RefundLine WHERE IsActive = 'Y' AND TP_RefundLine_ID <> " + rLine.get_ID() + " AND M_Movement_ID = " + rLine.getM_Movement_ID() + " AND TP_RefundAmt_ID = " + rLine.get_ValueAsInt("TP_RefundAmt_ID") + " AND DateTrx = ?", rLine.getDateTrx());
            if (cant > 0) {
                throw new AdempiereException("ERROR: Existe una HR y concepto repetido");
            }
            if (rLine.getM_Movement_ID() > 0 || rLine.get_ValueAsInt("TP_RefundAmt_ID") <= 0 || rLine.getTP_Refund().getAD_Org_ID() == 1000004 || rLine.getTP_Refund().getAD_Org_ID() == 1000017 || rLine.getTP_Refund().getAD_Org_ID() == 1000067) continue;
            throw new AdempiereException("ERROR: Concepto sin HR ingresada");
        }
        rs.close();
        pstmt.close();
        pstmt = null;
        if (viatico.getDocStatus().compareTo("DR") == 0) {
            viatico.setDocStatus("WC");
            viatico.save(this.get_TrxName());
        } else if (viatico.getDocStatus().compareTo("WC") == 0) {
            viatico.setDocStatus("CO");
            viatico.setProcessed(true);
            viatico.save(this.get_TrxName());
            DB.executeUpdate("UPDATE TP_RefundLine SET Processed = 'Y' WHERE TP_Refund_ID = " + viatico.get_ID(), this.get_TrxName());
        }
    }
}

