/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.X_C_CriticalDate;
import org.compiere.model.X_C_CriticalDateConcept;
import org.compiere.model.X_HR_Prebitacora;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.ofb.utils.DateUtils;

public class ProcessCriticalDateTSM
extends SvrProcess {
    private int Record_ID;

    @Override
    protected void prepare() {
        this.Record_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        X_C_CriticalDate cDate = new X_C_CriticalDate(Env.getCtx(), this.Record_ID, this.get_TrxName());
        int flag = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM ad_attachment WHERE AD_Table_ID=" + X_C_CriticalDate.Table_ID + " AND record_id=" + cDate.get_ID());
        if (flag <= 0) {
            throw new AdempiereException("ERROR: Debe Adjuntar documento");
        }
        String sqlValid = "SELECT MAX(C_CriticalDate_ID) FROM C_CriticalDate WHERE IsActive='Y' AND Status='AL'  AND C_CriticalDateConcept_ID = " + cDate.getC_CriticalDateConcept_ID() + " AND C_CriticalDate_ID NOT IN (" + cDate.get_ID() + ")";
        if (cDate.getC_BPartner_ID() > 0) {
            sqlValid = String.valueOf(sqlValid) + " AND C_Bpartner_ID = " + cDate.getC_BPartner_ID();
        } else if (cDate.getA_Asset_ID() > 0) {
            sqlValid = String.valueOf(sqlValid) + " AND A_Asset_ID = " + cDate.getA_Asset_ID();
        }
        int ID_CDAte = DB.getSQLValue(this.get_TrxName(), sqlValid);
        if (ID_CDAte > 0) {
            X_C_CriticalDate cDateOld = new X_C_CriticalDate(this.getCtx(), ID_CDAte, this.get_TrxName());
            cDateOld.setStatus("BA");
            cDateOld.saveEx(this.get_TrxName());
            if (cDate.getC_CriticalDateConcept().getIsDue().compareTo(Env.ZERO) > 0) {
                Timestamp dateEnd = DateUtils.SumarMeses(cDate.getDateTrx(), cDate.getC_CriticalDateConcept().getIsDue().multiply(new BigDecimal("12.0")).intValue());
                cDate.setDueDate(dateEnd);
            }
            cDate.setDocStatus("CO");
            cDate.setProcessed(true);
        } else {
            cDate.setDocStatus("CO");
            cDate.setProcessed(true);
        }
        X_C_CriticalDateConcept concept = new X_C_CriticalDateConcept(this.getCtx(), cDate.getC_CriticalDateConcept_ID(), this.get_TrxName());
        if (concept.get_ValueAsBoolean("genPreB")) {
            Timestamp fechaEmision = cDate.getDateTrx();
            Timestamp fechaVencimiento = cDate.getDueDate();
            Calendar calCalendario = Calendar.getInstance();
            if (fechaEmision != null && fechaVencimiento != null) {
                while (fechaEmision.compareTo(fechaVencimiento) <= 0) {
                    X_HR_Prebitacora preB = new X_HR_Prebitacora(this.getCtx(), 0, this.get_TrxName());
                    preB.setAD_Org_ID(cDate.getAD_Org_ID());
                    if (cDate.getC_BPartner_ID() > 0) {
                        preB.setColumnType("B");
                        preB.setC_BPartner_ID(cDate.getC_BPartner_ID());
                    } else if (cDate.getA_Asset_ID() > 0) {
                        preB.setColumnType("A");
                        preB.setA_Asset_ID(cDate.getA_Asset_ID());
                    }
                    preB.setDateTrx(fechaEmision);
                    preB.set_CustomColumn("C_CriticalDate_ID", cDate.get_ID());
                    preB.setHR_Concept_TSM_ID(1000005);
                    preB.saveEx(this.get_TrxName());
                    calCalendario.setTimeInMillis(fechaEmision.getTime());
                    calCalendario.add(5, 1);
                    fechaEmision = new Timestamp(calCalendario.getTimeInMillis());
                }
            }
        }
        cDate.saveEx(this.get_TrxName());
        return "Procesado";
    }
}

