/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.model;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCash;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_Pre_M_Movement;
import org.compiere.model.X_Pre_M_MovementLine;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModTSMPreMovement
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModTSMPreMovement.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("Pre_M_MovementLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 2 || type == 1) && po.get_Table_ID() == X_Pre_M_MovementLine.Table_ID) {
            X_Pre_M_MovementLine pMovLine = (X_Pre_M_MovementLine)po;
            X_Pre_M_Movement preMov = new X_Pre_M_Movement(po.getCtx(), pMovLine.getPre_M_Movement_ID(), po.get_TrxName());
            if (pMovLine.isActive()) {
                int cantPMovLine;
                if (pMovLine.getA_Asset_ID() > 0 && (cantPMovLine = DB.getSQLValue(po.get_TrxName(), "SELECT COUNT(1) FROM Pre_M_Movement mm INNER JOIN Pre_M_MovementLine mml ON (mm.Pre_M_Movement_ID = mml.Pre_M_Movement_ID)  WHERE mm.Pre_M_Movement_ID <> " + preMov.get_ID() + "AND mm.MovementDate = ? " + " AND mm.AD_Org_ID=" + preMov.getAD_Org_ID() + " AND mm.Workshift='" + preMov.get_ValueAsString("Workshift") + "'" + " AND mml.A_Asset_ID = " + pMovLine.getA_Asset_ID(), preMov.getMovementDate())) > 0) {
                    throw new AdempiereException("ERROR: Ya existe una disponibilidad para el mismo activo:" + pMovLine.getA_Asset().getValue());
                }
                if (pMovLine.getC_BPartner_ID() > 0 && (cantPMovLine = DB.getSQLValue(po.get_TrxName(), "SELECT COUNT(1) FROM Pre_M_Movement mm INNER JOIN Pre_M_MovementLine mml ON (mm.Pre_M_Movement_ID = mml.Pre_M_Movement_ID)  WHERE mm.Pre_M_Movement_ID <> " + preMov.get_ID() + " AND mm.MovementDate = ? " + " AND mm.AD_Org_ID=" + preMov.getAD_Org_ID() + " AND mm.Workshift='" + preMov.get_ValueAsString("Workshift") + "'" + " AND mml.C_Bpartner_ID = " + pMovLine.getC_BPartner_ID(), preMov.getMovementDate())) > 0) {
                    throw new AdempiereException("ERROR: Ya existe una disponibilidad para el mismo conductor:" + pMovLine.getC_BPartner().getValue());
                }
                pMovLine.getC_BPartner_ID();
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }

    private boolean updateHeader(MCash cash) {
        String sql = "SELECT COALESCE(SUM(cl.Amount),0) FROM C_CashLine cl WHERE cl.IsActive='Y' AND cl.C_Cash_ID=" + cash.getC_Cash_ID();
        BigDecimal StatementDifference = DB.getSQLValueBD(cash.get_TrxName(), sql, new Object[0]);
        cash.setStatementDifference(StatementDifference);
        cash.setEndingBalance(cash.getBeginningBalance().add(StatementDifference));
        cash.saveEx();
        return true;
    }
}

