/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_MP_AssetMeter;
import org.compiere.model.X_MP_AssetMeter_Log;
import org.compiere.model.X_MP_Meter;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModTSMInsertAssetMeter
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModTSMInsertAssetMeter.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("MP_AssetMeter_Log", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 4 && po.get_Table_ID() == X_MP_AssetMeter_Log.Table_ID) {
            X_MP_AssetMeter_Log aMetLog = (X_MP_AssetMeter_Log)po;
            X_MP_AssetMeter aMet = new X_MP_AssetMeter(po.getCtx(), aMetLog.getMP_AssetMeter_ID(), po.get_TrxName());
            X_MP_Meter met = new X_MP_Meter(po.getCtx(), aMet.get_ValueAsInt("MP_Meter_ID"), po.get_TrxName());
            if (met.get_ValueAsBoolean("InsertAssetPartner")) {
                BigDecimal amtOld = DB.getSQLValueBD(po.get_TrxName(), "SELECT MAX(Amt) FROM MP_AssetMeter_Log  WHERE IsActive = 'Y' AND MP_AssetMeter_ID = " + aMet.get_ID() + " AND Amt <> " + aMetLog.getAmt(), new Object[0]);
                if (amtOld == null) {
                    amtOld = Env.ZERO;
                }
                String sql = "SELECT DISTINCT(A_AssetRef_ID) as A_AssetRef_ID FROM MP_AssetPartner WHERE IsActive = 'Y' AND A_Asset_ID = " + aMet.getA_Asset_ID();
                try {
                    CPreparedStatement pstmt = DB.prepareStatement(sql, po.get_TrxName());
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int ID_AMetter = DB.getSQLValue(po.get_TrxName(), " SELECT MP_AssetMeter_ID FROM MP_AssetMeter   WHERE IsActive = 'Y' AND A_Asset_ID = " + rs.getInt("A_AssetRef_ID") + " AND MP_Meter_ID = " + met.get_ID());
                        X_MP_AssetMeter aMeterRef = null;
                        if (ID_AMetter > 0) {
                            aMeterRef = new X_MP_AssetMeter(po.getCtx(), ID_AMetter, po.get_TrxName());
                        } else {
                            aMeterRef = new X_MP_AssetMeter(po.getCtx(), 0, po.get_TrxName());
                            aMeterRef.setA_Asset_ID(rs.getInt("A_AssetRef_ID"));
                            aMeterRef.set_CustomColumn("MP_Meter_ID", met.get_ID());
                            aMeterRef.setName(String.valueOf(met.getName()) + " Auto.");
                            aMeterRef.save();
                        }
                        X_MP_AssetMeter_Log aMetLogRef = new X_MP_AssetMeter_Log(po.getCtx(), 0, po.get_TrxName());
                        aMetLogRef.setMP_AssetMeter_ID(aMeterRef.get_ID());
                        aMetLogRef.setAD_Org_ID(aMetLogRef.getAD_Org_ID());
                        aMetLogRef.setDateTrx(aMetLog.getDateTrx());
                        aMetLogRef.setAD_User_ID(aMetLog.getAD_User_ID());
                        aMetLogRef.setAmt(aMeterRef.getAmt().add(aMet.getAmt().subtract(amtOld)));
                        aMetLogRef.setcurrentamt(aMeterRef.getAmt().add(aMet.getAmt().subtract(amtOld)));
                        aMetLogRef.set_CustomColumn("A_AssetRef_ID", aMet.getA_Asset_ID());
                        aMeterRef.setAmt(aMetLogRef.getcurrentamt());
                        aMeterRef.save();
                        aMetLogRef.save();
                        aMeterRef.setAmt(aMetLogRef.getcurrentamt());
                        aMeterRef.save();
                    }
                }
                catch (Exception e) {
                    log.config("Error recuperando Activos asociados " + sql);
                }
            }
        }
        return null;
    }

    public static String rtrim(String s, char c) {
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) == c) {
            --i;
        }
        return s.substring(0, i + 1);
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

