/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.model;

import org.compiere.acct.FactLine;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModTSMAcctExpInvoice
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModTSMAcctExpInvoice.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("Fact_Acct", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        FactLine fLine;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 5 || type == 4) && po.get_Table_ID() == FactLine.Table_ID && (fLine = (FactLine)po).getAD_Table_ID() == MAllocationHdr.Table_ID) {
            MAllocationHdr allo = new MAllocationHdr(po.getCtx(), fLine.getRecord_ID(), po.get_TrxName());
            MAllocationLine[] lines = allo.getLines(false);
            int i = 0;
            while (i < lines.length) {
                MInvoice inv;
                MAllocationLine line = lines[i];
                if (line.getAmount().compareTo(Env.ZERO) > 0 && line.getC_Invoice_ID() > 0 && ((inv = new MInvoice(po.getCtx(), line.getC_Invoice_ID(), po.get_TrxName())).getC_DocType_ID() == 1000079 || inv.getC_DocType_ID() == 1000080 || inv.getC_DocType_ID() == 1000101)) {
                    DB.executeUpdateEx("DELETE FROM Fact_Acct WHERE AD_Table_ID=735 AND RECORD_ID=" + fLine.getRecord_ID() + " AND AmtAcctDr > 0 AND AmtAcctDr <> " + line.getAmount(), po.get_TrxName());
                    DB.executeUpdateEx("DELETE FROM Fact_Acct WHERE AD_Table_ID=735 AND RECORD_ID=" + fLine.getRecord_ID() + " AND AmtAcctCr > 0 AND AmtAcctCr <> " + line.getAmount(), po.get_TrxName());
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

