/*
 * Decompiled with CFR 0.152.
 */
package org.qdc.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModQDCValidStockSO
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModQDCValidStockSO.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)po).isSOTrx() && (order.getC_DocTypeTarget().getDocSubTypeSO() == null || order.getC_DocTypeTarget().getDocSubTypeSO() != null && !order.getC_DocTypeTarget().getDocSubTypeSO().equals("RM"))) {
            try {
                MOrderLine[] mOrderLineArray = order.getLines();
                int n = mOrderLineArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MOrderLine line = mOrderLineArray[n2];
                    BigDecimal onHand = DB.getSQLValueBD(po.get_TrxName(), "select SUM(s.qtyonhand) from M_Storage s Inner join M_Locator l on (s.M_Locator_ID=l.M_Locator_ID) where l.M_Warehouse_ID=? and s.M_Product_ID=? and l.isactive='Y' ", order.getM_Warehouse_ID(), line.getM_Product_ID());
                    BigDecimal reservation = DB.getSQLValueBD(po.get_TrxName(), "select SUM(s.qtyreserved) from M_StorageReservation s  where s.M_Warehouse_ID=? and s.M_Product_ID=?  ", order.getM_Warehouse_ID(), line.getM_Product_ID());
                    BigDecimal available = onHand.subtract(reservation);
                    BigDecimal difValidacion = line.getQtyOrdered().subtract(line.getQtyDelivered());
                    log.config("disponible:" + available + "  difValidacion:" + difValidacion + "   signature:" + order.get_ValueAsString("SignatureStock"));
                    if (difValidacion.compareTo(available) > 0 && order.get_ValueAsString("SignatureStock").equals("false")) {
                        return "Superado el Stock disponible del producto : " + line.getM_Product().getName() + ", solo se poseen :" + available;
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

