/*
 * Decompiled with CFR 0.152.
 */
package org.qdc.model;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModQDCValidLimitPrice
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModQDCValidLimitPrice.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Invoice", this);
        engine.addModelChange("C_InvoiceLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        MInvoiceLine invl;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == MInvoiceLine.Table_ID && (invl = (MInvoiceLine)po).getC_Invoice().isSOTrx() && invl.getPriceLimit().compareTo(Env.ZERO) > 0) {
            BigDecimal priceLimit = DB.getSQLValueBD(po.get_TrxName(), "select coalesce(round(pp.PriceLimit,2),0) from m_productprice pp left join m_pricelist_version pl on(pp.m_pricelist_version_id = pl.m_pricelist_version_id) where pp.isactive = 'Y' and lower(pl.name) like lower('ventas') and pp.m_product_id =" + invl.getM_Product_ID(), new Object[0]);
            if (invl.getPriceEntered().compareTo(priceLimit) < 0) {
                invl.setPriceEntered(priceLimit);
                invl.setLineNetAmt(priceLimit.multiply(invl.getQtyEntered()));
                invl.setPriceActual(priceLimit);
                invl.save();
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MInvoice inv;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MInvoice.Table_ID && (inv = (MInvoice)po).isSOTrx()) {
            MInvoiceLine[] lines = inv.getLines();
            int i = 0;
            while (i < lines.length) {
                MInvoiceLine line = lines[i];
                if (line.getPriceEntered().compareTo(Env.ZERO) > 0) {
                    BigDecimal priceLimit = DB.getSQLValueBD(po.get_TrxName(), "select coalesce(round(pp.PriceLimit,2),0) from m_productprice pp left join m_pricelist_version pl on(pp.m_pricelist_version_id = pl.m_pricelist_version_id) where pp.isactive = 'Y' and lower(pl.name) like lower('ventas') and pp.m_product_id =" + line.getM_Product_ID(), new Object[0]);
                    if (line.getPriceEntered().compareTo(priceLimit) < 0) {
                        throw new AdempiereException("La linea " + line.getLine() + " Tiene un precio inferior al minimo.");
                    }
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

