/*
 * Decompiled with CFR 0.152.
 */
package org.prototipos.process;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.compiere.model.X_I_ACHSFile1;
import org.compiere.model.X_I_ACHSFile3;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class ImportFileACHS
extends SvrProcess {
    private String rutaArchivo;
    private String rutaArchivo3;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("rutaArchivo")) {
                    this.rutaArchivo = para[i].getParameterAsString();
                } else if (name.equals("rutaArchivo3")) {
                    this.rutaArchivo3 = para[i].getParameterAsString();
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        String linea;
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setGroupingSeparator('.');
        symbols.setDecimalSeparator(',');
        String pattern = "#,##0.0#";
        DecimalFormat decimalFormat = new DecimalFormat(pattern, symbols);
        decimalFormat.setParseBigDecimal(true);
        DB.executeUpdate("DELETE FROM I_ACHSFile1 WHERE I_ACHSFile1_ID NOT IN(SELECT I_ACHSFile1_ID FROM C_OrderLine WHERE I_ACHSFile1_ID IS NOT NULL)", this.get_TrxName());
        DB.executeUpdate("DELETE FROM I_ACHSFile3", this.get_TrxName());
        String pFile = this.rutaArchivo;
        String pFile3 = this.rutaArchivo3;
        ArrayList<String[]> datos = new ArrayList<String[]>();
        ArrayList<String[]> datos3 = new ArrayList<String[]>();
        int cantLines = 0;
        int cantLines3 = 0;
        int ID_Bpartner = 0;
        int ID_product = 0;
        try {
            FileInputStream fis = new FileInputStream(pFile);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF8");
            BufferedReader br = new BufferedReader(isr);
            linea = br.readLine();
            while (linea != null) {
                datos.add(linea.split(";"));
                linea = br.readLine();
                if (++cantLines > 5) {
                    X_I_ACHSFile1 f1 = new X_I_ACHSFile1(this.getCtx(), 0, this.get_TrxName());
                    f1.setRut_Empresa(((String[])datos.get(0))[3].toString());
                    ID_Bpartner = DB.getSQLValue(this.get_TrxName(), "SELECT C_BPartner_ID FROM C_BPartner  WHERE IsActive='Y' AND value like '" + ((String[])datos.get(0))[3].toString().substring(0, 8) + "'");
                    if (ID_Bpartner > 0) {
                        f1.setC_BPartner_ID(ID_Bpartner);
                    }
                    f1.setEpisodio(((String[])datos.get(0))[5].toString());
                    f1.setRut_Paciente(((String[])datos.get(0))[20].toString());
                    f1.setBP_Empresa(((String[])datos.get(0))[21].toString());
                    f1.setPrestacion(((String[])datos.get(0))[27].toString());
                    ID_product = DB.getSQLValue(this.get_TrxName(), "SELECT M_Product_ID FROM M_Product  WHERE IsActive='Y' AND Value like '" + ((String[])datos.get(0))[27].toString() + "'");
                    if (ID_product > 0) {
                        f1.setM_Product_ID(ID_product);
                    }
                    f1.setPrestacionGlosa(((String[])datos.get(0))[28].toString());
                    if (ImportFileACHS.isNumber(((String[])datos.get(0))[6].toString().replace("$", ""))) {
                        f1.setLineNetAmt((BigDecimal)decimalFormat.parse(((String[])datos.get(0))[6].replace("$", "").trim()));
                    }
                    f1.setName(String.valueOf(((String[])datos.get(0))[15].toString()) + " " + ((String[])datos.get(0))[16].toString() + " " + ((String[])datos.get(0))[17].toString());
                    if (this.isDate(((String[])datos.get(0))[4].toString())) {
                        f1.setFechaAtencion(this.convertDate(((String[])datos.get(0))[4].toString()));
                    }
                    f1.saveEx(this.get_TrxName());
                }
                datos.clear();
                this.log.config("linea: " + cantLines + ".");
            }
            br.close();
            isr.close();
            fis.close();
            this.log.config(datos.toString());
        }
        catch (Exception e) {
            this.log.config("ERROR: " + e);
        }
        try {
            FileInputStream fis2 = new FileInputStream(pFile3);
            InputStreamReader isr2 = new InputStreamReader((InputStream)fis2, "UTF8");
            BufferedReader br2 = new BufferedReader(isr2);
            linea = br2.readLine();
            while (linea != null) {
                datos3.add(linea.split(";"));
                linea = br2.readLine();
                if (++cantLines3 > 1) {
                    X_I_ACHSFile3 f3 = new X_I_ACHSFile3(this.getCtx(), 0, this.get_TrxName());
                    f3.setRut_Empresa(((String[])datos3.get(0))[2].toString());
                    f3.setNombreEmpresa(((String[])datos3.get(0))[4].toString());
                    f3.setCentroDeCosto(((String[])datos3.get(0))[8].toString());
                    if (this.isDate(((String[])datos3.get(0))[9].toString())) {
                        f3.setFechaAtencion(this.convertDate(((String[])datos3.get(0))[9].toString()));
                    }
                    f3.setStatus(((String[])datos3.get(0))[11].toString());
                    f3.setRut_Paciente(((String[])datos3.get(0))[13].toString());
                    f3.setNombre_Paciente(((String[])datos3.get(0))[14].toString());
                    f3.setNombre_Solicitante(((String[])datos3.get(0))[15].toString());
                    f3.setRut_Solicitante(((String[])datos3.get(0))[16].toString());
                    f3.setMail_Solicitante(((String[])datos3.get(0))[19].toString());
                    f3.setSucursal(((String[])datos3.get(0))[24].toString());
                    f3.saveEx(this.get_TrxName());
                }
                datos3.clear();
                this.log.config("linea: " + cantLines + ".");
            }
            br2.close();
            isr2.close();
            fis2.close();
            this.log.config(datos.toString());
        }
        catch (Exception e) {
            this.log.config("ERROR: " + e);
        }
        return "procesado";
    }

    private boolean isDate(String dateStr) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
            Date parsedDate = dateFormat.parse(dateStr);
            Timestamp timestamp = new Timestamp(parsedDate.getTime());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Timestamp convertDate(String dateStr) {
        Timestamp timestamp = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
            Date parsedDate = dateFormat.parse(dateStr);
            timestamp = new Timestamp(parsedDate.getTime());
        }
        catch (Exception e) {
            this.log.config("ERRRO:" + e);
        }
        return timestamp;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean isNumber(String numberStr) {
        if (numberStr == null || numberStr.isEmpty()) {
            return false;
        }
        numberStr = numberStr.trim();
        numberStr = numberStr.replace(",", "");
        numberStr = numberStr.replace(".", "");
        int i = 0;
        if (numberStr.charAt(0) == '-') {
            if (numberStr.length() <= 1) {
                return false;
            }
            ++i;
        }
        while (i < numberStr.length()) {
            if (!Character.isDigit(numberStr.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

