/*
 * Decompiled with CFR 0.152.
 */
package org.prototipos.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.PO;
import org.compiere.model.X_C_Order;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.ofb.utils.DateUtils;

public class GenNVACHS
extends SvrProcess {
    private int p_ID_BPartner;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_BPartner_ID")) {
                    this.p_ID_BPartner = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        StringBuffer sql = new StringBuffer(" SELECT * FROM i_achsfile1 WHERE C_BPartner_ID > 0  AND IsActive = 'Y' AND I_ACHSFile1_ID NOT IN(SELECT I_ACHSFile1_ID FROM C_OrderLine WHERE I_ACHSFile1_ID IS NOT NULL)");
        if (this.p_ID_BPartner > 0) {
            sql.append(" AND C_BPartner_ID = " + this.p_ID_BPartner);
        }
        sql.append(" ORDER BY C_BPartner_ID DESC");
        String sql3 = "";
        int noInsert = 0;
        int cantTotal = 0;
        int cantAusente = 0;
        BigDecimal Total = Env.ZERO;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            int oldC_BPartner_ID = 0;
            PO order = null;
            int lineNo = 0;
            while (rs.next()) {
                if (oldC_BPartner_ID != rs.getInt("C_Bpartner_ID")) {
                    if (order != null) {
                        cantTotal = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM C_OrderLine  WHERE C_Order_ID=" + order.get_ID() + " AND status NOT IN ('L')");
                        cantAusente = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM C_OrderLine  WHERE C_Order_ID=" + order.get_ID() + " AND status IN ('N')");
                        Total = Env.ONEHUNDRED.multiply(new BigDecimal(cantAusente));
                        Total = Total.divide(new BigDecimal(cantTotal), 0, RoundingMode.HALF_EVEN);
                        DB.executeUpdate("UPDATE C_Order SET Description=Description||' - Ausentismo" + Total.intValue() + "%' " + " WHERE C_Order_ID = " + order.get_ID(), this.get_TrxName());
                    }
                    order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                    ((MOrder)order).setClientOrg(Env.getAD_Client_ID(this.getCtx()), Env.getAD_Org_ID(this.getCtx()));
                    ((X_C_Order)order).setC_DocTypeTarget_ID(MDocType.getDocType("SOO", Env.getAD_Org_ID(this.getCtx())));
                    ((X_C_Order)order).setIsSOTrx(true);
                    ((MOrder)order).setC_BPartner_ID(rs.getInt("C_Bpartner_ID"));
                    ((MOrder)order).setAD_User_ID(Env.getAD_User_ID(this.getCtx()));
                    ((X_C_Order)order).setBill_BPartner_ID(rs.getInt("C_Bpartner_ID"));
                    ((X_C_Order)order).setDescription("Generado automaticamente");
                    ((MOrder)order).setM_PriceList_ID(2000030);
                    ((MOrder)order).setM_Warehouse_ID(2000015);
                    ((X_C_Order)order).setSalesRep_ID(2000012);
                    ((X_C_Order)order).setAD_OrgTrx_ID(Env.getAD_Org_ID(this.getCtx()));
                    ((X_C_Order)order).setDateOrdered(DateUtils.today());
                    ((X_C_Order)order).setDatePromised(DateUtils.today());
                    ((X_C_Order)order).setDateAcct(DateUtils.today());
                    ((X_C_Order)order).setC_ConversionType_ID(114);
                    order.saveEx(this.get_TrxName());
                    ++noInsert;
                    lineNo = 10;
                }
                MOrderLine line = new MOrderLine((MOrder)order);
                line.setLine(lineNo);
                lineNo += 10;
                if (rs.getInt("M_Product_ID") > 0) {
                    line.setM_Product_ID(rs.getInt("M_Product_ID"), true);
                } else {
                    line.setC_Charge_ID(2000006);
                }
                line.setQty(Env.ONE);
                line.setPrice();
                line.setTax();
                line.setLineNetAmt();
                line.setC_Tax_ID(2000002);
                line.set_CustomColumn("Episodio", rs.getString("Episodio"));
                line.set_CustomColumn("Prestacion", rs.getString("Prestacion"));
                line.set_CustomColumn("PrestacionGlosa", rs.getString("PrestacionGlosa"));
                line.set_CustomColumn("Rut_Paciente", rs.getString("Rut_Paciente"));
                line.set_CustomColumn("Name", rs.getString("Name"));
                line.set_CustomColumn("BP_Empresa", rs.getString("BP_Empresa"));
                line.set_CustomColumn("NombreEmpresa", rs.getString("NombreEmpresa"));
                sql3 = "SELECT * FROM i_achsfile3 WHERE Rut_Empresa='" + rs.getString("Rut_Empresa") + "'" + " AND Rut_Paciente='" + rs.getString("Rut_Paciente") + "' AND FechaAtencion =?";
                CPreparedStatement pstmt3 = DB.prepareStatement(sql3.toString(), this.get_TrxName());
                pstmt3.setTimestamp(1, rs.getTimestamp("FechaAtencion"));
                ResultSet rs3 = pstmt3.executeQuery();
                if (rs3.next()) {
                    if (rs3.getString("Status").compareToIgnoreCase("Atendido") == 0 || rs3.getString("Status").compareToIgnoreCase("Atendi\u00e9ndose") == 0 || rs3.getString("Status").compareToIgnoreCase("En sala de espera") == 0 || rs3.getString("Status").compareToIgnoreCase("No confirmado") == 0) {
                        line.set_CustomColumn("Status", "A");
                    } else if (rs3.getString("Status").compareToIgnoreCase("Anulado") == 0) {
                        line.set_CustomColumn("Status", "L");
                        line.setQty(Env.ZERO);
                        line.setPrice(Env.ZERO);
                    } else if (rs3.getString("Status").compareToIgnoreCase("No asiste") == 0) {
                        line.set_CustomColumn("Status", "N");
                    } else {
                        line.set_CustomColumn("Status", "A");
                    }
                    line.set_CustomColumn("FechaAtencion", rs3.getTimestamp("FechaAtencion"));
                    line.set_CustomColumn("Sucursal", rs3.getString("Sucursal"));
                    line.set_CustomColumn("Nombre_Solicitante", rs3.getString("Nombre_Solicitante"));
                    line.set_CustomColumn("CentroDeCosto", rs3.getString("CentroDeCosto"));
                    line.set_CustomColumn("Mail_Solicitante", rs3.getString("Mail_Solicitante"));
                } else {
                    line.set_CustomColumn("Status", "N");
                }
                line.set_CustomColumn("I_ACHSFile1_ID", rs.getString("I_ACHSFile1_ID"));
                line.saveEx(this.get_TrxName());
                oldC_BPartner_ID = rs.getInt("C_Bpartner_ID");
            }
            cantTotal = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM C_OrderLine  WHERE C_Order_ID=" + order.get_ID() + " AND status NOT IN ('L')");
            cantAusente = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM C_OrderLine  WHERE C_Order_ID=" + order.get_ID() + " AND status IN ('N')");
            Total = Env.ONEHUNDRED.multiply(new BigDecimal(cantAusente));
            Total = Total.divide(new BigDecimal(cantTotal), 0, RoundingMode.HALF_EVEN);
            DB.executeUpdate("UPDATE C_Order SET Description=Description||' - Ausentismo" + Total.intValue() + "%' " + " WHERE C_Order_ID = " + order.get_ID(), this.get_TrxName());
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Order - " + sql.toString(), e);
        }
        return "Se han generado " + noInsert + " notas";
    }
}

