/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MWarehouse;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class WindsordProductChange
extends SvrProcess {
    private int p_Invoice_ID = 0;
    private int p_InvoiceLine_ID = 0;
    private int p_NewProduct_ID = 0;
    private BigDecimal p_NewQty;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_Invoice_ID")) {
                    this.p_Invoice_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_InvoiceLine_ID")) {
                    this.p_InvoiceLine_ID = para[i].getParameterAsInt();
                } else if (name.equals("M_Product_ID")) {
                    this.p_NewProduct_ID = para[i].getParameterAsInt();
                } else if (name.equals("QtyInvoiced")) {
                    this.p_NewQty = (BigDecimal)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_Invoice_ID <= 0 || this.p_InvoiceLine_ID <= 0 || this.p_NewProduct_ID <= 0) {
            throw new AdempiereException("Parametros Incompletos");
        }
        if (this.p_NewQty == null || this.p_NewQty.signum() == 0) {
            throw new AdempiereException("la cantidad no puede ser 0");
        }
        MInvoice invoice = new MInvoice(this.getCtx(), this.p_Invoice_ID, this.get_TrxName());
        if (!invoice.getDocStatus().equals("CO") && !invoice.getDocStatus().equals("CL")) {
            throw new AdempiereException("la boleta / factura no posee un estado valido");
        }
        MInvoiceLine line = new MInvoiceLine(this.getCtx(), this.p_InvoiceLine_ID, this.get_TrxName());
        if (this.p_NewQty.compareTo(line.getQtyInvoiced()) > 0) {
            throw new AdempiereException("Error - La cantidad supera la cantidad original");
        }
        int inOutLine_ID = DB.getSQLValue(this.get_TrxName(), "Select M_InOutLine_ID from M_InOutLine where C_OrderLine_ID=?", line.getC_OrderLine_ID());
        if (inOutLine_ID <= 0) {
            throw new AdempiereException("no se puede encontrar la ENTREGA de la boleta");
        }
        MInOutLine out = new MInOutLine(this.getCtx(), inOutLine_ID, this.get_TrxName());
        MProductPricing pp = new MProductPricing(this.p_NewProduct_ID, invoice.getC_BPartner_ID(), line.getQtyInvoiced(), invoice.isSOTrx());
        pp.setM_PriceList_ID(invoice.getM_PriceList_ID());
        int M_PriceList_Version_ID = 0;
        if (M_PriceList_Version_ID == 0) {
            String sql = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC";
            M_PriceList_Version_ID = DB.getSQLValueEx(null, sql, invoice.getM_PriceList_ID(), invoice.getDateOrdered());
        }
        pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        pp.setPriceDate(invoice.getDateOrdered());
        if (pp.getPriceStd().compareTo(line.getPriceActual()) != 0) {
            throw new AdempiereException("Productos de Distinto Precio - Error : Nuevo: " + pp.getPriceStd() + " - Original: " + line.getPriceActual());
        }
        Timestamp MovementDate = TimeUtil.getDay(null);
        MWarehouse ware = MWarehouse.get(this.getCtx(), invoice.getC_Order().getM_Warehouse_ID());
        MInventory inventory = new MInventory(this.getCtx(), 0, this.get_TrxName());
        inventory.setDescription("Devolucion Cambio Producto Boleta Mismo Precio :" + invoice.getDocumentNo());
        inventory.setClientOrg(invoice.getAD_Client_ID(), invoice.getAD_Org_ID());
        inventory.setM_Warehouse_ID(ware.getM_Warehouse_ID());
        inventory.setMovementDate(MovementDate);
        if (!inventory.save()) {
            this.log.log(Level.SEVERE, "Inventory not saved");
            throw new AdempiereException("No se puede actualizar el inventario");
        }
        MInventoryLine iline1 = new MInventoryLine(inventory, out.getM_Locator_ID(), out.getM_Product_ID(), out.getM_AttributeSetInstance_ID(), Env.ZERO, this.p_NewQty);
        iline1.save();
        MInventoryLine iline2 = new MInventoryLine(inventory, ware.getDefaultLocator().getM_Locator_ID(), this.p_NewProduct_ID, 0, this.p_NewQty, Env.ZERO);
        iline2.save();
        line.addDescription("*Producto Cambiado* por:" + MProduct.get(this.getCtx(), this.p_NewProduct_ID).getName());
        line.save();
        inventory.processIt("CO");
        inventory.setProcessed(true);
        inventory.save();
        return "Producto Cambiado, Inventario Actualizado";
    }
}

