/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.X_C_PaymentRequest;
import org.compiere.model.X_C_ProjectSchedule;
import org.compiere.model.X_DM_Document;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class VoidPaymentRequestG
extends SvrProcess {
    private int Record_ID;
    private String P_Message;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("Message")) {
                    this.P_Message = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.Record_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        String sqlvalid = "SELECT COUNT(*) FROM C_Payment WHERE C_PaymentRequest_ID = ? AND DocStatus in ('CO','DR','CL','IN')";
        X_C_PaymentRequest pr = new X_C_PaymentRequest(Env.getCtx(), this.Record_ID, this.get_TrxName());
        int cant = DB.getSQLValue(sqlvalid, sqlvalid, pr.get_ID());
        if (cant > 0) {
            return "Solicitud no se puede anular, existen " + cant + " pagos asociados esta solicitud";
        }
        if (pr.getRequestType().equals("R")) {
            MProject pj = new MProject(this.getCtx(), pr.get_ValueAsInt("C_Project_ID"), this.get_TrxName());
            pj.setProjectBalanceAmt(pj.getProjectBalanceAmt().subtract(pr.getPayAmt()));
            pj.save();
            String sql2 = "select max(dmd.c_projectline_id) from C_PaymentRequest cpr inner join C_ProjectSchedule cps on (cpr.C_ProjectSchedule_id = cps.C_ProjectSchedule_id) inner join DM_Document dmd on (dmd.DM_Document_ID = cps.DM_Document_id) where cpr.C_PaymentRequest_ID=?";
            int cpl = DB.getSQLValue(this.get_TrxName(), sql2, pr.get_ID());
            MProjectLine pjline = new MProjectLine(this.getCtx(), cpl, this.get_TrxName());
            BigDecimal sum = (BigDecimal)pjline.get_Value("ProjectBalanceAmt");
            sum = sum.subtract(pr.getPayAmt());
            pjline.set_CustomColumn("ProjectBalanceAmt", sum);
            pjline.save();
            if (pr.get_ValueAsInt("C_ProjectSchedule_ID") > 0) {
                DB.executeUpdate("update C_ProjectSchedule set isvalid='Y',C_PaymentRequest_ID=0 where C_ProjectSchedule_ID=" + pr.get_ValueAsInt("C_ProjectSchedule_ID"), this.get_TrxName());
            }
            X_C_ProjectSchedule ps = new X_C_ProjectSchedule(this.getCtx(), pr.get_ValueAsInt("C_ProjectSchedule_ID"), this.get_TrxName());
            X_DM_Document dm = new X_DM_Document(this.getCtx(), ps.get_ValueAsInt("DM_Document_ID"), this.get_TrxName());
            BigDecimal NAcumAnticipo = (BigDecimal)dm.get_Value("AcumAnticipo");
            if (pr.get_ValueAsString("IsPrepayment").equals("true") || pr.get_ValueAsString("IsPrepayment").equals("Y")) {
                NAcumAnticipo = NAcumAnticipo.subtract(pr.getPayAmt());
                dm.set_CustomColumn("AcumAnticipo", NAcumAnticipo);
            } else {
                BigDecimal NAmtDate = (BigDecimal)dm.get_Value("AmtDate");
                NAmtDate = NAmtDate.subtract(ps.getDueAmt());
                dm.set_CustomColumn("AmtDate", NAmtDate);
            }
            String sqlER = "select abs(Coalesce(sum(pp.referenceamount), 0)) + abs(Coalesce(sum(pp.amt), 0)) from C_ProjectSchedule ps inner join PM_ProjectPay pp on (pp.C_ProjectSchedule_id = ps.C_ProjectSchedule_id) where ps.C_ProjectSchedule_id = ? and pay_type like 'ER'";
            BigDecimal sumER = new BigDecimal("0.0");
            sumER = DB.getSQLValueBD(this.get_TrxName(), sqlER, pr.get_ValueAsInt("C_ProjectSchedule_ID"));
            BigDecimal NAcumDevR = (BigDecimal)dm.get_Value("AcumDevR");
            NAcumDevR = NAcumDevR.subtract(sumER);
            dm.set_CustomColumn("AcumDevR", NAcumDevR);
            String sqlD1 = "select abs(Coalesce(sum(pp.referenceamount), 0)) + abs(Coalesce(sum(pp.amt), 0)) from C_ProjectSchedule ps inner join PM_ProjectPay pp on (pp.C_ProjectSchedule_id = ps.C_ProjectSchedule_id) where ps.C_ProjectSchedule_id = ? and pay_type like 'D1'";
            BigDecimal sumD1 = new BigDecimal("0.0");
            sumD1 = DB.getSQLValueBD(this.get_TrxName(), sqlD1, pr.get_ValueAsInt("C_ProjectSchedule_ID"));
            BigDecimal NAcumMultas = (BigDecimal)dm.get_Value("AcumMultas");
            NAcumMultas = NAcumMultas.subtract(sumD1);
            dm.set_CustomColumn("AcumMultas", NAcumMultas);
            String sqlR1 = "select abs(Coalesce(sum(pp.referenceamount), 0)) + abs(Coalesce(sum(pp.amt), 0)) from C_ProjectSchedule ps inner join PM_ProjectPay pp on (pp.C_ProjectSchedule_id = ps.C_ProjectSchedule_id) where ps.C_ProjectSchedule_id = ? and pay_type like 'R1'";
            BigDecimal sumR1 = new BigDecimal("0.0");
            sumR1 = DB.getSQLValueBD(this.get_TrxName(), sqlR1, pr.get_ValueAsInt("C_ProjectSchedule_ID"));
            BigDecimal NAcumRetencion = (BigDecimal)dm.get_Value("AcumRetencion");
            NAcumRetencion = NAcumRetencion.subtract(sumR1);
            dm.set_CustomColumn("AcumRetencion", NAcumRetencion);
            String sqlD2 = "select abs(Coalesce(sum(pp.referenceamount), 0)) + abs(Coalesce(sum(pp.amt), 0)) from C_ProjectSchedule ps inner join PM_ProjectPay pp on (pp.C_ProjectSchedule_id = ps.C_ProjectSchedule_id) where ps.C_ProjectSchedule_id = ? and pay_type like 'D2'";
            BigDecimal sumD2 = new BigDecimal("0.0");
            sumD2 = DB.getSQLValueBD(this.get_TrxName(), sqlD2, pr.get_ValueAsInt("C_ProjectSchedule_ID"));
            BigDecimal NAcumDevA = (BigDecimal)dm.get_Value("AcumDevA");
            NAcumDevA = NAcumDevA.subtract(sumD2);
            dm.set_CustomColumn("AcumDevA", NAcumDevA);
            dm.set_CustomColumn("AcumAnticipo", NAcumAnticipo);
            dm.save();
        }
        pr.setDocStatus("VO");
        String sqlDelete = "DELETE FROM Fact_Acct WHERE record_id = " + pr.get_ID() + "AND AD_Table_ID = " + pr.get_Table_ID();
        DB.executeUpdate(sqlDelete, this.get_TrxName());
        pr.save();
        return "Solicitud Anulada";
    }
}

