/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MPeriod;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class TSMReporteConductor
extends SvrProcess {
    private Timestamp p_MovementDateFrom = null;
    private Timestamp p_MovementDateTo = null;
    private int p_C_ProjectOFB_ID;
    private int p_C_Period_ID = 0;
    private int p_PInstance_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_Period_ID")) {
                    this.p_C_Period_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_ProjectOFB_ID")) {
                    this.p_C_ProjectOFB_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_PInstance_ID = this.getAD_PInstance_ID();
    }

    @Override
    protected String doIt() throws AdempiereSystemError {
        MPeriod period = new MPeriod(this.getCtx(), this.p_C_Period_ID, this.get_TrxName());
        this.p_MovementDateFrom = period.getStartDate();
        this.p_MovementDateTo = period.getEndDate();
        DB.executeUpdate("DELETE FROM T_ReporteConductor", this.get_TrxName());
        StringBuilder sqlC = new StringBuilder();
        sqlC.append("SELECT max(rv.ad_client_id) AS ad_client_id, max(rv.ad_org_id) AS ad_org_id, max(rv.isactive) AS isactive, max(rv.created) AS created, max(rv.createdby) AS createdby, max(rv.updated) AS updated, max(rv.updatedby) AS updatedby, ROUND((EXTRACT(epoch FROM (sum(rv.sum3::interval)))/3600)::numeric,2) AS sum, ROUND((EXTRACT(epoch FROM (sum(rv.sum2::interval)))/3600)::numeric,2) AS sum2, rv.c_bpartner_id, ROUND((EXTRACT(epoch FROM (sum(rv.sum::interval)))/3600)::numeric,2) AS sumtotal, round(round((date_part('epoch'::text, sum(rv.sum3::interval)) / 3600::double precision)::numeric, 2)::double precision * 100::double precision / CASE WHEN round((date_part('epoch'::text, sum(rv.sum::interval)) / 3600::double precision)::numeric, 2)::double precision = 0::double precision THEN 1::double precision ELSE round((date_part('epoch'::text, sum(rv.sum::interval)) / 3600::double precision)::numeric, 2)::double precision END)::numeric AS driveporcent, (( SELECT count(*) AS count FROM m_movement WHERE m_movement.c_bpartner_id = rv.c_bpartner_id)) * 12 AS qty, rv.c_projectofb_id, sum(rv.cost)as cost, (SELECT COUNT(DISTINCT(mml.POReference)) FROM M_MovementLine mml INNER JOIN M_Movement mm ON (mml.M_Movement_ID = mm.M_Movement_ID) WHERE MovementDate between ? and ? AND mml.POReference is not null AND mml.POReference <> '0' AND mm.C_ProjectOFB_ID = rv.C_ProjectOFB_ID AND mm.C_BPartner_ID = rv.C_BPartner_ID) as shipmentcount, (SELECT COUNT(DISTINCT(mml.POReference)) FROM M_MovementLine mml INNER JOIN M_Movement mm ON (mml.M_Movement_ID = mm.M_Movement_ID) WHERE MovementDate between ? and ? AND mml.TP_LineNo is not null AND mml.TP_LineNo <> 0 AND mml.TP_LineNo <> 99 AND mm.C_ProjectOFB_ID = rv.C_ProjectOFB_ID AND mm.C_BPartner_ID = rv.C_BPartner_ID) as travelcount, (SELECT COUNT(1) FROM M_Movement mm WHERE MovementDate between ? and ? AND mm.C_ProjectOFB_ID = rv.C_ProjectOFB_ID AND mm.C_BPartner_ID = rv.C_BPartner_ID) as cant, ((SELECT COUNT(1) FROM M_Movement mm WHERE MovementDate between ? and ? AND mm.C_ProjectOFB_ID = rv.C_ProjectOFB_ID AND mm.C_BPartner_ID = rv.C_BPartner_ID) *  100)/ CASE WHEN (SELECT Workshift FROM C_ProjectOFB WHERE C_ProjectOFB_ID = rv.C_ProjectOFB_ID) like '30' THEN 26 WHEN (SELECT Workshift FROM C_ProjectOFB WHERE C_ProjectOFB_ID = rv.C_ProjectOFB_ID) like '60' THEN 60 WHEN (SELECT Workshift FROM C_ProjectOFB WHERE C_ProjectOFB_ID = rv.C_ProjectOFB_ID) like '90' THEN 90 END as hrWorkshift, round(((EXTRACT(epoch from sum(rv.sum))/648000)*100)::numeric,2) as utilization FROM rvofb_detallehojarutaConFecha rv where movementdate between ? and ? ");
        if (this.p_C_ProjectOFB_ID > 0) {
            sqlC.append(" AND rv.C_ProjectOFB_ID = ? ");
        }
        sqlC.append("GROUP BY rv.c_bpartner_id, rv.c_projectofb_id");
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sqlC.toString(), this.get_TrxName());
            pstmt.setTimestamp(1, this.p_MovementDateFrom);
            pstmt.setTimestamp(2, this.p_MovementDateTo);
            pstmt.setTimestamp(3, this.p_MovementDateFrom);
            pstmt.setTimestamp(4, this.p_MovementDateTo);
            pstmt.setTimestamp(5, this.p_MovementDateFrom);
            pstmt.setTimestamp(6, this.p_MovementDateTo);
            pstmt.setTimestamp(7, this.p_MovementDateFrom);
            pstmt.setTimestamp(8, this.p_MovementDateTo);
            pstmt.setTimestamp(9, this.p_MovementDateFrom);
            pstmt.setTimestamp(10, this.p_MovementDateTo);
            if (this.p_C_ProjectOFB_ID > 0) {
                pstmt.setInt(11, this.p_C_ProjectOFB_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String Insert = new String("INSERT INTO T_ReporteConductor(ad_pinstance_id,ad_client_id,ad_org_id,isactive,created,createdby,updated,updatedby,sum,sum2,c_bpartner_id,sumtotal,driveporcent,qty,c_projectofb_id,cost,shipmentcount,travelcount,cant,hrWorkshift,utilization) VALUES (" + this.p_PInstance_ID + "," + rs.getInt("AD_Client_ID") + "," + rs.getInt("AD_Org_ID") + ",'" + rs.getString("IsActive") + "','" + rs.getTimestamp("Created") + "'," + rs.getInt("CreatedBy") + ",'" + rs.getTimestamp("Updated") + "'," + rs.getInt("UpdatedBy") + "," + rs.getDouble("sum") + "," + rs.getDouble("sum2") + "," + rs.getInt("c_bpartner_id") + "," + rs.getDouble("sumtotal") + "," + rs.getDouble("driveporcent") + "," + rs.getDouble("qty") + "," + rs.getInt("c_projectofb_id") + "," + rs.getBigDecimal("cost") + "," + rs.getDouble("shipmentcount") + "," + rs.getDouble("travelcount") + "," + rs.getInt("cant") + "," + rs.getDouble("hrWorkshift") + "," + rs.getDouble("utilization") + ")");
                DB.executeUpdate(Insert, this.get_TrxName());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        DB.executeUpdate("UPDATE T_ReporteConductor SET AD_PInstance_ID=" + this.p_PInstance_ID, this.get_TrxName());
        return "";
    }
}

