/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.X_GL_BudgetControlLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProcessRequisitionDDHH
extends SvrProcess {
    private int p_Requisition_ID = 0;
    private String p_Action = "PR";
    private String p_Message = "";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("Action")) {
                this.p_Action = para[i].getParameterAsString();
            } else if (name.equals("Message")) {
                this.p_Message = para[i].getParameterAsString();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.p_Requisition_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_Requisition_ID > 0) {
            MRequisition req = new MRequisition(this.getCtx(), this.p_Requisition_ID, this.get_TrxName());
            String newStatus = "DR";
            String newAction = "DR";
            String mode = req.get_Value("Mode").toString();
            this.log.config("mode " + mode);
            this.log.config("paction " + this.p_Action);
            if (req.getDocStatus().compareTo("DR") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "SR";
                newAction = "SR";
            } else if (req.getDocStatus().compareTo("SR") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "AJ";
                newAction = "AJ";
            } else if (req.getDocStatus().compareTo("AJ") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "AB";
                newAction = "AB";
            } else if (req.getDocStatus().compareTo("AB") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "CO";
                newAction = "CO";
            } else if (req.getDocStatus().compareTo("DR") == 0 && this.p_Action.compareTo("VO") == 0) {
                newStatus = "DR";
                newAction = "DR";
            } else if (req.getDocStatus().compareTo("SR") == 0 && this.p_Action.compareTo("VO") == 0) {
                newStatus = "DR";
                newAction = "DR";
            } else if (req.getDocStatus().compareTo("AJ") == 0 && this.p_Action.compareTo("VO") == 0) {
                newStatus = "DR";
                newAction = "DR";
            } else if (req.getDocStatus().compareTo("AB") == 0 && this.p_Action.compareTo("VO") == 0) {
                newStatus = "DR";
                newAction = "DR";
            }
            int cant = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM AD_Document_Action_Access daa INNER JOIN AD_Ref_List rl ON (daa.AD_Ref_List_ID = rl.AD_Ref_List_ID)  WHERE value = '" + newAction + "' AND AD_Role_ID = " + Env.getAD_Role_ID(this.getCtx()) + " AND C_DocType_ID = " + req.getC_DocType_ID());
            this.log.config("cantidad" + cant);
            if (cant > 0) {
                if (newAction.compareTo("CO") != 0) {
                    req.setDocStatus(newStatus);
                    if (newAction.compareTo("DR") == 0) {
                        req.set_CustomColumn("Comments2", "*** Solicitud devuelta ***");
                        String prevmessage = DB.getSQLValueString(this.get_TrxName(), "SELECT comments3 from m_requisition where m_requisition_id = ? ", req.get_ID());
                        if (prevmessage != null) {
                            req.set_CustomColumn("Comments3", String.valueOf(prevmessage) + " - " + this.p_Message);
                        } else {
                            req.set_CustomColumn("Comments3", this.p_Message);
                        }
                        req.save();
                        CallableStatement cst = DB.prepareCall("{call pa_envia_mail_auto2(?,?,?,?)}");
                        this.log.config("id " + req.get_ID());
                        cst.setInt(1, Env.getAD_Client_ID(this.getCtx()));
                        cst.setInt(2, 8);
                        cst.setString(3, "-");
                        cst.setInt(4, req.get_ID());
                        cst.execute();
                    } else if (newAction.compareTo("SR") == 0) {
                        String sqlatt = "select ad_attachment_id from ad_attachment where ad_table_id = 702 and record_id = " + req.get_ID();
                        CPreparedStatement pstmt = DB.prepareStatement(sqlatt, this.get_TrxName());
                        ResultSet rs = pstmt.executeQuery();
                        int att = 0;
                        while (rs.next()) {
                            ++att;
                        }
                        if (att <= 0) {
                            throw new AdempiereException("No se ha encontrado adjuntos");
                        }
                        req.set_CustomColumn("Comments2", "");
                        int countlines = DB.getSQLValue(req.get_TrxName(), "SELECT count(1) FROM m_requisitionline where m_requisition_id = " + req.get_ID());
                        if (countlines == 0) {
                            throw new AdempiereException("La solicitud no tiene l\u00edneas");
                        }
                        String wf = req.get_ValueAsString("IsWorkflow");
                        this.log.config("isworkflow = " + wf);
                        if (wf.compareTo("true") == 0) {
                            int ID_Org = req.get_ValueAsInt("AD_OrgRef2_ID");
                            req.set_CustomColumn("AD_OrgRef_ID", req.getAD_Org_ID());
                            req.setAD_Org_ID(ID_Org);
                            DB.executeUpdate("UPDATE m_requisitionline set ad_org_id = " + ID_Org + " where m_requisition_id = " + req.get_ID(), this.get_TrxName());
                        }
                        req.save();
                        CallableStatement cst = DB.prepareCall("{call pa_envia_mail_auto2(?,?,?,?)}");
                        this.log.config("id " + req.get_ID());
                        cst.setInt(1, Env.getAD_Client_ID(this.getCtx()));
                        cst.setInt(2, 9);
                        cst.setString(3, "-");
                        cst.setInt(4, req.get_ID());
                        cst.execute();
                    } else if (newAction.compareTo("AJ") == 0) {
                        req.set_CustomColumn("DateReturn", new Timestamp(System.currentTimeMillis()));
                        req.save();
                        CallableStatement cst = DB.prepareCall("{call pa_envia_mail_auto2(?,?,?,?)}");
                        this.log.config("id " + req.get_ID());
                        cst.setInt(1, Env.getAD_Client_ID(this.getCtx()));
                        cst.setInt(2, 10);
                        cst.setString(3, "-");
                        cst.setInt(4, req.get_ID());
                        cst.execute();
                        MCurrency curreTo = new MCurrency(this.getCtx(), 228, this.get_TrxName());
                        BigDecimal MultiplyRate = null;
                        if (req.get_ValueAsInt("C_Currency_ID") != curreTo.get_ID()) {
                            if (MultiplyRate == null || MultiplyRate.signum() == 0) {
                                MultiplyRate = MConversionRate.getRate(req.get_ValueAsInt("C_Currency_ID"), curreTo.get_ID(), req.getDateDoc(), req.get_ValueAsInt("C_ConversionType_ID"), req.getAD_Client_ID(), req.getAD_Org_ID());
                            }
                            this.log.config("currency = " + req.get_ValueAsInt("C_Currency_ID") + " - To_Currency=" + curreTo.get_ID() + "- Date=" + req.getDateDoc() + "-Conversion=" + req.get_ValueAsInt("C_ConversionType_ID"));
                            if (MultiplyRate == null || MultiplyRate.compareTo(Env.ZERO) <= 0) {
                                throw new AdempiereUserError("Por favor definir el tipo de cambio", "Conversion Monetaria");
                            }
                        } else {
                            MultiplyRate = Env.ONE;
                        }
                        MRequisitionLine[] lines = req.getLines();
                        int i = 0;
                        while (i < lines.length) {
                            MRequisitionLine rLine = lines[i];
                            if (rLine.get_ValueAsInt("GL_BudgetControlLine_ID") > 0) {
                                X_GL_BudgetControlLine bcLine = new X_GL_BudgetControlLine(this.getCtx(), rLine.get_ValueAsInt("GL_BudgetControlLine_ID"), this.get_TrxName());
                                BigDecimal usedAmt = (BigDecimal)bcLine.get_Value("Amount2");
                                if (usedAmt == null) {
                                    usedAmt = Env.ZERO;
                                }
                                BigDecimal amtConvert = rLine.getLineNetAmt().multiply(MultiplyRate).setScale(curreTo.getStdPrecision(), 6);
                                if (rLine.get_ValueAsBoolean("IsTaxed")) {
                                    amtConvert = amtConvert.multiply(new BigDecimal("1.19"));
                                }
                                usedAmt = usedAmt.add(amtConvert);
                                bcLine.set_CustomColumn("Amount2", usedAmt);
                                bcLine.save();
                            }
                            ++i;
                        }
                    } else if (newAction.compareTo("AB") == 0) {
                        req.save();
                        CallableStatement cst = DB.prepareCall("{call pa_envia_mail_auto2(?,?,?,?)}");
                        this.log.config("id " + req.get_ID());
                        cst.setInt(1, Env.getAD_Client_ID(this.getCtx()));
                        cst.setInt(2, 11);
                        cst.setString(3, "-");
                        cst.setInt(4, req.get_ID());
                        cst.execute();
                    } else {
                        req.save();
                    }
                } else if (newAction.compareTo("CO") == 0) {
                    req.setDocStatus("IP");
                    req.processIt("CO");
                    req.save();
                }
            } else {
                throw new AdempiereException("Error: Permisos de rol insuficientes");
            }
        }
        return "Procesado";
    }
}

