/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProcessAssetNetting
extends SvrProcess {
    private int p_C_Year_ID = 0;
    private int p_AD_Org_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("Year")) {
                    this.p_C_Year_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        int Year = DB.getSQLValue(this.get_TrxName(), "SELECT cast(fiscalyear as int) from c_year where c_year_id = " + this.p_C_Year_ID);
        String sqlassets = "SELECT ad.a_Asset_id from a_depreciation_workfile ad INNER JOIN a_asset ass on (ass.a_Asset_id = ad.a_asset_id) WHERE  ROUND(ad.A_Asset_Cost) - Round(ad.a_Accumulated_depr) <= 2 AND  ROUND(ad.A_Asset_Cost) > 2 AND ass.isinposession='Y' AND  ass.isactive='Y' AND ass.AssetSituation='ALT'";
        if (this.p_AD_Org_ID > 0) {
            sqlassets = String.valueOf(sqlassets) + " AND ass.AD_Org_ID = " + this.p_AD_Org_ID;
        }
        CPreparedStatement pstmt = null;
        this.log.info("p_C_Year_ID=" + this.p_C_Year_ID + ", Year=" + Year);
        int count = 0;
        BigDecimal amountdep = Env.ZERO;
        try {
            this.log.config("sqlassets " + sqlassets);
            pstmt = DB.prepareStatement(sqlassets, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int assetwf = DB.getSQLValue(this.get_TrxName(), "SELECT max(A_depreciation_workfile_id) from a_depreciation_workfile where a_Asset_id = " + rs.getInt("A_Asset_ID"));
                if (assetwf <= 0) continue;
                MDepreciationWorkfile wf = new MDepreciationWorkfile(this.getCtx(), assetwf, this.get_TrxName());
                wf.set_CustomColumn("AmtAcctBalance", wf.getA_Accumulated_Depr().setScale(0, 4));
                wf.setA_Asset_Cost(Env.ONE);
                wf.setA_Accumulated_Depr(Env.ZERO);
                wf.set_CustomColumn("ANNO", Year);
                wf.save();
                ++count;
                amountdep = amountdep.add(wf.getA_Accumulated_Depr().setScale(0, 4));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            this.log.config("total de bienes " + count + ". Monto total: " + amountdep + ". year: " + Year);
            DB.executeUpdate("UPDATE a_Asset SET assetsituation='TER' WHERE assetsituation='ALT' and isactive='Y'  AND isinposession='Y' and a_asset_id in  (SELECT a_Asset_id from a_depreciation_workfile WHERE anno = " + Year + ")", this.get_TrxName());
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return "Detalle Generado. Total de bienes: " + count;
    }
}

