/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.X_M_InOutLine;
import org.compiere.model.X_M_Storage;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class InOutGenerateOFB
extends SvrProcess {
    private boolean p_Selection = false;
    private int p_M_Warehouse_ID = 0;
    private int p_C_BPartner_ID = 0;
    private Timestamp p_DatePromised = null;
    private boolean p_IsUnconfirmedInOut = false;
    private String p_docAction = "CO";
    private boolean p_ConsolidateDocument = true;
    private Timestamp p_DateShipped = null;
    private MInOut m_shipment = null;
    private int m_created = 0;
    private int m_line = 0;
    private Timestamp m_movementDate = null;
    private int m_lastC_BPartner_Location_ID = -1;
    private String m_sql = null;
    private HashMap<SParameter, MStorage[]> m_map = new HashMap();
    private SParameter m_lastPP = null;
    private MStorage[] m_lastStorages = null;
    private String msg = "";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Warehouse_ID")) {
                    this.p_M_Warehouse_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("DatePromised")) {
                    this.p_DatePromised = (Timestamp)para[i].getParameter();
                } else if (name.equals("Selection")) {
                    this.p_Selection = "Y".equals(para[i].getParameter());
                } else if (name.equals("IsUnconfirmedInOut")) {
                    this.p_IsUnconfirmedInOut = "Y".equals(para[i].getParameter());
                } else if (name.equals("ConsolidateDocument")) {
                    this.p_ConsolidateDocument = "Y".equals(para[i].getParameter());
                } else if (name.equals("DocAction")) {
                    this.p_docAction = (String)para[i].getParameter();
                } else if (name.equals("MovementDate")) {
                    this.p_DateShipped = (Timestamp)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            if (this.p_DateShipped == null) {
                this.m_movementDate = Env.getContextAsDate(this.getCtx(), "#Date");
                if (this.m_movementDate == null) {
                    this.m_movementDate = new Timestamp(System.currentTimeMillis());
                }
            } else {
                this.m_movementDate = this.p_DateShipped;
            }
            if (!"CO".equals(this.p_docAction)) {
                this.p_docAction = "PR";
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("Selection=" + this.p_Selection + ", M_Warehouse_ID=" + this.p_M_Warehouse_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", Consolidate=" + this.p_ConsolidateDocument + ", IsUnconfirmed=" + this.p_IsUnconfirmedInOut + ", Movement=" + this.m_movementDate);
        if (this.p_M_Warehouse_ID == 0) {
            throw new AdempiereUserError("@NotFound@ @M_Warehouse_ID@");
        }
        if (this.p_Selection) {
            this.m_sql = "SELECT C_Order.* FROM C_Order, T_Selection WHERE C_Order.DocStatus='CO' AND C_Order.IsSOTrx='Y' AND C_Order.AD_Client_ID=? AND C_Order.C_Order_ID = T_Selection.T_Selection_ID AND T_Selection.AD_PInstance_ID=? ";
        } else {
            this.m_sql = "SELECT * FROM C_Order o WHERE DocStatus='CO' AND IsSOTrx='Y' AND o.C_DocType_ID IN (SELECT C_DocType_ID FROM C_DocType WHERE DocBaseType='SOO' AND DocSubTypeSO NOT IN ('ON','OB','WR'))\tAND o.IsDropShip='N' AND o.DeliveryRule<>'M' AND EXISTS (SELECT * FROM C_OrderLine ol WHERE ol.M_Warehouse_ID=?";
            if (this.p_DatePromised != null) {
                this.m_sql = String.valueOf(this.m_sql) + " AND TRUNC(ol.DatePromised)<=?";
            }
            this.m_sql = String.valueOf(this.m_sql) + " AND o.C_Order_ID=ol.C_Order_ID AND ol.QtyOrdered<>ol.QtyDelivered)";
            if (this.p_C_BPartner_ID != 0) {
                this.m_sql = String.valueOf(this.m_sql) + " AND o.C_BPartner_ID=?";
            }
        }
        this.m_sql = String.valueOf(this.m_sql) + " ORDER BY M_Warehouse_ID, PriorityRule, M_Shipper_ID, C_BPartner_ID, C_BPartner_Location_ID, C_Order_ID";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(this.m_sql, this.get_TrxName());
            int index = 1;
            if (this.p_Selection) {
                pstmt.setInt(index++, Env.getAD_Client_ID(this.getCtx()));
                pstmt.setInt(index++, this.getAD_PInstance_ID());
            } else {
                pstmt.setInt(index++, this.p_M_Warehouse_ID);
                if (this.p_DatePromised != null) {
                    pstmt.setTimestamp(index++, this.p_DatePromised);
                }
                if (this.p_C_BPartner_ID != 0) {
                    pstmt.setInt(index++, this.p_C_BPartner_ID);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, this.m_sql, e);
        }
        return this.generate(pstmt);
    }

    private String generate(PreparedStatement pstmt) {
        MClient client = MClient.get(this.getCtx());
        try {
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MOrder order = new MOrder(this.getCtx(), rs, this.get_TrxName());
                if (!this.p_ConsolidateDocument || this.m_shipment != null && (this.m_shipment.getC_BPartner_Location_ID() != order.getC_BPartner_Location_ID() || this.m_shipment.getM_Shipper_ID() != order.getM_Shipper_ID())) {
                    this.completeShipment();
                }
                this.log.fine("check: " + order + " - DeliveryRule=" + order.getDeliveryRule());
                boolean completeOrder = "O".equals(order.getDeliveryRule());
                boolean completeLine = "L".equals(order.getDeliveryRule());
                boolean available = "A".equals(order.getDeliveryRule());
                String where = " AND M_Warehouse_ID=" + this.p_M_Warehouse_ID;
                if (this.p_DatePromised != null) {
                    where = String.valueOf(where) + " AND (TRUNC(DatePromised)<=" + DB.TO_DATE(this.p_DatePromised, true) + " OR DatePromised IS NULL)";
                }
                MOrderLine[] lines = order.getLines(where, "ORDER BY C_BPartner_Location_ID, M_Product_ID");
                this.exploreLines(lines, completeOrder, completeLine, available);
                this.m_line += 1000;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, this.m_sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.completeShipment();
        return "@Created@ = " + this.m_created;
    }

    private void exploreLines(MOrderLine[] lines, boolean completeOrder, boolean completeLine, boolean available) {
        Serializable[] storages;
        String MMPolicy;
        MProduct product;
        BigDecimal toDeliver;
        BigDecimal onHand;
        MOrderLine line;
        int i;
        boolean error = false;
        if (completeOrder || completeLine) {
            i = 0;
            while (i < lines.length) {
                line = lines[i];
                if (line.getM_Warehouse_ID() == this.p_M_Warehouse_ID) {
                    this.log.fine("check: " + line);
                    onHand = Env.ZERO;
                    toDeliver = line.getQtyOrdered().subtract(line.getQtyDelivered());
                    product = line.getProduct();
                    if (!(product != null && toDeliver.signum() == 0 || line.getC_Charge_ID() != 0 && toDeliver.signum() == 0)) {
                        if (!(product != null && product.isStocked() || line.getQtyOrdered().signum() != 0 && toDeliver.signum() == 0)) {
                            if (!"O".equals(line.getParent().getDeliveryRule())) {
                                this.createLine(line.getParent(), line, toDeliver, null, false);
                            }
                        } else if (product.isItem()) {
                            boolean fullLine;
                            MMPolicy = product.getMMPolicy();
                            storages = this.getStorages(line.getM_Warehouse_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), "F".equals(MMPolicy));
                            BigDecimal inProcess = this.getInProcessW(line.getM_Product_ID(), line.getM_Warehouse_ID());
                            int j = 0;
                            while (j < storages.length) {
                                Serializable storage = storages[j];
                                onHand = onHand.add(((X_M_Storage)storage).getQtyOnHand());
                                this.log.config("storage " + j + ",id:" + ((X_M_Storage)storage).getM_Locator_ID() + " QtyOnHand:" + ((X_M_Storage)storage).getQtyOnHand());
                                ++j;
                            }
                            BigDecimal stock = onHand;
                            boolean bl = fullLine = (onHand = onHand.subtract(inProcess)).compareTo(toDeliver) >= 0 || toDeliver.signum() < 0;
                            if ((completeOrder || completeLine) && !fullLine) {
                                try {
                                    this.addLog(0, line.getDateOrdered(), null, String.valueOf(line.getParent().getDocumentNo()) + ": No se posee stock para " + line.getM_Product().getValue());
                                    this.addLog(0, line.getDateOrdered(), null, String.valueOf(line.getParent().getDocumentNo()) + ": Encontrado " + onHand + "|Stock :" + stock + " enProceso: " + inProcess + " | Requerido " + toDeliver + "|" + this.getReplenish(line.getM_Product_ID(), line.getM_AttributeSetInstance_ID()));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                error = true;
                            }
                        }
                    }
                }
                ++i;
            }
        }
        if (error) {
            return;
        }
        i = 0;
        while (i < lines.length) {
            line = lines[i];
            if (line.getM_Warehouse_ID() == this.p_M_Warehouse_ID) {
                this.log.fine("check: " + line);
                onHand = Env.ZERO;
                toDeliver = line.getQtyOrdered().subtract(line.getQtyDelivered());
                product = line.getProduct();
                if (!(product != null && toDeliver.signum() == 0 || line.getC_Charge_ID() != 0 && toDeliver.signum() == 0)) {
                    if (!(product != null && product.isStocked() || line.getQtyOrdered().signum() != 0 && toDeliver.signum() == 0)) {
                        if (!"O".equals(line.getParent().getDeliveryRule())) {
                            this.createLine(line.getParent(), line, toDeliver, null, false);
                        }
                    } else {
                        MMPolicy = product.getMMPolicy();
                        storages = this.getLocators(line.getM_Warehouse_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID());
                        this.createLine(line.getParent(), line, toDeliver, (Integer[])storages, false);
                    }
                }
            }
            ++i;
        }
    }

    private void createLine(MOrder order, MOrderLine orderLine, BigDecimal qty, Integer[] storages, boolean force) {
        if (this.m_lastC_BPartner_Location_ID != orderLine.getC_BPartner_Location_ID()) {
            this.completeShipment();
        }
        this.m_lastC_BPartner_Location_ID = orderLine.getC_BPartner_Location_ID();
        if (this.m_shipment == null) {
            this.m_shipment = new MInOut(order, order.getC_DocType().getC_DocTypeShipment_ID(), this.m_movementDate);
            this.m_shipment.setM_Warehouse_ID(orderLine.getM_Warehouse_ID());
            if (order.getC_BPartner_ID() != orderLine.getC_BPartner_ID()) {
                this.m_shipment.setC_BPartner_ID(orderLine.getC_BPartner_ID());
            }
            if (order.getC_BPartner_Location_ID() != orderLine.getC_BPartner_Location_ID()) {
                this.m_shipment.setC_BPartner_Location_ID(orderLine.getC_BPartner_Location_ID());
            }
            if (!this.m_shipment.save()) {
                throw new IllegalStateException("Could not create Shipment");
            }
        }
        MProduct product = orderLine.getProduct();
        product.getValue();
        if (storages == null || !product.isItem() || storages.length == 0) {
            MInOutLine line = new MInOutLine(this.m_shipment);
            line.setOrderLine(orderLine, 0, Env.ZERO);
            line.setQty(qty);
            if (orderLine.getQtyEntered().compareTo(orderLine.getQtyOrdered()) != 0) {
                line.setQtyEntered(qty.multiply(orderLine.getQtyEntered()).divide(orderLine.getQtyOrdered(), 12, 4));
            }
            line.setLine(this.m_line + orderLine.getLine());
            if (!line.save()) {
                throw new IllegalStateException("Could not create Shipment Line");
            }
            this.log.fine(line.toString());
            return;
        }
        boolean linePerASI = false;
        if (product.getM_AttributeSet_ID() != 0) {
            MAttributeSet mas = MAttributeSet.get(this.getCtx(), product.getM_AttributeSet_ID());
            linePerASI = mas.isInstanceAttribute();
        }
        ArrayList<X_M_InOutLine> list = new ArrayList<X_M_InOutLine>();
        BigDecimal toDeliver = qty;
        int i = 0;
        while (i < storages.length) {
            int storage = storages[i];
            this.log.config("storage " + i + ",id:" + storage);
            BigDecimal deliver = toDeliver;
            X_M_InOutLine line = null;
            if (deliver.signum() != 0) {
                int M_Locator_ID = storage;
                BigDecimal inProcess = this.getInProcess(orderLine.getM_Product_ID(), M_Locator_ID);
                BigDecimal total = this.getTotalLocator(M_Locator_ID, orderLine.getM_Product_ID(), orderLine.getM_AttributeSetInstance_ID());
                BigDecimal totalEff = total.subtract(inProcess);
                if (totalEff.signum() > 0) {
                    if (!linePerASI) {
                        int ll = 0;
                        while (ll < list.size()) {
                            MInOutLine test = (MInOutLine)list.get(ll);
                            if (test.getM_Locator_ID() == M_Locator_ID) {
                                line = test;
                                break;
                            }
                            ++ll;
                        }
                    }
                    if (line == null) {
                        MLocator locTemp;
                        line = new MInOutLine(this.m_shipment);
                        ((MInOutLine)line).setOrderLine(orderLine, M_Locator_ID, order.isSOTrx() ? deliver : Env.ZERO);
                        line.set_CustomColumn("QtyNeeded", qty);
                        if (totalEff.compareTo(deliver) < 0) {
                            deliver = totalEff;
                        }
                        if (totalEff.compareTo(qty) >= 0) {
                            deliver = toDeliver;
                        }
                        ((MInOutLine)line).setQty(deliver);
                        line.set_CustomColumn("QtyFound", totalEff);
                        line.set_CustomColumn("QtyCountR", totalEff);
                        String pickupDesc = "";
                        if (i + 1 < storages.length) {
                            locTemp = MLocator.get(this.getCtx(), storages[i + 1]);
                            pickupDesc = String.valueOf(pickupDesc) + locTemp.getValue() + " C:" + this.getTotalLocator(locTemp.getM_Locator_ID(), orderLine.getM_Product_ID(), orderLine.getM_AttributeSetInstance_ID());
                        }
                        if (i + 2 < storages.length) {
                            locTemp = MLocator.get(this.getCtx(), storages[i + 2]);
                            pickupDesc = String.valueOf(pickupDesc) + "/ " + locTemp.getValue() + " C:" + this.getTotalLocator(locTemp.getM_Locator_ID(), orderLine.getM_Product_ID(), orderLine.getM_AttributeSetInstance_ID());
                        }
                        line.set_CustomColumn("PickupDesc", pickupDesc);
                        list.add(line);
                        this.log.config("new line qty=" + deliver + " locator:" + M_Locator_ID);
                    } else {
                        ((MInOutLine)line).setQty(line.getMovementQty().add(deliver));
                        this.log.config("old add line qty=" + deliver + " locator:" + M_Locator_ID);
                    }
                    if (orderLine.getQtyEntered().compareTo(orderLine.getQtyOrdered()) != 0) {
                        ((MInOutLine)line).setQtyEntered(line.getMovementQty().multiply(orderLine.getQtyEntered()).divide(orderLine.getQtyOrdered(), 12, 4));
                    }
                    line.setLine(this.m_line + orderLine.getLine());
                    if (linePerASI) {
                        line.setM_AttributeSetInstance_ID(orderLine.getM_AttributeSetInstance_ID());
                    }
                    if (!line.save()) {
                        throw new IllegalStateException("Could not create Shipment Line");
                    }
                    this.log.config("ToDeliver=" + qty + "/" + deliver + " - " + line);
                    toDeliver = toDeliver.subtract(deliver);
                    if (toDeliver.signum() == 0) break;
                }
            }
            ++i;
        }
        if (toDeliver.signum() != 0) {
            throw new IllegalStateException("Not All Delivered - Remainder=" + toDeliver);
        }
    }

    private MStorage[] getStorages(int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, boolean FiFo) {
        String sql;
        ArrayList<MStorage> list;
        block8: {
            this.m_lastStorages = null;
            list = new ArrayList<MStorage>();
            sql = "SELECT s.M_Product_ID,s.M_Locator_ID,s.M_AttributeSetInstance_ID,s.AD_Client_ID,s.AD_Org_ID,s.IsActive,s.Created,s.CreatedBy,s.Updated,s.UpdatedBy,s.QtyOnHand,s.QtyReserved,s.QtyOrdered,s.DateLastInventory FROM M_Storage s INNER JOIN M_Locator l ON (l.M_Locator_ID=s.M_Locator_ID) WHERE s.QtyOnHand> 0 and l.M_Warehouse_ID=? AND s.M_Product_ID=? ";
            sql = String.valueOf(sql) + " And l.M_Locator_ID IN " + this.getPositiveLocators(M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID);
            if (M_AttributeSetInstance_ID > 0) {
                sql = String.valueOf(sql) + " AND COALESCE(s.M_AttributeSetInstance_ID,0)=? ";
            }
            sql = String.valueOf(sql) + " ORDER BY l.PriorityNo Desc, s.QtyOnHand- (select coalesce(sum(loc.movementqty),0) from m_inoutline loc inner join m_inout i on (i.m_inout_id=loc.m_inout_id) where i.DocStatus='IP' and loc.m_product_id= s.M_Product_ID  and loc.m_locator_id=l.m_locator_id) Asc";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, M_Warehouse_ID);
                    pstmt.setInt(2, M_Product_ID);
                    if (M_AttributeSetInstance_ID > 0) {
                        pstmt.setInt(3, M_AttributeSetInstance_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MStorage(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.log.config("sql:" + sql);
        MStorage[] retValue = new MStorage[list.size()];
        list.toArray(retValue);
        this.m_lastStorages = retValue;
        return this.m_lastStorages;
    }

    private String getReplenish(int M_Product_ID, int M_AttributeSetInstance_ID) {
        String sql;
        String msg;
        block9: {
            msg = " R : ";
            int count = 0;
            int M_Warehouse_ID = DB.getSQLValue(this.get_TrxName(), "select M_Warehouse_ID from M_Warehouse where ISINTRANSIT='Y' and AD_Client_ID=" + this.getAD_Client_ID());
            if (M_Warehouse_ID <= 0) {
                return "";
            }
            sql = "SELECT s.M_Product_ID,s.M_Locator_ID,s.M_AttributeSetInstance_ID,s.AD_Client_ID,s.AD_Org_ID,s.IsActive,s.Created,s.CreatedBy,s.Updated,s.UpdatedBy,s.QtyOnHand,s.QtyReserved,s.QtyOrdered,s.DateLastInventory,l.value FROM M_Storage s INNER JOIN M_Locator l ON (l.M_Locator_ID=s.M_Locator_ID) WHERE s.QtyOnHand> 0 and l.M_Warehouse_ID=? AND s.M_Product_ID=? ";
            sql = String.valueOf(sql) + " And l.M_Locator_ID IN " + this.getPositiveLocators(M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID);
            if (M_AttributeSetInstance_ID > 0) {
                sql = String.valueOf(sql) + " AND COALESCE(s.M_AttributeSetInstance_ID,0)=? ";
            }
            sql = String.valueOf(sql) + " ORDER BY l.PriorityNo Desc, s.QtyOnHand Asc";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, M_Warehouse_ID);
                    pstmt.setInt(2, M_Product_ID);
                    if (M_AttributeSetInstance_ID > 0) {
                        pstmt.setInt(3, M_AttributeSetInstance_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        if (count == 2) continue;
                        msg = String.valueOf(msg) + " " + rs.getString("Value") + " : " + this.getTotalLocator(rs.getInt("M_Locator_ID"), rs.getInt("M_Product_ID"), M_AttributeSetInstance_ID);
                        ++count;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.log.config("sql:" + sql);
        return msg;
    }

    private String getPositiveLocators(int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID) {
        String out;
        block9: {
            out = "(0 ";
            String sql = "SELECT Sum(s.QtyOnHand),s.M_Locator_ID,l.PriorityNo FROM M_Storage s INNER JOIN M_Locator l ON (l.M_Locator_ID=s.M_Locator_ID) WHERE l.M_Warehouse_ID=?  AND s.M_Product_ID=? ";
            if (M_AttributeSetInstance_ID > 0) {
                sql = String.valueOf(sql) + " AND COALESCE(s.M_AttributeSetInstance_ID,0)=? ";
            }
            sql = String.valueOf(sql) + " Group by s.M_Locator_ID ,l.PriorityNo  Having Sum(s.QtyOnHand)>0 ";
            sql = String.valueOf(sql) + " ORDER BY l.PriorityNo Desc, Sum(s.QtyOnHand) Asc";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, M_Warehouse_ID);
                    pstmt.setInt(2, M_Product_ID);
                    if (M_AttributeSetInstance_ID > 0) {
                        pstmt.setInt(3, M_AttributeSetInstance_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        out = String.valueOf(out) + "," + rs.getInt(2);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        out = String.valueOf(out) + ",0)";
        if (out.equals("(0, ,0)")) {
            out = "(0)";
        }
        return out;
    }

    private BigDecimal getTotalLocator(int Locator_ID, int Product_ID, int ATTRIBUTESETINSTANCE_ID) {
        String sql = " Select Sum(QtyOnhand) from M_Storage where M_Locator_ID=? and M_Product_ID=? ";
        if (ATTRIBUTESETINSTANCE_ID > 0) {
            sql = String.valueOf(sql) + " and M_ATTRIBUTESETINSTANCE_ID=?";
        }
        BigDecimal rvalue = new BigDecimal(0);
        rvalue = ATTRIBUTESETINSTANCE_ID > 0 ? DB.getSQLValueBD(this.get_TrxName(), sql, Locator_ID, Product_ID, ATTRIBUTESETINSTANCE_ID) : DB.getSQLValueBD(this.get_TrxName(), sql, Locator_ID, Product_ID);
        return rvalue;
    }

    private BigDecimal getInProcess(int Product_ID, int Locator_ID) {
        BigDecimal reValue;
        block7: {
            String sql = "select sum(l.movementqty) from m_inoutline l inner join m_inout i on (i.m_inout_id=l.m_inout_id)  where i.DocStatus='IP' and l.m_product_id= ?  and l.m_locator_id= ? ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            reValue = new BigDecimal(0.0);
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, Product_ID);
                    pstmt.setInt(2, Locator_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        reValue = rs.getBigDecimal(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (reValue == null) {
            reValue = new BigDecimal(0.0);
        }
        return reValue;
    }

    private BigDecimal getInProcessW(int Product_ID, int Warehouse_ID) {
        BigDecimal reValue;
        block7: {
            String sql = "select sum(l.movementqty) from m_inoutline l inner join m_inout i on (i.m_inout_id=l.m_inout_id)  where i.DocStatus='IP' and l.m_product_id= ?  and i.M_WAREHOUSE_ID= ? ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            reValue = new BigDecimal(0.0);
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, Product_ID);
                    pstmt.setInt(2, Warehouse_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        reValue = rs.getBigDecimal(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (reValue == null) {
            reValue = new BigDecimal(0.0);
        }
        return reValue;
    }

    private void completeShipment() {
        if (this.m_shipment != null) {
            if (!this.m_shipment.processIt(this.p_docAction)) {
                this.log.warning("Failed: " + this.m_shipment);
            }
            this.m_shipment.save();
            try {
                this.addLog(this.m_shipment.getM_InOut_ID(), this.m_shipment.getMovementDate(), null, "Orden OK:" + this.m_shipment.getC_Order().getDocumentNo() + " | Despacho: " + this.m_shipment.getDocumentNo());
            }
            catch (Exception e) {
                this.addLog(this.m_shipment.getM_InOut_ID(), this.m_shipment.getMovementDate(), null, this.m_shipment.getDocumentNo());
            }
            ++this.m_created;
            this.m_map = new HashMap();
            if (this.m_lastPP != null && this.m_lastStorages != null) {
                this.m_map.put(this.m_lastPP, this.m_lastStorages);
            }
        }
        this.m_shipment = null;
        this.m_line = 0;
    }

    private Integer[] getLocators(int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID) {
        String sql;
        ArrayList<Integer> locators;
        block8: {
            locators = new ArrayList<Integer>();
            sql = "SELECT s.M_Product_ID,s.M_Locator_ID,  SUM(s.QtyOnHand) as QtyOnHand FROM M_Storage s INNER JOIN M_Locator l ON (l.M_Locator_ID=s.M_Locator_ID)  WHERE l.isactive='Y' and l.M_Warehouse_ID=? AND s.M_Product_ID=? ";
            if (M_AttributeSetInstance_ID > 0) {
                sql = String.valueOf(sql) + " AND COALESCE(s.M_AttributeSetInstance_ID,0)=? ";
            }
            sql = String.valueOf(sql) + "   Group by s.M_Product_ID,s.M_Locator_ID  Having SUM(s.QtyOnHand)>0   order by 3 asc";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, M_Warehouse_ID);
                    pstmt.setInt(2, M_Product_ID);
                    if (M_AttributeSetInstance_ID > 0) {
                        pstmt.setInt(3, M_AttributeSetInstance_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        locators.add(rs.getInt(2));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.log.config("sql:" + sql);
        Integer[] retValue = new Integer[locators.size()];
        locators.toArray(retValue);
        return retValue;
    }

    class SParameter {
        public int M_Warehouse_ID;
        public int M_Product_ID;
        public int M_AttributeSetInstance_ID;
        public int M_AttributeSet_ID;
        public boolean allAttributeInstances;
        public Timestamp minGuaranteeDate;
        public boolean FiFo;

        protected SParameter(int p_Warehouse_ID, int p_Product_ID, int p_AttributeSetInstance_ID, int p_AttributeSet_ID, boolean p_allAttributeInstances, Timestamp p_minGuaranteeDate, boolean p_FiFo) {
            this.M_Warehouse_ID = p_Warehouse_ID;
            this.M_Product_ID = p_Product_ID;
            this.M_AttributeSetInstance_ID = p_AttributeSetInstance_ID;
            this.M_AttributeSet_ID = p_AttributeSet_ID;
            this.allAttributeInstances = p_allAttributeInstances;
            this.minGuaranteeDate = p_minGuaranteeDate;
            this.FiFo = p_FiFo;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof SParameter) {
                boolean eq;
                SParameter cmp = (SParameter)obj;
                boolean bl = eq = cmp.M_Warehouse_ID == this.M_Warehouse_ID && cmp.M_Product_ID == this.M_Product_ID && cmp.M_AttributeSetInstance_ID == this.M_AttributeSetInstance_ID && cmp.M_AttributeSet_ID == this.M_AttributeSet_ID && cmp.allAttributeInstances == this.allAttributeInstances && cmp.FiFo == this.FiFo;
                if (!(!eq || cmp.minGuaranteeDate == null && this.minGuaranteeDate == null || cmp.minGuaranteeDate != null && this.minGuaranteeDate != null && cmp.minGuaranteeDate.equals(this.minGuaranteeDate))) {
                    eq = false;
                }
                return eq;
            }
            return false;
        }

        public int hashCode() {
            long hash = this.M_Warehouse_ID + this.M_Product_ID * 2 + this.M_AttributeSetInstance_ID * 3 + this.M_AttributeSet_ID * 4;
            if (this.allAttributeInstances) {
                hash *= -1L;
            }
            if (this.FiFo) {
                // empty if block
            }
            if ((hash *= -2L) < 0L) {
                hash = -hash + 7L;
            }
            while (hash > Integer.MAX_VALUE) {
                hash -= Integer.MAX_VALUE;
            }
            if (this.minGuaranteeDate != null) {
                hash += (long)this.minGuaranteeDate.hashCode();
                while (hash > Integer.MAX_VALUE) {
                    hash -= Integer.MAX_VALUE;
                }
            }
            return (int)hash;
        }
    }
}

