/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MWarehouse;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

public class GenerateShipBOM
extends SvrProcess {
    private int Order_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_Order_ID")) {
                    this.Order_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        MOrder order = new MOrder(Env.getCtx(), this.Order_ID, this.get_TrxName());
        MInOut out = new MInOut(order, 0, new Timestamp(TimeUtil.getToday().getTimeInMillis()));
        out.save();
        MOrderLine[] lines = order.getLines();
        int i = 0;
        while (i < lines.length) {
            if (lines[i].getM_Product_ID() > 0) {
                if (lines[i].getM_Product().isBOM()) {
                    MPPProductBOM bom = MPPProductBOM.getDefault(MProduct.get(this.getCtx(), lines[i].getM_Product_ID()), this.get_TrxName());
                    MPPProductBOMLine[] bomLines = bom.getLines();
                    int x = 0;
                    while (x < bomLines.length) {
                        MInOutLine line = new MInOutLine(out);
                        line.setC_OrderLine_ID(lines[i].getC_OrderLine_ID());
                        MProduct product = MProduct.get(this.getCtx(), bomLines[x].getM_Product_ID());
                        line.setProduct(product);
                        line.setQty(bomLines[x].getQtyBOM().multiply(lines[i].getQtyOrdered()));
                        line.setM_Locator_ID(MLocator.getDefault(MWarehouse.get(this.getCtx(), order.getM_Warehouse_ID())).getM_Locator_ID());
                        line.save();
                        ++x;
                    }
                } else {
                    MInOutLine line = new MInOutLine(out);
                    line.setOrderLine(lines[i], MLocator.getDefault(MWarehouse.get(this.getCtx(), order.getM_Warehouse_ID())).getM_Locator_ID(), Env.ZERO);
                    line.setQty(lines[i].getQtyOrdered());
                    line.save();
                }
            }
            ++i;
        }
        return "Despacho Generado " + out.getDocumentNo();
    }
}

