/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GenerateReceiptWS
extends SvrProcess {
    private Properties m_ctx;
    private String p_IMEI;
    private int p_WS = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("IMEI")) {
                    this.p_IMEI = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.m_ctx = Env.getCtx();
    }

    @Override
    protected String doIt() throws AdempiereSystemError {
        String sql = "Select * from M_InOutLineTemp where PROCESSED='N'";
        if (this.p_IMEI != null && this.p_IMEI != "" && this.p_IMEI != " ") {
            sql = String.valueOf(sql) + " AND IMEI = '" + this.p_IMEI + "'";
        }
        MInOut minout = null;
        try {
            CPreparedStatement pstmt = null;
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MOrderLine oLine = null;
                if (rs.getInt("C_ORDERLINE_ID") > 0) {
                    oLine = new MOrderLine(this.getCtx(), rs.getInt("C_ORDERLINE_ID"), this.get_TrxName());
                }
                if (minout == null) {
                    MOrder order = null;
                    if (rs.getInt("C_ORDERLINE_ID") > 0) {
                        order = new MOrder(this.getCtx(), oLine.getC_Order_ID(), this.get_TrxName());
                    } else if (rs.getInt("C_ORDER_ID") > 0) {
                        order = new MOrder(this.getCtx(), rs.getInt("C_ORDER_ID"), this.get_TrxName());
                    }
                    Calendar calendar = Calendar.getInstance();
                    Date now = calendar.getTime();
                    Timestamp currentTimestamp = new Timestamp(now.getTime());
                    minout = new MInOut(order, 1000014, currentTimestamp);
                    minout.setDescription("Desde WS");
                    minout.setC_DocType_ID(1000014);
                    minout.setC_Order_ID(order.get_ID());
                    minout.setIsSOTrx(false);
                    minout.save();
                }
                MInOutLine line = new MInOutLine(minout);
                int Locator_ID = DB.getSQLValue(this.get_TrxName(), "select MAX(M_locator_ID) from M_locator where value like ?", rs.getString("LOCATORVALUE"));
                line.setM_Locator_ID(Locator_ID);
                if (rs.getInt("C_ORDERLINE_ID") > 0) {
                    line.setProduct(MProduct.get(this.getCtx(), oLine.getM_Product_ID()));
                } else {
                    int product_ID = DB.getSQLValue(this.get_TrxName(), "select M_Product_ID from M_Product where value = ? and ad_client_id = ?", rs.getString("PRODUCTVALUE"), rs.getInt("AD_Client_ID"));
                    line.setProduct(MProduct.get(this.getCtx(), product_ID));
                }
                line.setQty(rs.getBigDecimal("MOVEMENTQTY"));
                line.setQtyEntered(rs.getBigDecimal("MOVEMENTQTY"));
                line.setMovementQty(rs.getBigDecimal("MOVEMENTQTY"));
                line.setC_OrderLine_ID(rs.getInt("C_ORDERLINE_ID"));
                line.set_ValueOfColumn("TEMPLINE_ID", (Object)rs.getInt("M_INOUTLINETEMP_ID"));
                line.setM_AttributeSetInstance_ID(-1);
                line.save();
            }
            rs.close();
            pstmt.close();
            DB.close(rs, pstmt);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        if (minout != null) {
            minout.processIt("CO");
            minout.save();
            DB.executeUpdate("Update M_INOUTLINETEMP set PROCESSED='Y' Where M_INOUTLINETEMP_ID  IN (select TEMPLINE_ID from M_InOutLine where M_InOut_ID=" + minout.get_ID() + ") ", this.get_TrxName());
            return "Generado: " + minout.getDocumentNo();
        }
        return "No Generado";
    }
}

