/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.exceptions.AdempiereException;
import org.apache.commons.codec.binary.Base64;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCity;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrg;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.PO;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_M_InOut;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.ofb.model.OFBForward;
import org.ofb.process.CXFConnector;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ExportDTEInvoiceFOLComplete
extends SvrProcess {
    private Properties m_ctx;
    private int p_C_Invoice_ID = 0;
    public String urlPdf = "";

    @Override
    protected void prepare() {
        this.p_C_Invoice_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    @Override
    protected String doIt() throws Exception {
        MInvoice inv = new MInvoice(this.m_ctx, this.p_C_Invoice_ID, this.get_TrxName());
        String msg = "";
        msg = inv.getC_DocType().getName().toLowerCase().contains("boleta") ? this.CreateXMLCGBoleta(inv) : this.CreateXMLCG(inv);
        return msg;
    }

    public String CreateXMLCG(MInvoice invoice) {
        String wsRespuesta = "";
        MDocType doc = new MDocType(invoice.getCtx(), invoice.getC_DocTypeTarget_ID(), invoice.get_TrxName());
        if (doc.get_Value("CreateXML") == null) {
            return "";
        }
        if (!((Boolean)doc.get_Value("CreateXML")).booleanValue()) {
            return "";
        }
        int typeDoc = Integer.parseInt((String)doc.get_Value("DocumentNo"));
        if (typeDoc == 0) {
            return "";
        }
        String mylog = new String();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            PO refdoc;
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation implementation = builder.getDOMImplementation();
            Document document = implementation.createDocument(null, "DTE", null);
            document.setXmlVersion("1.0");
            document.setTextContent("text/xml");
            Attr atr = document.createAttribute("xmlns");
            atr.setValue("http://www.sii.cl/SiiDte");
            Element Documento2 = document.createElement("Documento");
            document.getDocumentElement().appendChild(Documento2);
            Documento2.setAttribute("ID", "F" + invoice.getDocumentNo() + "T" + (String)doc.get_Value("DocumentNo"));
            Element Encabezado2 = document.createElement("Encabezado");
            Documento2.appendChild(Encabezado2);
            Element IdDoc2 = document.createElement("IdDoc");
            Encabezado2.appendChild(IdDoc2);
            mylog = "IdDoc";
            Element TipoDTE = document.createElement("TipoDTE");
            Text text = document.createTextNode(Integer.toString(typeDoc));
            TipoDTE.appendChild(text);
            IdDoc2.appendChild(TipoDTE);
            Element Folio = document.createElement("Folio");
            Text fo = document.createTextNode(invoice.getDocumentNo());
            Folio.appendChild(fo);
            IdDoc2.appendChild(Folio);
            Element FchEmis = document.createElement("FchEmis");
            Text emis = document.createTextNode(invoice.getDateInvoiced().toString().substring(0, 10));
            FchEmis.appendChild(emis);
            IdDoc2.appendChild(FchEmis);
            Element MntPagos2 = document.createElement("MntPagos");
            IdDoc2.appendChild(MntPagos2);
            mylog = "Termino de Pago";
            Element FchPago = document.createElement("FchPago");
            Text fPago = document.createTextNode(invoice.getDateInvoiced().toString().substring(0, 10));
            FchPago.appendChild(fPago);
            MntPagos2.appendChild(FchPago);
            Element MntPago = document.createElement("MntPago");
            Text mPago = document.createTextNode(invoice.getGrandTotal().setScale(0, 4).toString());
            MntPago.appendChild(mPago);
            MntPagos2.appendChild(MntPago);
            String GlosaP = DB.getSQLValueString(invoice.get_TrxName(), "SELECT MAX(rlt.name)  FROM AD_Ref_List rl  INNER JOIN AD_Ref_List_Trl rlt ON (rl.AD_Ref_List_ID = rlt.AD_Ref_List_ID)  WHERE AD_Reference_ID=195  AND rlt.AD_Language='es_MX' AND rl.value = '" + invoice.getPaymentRule() + "'", new Object[0]);
            String GlosaPFull = invoice.getC_PaymentTerm().getName();
            if (GlosaP != null && GlosaP.trim().length() > 0) {
                GlosaPFull = String.valueOf(GlosaPFull) + "-" + GlosaP;
            }
            Element GlosaPagos = document.createElement("GlosaPagos");
            Text gPagos = document.createTextNode(GlosaPFull);
            GlosaPagos.appendChild(gPagos);
            MntPagos2.appendChild(GlosaPagos);
            int cantdias = 0;
            Timestamp fchVencCal = DB.getSQLValueTS(invoice.get_TrxName(), "SELECT MAX(duedate) FROM C_Invoice_V WHERE C_Invoice_ID = ?", invoice.get_ID());
            if (fchVencCal == null && invoice.getC_PaymentTerm_ID() > 0) {
                MPaymentTerm tpago = new MPaymentTerm(invoice.getCtx(), invoice.getC_PaymentTerm_ID(), invoice.get_TrxName());
                int cantDet = DB.getSQLValue(invoice.get_TrxName(), "SELECT MIN(NetDays) FROM C_PaySchedule WHERE C_PaymentTerm_ID = " + invoice.getC_PaymentTerm_ID());
                cantdias = tpago.getNetDays() > 0 ? tpago.getNetDays() : (cantDet > 0 ? cantDet : 0);
                if (cantdias > 0) {
                    Calendar calFchVenc = Calendar.getInstance();
                    calFchVenc.setTimeInMillis(invoice.getDateInvoiced().getTime());
                    calFchVenc.add(5, cantdias);
                    fchVencCal = new Timestamp(calFchVenc.getTimeInMillis());
                }
            }
            Element FchVenc = document.createElement("FchVenc");
            Text venc = document.createTextNode(fchVencCal.toString().substring(0, 10));
            FchVenc.appendChild(venc);
            IdDoc2.appendChild(FchVenc);
            Element Emisor2 = document.createElement("Emisor");
            Encabezado2.appendChild(Emisor2);
            mylog = "Emisor";
            MOrg company = MOrg.get(invoice.getCtx(), invoice.getAD_Org_ID());
            Element Rut = document.createElement("RUTEmisor");
            Text rut = document.createTextNode((String)company.get_Value("Rut"));
            Rut.appendChild(rut);
            Emisor2.appendChild(Rut);
            String nameRzn = company.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = company.getName();
            }
            nameRzn = nameRzn.replace("'", "");
            nameRzn = nameRzn.replace("\"", "");
            Element RznSoc = document.createElement("RznSoc");
            Text rzn = document.createTextNode(nameRzn);
            RznSoc.appendChild(rzn);
            Emisor2.appendChild(RznSoc);
            String giroEmisStr = (String)company.get_Value("Giro");
            giroEmisStr = giroEmisStr.replace("'", "");
            giroEmisStr = giroEmisStr.replace("\"", "");
            Element GiroEmis = document.createElement("GiroEmis");
            Text gi = document.createTextNode(giroEmisStr);
            GiroEmis.appendChild(gi);
            Emisor2.appendChild(GiroEmis);
            Element Acteco = document.createElement("Acteco");
            Text teco = document.createTextNode((String)company.get_Value("Acteco"));
            Acteco.appendChild(teco);
            Emisor2.appendChild(Acteco);
            Element DirOrigen = document.createElement("DirOrigen");
            Text dir = document.createTextNode((String)company.get_Value("Address1"));
            DirOrigen.appendChild(dir);
            Emisor2.appendChild(DirOrigen);
            Element CmnaOrigen = document.createElement("CmnaOrigen");
            Text com = document.createTextNode((String)company.get_Value("Comuna"));
            CmnaOrigen.appendChild(com);
            Emisor2.appendChild(CmnaOrigen);
            Element CiudadOrigen = document.createElement("CiudadOrigen");
            Text city = document.createTextNode((String)company.get_Value("City"));
            CiudadOrigen.appendChild(city);
            Emisor2.appendChild(CiudadOrigen);
            if (invoice.getSalesRep_ID() > 0) {
                Element SalesRep = document.createElement("CdgVendedor");
                Text sales = document.createTextNode(invoice.getSalesRep().getName());
                SalesRep.appendChild(sales);
                Emisor2.appendChild(SalesRep);
            }
            mylog = "receptor";
            MBPartner BP = new MBPartner(invoice.getCtx(), invoice.getC_BPartner_ID(), invoice.get_TrxName());
            MBPartnerLocation bloc = new MBPartnerLocation(invoice.getCtx(), invoice.getC_BPartner_Location_ID(), invoice.get_TrxName());
            Element Receptor2 = document.createElement("Receptor");
            Encabezado2.appendChild(Receptor2);
            Element RUTRecep = document.createElement("RUTRecep");
            Text rutc = document.createTextNode(BP.getValue() + "-" + BP.get_ValueAsString("Digito"));
            RUTRecep.appendChild(rutc);
            Receptor2.appendChild(RUTRecep);
            String RznSocRecepStr = BP.getName();
            RznSocRecepStr = RznSocRecepStr.replace("'", "");
            RznSocRecepStr = RznSocRecepStr.replace("\"", "");
            Element RznSocRecep = document.createElement("RznSocRecep");
            Text RznSocR = document.createTextNode(RznSocRecepStr);
            RznSocRecep.appendChild(RznSocR);
            Receptor2.appendChild(RznSocRecep);
            Element GiroRecep = document.createElement("GiroRecep");
            Text giro = document.createTextNode((String)BP.get_Value("Giro"));
            GiroRecep.appendChild(giro);
            Receptor2.appendChild(GiroRecep);
            String dirRecepStr = String.valueOf(bloc.getLocation(true).getAddress1()) + ". Fono:" + bloc.getPhone();
            dirRecepStr = dirRecepStr.replace("'", "");
            dirRecepStr = dirRecepStr.replace("\"", "");
            Element DirRecep = document.createElement("DirRecep");
            Text dirr = document.createTextNode(dirRecepStr);
            DirRecep.appendChild(dirr);
            Receptor2.appendChild(DirRecep);
            String CmnaRecepStr = null;
            if (bloc.getLocation(true).getAddress2() != null) {
                CmnaRecepStr = bloc.getLocation(true).getAddress2();
            } else if (bloc.getLocation(true).getC_City_ID() > 0) {
                CmnaRecepStr = MCity.get(invoice.getCtx(), bloc.getLocation(true).getC_City_ID()).getName();
            } else if (bloc.getLocation(true).getAddress3() != null) {
                CmnaRecepStr = bloc.getLocation(true).getAddress3();
            }
            Element CmnaRecep = document.createElement("CmnaRecep");
            Text Cmna = document.createTextNode(CmnaRecepStr);
            CmnaRecep.appendChild(Cmna);
            Receptor2.appendChild(CmnaRecep);
            String ciudadTxt = "";
            ciudadTxt = bloc.getLocation(true).getC_Region_ID() == 1000001 || bloc.getLocation(true).getC_City_ID() <= 0 ? "SANTIAGO" : bloc.getC_Location().getCity();
            if (ciudadTxt == null || ciudadTxt.trim().length() < 2) {
                ciudadTxt = CmnaRecepStr;
            }
            Element CiudadRecep = document.createElement("CiudadRecep");
            Text reg = document.createTextNode(ciudadTxt != null ? ciudadTxt : "Santiago");
            CiudadRecep.appendChild(reg);
            Receptor2.appendChild(CiudadRecep);
            mylog = "Totales";
            Element Totales2 = document.createElement("Totales");
            Encabezado2.appendChild(Totales2);
            BigDecimal amountex = DB.getSQLValueBD(invoice.get_TrxName(), "select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='Y' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID(), new Object[0]);
            BigDecimal amountNeto = DB.getSQLValueBD(invoice.get_TrxName(), "select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='N' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID(), new Object[0]);
            Element MntNeto = document.createElement("MntNeto");
            Text neto = document.createTextNode(amountNeto != null ? amountNeto.toString() : "0");
            MntNeto.appendChild(neto);
            Totales2.appendChild(MntNeto);
            Element MntExe = document.createElement("MntExe");
            Text exe = document.createTextNode(amountex != null ? amountex.toString() : "0");
            MntExe.appendChild(exe);
            Totales2.appendChild(MntExe);
            if (amountNeto.signum() > 0) {
                Element TasaIVA = document.createElement("TasaIVA");
                Text tiva = document.createTextNode("19");
                TasaIVA.appendChild(tiva);
                Totales2.appendChild(TasaIVA);
            }
            Element IVA = document.createElement("IVA");
            BigDecimal ivaamt = Env.ZERO;
            if (amountex.intValue() != invoice.getGrandTotal().intValue()) {
                ivaamt = invoice.getGrandTotal().subtract(invoice.getTotalLines()).setScale(0, 4);
            }
            Text iva = document.createTextNode(ivaamt.toString());
            IVA.appendChild(iva);
            Totales2.appendChild(IVA);
            Element MntTotal = document.createElement("MntTotal");
            Text total = document.createTextNode(invoice.getGrandTotal().setScale(0, 4).toString());
            MntTotal.appendChild(total);
            Totales2.appendChild(MntTotal);
            mylog = "detalle";
            MInvoiceLine[] iLines = invoice.getLines(false);
            int lineInvoice = 0;
            int i = 0;
            while (i < iLines.length) {
                MInvoiceLine iLine = iLines[i];
                if (iLine.getM_Product_ID() != 0 || iLine.getC_Charge_ID() != 0) {
                    Element Detalle2 = document.createElement("Detalle");
                    Documento2.appendChild(Detalle2);
                    Element NroLinDet = document.createElement("NroLinDet");
                    Text line = document.createTextNode(Integer.toString(++lineInvoice));
                    NroLinDet.appendChild(line);
                    Detalle2.appendChild(NroLinDet);
                    Element NmbItem = document.createElement("NmbItem");
                    String pname = "";
                    pname = iLine.getProduct() != null ? iLine.getProduct().getName() : iLine.getC_Charge().getName();
                    pname = pname.replace("'", "");
                    pname = pname.replace("\"", "");
                    Text Item = document.createTextNode(pname);
                    NmbItem.appendChild(Item);
                    Detalle2.appendChild(NmbItem);
                    if (iLine.getDescription() != null && iLine.getDescription() != "") {
                        Element DscItem = document.createElement("DscItem");
                        Text desc = document.createTextNode(iLine.getDescription() == null ? " " : iLine.getDescription());
                        DscItem.appendChild(desc);
                        Detalle2.appendChild(DscItem);
                    }
                    Element QtyItem = document.createElement("QtyItem");
                    Text qt = document.createTextNode(iLine.getQtyInvoiced().toString());
                    QtyItem.appendChild(qt);
                    Detalle2.appendChild(QtyItem);
                    String unmdItemStr = "";
                    unmdItemStr = iLine.getM_Product_ID() > 0 ? iLine.getM_Product().getC_UOM().getUOMSymbol() : "UN";
                    if (unmdItemStr == null) {
                        unmdItemStr = "UN";
                    }
                    Element UnmdItem = document.createElement("UnmdItem");
                    Text UM = document.createTextNode(unmdItemStr);
                    UnmdItem.appendChild(UM);
                    Detalle2.appendChild(UnmdItem);
                    Element PrcItem = document.createElement("PrcItem");
                    Text pa = document.createTextNode(iLine.getPriceActual().setScale(0, 4).toString());
                    PrcItem.appendChild(pa);
                    Detalle2.appendChild(PrcItem);
                    Element MontoItem = document.createElement("MontoItem");
                    Text tl = document.createTextNode(iLine.getLineNetAmt().setScale(0, 4).toString());
                    MontoItem.appendChild(tl);
                    Detalle2.appendChild(MontoItem);
                }
                ++i;
            }
            mylog = "referencia";
            String tiporeferencia = new String();
            String folioreferencia = new String();
            String fechareferencia = new String();
            int tipo_Ref = 0;
            String codRef = null;
            if (invoice.get_Value("C_RefDoc_ID") != null && (Integer)invoice.get_Value("C_RefDoc_ID") > 0) {
                mylog = "referencia:invoice";
                refdoc = new MInvoice(invoice.getCtx(), (int)((Integer)invoice.get_Value("C_RefDoc_ID")), invoice.get_TrxName());
                MDocType Refdoctype = new MDocType(invoice.getCtx(), ((X_C_Invoice)refdoc).getC_DocType_ID(), invoice.get_TrxName());
                tiporeferencia = (String)Refdoctype.get_Value("DocumentNo");
                folioreferencia = ((X_C_Invoice)refdoc).getDocumentNo();
                fechareferencia = ((X_C_Invoice)refdoc).getDateInvoiced().toString().substring(0, 10);
                tipo_Ref = 1;
                codRef = invoice.get_ValueAsString("CodRef");
            }
            if (invoice.getPOReference() != null && invoice.getPOReference().length() > 0) {
                mylog = "referencia:order";
                tiporeferencia = "801";
                folioreferencia = invoice.getPOReference();
                fechareferencia = invoice.getDateOrdered().toString().substring(0, 10);
                tipo_Ref = 2;
            }
            if (invoice.get_Value("C_RefInOut_ID") != null && (Integer)invoice.get_Value("C_RefInOut_ID") > 0) {
                mylog = "referencia:despacho";
                refdoc = new MInOut(invoice.getCtx(), (int)((Integer)invoice.get_Value("C_RefInOut_ID")), invoice.get_TrxName());
                tiporeferencia = "52";
                folioreferencia = ((X_M_InOut)refdoc).getDocumentNo();
                fechareferencia = ((X_M_InOut)refdoc).getMovementDate().toString().substring(0, 10);
                tipo_Ref = 3;
            }
            int indice = 1;
            if (tipo_Ref > 0) {
                Element Referencia2 = document.createElement("Referencia");
                Documento2.appendChild(Referencia2);
                Element NroLinRef = document.createElement("NroLinRef");
                Text Nro = document.createTextNode(Integer.toString(indice));
                NroLinRef.appendChild(Nro);
                Referencia2.appendChild(NroLinRef);
                Element TpoDocRef = document.createElement("TpoDocRef");
                Text tpo = document.createTextNode(tiporeferencia);
                TpoDocRef.appendChild(tpo);
                Referencia2.appendChild(TpoDocRef);
                Element FolioRef = document.createElement("FolioRef");
                Text ref = document.createTextNode(folioreferencia);
                FolioRef.appendChild(ref);
                Referencia2.appendChild(FolioRef);
                Element FchRef = document.createElement("FchRef");
                Text fchref = document.createTextNode(fechareferencia);
                FchRef.appendChild(fchref);
                Referencia2.appendChild(FchRef);
                if (codRef != null && codRef.trim().length() > 0) {
                    Element CodRef = document.createElement("CodRef");
                    Text codref = document.createTextNode(codRef);
                    CodRef.appendChild(codref);
                    Referencia2.appendChild(CodRef);
                }
                ++indice;
            }
            String hesTxt = invoice.get_ValueAsString("Hes");
            Timestamp dateHesTxt = (Timestamp)invoice.get_Value("DateHes");
            if (hesTxt != null && hesTxt.trim().length() > 0) {
                Element Referencia2 = document.createElement("Referencia");
                Documento2.appendChild(Referencia2);
                Element NroLinRef2 = document.createElement("NroLinRef");
                Text Nro2 = document.createTextNode(Integer.toString(indice));
                NroLinRef2.appendChild(Nro2);
                Referencia2.appendChild(NroLinRef2);
                Element TpoDocRef2 = document.createElement("TpoDocRef");
                Text tpo2 = document.createTextNode("HES");
                TpoDocRef2.appendChild(tpo2);
                Referencia2.appendChild(TpoDocRef2);
                Element FolioRef2 = document.createElement("FolioRef");
                Text ref2 = document.createTextNode(hesTxt);
                FolioRef2.appendChild(ref2);
                Referencia2.appendChild(FolioRef2);
                if (dateHesTxt == null) {
                    dateHesTxt = invoice.getDateInvoiced();
                }
                if (dateHesTxt != null) {
                    Element FchRef2 = document.createElement("FchRef");
                    Text fchref2 = document.createTextNode(dateHesTxt.toString().substring(0, 10));
                    FchRef2.appendChild(fchref2);
                    Referencia2.appendChild(FchRef2);
                }
            }
            if (invoice.getDescription() != null && invoice.getDescription() != "" && invoice.getDescription() != " ") {
                mylog = "Adicional";
                Element Adicional = document.createElement("Adicional");
                Documento2.appendChild(Adicional);
                Element NodosA = document.createElement("NodosA");
                Adicional.appendChild(NodosA);
                Element A6 = document.createElement("A6");
                Text a6Text = document.createTextNode(invoice.getDescription());
                A6.appendChild(a6Text);
                NodosA.appendChild(A6);
            }
            mylog = "archivo";
            String ExportDir = (String)company.get_Value("ExportDir");
            try {
                File theDir = new File(ExportDir);
                if (!theDir.exists()) {
                    ExportDir = (String)company.get_Value("ExportDir2");
                }
            }
            catch (Exception e) {
                throw new AdempiereException("no existe directorio");
            }
            ExportDir = ExportDir.replace("\\", "/");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(ExportDir, invoice.getDocumentNo() + ".xml"));
            StreamResult console = new StreamResult(System.out);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(source, result);
            transformer.transform(source, console);
            File file = new File(ExportDir, invoice.getDocumentNo() + ".xml");
            Document docValid = builder.parse(file);
            Element raiz = docValid.getDocumentElement();
            raiz.setAttribute("version", "1.0");
            raiz.setAttribute("xmlns", "http://www.sii.cl/SiiDte");
            source = new DOMSource(docValid);
            result = new StreamResult(new File(ExportDir, invoice.getDocumentNo() + ".xml"));
            console = new StreamResult(System.out);
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(source, result);
            transformer.transform(source, console);
            byte[] fileArray = new byte[(int)file.length()];
            FileInputStream inputStream = new FileInputStream(file);
            ((InputStream)inputStream).read(fileArray);
            byte[] encoded = Base64.encodeBase64((byte[])fileArray);
            String encodedFile = "";
            try {
                encodedFile = new String(encoded);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String token = "";
            String rutEmpresa = "";
            String rutUsuario = "";
            String password = "";
            try {
                rutEmpresa = OFBForward.RutEmpresaFEL();
                rutUsuario = OFBForward.RutUsuarioFEL();
                password = OFBForward.ContrasenaFEL();
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getMessage(), e);
            }
            String archivoXML = String.valueOf(ExportDir) + invoice.getDocumentNo() + ".xml";
            String tipoDocumento = Integer.toString(typeDoc);
            String folioDocumento = invoice.getDocumentNo();
            if (archivoXML != "" && rutEmpresa != "" && rutUsuario != "" && password != "") {
                token = this.llamarWSToken(rutEmpresa, rutUsuario, password);
                if (token.substring(0, 5).compareToIgnoreCase("error") == 0) {
                    return token;
                }
                wsRespuesta = this.llamarWSEnviarDTE(token, encodedFile, rutEmpresa, tipoDocumento, folioDocumento);
                this.log.config(wsRespuesta);
                if (this.urlPdf != null && this.urlPdf != "" && this.urlPdf != " ") {
                    this.urlPdf = String.valueOf(this.urlPdf) + "&Ced=3";
                    invoice.set_CustomColumn("URLXML", this.urlPdf);
                }
                invoice.set_CustomColumn("DescriptionFEL", wsRespuesta);
                invoice.save();
                if (this.urlPdf != null && this.urlPdf != "" && this.urlPdf != " " && OFBForward.PrintPDFFEL()) {
                    this.PrintPDF(this.urlPdf);
                }
            }
        }
        catch (Exception e) {
            this.log.severe("CreateXML: " + mylog + "--" + e.getMessage());
            return "CreateXML: " + mylog + "--" + e.getMessage();
        }
        return "XML CG Generated " + wsRespuesta;
    }

    private String llamarWSToken(String rutEmpresa, String rutPersona, String password) throws Exception {
        String token = "";
        String request = "<soapenv:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:wst=\"/var/www//WsTest/\"> <soapenv:Header/><soapenv:Body><wst:SolicitarSesion soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><rutEmpresa xsi:type=\"xsd:string\">" + rutEmpresa + "</rutEmpresa>" + "<rutPersona xsi:type=\"xsd:string\">" + rutPersona + "</rutPersona>" + "<password xsi:type=\"xsd:string\">" + password + "</password>" + "</wst:SolicitarSesion>" + "</soapenv:Body>" + "</soapenv:Envelope>";
        Source response = null;
        try {
            CXFConnector wsc = new CXFConnector();
            wsc.setSoapAction("http://clientes.dtefacturaenlinea.cl/WsFEL/wsFEL.php/SolicitarSesion");
            wsc.setRequest(request);
            wsc.setBinding("http://schemas.xmlsoap.org/wsdl/soap/http");
            wsc.setEndpointAddress("http://clientes.dtefacturaenlinea.cl/WsFEL/wsFEL.php");
            wsc.setServiceName("DTElectronico");
            wsc.setPortName("DTElectronicoPort");
            wsc.setTargetNS("/var/www//WsTest/");
            wsc.executeConnector();
            response = wsc.getResponse();
        }
        catch (Exception e) {
            throw new Exception("No se ha podido establecer conexion con el Servicio de Facturacion");
        }
        try {
            DocumentBuilderFactory.newInstance().newDocumentBuilder();
            SAXSource output = (SAXSource)response;
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            DOMResult result = new DOMResult();
            tf.transform(output, result);
            Document doc = (Document)result.getNode();
            Node datos = this.findReturn(doc.getChildNodes().item(0));
            if (datos != null) {
                NodeList att = datos.getChildNodes();
                int x = 0;
                while (x < att.getLength()) {
                    this.log.config(att.item(x).getLocalName());
                    if (att.item(x).getLocalName().equals("return") || att.item(x).getNodeName().equals("return")) {
                        token = att.item(x).getFirstChild().getNodeValue();
                    }
                    ++x;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return token;
    }

    private String llamarWSEnviarDTE(String token, String dte, String rutEmpresa, String tipoDocumento, String folioDocumento) throws Exception {
        String msg = "";
        String EstadoDte = "";
        String GlosaEstadoDte = "";
        String request = "<soapenv:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:wst=\"/var/www//WsTest/\"><soapenv:Header/><soapenv:Body><wst:EnviarDTE soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><sesion xsi:type=\"xsd:string\">" + token + "</sesion>" + "<archivo xsi:type=\"xsd:string\">" + dte + "</archivo>" + "<rutEmpresa xsi:type=\"xsd:string\">" + rutEmpresa + "</rutEmpresa>" + "<tipoDocumento xsi:type=\"xsd:string\">" + tipoDocumento + "</tipoDocumento>" + "<folio xsi:type=\"xsd:string\">" + folioDocumento + "</folio>" + "</wst:EnviarDTE>" + "</soapenv:Body>" + "</soapenv:Envelope>";
        Source response = null;
        try {
            CXFConnector wsc = new CXFConnector();
            wsc.setSoapAction("http://clientes.dtefacturaenlinea.cl/WsFEL/wsFEL.php/EnviarDTE");
            wsc.setRequest(request);
            wsc.setBinding("http://schemas.xmlsoap.org/wsdl/soap/http");
            wsc.setEndpointAddress("http://clientes.dtefacturaenlinea.cl/WsFEL/wsFEL.php");
            wsc.setServiceName("DTElectronico");
            wsc.setPortName("DTElectronicoPort");
            wsc.setTargetNS("/var/www//WsTest/");
            wsc.executeConnector();
            response = wsc.getResponse();
        }
        catch (Exception e) {
            throw new Exception("No se ha podido establecer conexion con el Servicio de Facturacion - " + e);
        }
        try {
            DocumentBuilderFactory.newInstance().newDocumentBuilder();
            SAXSource output = (SAXSource)response;
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            DOMResult result = new DOMResult();
            tf.transform(output, result);
            Document doc = (Document)result.getNode();
            Node datos = this.findReturnEnviarDTE(doc.getChildNodes().item(0));
            if (datos != null) {
                NodeList att = datos.getChildNodes();
                int x = 0;
                while (x < att.getLength()) {
                    this.log.config(att.item(x).getLocalName());
                    if (att.item(x).getLocalName().equals("return") || att.item(x).getNodeName().equals("return")) {
                        msg = att.item(x).getFirstChild().getNodeValue();
                    }
                    ++x;
                }
            }
            EstadoDte = this.findText(msg, "<EstadoDTE>", "</EstadoDTE>");
            GlosaEstadoDte = this.findText(msg, "<GlosaEstadoDTE>", "</GlosaEstadoDTE>");
            this.urlPdf = this.findText(msg, "<PDF Url=\"", "\"/>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "Estado DTE: " + EstadoDte + " Glosa Estado: " + GlosaEstadoDte + " Url:" + this.urlPdf;
    }

    public Node findReturn(Node node) {
        Node value = null;
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node childNode = list.item(i);
            if (childNode.getNodeName().equals("ns1:SolicitarSesionResponse")) {
                value = childNode;
                break;
            }
            value = this.findReturn(childNode);
            ++i;
        }
        return value;
    }

    public Node findReturnEnviarDTE(Node node) {
        Node value = null;
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node childNode = list.item(i);
            if (childNode.getNodeName().equals("ns1:EnviarDTEResponse")) {
                value = childNode;
                break;
            }
            value = this.findReturnEnviarDTE(childNode);
            ++i;
        }
        return value;
    }

    public String findText(String cadena, String fragmentoIni, String fragmentoFin) {
        String newText = "";
        int indiceIni = 0;
        int indiceFin = 0;
        boolean flag = cadena.contains(fragmentoIni);
        if (flag) {
            indiceIni = cadena.indexOf(fragmentoIni);
            indiceFin = cadena.indexOf(fragmentoFin);
            newText = cadena.substring(indiceIni += fragmentoIni.length(), indiceFin);
        } else {
            newText = "Error - No existe Cadena Especificada";
        }
        return newText;
    }

    public String PrintPDF(String p_url) {
        block11: {
            SimpleDoc pdfDoc;
            DocPrintJob job;
            HashPrintRequestAttributeSet attributes;
            PrintService service;
            block10: {
                block9: {
                    try {
                        service = PrintServiceLookup.lookupDefaultPrintService();
                        if (service != null) {
                            DocFlavor.INPUT_STREAM psFormat = DocFlavor.INPUT_STREAM.AUTOSENSE;
                            HashPrintRequestAttributeSet attributes2 = new HashPrintRequestAttributeSet();
                            DocPrintJob job2 = service.createPrintJob();
                            SimpleDoc pdfDoc2 = new SimpleDoc(new URL(p_url).openStream(), psFormat, null);
                            job2.print(pdfDoc2, attributes2);
                            break block9;
                        }
                        return "No Print Service";
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                try {
                    service = PrintServiceLookup.lookupDefaultPrintService();
                    if (service != null) {
                        attributes = new HashPrintRequestAttributeSet();
                        job = service.createPrintJob();
                        pdfDoc = new SimpleDoc(new URL(p_url).openStream(), DocFlavor.URL.AUTOSENSE, null);
                        job.print(pdfDoc, attributes);
                        break block10;
                    }
                    return "No Print Service";
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            try {
                service = PrintServiceLookup.lookupDefaultPrintService();
                if (service != null) {
                    attributes = new HashPrintRequestAttributeSet();
                    job = service.createPrintJob();
                    pdfDoc = new SimpleDoc(new URL(p_url).openStream(), DocFlavor.BYTE_ARRAY.AUTOSENSE, null);
                    job.print(pdfDoc, attributes);
                    break block11;
                }
                return "No Print Service";
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return "Imprimiendo...";
    }

    public String CreateXMLCGBoleta(MInvoice invoice) {
        String wsRespuesta = "";
        MDocType doc = new MDocType(invoice.getCtx(), invoice.getC_DocTypeTarget_ID(), invoice.get_TrxName());
        if (doc.get_Value("CreateXML") == null) {
            return "";
        }
        if (!((Boolean)doc.get_Value("CreateXML")).booleanValue()) {
            return "";
        }
        int typeDoc = Integer.parseInt((String)doc.get_Value("DocumentNo"));
        if (typeDoc == 0) {
            return "";
        }
        String mylog = new String();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            PO refdoc;
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation implementation = builder.getDOMImplementation();
            Document document = implementation.createDocument(null, "DTE", null);
            document.setXmlVersion("1.0");
            document.setTextContent("text/xml");
            Attr atr = document.createAttribute("xmlns");
            atr.setValue("http://www.sii.cl/SiiDte");
            Element Documento2 = document.createElement("Documento");
            document.getDocumentElement().appendChild(Documento2);
            Documento2.setAttribute("ID", "F" + invoice.getDocumentNo() + "T" + (String)doc.get_Value("DocumentNo"));
            Element Encabezado2 = document.createElement("Encabezado");
            Documento2.appendChild(Encabezado2);
            Element IdDoc2 = document.createElement("IdDoc");
            Encabezado2.appendChild(IdDoc2);
            mylog = "IdDoc";
            Element TipoDTE = document.createElement("TipoDTE");
            Text text = document.createTextNode(Integer.toString(typeDoc));
            TipoDTE.appendChild(text);
            IdDoc2.appendChild(TipoDTE);
            Element Folio = document.createElement("Folio");
            Text fo = document.createTextNode(invoice.getDocumentNo());
            Folio.appendChild(fo);
            IdDoc2.appendChild(Folio);
            Element FchEmis = document.createElement("FchEmis");
            Text emis = document.createTextNode(invoice.getDateInvoiced().toString().substring(0, 10));
            FchEmis.appendChild(emis);
            IdDoc2.appendChild(FchEmis);
            Element MntPagos2 = document.createElement("MntPagos");
            IdDoc2.appendChild(MntPagos2);
            mylog = "Termino de Pago";
            Element FchPago = document.createElement("FchPago");
            Text fPago = document.createTextNode(invoice.getDateInvoiced().toString().substring(0, 10));
            FchPago.appendChild(fPago);
            MntPagos2.appendChild(FchPago);
            Element MntPago = document.createElement("MntPago");
            Text mPago = document.createTextNode(invoice.getGrandTotal().setScale(0, 4).toString());
            MntPago.appendChild(mPago);
            MntPagos2.appendChild(MntPago);
            String GlosaP = DB.getSQLValueString(invoice.get_TrxName(), "SELECT MAX(rlt.name)  FROM AD_Ref_List rl  INNER JOIN AD_Ref_List_Trl rlt ON (rl.AD_Ref_List_ID = rlt.AD_Ref_List_ID)  WHERE AD_Reference_ID=195  AND rlt.AD_Language='es_MX' AND rl.value = '" + invoice.getPaymentRule() + "'", new Object[0]);
            String GlosaPFull = invoice.getC_PaymentTerm().getName();
            if (GlosaP != null && GlosaP.trim().length() > 0) {
                GlosaPFull = String.valueOf(GlosaPFull) + "-" + GlosaP;
            }
            Element GlosaPagos = document.createElement("GlosaPagos");
            Text gPagos = document.createTextNode(GlosaPFull);
            GlosaPagos.appendChild(gPagos);
            MntPagos2.appendChild(GlosaPagos);
            int cantdias = 0;
            Timestamp fchVencCal = DB.getSQLValueTS(invoice.get_TrxName(), "SELECT MAX(duedate) FROM C_Invoice_V WHERE C_Invoice_ID = ?", invoice.get_ID());
            if (fchVencCal == null && invoice.getC_PaymentTerm_ID() > 0) {
                MPaymentTerm tpago = new MPaymentTerm(invoice.getCtx(), invoice.getC_PaymentTerm_ID(), invoice.get_TrxName());
                int cantDet = DB.getSQLValue(invoice.get_TrxName(), "SELECT MIN(NetDays) FROM C_PaySchedule WHERE C_PaymentTerm_ID = " + invoice.getC_PaymentTerm_ID());
                cantdias = tpago.getNetDays() > 0 ? tpago.getNetDays() : (cantDet > 0 ? cantDet : 0);
                if (cantdias > 0) {
                    Calendar calFchVenc = Calendar.getInstance();
                    calFchVenc.setTimeInMillis(invoice.getDateInvoiced().getTime());
                    calFchVenc.add(5, cantdias);
                    fchVencCal = new Timestamp(calFchVenc.getTimeInMillis());
                }
            }
            Element FchVenc = document.createElement("FchVenc");
            Text venc = document.createTextNode(fchVencCal.toString().substring(0, 10));
            FchVenc.appendChild(venc);
            IdDoc2.appendChild(FchVenc);
            Element Emisor2 = document.createElement("Emisor");
            Encabezado2.appendChild(Emisor2);
            mylog = "Emisor";
            MOrg company = MOrg.get(invoice.getCtx(), invoice.getAD_Org_ID());
            Element Rut = document.createElement("RUTEmisor");
            Text rut = document.createTextNode((String)company.get_Value("Rut"));
            Rut.appendChild(rut);
            Emisor2.appendChild(Rut);
            String nameRzn = company.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = company.getName();
            }
            nameRzn = nameRzn.replace("'", "");
            nameRzn = nameRzn.replace("\"", "");
            Element RznSoc = document.createElement("RznSoc");
            Text rzn = document.createTextNode(nameRzn);
            RznSoc.appendChild(rzn);
            Emisor2.appendChild(RznSoc);
            String giroEmisStr = (String)company.get_Value("Giro");
            giroEmisStr = giroEmisStr.replace("'", "");
            giroEmisStr = giroEmisStr.replace("\"", "");
            Element GiroEmis = document.createElement("GiroEmis");
            Text gi = document.createTextNode(giroEmisStr);
            GiroEmis.appendChild(gi);
            Emisor2.appendChild(GiroEmis);
            Element Acteco = document.createElement("Acteco");
            Text teco = document.createTextNode((String)company.get_Value("Acteco"));
            Acteco.appendChild(teco);
            Emisor2.appendChild(Acteco);
            Element DirOrigen = document.createElement("DirOrigen");
            Text dir = document.createTextNode((String)company.get_Value("Address1"));
            DirOrigen.appendChild(dir);
            Emisor2.appendChild(DirOrigen);
            Element CmnaOrigen = document.createElement("CmnaOrigen");
            Text com = document.createTextNode((String)company.get_Value("Comuna"));
            CmnaOrigen.appendChild(com);
            Emisor2.appendChild(CmnaOrigen);
            Element CiudadOrigen = document.createElement("CiudadOrigen");
            Text city = document.createTextNode((String)company.get_Value("City"));
            CiudadOrigen.appendChild(city);
            Emisor2.appendChild(CiudadOrigen);
            if (invoice.getSalesRep_ID() > 0) {
                Element SalesRep = document.createElement("CdgVendedor");
                Text sales = document.createTextNode(invoice.getSalesRep().getName());
                SalesRep.appendChild(sales);
                Emisor2.appendChild(SalesRep);
            }
            mylog = "receptor";
            MBPartner BP = new MBPartner(invoice.getCtx(), invoice.getC_BPartner_ID(), invoice.get_TrxName());
            MBPartnerLocation bloc = new MBPartnerLocation(invoice.getCtx(), invoice.getC_BPartner_Location_ID(), invoice.get_TrxName());
            Element Receptor2 = document.createElement("Receptor");
            Encabezado2.appendChild(Receptor2);
            Element RUTRecep = document.createElement("RUTRecep");
            Text rutc = document.createTextNode(BP.getValue() + "-" + BP.get_ValueAsString("Digito"));
            RUTRecep.appendChild(rutc);
            Receptor2.appendChild(RUTRecep);
            String RznSocRecepStr = BP.getName();
            RznSocRecepStr = RznSocRecepStr.replace("'", "");
            RznSocRecepStr = RznSocRecepStr.replace("\"", "");
            Element RznSocRecep = document.createElement("RznSocRecep");
            Text RznSocR = document.createTextNode(RznSocRecepStr);
            RznSocRecep.appendChild(RznSocR);
            Receptor2.appendChild(RznSocRecep);
            Element GiroRecep = document.createElement("GiroRecep");
            Text giro = document.createTextNode((String)BP.get_Value("Giro"));
            GiroRecep.appendChild(giro);
            Receptor2.appendChild(GiroRecep);
            String dirRecepStr = String.valueOf(bloc.getLocation(true).getAddress1()) + "-" + bloc.getPhone();
            dirRecepStr = dirRecepStr.replace("'", "");
            dirRecepStr = dirRecepStr.replace("\"", "");
            Element DirRecep = document.createElement("DirRecep");
            Text dirr = document.createTextNode(dirRecepStr);
            DirRecep.appendChild(dirr);
            Receptor2.appendChild(DirRecep);
            String CmnaRecepStr = null;
            if (bloc.getLocation(true).getAddress2() != null) {
                CmnaRecepStr = bloc.getLocation(true).getAddress2();
            } else if (bloc.getLocation(true).getC_City_ID() > 0) {
                CmnaRecepStr = MCity.get(invoice.getCtx(), bloc.getLocation(true).getC_City_ID()).getName();
            }
            Element CmnaRecep = document.createElement("CmnaRecep");
            Text Cmna = document.createTextNode(CmnaRecepStr);
            CmnaRecep.appendChild(Cmna);
            Receptor2.appendChild(CmnaRecep);
            String ciudadTxt = "";
            ciudadTxt = bloc.getLocation(true).getC_Region_ID() == 1000001 || bloc.getLocation(true).getC_City_ID() <= 0 ? "SANTIAGO" : bloc.getC_Location().getCity();
            Element CiudadRecep = document.createElement("CiudadRecep");
            Text reg = document.createTextNode(ciudadTxt != null ? ciudadTxt : "Santiago");
            CiudadRecep.appendChild(reg);
            Receptor2.appendChild(CiudadRecep);
            mylog = "Totales";
            Element Totales2 = document.createElement("Totales");
            Encabezado2.appendChild(Totales2);
            BigDecimal amountex = DB.getSQLValueBD(invoice.get_TrxName(), "select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='Y' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID(), new Object[0]);
            BigDecimal amountNeto = DB.getSQLValueBD(invoice.get_TrxName(), "select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='N' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID(), new Object[0]);
            Element MntNeto = document.createElement("MntNeto");
            Text neto = document.createTextNode(amountNeto != null ? amountNeto.toString() : "0");
            MntNeto.appendChild(neto);
            Totales2.appendChild(MntNeto);
            Element MntExe = document.createElement("MntExe");
            Text exe = document.createTextNode(amountex != null ? amountex.toString() : "0");
            MntExe.appendChild(exe);
            Totales2.appendChild(MntExe);
            if (amountNeto.signum() > 0) {
                Element TasaIVA = document.createElement("TasaIVA");
                Text tiva = document.createTextNode("19");
                TasaIVA.appendChild(tiva);
                Totales2.appendChild(TasaIVA);
            }
            Element IVA = document.createElement("IVA");
            BigDecimal ivaamt = Env.ZERO;
            if (amountex.intValue() != invoice.getGrandTotal().intValue()) {
                ivaamt = invoice.getGrandTotal().subtract(invoice.getTotalLines()).setScale(0, 4);
            }
            Text iva = document.createTextNode(ivaamt.toString());
            IVA.appendChild(iva);
            Totales2.appendChild(IVA);
            Element MntTotal = document.createElement("MntTotal");
            Text total = document.createTextNode(invoice.getGrandTotal().setScale(0, 4).toString());
            MntTotal.appendChild(total);
            Totales2.appendChild(MntTotal);
            mylog = "detalle";
            MInvoiceLine[] iLines = invoice.getLines(false);
            int lineInvoice = 0;
            int i = 0;
            while (i < iLines.length) {
                MInvoiceLine iLine = iLines[i];
                if (iLine.getM_Product_ID() != 0 || iLine.getC_Charge_ID() != 0) {
                    Element Detalle2 = document.createElement("Detalle");
                    Documento2.appendChild(Detalle2);
                    Element NroLinDet = document.createElement("NroLinDet");
                    Text line = document.createTextNode(Integer.toString(++lineInvoice));
                    NroLinDet.appendChild(line);
                    Detalle2.appendChild(NroLinDet);
                    Element NmbItem = document.createElement("NmbItem");
                    String pname = "";
                    pname = iLine.getProduct() != null ? iLine.getProduct().getName() : iLine.getC_Charge().getName();
                    pname = pname.replace("'", "");
                    pname = pname.replace("\"", "");
                    Text Item = document.createTextNode(pname);
                    NmbItem.appendChild(Item);
                    Detalle2.appendChild(NmbItem);
                    if (iLine.getDescription() != null && iLine.getDescription() != "") {
                        Element DscItem = document.createElement("DscItem");
                        Text desc = document.createTextNode(iLine.getDescription() == null ? " " : iLine.getDescription());
                        DscItem.appendChild(desc);
                        Detalle2.appendChild(DscItem);
                    }
                    Element QtyItem = document.createElement("QtyItem");
                    Text qt = document.createTextNode(iLine.getQtyInvoiced().toString());
                    QtyItem.appendChild(qt);
                    Detalle2.appendChild(QtyItem);
                    String unmdItemStr = "";
                    unmdItemStr = iLine.getM_Product_ID() > 0 ? iLine.getM_Product().getC_UOM().getUOMSymbol() : "UN";
                    if (unmdItemStr == null) {
                        unmdItemStr = "UN";
                    }
                    Element UnmdItem = document.createElement("UnmdItem");
                    Text UM = document.createTextNode(unmdItemStr);
                    UnmdItem.appendChild(UM);
                    Detalle2.appendChild(UnmdItem);
                    BigDecimal prcItem = null;
                    BigDecimal mntItem = null;
                    BigDecimal prcItemTax = null;
                    BigDecimal mntItemTax = null;
                    if (invoice.getC_DocType().getDocBaseType().compareToIgnoreCase("ARI") == 0 && invoice.getC_DocType().getName().toLowerCase().contains("boleta") && iLine.getC_Tax().getRate().compareTo(Env.ZERO) != 0) {
                        prcItemTax = iLine.getPriceActual().multiply(iLine.getC_Tax().getRate());
                        prcItemTax = prcItemTax.divide(Env.ONEHUNDRED);
                        prcItem = iLine.getPriceActual().add(prcItemTax);
                        mntItemTax = iLine.getLineNetAmt().multiply(iLine.getC_Tax().getRate());
                        mntItemTax = mntItemTax.divide(Env.ONEHUNDRED);
                        mntItem = iLine.getLineNetAmt().add(mntItemTax);
                    } else {
                        prcItem = iLine.getPriceActual();
                        mntItem = iLine.getLineNetAmt();
                    }
                    Element PrcItem = document.createElement("PrcItem");
                    Text pa = document.createTextNode(prcItem.setScale(0, 4).toString());
                    PrcItem.appendChild(pa);
                    Detalle2.appendChild(PrcItem);
                    Element MontoItem = document.createElement("MontoItem");
                    Text tl = document.createTextNode(mntItem.setScale(0, 4).toString());
                    MontoItem.appendChild(tl);
                    Detalle2.appendChild(MontoItem);
                }
                ++i;
            }
            mylog = "referencia";
            String tiporeferencia = new String();
            String folioreferencia = new String();
            String fechareferencia = new String();
            int tipo_Ref = 0;
            if (invoice.get_Value("C_RefDoc_ID") != null && (Integer)invoice.get_Value("C_RefDoc_ID") > 0) {
                mylog = "referencia:invoice";
                refdoc = new MInvoice(invoice.getCtx(), (int)((Integer)invoice.get_Value("C_RefDoc_ID")), invoice.get_TrxName());
                MDocType Refdoctype = new MDocType(invoice.getCtx(), ((X_C_Invoice)refdoc).getC_DocType_ID(), invoice.get_TrxName());
                tiporeferencia = (String)Refdoctype.get_Value("DocumentNo");
                folioreferencia = ((X_C_Invoice)refdoc).getDocumentNo();
                fechareferencia = ((X_C_Invoice)refdoc).getDateInvoiced().toString().substring(0, 10);
                tipo_Ref = 1;
            }
            if (invoice.getPOReference() != null && invoice.getPOReference().length() > 0) {
                mylog = "referencia:order";
                tiporeferencia = "801";
                folioreferencia = invoice.getPOReference();
                fechareferencia = invoice.getDateOrdered().toString().substring(0, 10);
                tipo_Ref = 2;
            }
            if (invoice.get_Value("C_RefInOut_ID") != null && (Integer)invoice.get_Value("C_RefInOut_ID") > 0) {
                mylog = "referencia:despacho";
                refdoc = new MInOut(invoice.getCtx(), (int)((Integer)invoice.get_Value("C_RefInOut_ID")), invoice.get_TrxName());
                tiporeferencia = "52";
                folioreferencia = ((X_M_InOut)refdoc).getDocumentNo();
                fechareferencia = ((X_M_InOut)refdoc).getMovementDate().toString().substring(0, 10);
                tipo_Ref = 3;
            }
            int indice = 0;
            if (tipo_Ref > 0) {
                Element Referencia2 = document.createElement("Referencia");
                Documento2.appendChild(Referencia2);
                Element NroLinRef = document.createElement("NroLinRef");
                Text Nro = document.createTextNode("1");
                NroLinRef.appendChild(Nro);
                Referencia2.appendChild(NroLinRef);
                Element TpoDocRef = document.createElement("TpoDocRef");
                Text tpo = document.createTextNode(tiporeferencia);
                TpoDocRef.appendChild(tpo);
                Referencia2.appendChild(TpoDocRef);
                Element FolioRef = document.createElement("FolioRef");
                Text ref = document.createTextNode(folioreferencia);
                FolioRef.appendChild(ref);
                Referencia2.appendChild(FolioRef);
                Element FchRef = document.createElement("FchRef");
                Text fchref = document.createTextNode(fechareferencia);
                FchRef.appendChild(fchref);
                Referencia2.appendChild(FchRef);
                Element CodRef = document.createElement("CodRef");
                Text codref = document.createTextNode(Integer.toString(tipo_Ref));
                CodRef.appendChild(codref);
                Referencia2.appendChild(CodRef);
                ++indice;
            }
            if (OFBForward.UseRefInOutXMLFEL()) {
                int ID_Ship = 0;
                try {
                    if (invoice.getC_Order_ID() > 0) {
                        ID_Ship = DB.getSQLValue(invoice.get_TrxName(), "SELECT COALESCE((MAX(M_InOut_ID)),0) FROM M_InOut mi INNER JOIN C_Order co ON (mi.C_Order_ID = co.C_Order_ID) WHERE mi.docstatus IN ('CO','CL','VO') AND mi.C_Order_ID = " + invoice.getC_Order_ID());
                    }
                }
                catch (Exception e) {
                    ID_Ship = 0;
                    this.log.log(Level.SEVERE, e.getMessage(), e);
                }
                if (ID_Ship > 0) {
                    ++indice;
                    String docRef = "52";
                    MInOut inOutref = new MInOut(invoice.getCtx(), ID_Ship, invoice.get_TrxName());
                    MDocType docTShip = new MDocType(invoice.getCtx(), inOutref.getC_DocType_ID(), invoice.get_TrxName());
                    docRef = docTShip.get_ValueAsBoolean("CreateXML") ? "52" : "50";
                    Element Referencia3 = document.createElement("Referencia");
                    Documento2.appendChild(Referencia3);
                    Element NroLinRef = document.createElement("NroLinRef");
                    Text Nro = document.createTextNode(Integer.toString(indice));
                    NroLinRef.appendChild(Nro);
                    Referencia3.appendChild(NroLinRef);
                    Element TpoDocRef = document.createElement("TpoDocRef");
                    Text tpo = document.createTextNode(docRef);
                    TpoDocRef.appendChild(tpo);
                    Referencia3.appendChild(TpoDocRef);
                    Element FolioRef = document.createElement("FolioRef");
                    Text ref = document.createTextNode(inOutref.getDocumentNo());
                    FolioRef.appendChild(ref);
                    Referencia3.appendChild(FolioRef);
                    Element FchRef = document.createElement("FchRef");
                    Text fchref = document.createTextNode(inOutref.getMovementDate().toString().substring(0, 10));
                    FchRef.appendChild(fchref);
                    Referencia3.appendChild(FchRef);
                }
            }
            if (invoice.getDescription() != null && invoice.getDescription() != "" && invoice.getDescription() != " ") {
                mylog = "Adicional";
                Element Adicional = document.createElement("Adicional");
                Documento2.appendChild(Adicional);
                Element NodosA = document.createElement("NodosA");
                Adicional.appendChild(NodosA);
                Element A6 = document.createElement("A6");
                Text a6Text = document.createTextNode(invoice.getDescription());
                A6.appendChild(a6Text);
                NodosA.appendChild(A6);
            }
            mylog = "archivo";
            String ExportDir = (String)company.get_Value("ExportDir");
            try {
                File theDir = new File(ExportDir);
                if (!theDir.exists()) {
                    ExportDir = (String)company.get_Value("ExportDir2");
                }
            }
            catch (Exception e) {
                throw new AdempiereException("no existe directorio");
            }
            ExportDir = ExportDir.replace("\\", "/");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(ExportDir, invoice.getDocumentNo() + ".xml"));
            StreamResult console = new StreamResult(System.out);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(source, result);
            transformer.transform(source, console);
            File file = new File(ExportDir, invoice.getDocumentNo() + ".xml");
            Document docValid = builder.parse(file);
            Element raiz = docValid.getDocumentElement();
            raiz.setAttribute("version", "1.0");
            raiz.setAttribute("xmlns", "http://www.sii.cl/SiiDte");
            source = new DOMSource(docValid);
            result = new StreamResult(new File(ExportDir, invoice.getDocumentNo() + ".xml"));
            console = new StreamResult(System.out);
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(source, result);
            transformer.transform(source, console);
            byte[] fileArray = new byte[(int)file.length()];
            FileInputStream inputStream = new FileInputStream(file);
            ((InputStream)inputStream).read(fileArray);
            byte[] encoded = Base64.encodeBase64((byte[])fileArray);
            String encodedFile = "";
            try {
                encodedFile = new String(encoded);
            }
            catch (Exception fchref) {
                // empty catch block
            }
            String token = "";
            String rutEmpresa = "";
            String rutUsuario = "";
            String password = "";
            try {
                rutEmpresa = OFBForward.RutEmpresaFEL();
                rutUsuario = OFBForward.RutUsuarioFEL();
                password = OFBForward.ContrasenaFEL();
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getMessage(), e);
            }
            String archivoXML = String.valueOf(ExportDir) + invoice.getDocumentNo() + ".xml";
            String tipoDocumento = Integer.toString(typeDoc);
            String folioDocumento = invoice.getDocumentNo();
            if (archivoXML != "" && rutEmpresa != "" && rutUsuario != "" && password != "") {
                token = this.llamarWSToken(rutEmpresa, rutUsuario, password);
                if (token.substring(0, 5).compareToIgnoreCase("error") == 0) {
                    return token;
                }
                wsRespuesta = this.llamarWSEnviarDTE(token, encodedFile, rutEmpresa, tipoDocumento, folioDocumento);
                this.log.config(wsRespuesta);
                if (this.urlPdf != null && this.urlPdf != "" && this.urlPdf != " ") {
                    this.urlPdf = String.valueOf(this.urlPdf) + "&Ced=3";
                    invoice.set_CustomColumn("URLXML", this.urlPdf);
                }
                invoice.set_CustomColumn("DescriptionFEL", wsRespuesta);
                invoice.save();
                if (this.urlPdf != null && this.urlPdf != "" && this.urlPdf != " ") {
                    this.PrintPDF(this.urlPdf);
                }
            }
        }
        catch (Exception e) {
            this.log.severe("CreateXML: " + mylog + "--" + e.getMessage());
            return "CreateXML: " + mylog + "--" + e.getMessage();
        }
        return "XML CG Generated " + wsRespuesta;
    }
}

