/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCharge;
import org.compiere.model.MCity;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MOrg;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MProduct;
import org.compiere.model.MTax;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_M_InOut;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ExportDTEInvoiceCGBaskakow
extends SvrProcess {
    private Properties m_ctx;
    private int p_C_Invoice_ID = 0;

    @Override
    protected void prepare() {
        this.p_C_Invoice_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    @Override
    protected String doIt() throws Exception {
        MInvoice inv = new MInvoice(this.m_ctx, this.p_C_Invoice_ID, this.get_TrxName());
        String msg = this.CreateXMLCG(inv);
        return msg;
    }

    public String CreateXMLCG(MInvoice invoice) {
        MDocType doc = new MDocType(invoice.getCtx(), invoice.getC_DocTypeTarget_ID(), invoice.get_TrxName());
        if (doc.get_Value("CreateXML") == null) {
            return "";
        }
        if (!((Boolean)doc.get_Value("CreateXML")).booleanValue()) {
            return "";
        }
        int typeDoc = Integer.parseInt((String)doc.get_Value("DocumentNo"));
        if (typeDoc == 0) {
            return "";
        }
        String mylog = new String();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            PO refdoc;
            String nomContacto;
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation implementation = builder.getDOMImplementation();
            Document document = implementation.createDocument(null, "DTE", null);
            document.setXmlVersion("1.0");
            document.setTextContent("text/xml");
            Attr atr = document.createAttribute("xmlns");
            atr.setValue("http://www.sii.cl/SiiDte");
            Element Documento2 = document.createElement("Documento");
            document.getDocumentElement().appendChild(Documento2);
            Documento2.setAttribute("ID", "DTE-" + invoice.getDocumentNo());
            Element Encabezado2 = document.createElement("Encabezado");
            Documento2.appendChild(Encabezado2);
            Element IdDoc2 = document.createElement("IdDoc");
            Encabezado2.appendChild(IdDoc2);
            mylog = "IdDoc";
            Element TipoDTE = document.createElement("TipoDTE");
            Text text = document.createTextNode(Integer.toString(typeDoc));
            TipoDTE.appendChild(text);
            IdDoc2.appendChild(TipoDTE);
            Element Folio = document.createElement("Folio");
            Text fo = document.createTextNode(invoice.getDocumentNo());
            Folio.appendChild(fo);
            IdDoc2.appendChild(Folio);
            Element FchEmis = document.createElement("FchEmis");
            Text emis = document.createTextNode(invoice.getDateInvoiced().toString().substring(0, 10));
            FchEmis.appendChild(emis);
            IdDoc2.appendChild(FchEmis);
            String StrFmaPago = "";
            MPaymentTerm pterm = new MPaymentTerm(invoice.getCtx(), invoice.getC_PaymentTerm_ID(), invoice.get_TrxName());
            StrFmaPago = pterm.getDescription() != null && pterm.getDescription().length() > 0 ? pterm.getDescription() : pterm.getName();
            Element PayTerm = document.createElement("FmaPago");
            Text term = document.createTextNode(StrFmaPago);
            PayTerm.appendChild(term);
            IdDoc2.appendChild(PayTerm);
            Element TermPagoCdg = document.createElement("TermPagoCdg");
            Text termPagoCod = document.createTextNode(pterm.getValue());
            TermPagoCdg.appendChild(termPagoCod);
            IdDoc2.appendChild(TermPagoCdg);
            Element TermPagoGlosa = document.createElement("TermPagoGlosa");
            Text termPagoGlosa = document.createTextNode(pterm.getName());
            TermPagoGlosa.appendChild(termPagoGlosa);
            IdDoc2.appendChild(TermPagoGlosa);
            Element TermPagoDias = document.createElement("TermPagoDias");
            Text termPagoDias = document.createTextNode(Integer.toString(pterm.getNetDays()));
            TermPagoDias.appendChild(termPagoDias);
            IdDoc2.appendChild(TermPagoDias);
            Element FchVenc = document.createElement("FchVenc");
            Text venc = document.createTextNode(invoice.getDateInvoiced().toString().substring(0, 10));
            FchVenc.appendChild(venc);
            IdDoc2.appendChild(FchVenc);
            Element Emisor2 = document.createElement("Emisor");
            Encabezado2.appendChild(Emisor2);
            mylog = "Emisor";
            MOrg company = MOrg.get(invoice.getCtx(), invoice.getAD_Org_ID());
            Element Rut = document.createElement("RUTEmisor");
            Text rut = document.createTextNode((String)company.get_Value("Rut"));
            Rut.appendChild(rut);
            Emisor2.appendChild(Rut);
            String nameRzn = company.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = company.getName();
            }
            Element RznSoc = document.createElement("RznSoc");
            Text rzn = document.createTextNode(nameRzn);
            RznSoc.appendChild(rzn);
            Emisor2.appendChild(RznSoc);
            Element GiroEmis = document.createElement("GiroEmis");
            Text gi = document.createTextNode((String)company.get_Value("Giro"));
            GiroEmis.appendChild(gi);
            Emisor2.appendChild(GiroEmis);
            Element Acteco = document.createElement("Acteco");
            Text teco = document.createTextNode((String)company.get_Value("Acteco"));
            Acteco.appendChild(teco);
            Emisor2.appendChild(Acteco);
            Element DirOrigen = document.createElement("DirOrigen");
            Text dir = document.createTextNode((String)company.get_Value("Address1"));
            DirOrigen.appendChild(dir);
            Emisor2.appendChild(DirOrigen);
            Element CmnaOrigen = document.createElement("CmnaOrigen");
            Text com = document.createTextNode((String)company.get_Value("Comuna"));
            CmnaOrigen.appendChild(com);
            Emisor2.appendChild(CmnaOrigen);
            Element CiudadOrigen = document.createElement("CiudadOrigen");
            Text city = document.createTextNode((String)company.get_Value("City"));
            CiudadOrigen.appendChild(city);
            Emisor2.appendChild(CiudadOrigen);
            MUser salesUser = new MUser(invoice.getCtx(), invoice.getSalesRep_ID(), invoice.get_TrxName());
            Element SalesRep = document.createElement("CdgVendedor");
            Text sales = document.createTextNode(salesUser.getName());
            SalesRep.appendChild(sales);
            Emisor2.appendChild(SalesRep);
            mylog = "receptor";
            MBPartner BP = new MBPartner(invoice.getCtx(), invoice.getC_BPartner_ID(), invoice.get_TrxName());
            MBPartnerLocation obra = null;
            if (invoice.getC_Order_ID() > 0) {
                MOrder SOrder = new MOrder(invoice.getCtx(), invoice.getC_Order_ID(), invoice.get_TrxName());
                obra = new MBPartnerLocation(invoice.getCtx(), SOrder.getC_BPartner_Location_ID(), invoice.get_TrxName());
            } else {
                obra = new MBPartnerLocation(invoice.getCtx(), invoice.getC_BPartner_Location_ID(), invoice.get_TrxName());
            }
            MBPartnerLocation bloc = new MBPartnerLocation(invoice.getCtx(), invoice.getC_BPartner_Location_ID(), invoice.get_TrxName());
            Element Receptor2 = document.createElement("Receptor");
            Encabezado2.appendChild(Receptor2);
            Element RUTRecep = document.createElement("RUTRecep");
            Text rutc = document.createTextNode(BP.getValue() + "-" + BP.get_ValueAsString("Digito"));
            RUTRecep.appendChild(rutc);
            Receptor2.appendChild(RUTRecep);
            Element RznSocRecep = document.createElement("RznSocRecep");
            Text RznSocR = document.createTextNode(BP.getName());
            RznSocRecep.appendChild(RznSocR);
            Receptor2.appendChild(RznSocRecep);
            Element GiroRecep = document.createElement("GiroRecep");
            Text giro = document.createTextNode((String)BP.get_Value("Giro"));
            GiroRecep.appendChild(giro);
            Receptor2.appendChild(GiroRecep);
            String string = nomContacto = invoice.getAD_User_ID() > 0 ? invoice.getAD_User().getName() : " ";
            if (nomContacto == null) {
                nomContacto = " ";
            }
            Element ContactoRecep = document.createElement("Contacto");
            Text contacto = document.createTextNode(nomContacto);
            ContactoRecep.appendChild(contacto);
            Receptor2.appendChild(ContactoRecep);
            Element CorreoRecep = document.createElement("CorreoRecep");
            Text corrRecep = document.createTextNode(invoice.getAD_User().getEMail() == null ? " " : invoice.getAD_User().getEMail());
            CorreoRecep.appendChild(corrRecep);
            Receptor2.appendChild(CorreoRecep);
            Element DirRecep = document.createElement("DirRecep");
            Text dirr = document.createTextNode(bloc.getLocation(true).getAddress1());
            DirRecep.appendChild(dirr);
            Receptor2.appendChild(DirRecep);
            Element CiudadRecep = document.createElement("CmnaRecep");
            Text reg = document.createTextNode(bloc.getLocation(true).getC_City_ID() > 0 ? MCity.get(invoice.getCtx(), bloc.getLocation(true).getC_City_ID()).getName() : "Santiago");
            CiudadRecep.appendChild(reg);
            Receptor2.appendChild(CiudadRecep);
            Element CiudadRecep2 = document.createElement("CiudadRecep");
            Text cui = document.createTextNode(bloc.getLocation(true).getAddress2() == null ? "Santiago" : bloc.getLocation(true).getAddress2());
            CiudadRecep2.appendChild(cui);
            Receptor2.appendChild(CiudadRecep2);
            Element DirPostal = document.createElement("DirPostal");
            Text dirPostalStr = document.createTextNode(obra.getName());
            DirPostal.appendChild(dirPostalStr);
            Receptor2.appendChild(DirPostal);
            mylog = "Totales";
            Element Totales2 = document.createElement("Totales");
            Encabezado2.appendChild(Totales2);
            BigDecimal amountex = DB.getSQLValueBD(invoice.get_TrxName(), "select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='Y' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID(), new Object[0]);
            BigDecimal amountNeto = DB.getSQLValueBD(invoice.get_TrxName(), "select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='N' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID(), new Object[0]);
            Element MntNeto = document.createElement("MntNeto");
            Text neto = document.createTextNode(amountNeto != null ? amountNeto.toString() : "0");
            MntNeto.appendChild(neto);
            Totales2.appendChild(MntNeto);
            Element MntExe = document.createElement("MntExe");
            Text exe = document.createTextNode(amountex != null ? amountex.toString() : "0");
            MntExe.appendChild(exe);
            Totales2.appendChild(MntExe);
            if (amountNeto.signum() > 0) {
                Element TasaIVA = document.createElement("TasaIVA");
                Text tiva = document.createTextNode("19");
                TasaIVA.appendChild(tiva);
                Totales2.appendChild(TasaIVA);
            }
            Element IVA = document.createElement("IVA");
            BigDecimal ivaamt = Env.ZERO;
            if (amountex.intValue() != invoice.getGrandTotal().intValue()) {
                ivaamt = invoice.getGrandTotal().subtract(invoice.getTotalLines()).setScale(0, 4);
            }
            Text iva = document.createTextNode(ivaamt.toString());
            IVA.appendChild(iva);
            Totales2.appendChild(IVA);
            Element MntTotal = document.createElement("MntTotal");
            Text total = document.createTextNode(invoice.getGrandTotal().setScale(0, 4).toString());
            MntTotal.appendChild(total);
            Totales2.appendChild(MntTotal);
            mylog = "detalle";
            String MySqlCG = "select 0 AS M_PRODUCT_ID, 0 AS C_CHARGE_ID, MAX(il.C_TAX_ID) AS C_TAX_ID, MAX(il.DESCRIPTION2) as DESCRIPTION, MAX(il.Name) as name, SUM(il.QTYENTERED) AS QTYENTERED, MAX(il.PRICELIST) AS PRICELIST, SUM(il.QTYINVOICED) AS QTYINVOICED, MAX(il.PRICEACTUAL) AS PRICEACTUAL, SUM(il.LINENETAMT) AS LINENETAMT, il.M_Product_Name_ID from RVOFB_InfoLineXML il where c_invoice_id = ? and M_Product_Name_ID > 0 GROUP BY M_Product_Name_ID UNION select il.M_PRODUCT_ID, il.C_CHARGE_ID, C_TAX_ID, il.DESCRIPTION,il.Name, il.QTYENTERED, il.PRICELIST, il.QTYINVOICED, il.PRICEACTUAL,il.LINENETAMT, il.M_Product_Name_ID from RVOFB_InfoLineXML il where c_invoice_id = ? and M_Product_Name_ID is null";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(MySqlCG, invoice.get_TrxName());
                pstmt.setInt(1, invoice.get_ID());
                pstmt.setInt(2, invoice.get_ID());
                rs = pstmt.executeQuery();
                int lineInvoice = 1;
                while (rs.next()) {
                    MProduct produc = null;
                    MCharge charge = null;
                    if (rs.getInt("M_PRODUCT_ID") > 0) {
                        produc = new MProduct(invoice.getCtx(), rs.getInt("M_PRODUCT_ID"), invoice.get_TrxName());
                    }
                    if (rs.getInt("C_CHARGE_ID") > 0) {
                        charge = new MCharge(invoice.getCtx(), rs.getInt("C_CHARGE_ID"), invoice.get_TrxName());
                    }
                    if (rs.getInt("M_PRODUCT_ID") == 0 && rs.getInt("C_CHARGE_ID") == 0 && rs.getInt("M_Product_Name_ID") == 0 || rs.getBigDecimal("LINENETAMT").compareTo(Env.ZERO) < 0) continue;
                    Element Detalle2 = document.createElement("Detalle");
                    Documento2.appendChild(Detalle2);
                    MTax tax = new MTax(invoice.getCtx(), rs.getInt("C_TAX_ID"), invoice.get_TrxName());
                    if (tax.isTaxExempt()) {
                        Element IndEx = document.createElement("IndExe");
                        Text lineE = document.createTextNode("1");
                        IndEx.appendChild(lineE);
                        Detalle2.appendChild(IndEx);
                    }
                    Element NroLinDet = document.createElement("NroLinDet");
                    Text line = document.createTextNode(Integer.toString(lineInvoice));
                    NroLinDet.appendChild(line);
                    Detalle2.appendChild(NroLinDet);
                    Element NmbItem = document.createElement("NmbItem");
                    String pname = "";
                    pname = rs.getInt("M_PRODUCT_ID") > 0 ? produc.getName() : (rs.getInt("C_CHARGE_ID") > 0 ? charge.getName() : (rs.getInt("M_Product_Name_ID") > 0 ? (rs.getString("NAME") == null ? " " : rs.getString("NAME")) : " "));
                    Text Item = document.createTextNode(pname);
                    NmbItem.appendChild(Item);
                    Detalle2.appendChild(NmbItem);
                    Element DscItem = document.createElement("DscItem");
                    String pdescGen = "";
                    pdescGen = rs.getString("DESCRIPTION") == null ? " " : rs.getString("DESCRIPTION");
                    Text desc = document.createTextNode(pdescGen);
                    DscItem.appendChild(desc);
                    Detalle2.appendChild(DscItem);
                    Element QtyItem = document.createElement("QtyItem");
                    String qtD = " ";
                    qtD = rs.getInt("M_Product_Name_ID") > 0 ? Integer.toString(rs.getInt("QTYINVOICED")) : Integer.toString(rs.getInt("QTYINVOICED"));
                    Text qt = document.createTextNode(qtD);
                    QtyItem.appendChild(qt);
                    Detalle2.appendChild(QtyItem);
                    Element PrcItem = document.createElement("PrcItem");
                    String paD = " ";
                    paD = rs.getInt("M_Product_Name_ID") > 0 ? rs.getBigDecimal("PRICEACTUAL").setScale(0, 4).toString() : rs.getBigDecimal("PRICEACTUAL").setScale(0, 4).toString();
                    Text pa = document.createTextNode(paD);
                    PrcItem.appendChild(pa);
                    Detalle2.appendChild(PrcItem);
                    Element MontoItem = document.createElement("MontoItem");
                    Text tl = document.createTextNode(rs.getBigDecimal("LINENETAMT").setScale(0, 4).toString());
                    MontoItem.appendChild(tl);
                    Detalle2.appendChild(MontoItem);
                    ++lineInvoice;
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, MySqlCG, e);
            }
            try {
                String TpoMovStr = invoice.get_ValueAsString("TpoMov");
                String GlosaDRStr = invoice.get_ValueAsString("GlosaDR");
                String TpoValorStr = invoice.get_ValueAsString("TpoValor");
                BigDecimal AmtValorDR = DB.getSQLValueBD(invoice.get_TrxName(), "SELECT SUM(LineNetAmt) FROM C_InvoiceLine  WHERE C_Invoice_ID = ? AND LineNetAmt < 0", invoice.get_ID());
                if (TpoMovStr != null && TpoMovStr != "" && GlosaDRStr != null && GlosaDRStr != "" && TpoValorStr != null && TpoValorStr != "" && AmtValorDR != null && AmtValorDR.compareTo(Env.ZERO) < 0) {
                    mylog = "DscRcgGlobal";
                    Element DscRcgGlobal2 = document.createElement("DscRcgGlobal");
                    Documento2.appendChild(DscRcgGlobal2);
                    int correlativo = 1;
                    Element NroLinDR = document.createElement("NroLinDR");
                    Text NroLinDRTxt = document.createTextNode(Integer.toString(correlativo));
                    NroLinDR.appendChild(NroLinDRTxt);
                    DscRcgGlobal2.appendChild(NroLinDR);
                    Element TpoMov = document.createElement("TpoMov");
                    Text TpoMovTxt = document.createTextNode(TpoMovStr);
                    TpoMov.appendChild(TpoMovTxt);
                    DscRcgGlobal2.appendChild(TpoMov);
                    Element GlosaDR = document.createElement("GlosaDR");
                    Text GlosaDRTxt = document.createTextNode(GlosaDRStr);
                    GlosaDR.appendChild(GlosaDRTxt);
                    DscRcgGlobal2.appendChild(GlosaDR);
                    Element TpoValor = document.createElement("TpoValor");
                    Text TpoValorTxt = document.createTextNode(TpoValorStr);
                    TpoValor.appendChild(TpoValorTxt);
                    DscRcgGlobal2.appendChild(TpoValor);
                    Element ValorDR = document.createElement("ValorDR");
                    Text ValorDRTxt = document.createTextNode(AmtValorDR.abs().setScale(0, 4).toString());
                    ValorDR.appendChild(ValorDRTxt);
                    DscRcgGlobal2.appendChild(ValorDR);
                }
            }
            catch (Exception e) {
                this.log.severe("Error nuevas variables: NroLinDR,TpoMov,GlosaDR,TpoValor,ValorDR  " + e.getMessage());
            }
            mylog = "referencia";
            String tiporeferencia = new String();
            String folioreferencia = new String();
            String fechareferencia = new String();
            int tipo_Ref = 0;
            if (invoice.get_Value("C_RefDoc_ID") != null && (Integer)invoice.get_Value("C_RefDoc_ID") > 0) {
                mylog = "referencia:invoice";
                refdoc = new MInvoice(invoice.getCtx(), (int)((Integer)invoice.get_Value("C_RefDoc_ID")), invoice.get_TrxName());
                MDocType Refdoctype = new MDocType(invoice.getCtx(), ((X_C_Invoice)refdoc).getC_DocType_ID(), invoice.get_TrxName());
                tiporeferencia = (String)Refdoctype.get_Value("DocumentNo");
                folioreferencia = ((X_C_Invoice)refdoc).getDocumentNo();
                fechareferencia = ((X_C_Invoice)refdoc).getDateInvoiced().toString().substring(0, 10);
                tipo_Ref = 1;
            }
            if (invoice.getPOReference() != null && invoice.getPOReference().length() > 0) {
                mylog = "referencia:order";
                tiporeferencia = "801";
                folioreferencia = invoice.getPOReference();
                fechareferencia = invoice.getDateOrdered().toString().substring(0, 10);
                tipo_Ref = 2;
            }
            if (invoice.get_Value("C_RefInOut_ID") != null && (Integer)invoice.get_Value("C_RefInOut_ID") > 0) {
                mylog = "referencia:despacho";
                refdoc = new MInOut(invoice.getCtx(), (int)((Integer)invoice.get_Value("C_RefInOut_ID")), invoice.get_TrxName());
                tiporeferencia = "52";
                folioreferencia = ((X_M_InOut)refdoc).getDocumentNo();
                fechareferencia = ((X_M_InOut)refdoc).getMovementDate().toString().substring(0, 10);
                tipo_Ref = 3;
            }
            if (tipo_Ref > 0) {
                Element Referencia2 = document.createElement("Referencia");
                Documento2.appendChild(Referencia2);
                Element NroLinRef = document.createElement("NroLinRef");
                Text Nro = document.createTextNode("0001");
                NroLinRef.appendChild(Nro);
                Referencia2.appendChild(NroLinRef);
                Element TpoDocRef = document.createElement("TpoDocRef");
                Text tpo = document.createTextNode(tiporeferencia);
                TpoDocRef.appendChild(tpo);
                Referencia2.appendChild(TpoDocRef);
                Element FolioRef = document.createElement("FolioRef");
                Text ref = document.createTextNode(folioreferencia);
                FolioRef.appendChild(ref);
                Referencia2.appendChild(FolioRef);
                Element FchRef = document.createElement("FchRef");
                Text fchref = document.createTextNode(fechareferencia);
                FchRef.appendChild(fchref);
                Referencia2.appendChild(FchRef);
                String CodRefTxt = null;
                try {
                    CodRefTxt = invoice.get_ValueAsString("CodRef");
                }
                catch (Exception e) {
                    CodRefTxt = null;
                }
                if (CodRefTxt != null && CodRefTxt.length() > 0) {
                    Element CodRef = document.createElement("CodRef");
                    Text codref = document.createTextNode(invoice.get_ValueAsString("CodRef") == null ? "0" : invoice.get_ValueAsString("CodRef"));
                    CodRef.appendChild(codref);
                    Referencia2.appendChild(CodRef);
                }
            }
            Element Referencia2 = document.createElement("Referencia");
            Documento2.appendChild(Referencia2);
            Element NroLinRef2 = document.createElement("NroLinRef");
            Text Nro2 = document.createTextNode("0002");
            NroLinRef2.appendChild(Nro2);
            Referencia2.appendChild(NroLinRef2);
            Element TpoDocRef2 = document.createElement("TpoDocRef");
            Text NroTDR2 = document.createTextNode("I01");
            TpoDocRef2.appendChild(NroTDR2);
            Referencia2.appendChild(TpoDocRef2);
            Element FolioRef2 = document.createElement("FolioRef");
            Text fRef2 = document.createTextNode("Obra");
            FolioRef2.appendChild(fRef2);
            Referencia2.appendChild(FolioRef2);
            Element FchRef2 = document.createElement("FchRef");
            Text fchref2 = document.createTextNode(invoice.getDateInvoiced().toString().substring(0, 10));
            FchRef2.appendChild(fchref2);
            Referencia2.appendChild(FchRef2);
            Element ObraName = document.createElement("RazonRef");
            Text oName = document.createTextNode(obra.getName());
            ObraName.appendChild(oName);
            Referencia2.appendChild(ObraName);
            String sqlGuias = "select distinct(mio.m_inout_id) as m_inout_id  from C_InvoiceLine cil  inner join m_inoutline mil on (cil.m_inoutline_ID = mil.m_inoutline_ID)  inner join m_inout mio on (mil.m_inout_id = mio.m_inout_id)  WHERE cil.C_Invoice_ID = ?";
            CPreparedStatement pstmt2 = null;
            ResultSet rs2 = null;
            try {
                pstmt2 = DB.prepareStatement(sqlGuias, invoice.get_TrxName());
                pstmt2.setInt(1, invoice.get_ID());
                rs2 = pstmt2.executeQuery();
                int iRef = 3;
                while (rs2.next()) {
                    mylog = "referencia:despacho";
                    if (rs2.getInt("m_inout_id") <= 0) continue;
                    MInOut refdocIO = new MInOut(invoice.getCtx(), rs2.getInt("m_inout_id"), invoice.get_TrxName());
                    Element ReferenciaIO = document.createElement("Referencia");
                    Documento2.appendChild(ReferenciaIO);
                    Element NroLinRefIO = document.createElement("NroLinRef");
                    Text NroIO = document.createTextNode(Integer.toString(iRef));
                    NroLinRefIO.appendChild(NroIO);
                    ReferenciaIO.appendChild(NroLinRefIO);
                    Element TpoDocRefIO = document.createElement("TpoDocRef");
                    Text tpoIO = document.createTextNode("50");
                    TpoDocRefIO.appendChild(tpoIO);
                    ReferenciaIO.appendChild(TpoDocRefIO);
                    Element FolioRefIO = document.createElement("FolioRef");
                    Text refIO = document.createTextNode(refdocIO.getDocumentNo());
                    FolioRefIO.appendChild(refIO);
                    ReferenciaIO.appendChild(FolioRefIO);
                    String fechaRefIO = refdocIO.getMovementDate().toString().substring(0, 10);
                    Element FchRefIO = document.createElement("FchRef");
                    Text fchrefIO = document.createTextNode(fechaRefIO);
                    FchRefIO.appendChild(fchrefIO);
                    ReferenciaIO.appendChild(FchRefIO);
                    ++iRef;
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, MySqlCG, e);
            }
            mylog = "firma";
            Element Firma = document.createElement("TmstFirma");
            Timestamp today = new Timestamp(TimeUtil.getToday().getTimeInMillis());
            Text Ftext = document.createTextNode(today.toString().substring(0, 10) + "T" + today.toString().substring(11, 19));
            Firma.appendChild(Ftext);
            Documento2.appendChild(Firma);
            mylog = "archivo";
            String ExportDir = (String)company.get_Value("ExportDir");
            ExportDir = ExportDir.replace("\\", "/");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(ExportDir, invoice.getDocumentNo() + ".xml"));
            StreamResult console = new StreamResult(System.out);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.transform(source, result);
            transformer.transform(source, console);
            File file = new File(ExportDir, invoice.getDocumentNo() + ".xml");
            Document docValid = builder.parse(file);
            Element raiz = docValid.getDocumentElement();
            raiz.setAttribute("xmlns", "http://www.sii.cl/SiiDte");
            raiz.setAttribute("version", "1.0");
            source = new DOMSource(docValid);
            result = new StreamResult(new File(ExportDir, invoice.getDocumentNo() + ".xml"));
            console = new StreamResult(System.out);
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(source, result);
            transformer.transform(source, console);
        }
        catch (Exception e) {
            this.log.severe("CreateXML: " + mylog + "--" + e.getMessage());
            return "CreateXML: " + mylog + "--" + e.getMessage();
        }
        return "XML Baskakow Generated";
    }
}

