/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import org.compiere.model.X_DM_Document;
import org.compiere.model.X_DM_DocumentLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class CreateResolutionsCometidos
extends SvrProcess {
    private String p_Type = null;
    private Timestamp p_DateTrx_To;
    private Timestamp p_DateTrx_From;
    private int p_Document_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("Type")) {
                    this.p_Type = (String)para[i].getParameter();
                } else if (name.equals("DateTrx")) {
                    this.p_DateTrx_From = (Timestamp)para[i].getParameter();
                    this.p_DateTrx_To = (Timestamp)para[i].getParameter_To();
                } else if (name.equals("DM_Document_ID")) {
                    this.p_Document_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        X_DM_Document dc = new X_DM_Document(this.getCtx(), this.p_Document_ID, this.get_TrxName());
        String sqldoc = null;
        String desc = null;
        String descL = null;
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.p_DateTrx_From.getTime());
        cal.add(5, -1);
        Timestamp p_DateTrx_FromM = new Timestamp(cal.getTimeInMillis());
        cal.setTimeInMillis(this.p_DateTrx_To.getTime());
        cal.add(5, 1);
        Timestamp p_DateTrx_ToM = new Timestamp(cal.getTimeInMillis());
        CPreparedStatement pstmt = null;
        if (this.p_Type.equalsIgnoreCase("HO")) {
            sqldoc = "select rh_administrativerequests_id from rh_administrativerequests arD where requesttype like 'CMT' and docstatus in ('CO','CL') and rh_administrativerequests_id not in (select dl.rh_administrativerequests_id from DM_DocumentLine dl inner join DM_Document dc on (dl.DM_Document_ID = dc.DM_Document_ID) where dc.docstatus not in ('VO') and dl.rh_administrativerequests_id is not null and dc.dm_documenttype = 'AC') and datestartrequest > ? and datestartrequest < ? and (SELECT CASE WHEN ar.FACTOR > 0 then ar.FACTOR ELSE (((SELECT MAX(CommitmentAmt)*ar.QtyCP FROM C_Bpartner cbp WHERE cbp.C_Bpartner_ID = ar.C_Bpartner_ID)+(SELECT MAX(CommitmentAmtSP) * ar.QtySP FROM C_Bpartner cbp WHERE cbp.C_Bpartner_ID = ar.C_Bpartner_ID)) * (select case when (COALESCE((SUM(  case when payable = 'Y' then 1 else 0 end)),0)) > 0 then 1 else 0 end from rh_administrativerequestsline arl inner join c_city cc on (arl.c_city_id = cc.c_city_id) where arl.RH_AdministrativeRequests_ID = arD.RH_AdministrativeRequests_ID) ) end FROM RH_AdministrativeRequests ar where ar.RH_AdministrativeRequests_ID = arD.RH_AdministrativeRequests_ID) > 0 and (select typecontract from DM_Document dm where dm.dm_documenttype = 'CE' and dm.docstatus in ('CO') and dm.isactive = 'Y' and dm.c_bpartner_id = arD.C_BPartner_ID and dm.datetrx = (select max(dm2.datetrx) from DM_Document dm2 where dm2.c_bpartner_id = dm.c_bpartner_id and dm_documenttype = 'CE' and docstatus in ('CO') and isactive = 'Y')) in ('HO','HP')";
            desc = "Resolucion Cometido Honorarios (Institucionales/De Programa) entre fechas " + this.p_DateTrx_From + " / " + this.p_DateTrx_To;
            descL = "Carga Resolucion Cometido";
        } else if (this.p_Type.equalsIgnoreCase("OT")) {
            sqldoc = "select rh_administrativerequests_id from rh_administrativerequests arD where requesttype like 'CMT' and docstatus in ('CO','CL') and rh_administrativerequests_id not in (select dl.rh_administrativerequests_id from DM_DocumentLine dl inner join DM_Document dc on (dl.DM_Document_ID = dc.DM_Document_ID) where dc.docstatus not in ('VO') and dl.rh_administrativerequests_id is not null and dc.dm_documenttype = 'AC') and datestartrequest > ? and datestartrequest < ? and (SELECT CASE WHEN ar.FACTOR > 0 then ar.FACTOR ELSE (((SELECT MAX(CommitmentAmt)*ar.QtyCP FROM C_Bpartner cbp WHERE cbp.C_Bpartner_ID = ar.C_Bpartner_ID)+(SELECT MAX(CommitmentAmtSP) * ar.QtySP FROM C_Bpartner cbp WHERE cbp.C_Bpartner_ID = ar.C_Bpartner_ID)) * (select case when (COALESCE((SUM(  case when payable = 'Y' then 1 else 0 end)),0)) > 0 then 1 else 0 end from rh_administrativerequestsline arl inner join c_city cc on (arl.c_city_id = cc.c_city_id) where arl.RH_AdministrativeRequests_ID = arD.RH_AdministrativeRequests_ID) ) end FROM RH_AdministrativeRequests ar where ar.RH_AdministrativeRequests_ID = arD.RH_AdministrativeRequests_ID) > 0 and (select typecontract from DM_Document dm where dm.dm_documenttype = 'CE' and dm.docstatus in ('CO') and dm.isactive = 'Y' and dm.c_bpartner_id = arD.C_BPartner_ID and dm.datetrx = (select max(dm2.datetrx) from DM_Document dm2 where dm2.c_bpartner_id = dm.c_bpartner_id and dm_documenttype = 'CE' and docstatus in ('CO') and isactive = 'Y')) not in ('HO','HP')";
            desc = "Resolucion Cometido Otros (Contrata/Planta/Suplencia)entre fechas " + this.p_DateTrx_From + " / " + this.p_DateTrx_To;
            descL = "Carga Resolucion Cometido";
        }
        dc.setDescription(desc);
        dc.save();
        int cantC = 0;
        try {
            pstmt = DB.prepareStatement(sqldoc, this.get_TrxName());
            pstmt.setTimestamp(1, p_DateTrx_FromM);
            pstmt.setTimestamp(2, p_DateTrx_ToM);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_DM_DocumentLine dl = new X_DM_DocumentLine(this.getCtx(), 0, this.get_TrxName());
                dl.setDM_Document_ID(dc.get_ID());
                dl.set_CustomColumn("RH_AdministrativeRequests_ID", rs.getInt(1));
                dl.setDescription(descL);
                dl.setIsActive(true);
                dl.setAmt(new BigDecimal(0.0));
                dl.save();
                ++cantC;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return "Se han agregado " + cantC + " Lineas de Cometidos";
    }
}

