/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MPeriod;
import org.compiere.model.X_C_ProjectOFB;
import org.compiere.model.X_TP_CostingValues;
import org.compiere.model.X_TP_Destination;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CosteoRutaTSM
extends SvrProcess {
    private int p_ProjectOFB_ID = 0;
    private Timestamp p_MovementDateFrom = null;
    private Timestamp p_MovementDateTo = null;
    private int p_C_Period_ID = 0;
    private int p_PInstance_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_ProjectOFB_ID")) {
                    this.p_ProjectOFB_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Period_ID")) {
                    this.p_C_Period_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_PInstance_ID = this.getAD_PInstance_ID();
    }

    @Override
    protected String doIt() throws AdempiereSystemError {
        MPeriod period = new MPeriod(this.getCtx(), this.p_C_Period_ID, this.get_TrxName());
        String sqlCP = "SELECT periodstatus FROM C_PeriodControl WHERE docbasetype = 'MMM' AND C_Period_ID = ?";
        String periodS = DB.getSQLValueString(this.get_TrxName(), sqlCP, this.p_C_Period_ID);
        if (periodS.compareTo("C") == 0) {
            return "No se puede costear un periodo cerrado";
        }
        this.p_MovementDateFrom = period.getStartDate();
        this.p_MovementDateTo = period.getEndDate();
        int contador = 0;
        BigDecimal kmAcuT1 = new BigDecimal("0.0");
        BigDecimal volAcuT1 = new BigDecimal("0.0");
        BigDecimal kmAcuT2 = new BigDecimal("0.0");
        BigDecimal volAcuT2 = new BigDecimal("0.0");
        BigDecimal kmAcu = new BigDecimal("0.0");
        BigDecimal volAcu = new BigDecimal("0.0");
        String sqlPrincipal = "SELECT M_Movement_ID FROM M_Movement WHERE isactive = 'Y'";
        if (this.p_ProjectOFB_ID > 0) {
            sqlPrincipal = String.valueOf(sqlPrincipal) + " AND C_ProjectOFB_ID = " + this.p_ProjectOFB_ID;
        }
        if (this.p_MovementDateFrom != null && this.p_MovementDateTo != null) {
            sqlPrincipal = String.valueOf(sqlPrincipal) + " AND MovementDate between ? AND ?";
        }
        sqlPrincipal = String.valueOf(sqlPrincipal) + " ORDER BY MovementDate, M_Movement_ID";
        try {
            CPreparedStatement pstmt = null;
            pstmt = DB.prepareStatement(sqlPrincipal, this.get_TrxName());
            pstmt.setTimestamp(1, this.p_MovementDateFrom);
            pstmt.setTimestamp(2, this.p_MovementDateTo);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MMovement move = new MMovement(this.getCtx(), rs.getInt("M_Movement_ID"), this.get_TrxName());
                X_C_ProjectOFB pro = new X_C_ProjectOFB(this.getCtx(), move.get_ValueAsInt("C_ProjectOFB_ID"), this.get_TrxName());
                String CTC = pro.get_ValueAsString("TP_CostingType");
                if (move.get_ID() == 1005386) {
                    int aa = move.get_ID();
                    aa = 0;
                }
                String sqlType = "SELECT TP_Type FROM A_Asset WHERE A_Asset_ID = ?";
                String type = DB.getSQLValueString(this.get_TrxName(), sqlType, move.get_ValueAsInt("TP_Asset_ID"));
                boolean lineaunica = false;
                int IDPuerto = 0;
                if (CTC.equalsIgnoreCase("M")) {
                    String sqlPBase = "SELECT des.TP_Destination_ID FROM M_Movementline ml LEFT JOIN TP_Destination des ON (ml.TP_Destination_ID = des.TP_Destination_ID) WHERE M_Movement_ID = ? AND IsHarbor = 'Y'";
                    IDPuerto = DB.getSQLValue(this.get_TrxName(), sqlPBase, move.get_ID());
                }
                int idOrigen = move.get_ValueAsInt("TP_Destination_ID");
                MMovementLine[] lines = move.getLines(false);
                int i = 0;
                while (i < lines.length) {
                    MMovementLine line = lines[i];
                    int noViaje = line.get_ValueAsInt("TP_LineNo");
                    if (noViaje != 99 && noViaje != 87 && noViaje != 88 && noViaje != 89 && noViaje != 90) {
                        BigDecimal volnew;
                        X_TP_CostingValues cvaluesN2;
                        String sqlTP_Vn2;
                        BigDecimal kmnew;
                        String sqlLN;
                        BigDecimal volnew2;
                        X_TP_CostingValues CVAlueIDCK;
                        int CostingValuesCicloK_ID;
                        String sqlTP_KMC;
                        BigDecimal kmnew2;
                        X_TP_CostingValues CVAlueIDC;
                        ResultSet rsC;
                        String sqlCiclo;
                        BigDecimal SumCosto;
                        int cant;
                        String sqlTP_Cant;
                        String sqlTP_V;
                        int TP_DestinationRef_ID;
                        BigDecimal costM;
                        X_TP_CostingValues cvalues;
                        int CostingValues_ID;
                        boolean ISDN;
                        boolean validLine;
                        X_TP_CostingValues cvalues2;
                        int CostingValues_ID2;
                        String sqlTP_V2;
                        BigDecimal kmHR = (BigDecimal)line.get_Value("TP_TotalKM");
                        BigDecimal volHR = (BigDecimal)line.get_Value("TP_VolM3");
                        BigDecimal costoTotal = new BigDecimal("0.0");
                        if (kmHR == null) {
                            kmHR = Env.ZERO;
                        }
                        if (volHR == null) {
                            volHR = Env.ZERO;
                        }
                        if (type == null) {
                            type = "1";
                        }
                        if (type.equalsIgnoreCase("1")) {
                            kmAcuT1 = kmAcuT1.add(kmHR);
                            volAcuT1 = volAcuT1.add(volHR);
                            kmAcu = kmAcuT1;
                            volAcu = volAcuT1;
                        } else if (type.equalsIgnoreCase("2")) {
                            kmAcuT2 = kmAcuT2.add(kmHR);
                            volAcuT2 = volAcuT2.add(volHR);
                            kmAcu = kmAcuT2;
                            volAcu = volAcuT2;
                        }
                        if (CTC.equalsIgnoreCase("K")) {
                            sqlTP_V2 = "SELECT MAX(TP_CostingValues_ID) FROM TP_CostingValues WHERE C_ProjectOFB_ID = ? AND TP_CostingType = 'K' AND TP_TypeValue = 'K' AND MinQty <= ? AND MaxQty >= ? AND TP_Type = ? AND Isactive = 'Y' ";
                            CostingValues_ID2 = DB.getSQLValue(this.get_TrxName(), sqlTP_V2, pro.get_ID(), kmAcu, kmAcu, type);
                            if (CostingValues_ID2 > 0) {
                                cvalues2 = new X_TP_CostingValues(this.getCtx(), CostingValues_ID2, this.get_TrxName());
                                BigDecimal kmnew3 = new BigDecimal("0.0");
                                try {
                                    kmnew3 = (BigDecimal)cvalues2.get_Value("MaxType");
                                    if (kmnew3 != null && kmHR.compareTo(kmnew3) > 0 && kmnew3.compareTo(Env.ZERO) > 0) {
                                        kmHR = kmnew3;
                                    }
                                }
                                catch (Exception e) {
                                    this.log.log(Level.SEVERE, e.getMessage(), e);
                                }
                                costoTotal = kmHR.multiply(cvalues2.getAmt());
                                line.set_CustomColumn("Cost", costoTotal);
                                line.set_CustomColumn("KMAcu", kmAcu);
                                line.set_CustomColumn("VolAcu", volAcu);
                                if (line.getMovementQty().equals(Env.ZERO) | line.getMovementQty() == null) {
                                    line.setMovementQty(Env.ONE);
                                }
                                line.save();
                            } else {
                                return "Linea sin rango de valores ingresados: Flota " + pro.getName() + " Hoja de Ruta(ID) " + move.get_ID() + " Linea(ID) " + line.get_ID();
                            }
                        }
                        if (CTC.equalsIgnoreCase("V")) {
                            sqlTP_V2 = "SELECT MAX(TP_CostingValues_ID) FROM TP_CostingValues WHERE C_ProjectOFB_ID = ? AND TP_CostingType = 'V' AND TP_TypeValue = 'V' AND MinQty <= ? AND MaxQty >= ? AND TP_Type = ? AND Isactive = 'Y' ";
                            CostingValues_ID2 = DB.getSQLValue(this.get_TrxName(), sqlTP_V2, pro.get_ID(), volAcu, volAcu, type);
                            if (CostingValues_ID2 > 0) {
                                cvalues2 = new X_TP_CostingValues(this.getCtx(), CostingValues_ID2, this.get_TrxName());
                                boolean ISM3 = false;
                                boolean ISDN2 = false;
                                boolean ISValid = false;
                                validLine = false;
                                ISM3 = cvalues2.get_ValueAsBoolean("ExistM3");
                                ISDN2 = cvalues2.get_ValueAsBoolean("ExistDN");
                                ISValid = cvalues2.get_ValueAsBoolean("ValidDocument");
                                if (ISValid) {
                                    String sqlValidDM = "SELECT  count(1) FROM M_MovementLine mml INNER JOIN M_Movement mm ON (mml.M_Movement_ID = mm.M_Movement_ID) WHERE C_ProjectOFB_ID = ? AND mml.POReference like ? AND M_MovementLine_ID <> ? and mml.cost > 0";
                                    int cantSQL1 = DB.getSQLValue(this.get_TrxName(), sqlValidDM, move.get_ValueAsInt("C_ProjectOFB_ID"), line.get_ValueAsString("POReference"), line.get_ID());
                                    if (cantSQL1 > 0) {
                                        validLine = true;
                                    }
                                }
                                if (ISM3) {
                                    String sqlExM3 = "SELECT count(1) FROM M_MovementLine mml INNER JOIN M_Movement mm ON (mml.M_Movement_ID = mm.M_Movement_ID) WHERE mm.M_Movement_ID = ? AND mml.TP_VolM3 > 0 ";
                                    int cantSQL2 = DB.getSQLValue(this.get_TrxName(), sqlExM3, move.get_ID());
                                    if (cantSQL2 == 0) {
                                        validLine = true;
                                    }
                                }
                                if (ISDN2) {
                                    String sqlExDN = "SELECT count(1) FROM M_MovementLine mml INNER JOIN M_Movement mm ON (mml.M_Movement_ID = mm.M_Movement_ID) WHERE mm.M_Movement_ID = ? AND mml.POReference IS NOT NULL ";
                                    int cantSQL3 = DB.getSQLValue(this.get_TrxName(), sqlExDN, move.get_ID());
                                    if (cantSQL3 == 0) {
                                        validLine = true;
                                    }
                                }
                                if (!validLine) {
                                    BigDecimal volnew3 = new BigDecimal("0.0");
                                    try {
                                        volnew3 = (BigDecimal)cvalues2.get_Value("MaxType");
                                        if (volnew3 != null && volHR.compareTo(volnew3) > 0 && volnew3.compareTo(Env.ZERO) > 0) {
                                            volHR = volnew3;
                                        }
                                    }
                                    catch (Exception e) {
                                        this.log.log(Level.SEVERE, e.getMessage(), e);
                                    }
                                    costoTotal = volHR.multiply(cvalues2.getAmt());
                                    line.set_CustomColumn("Cost", costoTotal);
                                    line.set_CustomColumn("KMAcu", kmAcu);
                                    line.set_CustomColumn("VolAcu", volAcu);
                                    if (line.getMovementQty().equals(Env.ZERO) | line.getMovementQty() == null) {
                                        line.setMovementQty(Env.ONE);
                                    }
                                    line.save();
                                }
                            } else {
                                return "Linea sin rango de valores ingresados: Flota " + pro.getName() + " Hoja de Ruta(ID) " + move.get_ID() + " Linea(ID) " + line.get_ID();
                            }
                        }
                        if (CTC.equalsIgnoreCase("M")) {
                            boolean ISM3 = false;
                            ISDN = false;
                            boolean ISPE = false;
                            boolean ISValid = false;
                            boolean validLine2 = false;
                            String sqlTP_M = "SELECT MAX(TP_CostingValues_ID) FROM TP_CostingValues WHERE C_ProjectOFB_ID = ? AND TP_CostingType = 'M' AND MinQty <= ? AND MaxQty >= ? AND TP_Type = ? AND Isactive = 'Y'";
                            CostingValues_ID = DB.getSQLValue(this.get_TrxName(), sqlTP_M, pro.get_ID(), volAcu, volAcu, type);
                            if (CostingValues_ID > 0) {
                                int des_ID;
                                cvalues = new X_TP_CostingValues(this.getCtx(), CostingValues_ID, this.get_TrxName());
                                ISM3 = cvalues.get_ValueAsBoolean("ExistM3");
                                ISDN = cvalues.get_ValueAsBoolean("ExistDN");
                                ISPE = cvalues.get_ValueAsBoolean("ExistPE");
                                ISValid = cvalues.get_ValueAsBoolean("ValidDocument");
                                if (ISValid) {
                                    String sqlValidDM = "SELECT  count(1) FROM M_MovementLine mml INNER JOIN M_Movement mm ON (mml.M_Movement_ID = mm.M_Movement_ID) WHERE C_ProjectOFB_ID = ? AND mml.POReference like ? AND M_MovementLine_ID <> ? and mml.cost > 0";
                                    int cantSQL1 = DB.getSQLValue(this.get_TrxName(), sqlValidDM, move.get_ValueAsInt("C_ProjectOFB_ID"), line.get_ValueAsString("POReference"), line.get_ID());
                                    if (cantSQL1 > 0) {
                                        validLine2 = true;
                                    }
                                }
                                if (ISM3) {
                                    String sqlExM3 = "SELECT count(1) FROM M_MovementLine mml INNER JOIN M_Movement mm ON (mml.M_Movement_ID = mm.M_Movement_ID) WHERE mm.M_Movement_ID = ? AND mml.TP_VolM3 > 0 ";
                                    int cantSQL2 = DB.getSQLValue(this.get_TrxName(), sqlExM3, move.get_ID());
                                    if (cantSQL2 == 0) {
                                        validLine2 = true;
                                    }
                                }
                                if (ISDN) {
                                    String sqlExDN = "SELECT count(1) FROM M_MovementLine mml INNER JOIN M_Movement mm ON (mml.M_Movement_ID = mm.M_Movement_ID) WHERE mm.M_Movement_ID = ? AND mml.POReference IS NOT NULL ";
                                    int cantSQL3 = DB.getSQLValue(this.get_TrxName(), sqlExDN, move.get_ID());
                                    if (cantSQL3 == 0) {
                                        validLine2 = true;
                                    }
                                }
                                if (ISPE) {
                                    String sqlExM3 = "SELECT count(1) FROM M_MovementLine mml INNER JOIN M_Movement mm ON (mml.M_Movement_ID = mm.M_Movement_ID) WHERE mm.M_Movement_ID = ? AND mml.TP_VolIN > 0 ";
                                    int cantSQL4 = DB.getSQLValue(this.get_TrxName(), sqlExM3, move.get_ID());
                                    if (cantSQL4 == 0) {
                                        validLine2 = true;
                                    }
                                }
                                if ((des_ID = line.get_ValueAsInt("TP_Destination_ID")) == IDPuerto) {
                                    validLine2 = true;
                                }
                                if (!validLine2) {
                                    String sqlMD = "SELECT MAX(cost) FROM TP_DestinationM WHERE TP_Destination_ID = ? AND TP_DestinationRef_ID = ? AND IsActive = 'Y'";
                                    costM = DB.getSQLValueBD(this.get_TrxName(), sqlMD, IDPuerto, des_ID);
                                    BigDecimal VolEntrada = (BigDecimal)line.get_Value("TP_VolIN");
                                    costoTotal = costM != null ? VolEntrada.multiply(costM) : VolEntrada.multiply(cvalues.getAmt());
                                    line.set_CustomColumn("Cost", costoTotal);
                                    line.set_CustomColumn("KMAcu", kmAcu);
                                    line.set_CustomColumn("VolAcu", volAcu);
                                    if (line.getMovementQty().equals(Env.ZERO) | line.getMovementQty() == null) {
                                        line.setMovementQty(Env.ONE);
                                    }
                                    line.save();
                                }
                            } else {
                                return "Linea sin rango de valores ingresados: Flota " + pro.getName() + " Hoja de Ruta(ID) " + move.get_ID() + " Linea(ID) " + line.get_ID();
                            }
                        }
                        if (CTC.equalsIgnoreCase("F")) {
                            boolean ISM3 = false;
                            ISDN = false;
                            boolean ISPE = false;
                            boolean ISValid = false;
                            boolean validLine3 = false;
                            String sqlTP_M = "SELECT MAX(TP_CostingValues_ID) FROM TP_CostingValues WHERE C_ProjectOFB_ID = ? AND TP_CostingType = 'F' AND MinQty <= ? AND MaxQty >= ? AND TP_Type = ? AND Isactive = 'Y'";
                            CostingValues_ID = DB.getSQLValue(this.get_TrxName(), sqlTP_M, pro.get_ID(), volAcu, volAcu, type);
                            if (CostingValues_ID > 0) {
                                cvalues = new X_TP_CostingValues(this.getCtx(), CostingValues_ID, this.get_TrxName());
                                ISM3 = cvalues.get_ValueAsBoolean("ExistM3");
                                ISDN = cvalues.get_ValueAsBoolean("ExistDN");
                                ISPE = cvalues.get_ValueAsBoolean("ExistPE");
                                ISValid = cvalues.get_ValueAsBoolean("ValidDocument");
                                if (ISValid) {
                                    String sqlValidDM = "SELECT  count(1) FROM M_MovementLine mml INNER JOIN M_Movement mm ON (mml.M_Movement_ID = mm.M_Movement_ID) WHERE C_ProjectOFB_ID = ? AND mml.POReference like ? AND M_MovementLine_ID <> ? and mml.cost > 0";
                                    int cantSQL1 = DB.getSQLValue(this.get_TrxName(), sqlValidDM, move.get_ValueAsInt("C_ProjectOFB_ID"), line.get_ValueAsString("POReference"), line.get_ID());
                                    if (cantSQL1 > 0) {
                                        validLine3 = true;
                                    }
                                }
                                if (ISM3) {
                                    String sqlExM3 = "SELECT count(1) FROM M_MovementLine mml INNER JOIN M_Movement mm ON (mml.M_Movement_ID = mm.M_Movement_ID) WHERE mm.M_Movement_ID = ? AND mml.TP_VolM3 > 0 ";
                                    int cantSQL2 = DB.getSQLValue(this.get_TrxName(), sqlExM3, move.get_ID());
                                    if (cantSQL2 == 0) {
                                        validLine3 = true;
                                    }
                                }
                                if (ISDN) {
                                    String sqlExDN = "SELECT count(1) FROM M_MovementLine mml INNER JOIN M_Movement mm ON (mml.M_Movement_ID = mm.M_Movement_ID) WHERE mm.M_Movement_ID = ? AND mml.POReference IS NOT NULL ";
                                    int cantSQL3 = DB.getSQLValue(this.get_TrxName(), sqlExDN, move.get_ID());
                                    if (cantSQL3 == 0) {
                                        validLine3 = true;
                                    }
                                }
                                if (ISPE) {
                                    String sqlExM3 = "SELECT count(1) FROM M_MovementLine mml INNER JOIN M_Movement mm ON (mml.M_Movement_ID = mm.M_Movement_ID) WHERE mm.M_Movement_ID = ? AND mml.TP_VolIN > 0 ";
                                    int cantSQL4 = DB.getSQLValue(this.get_TrxName(), sqlExM3, move.get_ID());
                                    if (cantSQL4 == 0) {
                                        validLine3 = true;
                                    }
                                }
                                int des_ID = line.get_ValueAsInt("TP_Destination_ID");
                                if (!validLine3 && des_ID > 0 && idOrigen > 0) {
                                    X_TP_Destination tpDes2;
                                    String sqlMD = "SELECT MAX(cost) FROM TP_DestinationM WHERE TP_Destination_ID = ? AND TP_DestinationRef_ID = ? AND IsActive = 'Y'";
                                    costM = DB.getSQLValueBD(this.get_TrxName(), sqlMD, idOrigen, des_ID);
                                    if (costM != null) {
                                        line.set_CustomColumn("Cost", costM);
                                    }
                                    line.set_CustomColumn("KMAcu", kmAcu);
                                    line.set_CustomColumn("VolAcu", volAcu);
                                    if (line.getMovementQty().equals(Env.ZERO) | line.getMovementQty() == null) {
                                        line.setMovementQty(Env.ONE);
                                    }
                                    line.save();
                                    if (des_ID > 0 && (tpDes2 = new X_TP_Destination(this.getCtx(), des_ID, this.get_TrxName())).get_ValueAsBoolean("IsSource")) {
                                        idOrigen = des_ID;
                                    }
                                }
                            } else {
                                return "Linea sin rango de valores ingresados: Flota " + pro.getName() + " Hoja de Ruta(ID) " + move.get_ID() + " Linea(ID) " + line.get_ID();
                            }
                        }
                        if (CTC.equalsIgnoreCase("D")) {
                            String TP_TypeValue = "";
                            TP_DestinationRef_ID = 0;
                            X_TP_CostingValues cvalues3 = null;
                            boolean ISM3 = false;
                            boolean ISDN3 = false;
                            boolean ISValid = false;
                            validLine = false;
                            sqlTP_V = "SELECT MAX(TP_CostingValues_ID) FROM TP_CostingValues WHERE C_ProjectOFB_ID = ? AND TP_CostingType = 'D' AND Isactive = 'Y' AND TP_Destination_ID = ? AND (TP_Type = ?  OR TP_Type Is null)  ";
                            int CostingValues_ID3 = DB.getSQLValue(this.get_TrxName(), sqlTP_V, pro.get_ID(), line.get_ValueAsInt("TP_Destination_ID"), type);
                            if (CostingValues_ID3 > 0) {
                                cvalues3 = new X_TP_CostingValues(this.getCtx(), CostingValues_ID3, this.get_TrxName());
                                TP_TypeValue = cvalues3.getTP_TypeValue();
                                TP_DestinationRef_ID = cvalues3.get_ValueAsInt("TP_Destination_ID");
                                ISM3 = cvalues3.get_ValueAsBoolean("ExistM3");
                                ISDN3 = cvalues3.get_ValueAsBoolean("ExistDN");
                                ISValid = cvalues3.get_ValueAsBoolean("ValidDocument");
                            } else {
                                String sqlTP_Valid = "SELECT MAX(TP_CostingValues_ID) FROM TP_CostingValues WHERE C_ProjectOFB_ID = ? AND TP_CostingType = 'D' AND Isactive = 'Y' AND TP_Destination_ID > 0 ";
                                int CostingValuesValid_ID = DB.getSQLValue(this.get_TrxName(), sqlTP_Valid, pro.get_ID());
                                if (CostingValuesValid_ID <= 0) {
                                    return "No se Pueden setear parametros de validacion: Flota " + pro.getName() + " Hoja de Ruta(ID) " + move.get_ID() + " Linea(ID) " + line.get_ID();
                                }
                                cvalues3 = new X_TP_CostingValues(this.getCtx(), CostingValuesValid_ID, this.get_TrxName());
                                ISM3 = cvalues3.get_ValueAsBoolean("ExistM3");
                                ISDN3 = cvalues3.get_ValueAsBoolean("ExistDN");
                                ISValid = cvalues3.get_ValueAsBoolean("ValidDocument");
                                if (pro.get_ValueAsString("DefaultValue") == null) {
                                    validLine = true;
                                } else if (pro.get_ValueAsString("DefaultValue").equalsIgnoreCase("K")) {
                                    TP_TypeValue = "K";
                                    TP_DestinationRef_ID = 0;
                                } else if (pro.get_ValueAsString("DefaultValue").equalsIgnoreCase("V")) {
                                    TP_TypeValue = "V";
                                    TP_DestinationRef_ID = 0;
                                } else if (pro.get_ValueAsString("DefaultValue").equalsIgnoreCase("U")) {
                                    TP_TypeValue = "U";
                                    TP_DestinationRef_ID = 0;
                                } else if (pro.get_ValueAsString("DefaultValue").equalsIgnoreCase("F")) {
                                    TP_TypeValue = "F";
                                    TP_DestinationRef_ID = 0;
                                }
                            }
                            if (ISValid) {
                                String sqlValidDM = "SELECT  count(1) FROM M_MovementLine mml INNER JOIN M_Movement mm ON (mml.M_Movement_ID = mm.M_Movement_ID) WHERE C_ProjectOFB_ID = ? AND mml.POReference like ? AND M_MovementLine_ID <> ? and mml.cost > 0";
                                int cantSQL1 = DB.getSQLValue(this.get_TrxName(), sqlValidDM, move.get_ValueAsInt("C_ProjectOFB_ID"), line.get_ValueAsString("POReference"), line.get_ID());
                                if (cantSQL1 > 0) {
                                    validLine = true;
                                }
                            }
                            if (ISM3) {
                                String sqlExM3 = "SELECT count(1) FROM M_MovementLine mml INNER JOIN M_Movement mm ON (mml.M_Movement_ID = mm.M_Movement_ID) WHERE mm.M_Movement_ID = ? AND mml.TP_VolM3 > 0 ";
                                int cantSQL2 = DB.getSQLValue(this.get_TrxName(), sqlExM3, move.get_ID());
                                if (cantSQL2 == 0) {
                                    validLine = true;
                                }
                            }
                            if (ISDN3) {
                                String sqlExDN = "SELECT count(1) FROM M_MovementLine mml INNER JOIN M_Movement mm ON (mml.M_Movement_ID = mm.M_Movement_ID) WHERE mm.M_Movement_ID = ? AND mml.POReference IS NOT NULL ";
                                int cantSQL3 = DB.getSQLValue(this.get_TrxName(), sqlExDN, move.get_ID());
                                if (cantSQL3 == 0) {
                                    validLine = true;
                                }
                            }
                            boolean ValidNull = pro.get_ValueAsBoolean("ValidNull");
                            int TP_DesValid = line.get_ValueAsInt("TP_Destination_ID");
                            if (TP_DesValid < 1 & !ValidNull) {
                                validLine = true;
                            }
                            sqlTP_Cant = "SELECT COUNT(TP_CostingValues_ID) FROM TP_CostingValues WHERE C_ProjectOFB_ID = ? AND TP_CostingType = 'D' AND Isactive = 'Y' AND TP_Destination_ID = ? AND (TP_Type = ?  OR TP_Type Is null)";
                            cant = DB.getSQLValue(this.get_TrxName(), sqlTP_Cant, pro.get_ID(), line.get_ValueAsInt("TP_Destination_ID"), type);
                            if (cant > 1) {
                                SumCosto = new BigDecimal("0.0");
                                sqlCiclo = "SELECT TP_CostingValues_ID FROM TP_CostingValues WHERE C_ProjectOFB_ID = ? AND TP_CostingType = 'D' AND Isactive = 'Y' AND TP_Destination_ID = ? AND (TP_Type = ?  OR TP_Type Is null)";
                                try {
                                    CPreparedStatement pstmtC = null;
                                    pstmtC = DB.prepareStatement(sqlCiclo, this.get_TrxName());
                                    pstmtC.setInt(1, pro.get_ID());
                                    pstmtC.setInt(2, line.get_ValueAsInt("TP_Destination_ID"));
                                    pstmtC.setString(3, type);
                                    rsC = pstmtC.executeQuery();
                                    while (rsC.next()) {
                                        CVAlueIDC = new X_TP_CostingValues(this.getCtx(), rsC.getInt("TP_CostingValues_ID"), this.get_TrxName());
                                        if (CVAlueIDC.getTP_TypeValue().equalsIgnoreCase("F") && !validLine) {
                                            SumCosto = SumCosto.add(CVAlueIDC.getAmt());
                                            continue;
                                        }
                                        if (CVAlueIDC.getTP_TypeValue().equalsIgnoreCase("K") && !validLine) {
                                            kmnew2 = new BigDecimal("0.0");
                                            try {
                                                kmnew2 = (BigDecimal)CVAlueIDC.get_Value("MaxType");
                                                if (kmnew2 != null && kmHR.compareTo(kmnew2) > 0 && kmnew2.compareTo(Env.ZERO) > 0) {
                                                    kmHR = kmnew2;
                                                }
                                            }
                                            catch (Exception e) {
                                                this.log.log(Level.SEVERE, e.getMessage(), e);
                                            }
                                            if (CVAlueIDC.getAmt().compareTo(Env.ZERO) > 0) {
                                                SumCosto = SumCosto.add(kmHR.multiply(CVAlueIDC.getAmt()));
                                                continue;
                                            }
                                            sqlTP_KMC = "SELECT MAX(TP_CostingValues_ID) FROM TP_CostingValues WHERE C_ProjectOFB_ID = ? AND TP_CostingType = 'D' AND TP_TypeValue = 'K' AND MinQty <= ? AND MaxQty >= ? AND (TP_Type = ?  OR TP_Type Is null) AND Isactive = 'Y'";
                                            CostingValuesCicloK_ID = DB.getSQLValue(this.get_TrxName(), sqlTP_KMC, pro.get_ID(), kmAcu, kmAcu, type);
                                            if (CostingValuesCicloK_ID > 0) {
                                                CVAlueIDCK = new X_TP_CostingValues(this.getCtx(), CostingValuesCicloK_ID, this.get_TrxName());
                                                SumCosto = SumCosto.add(kmHR.multiply(CVAlueIDCK.getAmt()));
                                                continue;
                                            }
                                            return "SubLinea sin rango de valores ingresados: Flota " + pro.getName() + " Hoja de Ruta(ID) " + move.get_ID() + " Linea(ID) " + line.get_ID();
                                        }
                                        if (!CVAlueIDC.getTP_TypeValue().equalsIgnoreCase("V") || validLine) continue;
                                        volnew2 = new BigDecimal("0.0");
                                        try {
                                            volnew2 = (BigDecimal)CVAlueIDC.get_Value("MaxType");
                                            if (volnew2 != null && volHR.compareTo(volnew2) > 0 && volnew2.compareTo(Env.ZERO) > 0) {
                                                volHR = volnew2;
                                            }
                                        }
                                        catch (Exception e) {
                                            this.log.log(Level.SEVERE, e.getMessage(), e);
                                        }
                                        if (CVAlueIDC.getAmt().compareTo(Env.ZERO) > 0) {
                                            SumCosto = SumCosto.add(volHR.multiply(CVAlueIDC.getAmt()));
                                            continue;
                                        }
                                        sqlTP_KMC = "SELECT MAX(TP_CostingValues_ID) FROM TP_CostingValues WHERE C_ProjectOFB_ID = ? AND TP_CostingType = 'D' AND TP_TypeValue = 'V' AND MinQty <= ? AND MaxQty >= ? AND (TP_Type = ?  OR TP_Type Is null) AND Isactive = 'Y'";
                                        CostingValuesCicloK_ID = DB.getSQLValue(this.get_TrxName(), sqlTP_KMC, pro.get_ID(), volAcu, volAcu, type);
                                        if (CostingValuesCicloK_ID > 0) {
                                            CVAlueIDCK = new X_TP_CostingValues(this.getCtx(), CostingValuesCicloK_ID, this.get_TrxName());
                                            SumCosto = SumCosto.add(volHR.multiply(CVAlueIDCK.getAmt()));
                                            continue;
                                        }
                                        return "SubLinea sin rango de valores ingresados: Flota " + pro.getName() + " Hoja de Ruta(ID) " + move.get_ID() + " Linea(ID) " + line.get_ID();
                                    }
                                    if (!lineaunica) {
                                        line.set_CustomColumn("Cost", SumCosto);
                                    }
                                    line.set_CustomColumn("KMAcu", kmAcu);
                                    line.set_CustomColumn("VolAcu", volAcu);
                                    if (line.getMovementQty().equals(Env.ZERO) | line.getMovementQty() == null) {
                                        line.setMovementQty(Env.ONE);
                                    }
                                    line.save();
                                    rsC.close();
                                    pstmtC.close();
                                }
                                catch (Exception e) {
                                    this.log.log(Level.SEVERE, e.getMessage(), e);
                                }
                            } else {
                                if (TP_TypeValue.equalsIgnoreCase("F") && !validLine) {
                                    if (TP_DestinationRef_ID <= 0) {
                                        return "SubLinea sin rango de valores ingresados: Flota " + pro.getName() + " Hoja de Ruta(ID) " + move.get_ID() + " Linea(ID) " + line.get_ID();
                                    }
                                    costoTotal = cvalues3.getAmt();
                                    if (!lineaunica) {
                                        line.set_CustomColumn("Cost", costoTotal);
                                    }
                                    line.set_CustomColumn("KMAcu", kmAcu);
                                    line.set_CustomColumn("VolAcu", volAcu);
                                    if (line.getMovementQty().equals(Env.ZERO) | line.getMovementQty() == null) {
                                        line.setMovementQty(Env.ONE);
                                    }
                                    line.save();
                                }
                                if (TP_TypeValue.equalsIgnoreCase("U") && !validLine) {
                                    costoTotal = cvalues3.getAmt();
                                    if (!lineaunica) {
                                        line.set_CustomColumn("Cost", costoTotal);
                                    }
                                    line.set_CustomColumn("KMAcu", kmAcu);
                                    line.set_CustomColumn("VolAcu", volAcu);
                                    if (line.getMovementQty().equals(Env.ZERO) | line.getMovementQty() == null) {
                                        line.setMovementQty(Env.ONE);
                                    }
                                    line.save();
                                    lineaunica = true;
                                    sqlLN = "UPDATE M_MovementLine SET Cost=0 WHERE M_Movement_ID =" + line.getM_Movement_ID() + " AND M_MovementLine_ID <> " + line.getM_MovementLine_ID();
                                    DB.executeUpdate(sqlLN, this.get_TrxName());
                                } else if (TP_TypeValue.equalsIgnoreCase("K") && TP_DestinationRef_ID > 0 && !validLine) {
                                    kmnew = new BigDecimal("0.0");
                                    try {
                                        kmnew = (BigDecimal)cvalues3.get_Value("MaxType");
                                        if (kmnew != null && kmHR.compareTo(kmnew) > 0 && kmnew.compareTo(Env.ZERO) > 0) {
                                            kmHR = kmnew;
                                        }
                                    }
                                    catch (Exception e) {
                                        this.log.log(Level.SEVERE, e.getMessage(), e);
                                    }
                                    if (cvalues3.getAmt().compareTo(Env.ZERO) > 0) {
                                        costoTotal = kmHR.multiply(cvalues3.getAmt());
                                    } else {
                                        sqlTP_Vn2 = "SELECT MAX(TP_CostingValues_ID) FROM TP_CostingValues WHERE C_ProjectOFB_ID = ? AND TP_CostingType = 'D' AND TP_TypeValue = 'K' AND MinQty <= ? AND MaxQty >= ? AND TP_Type = ? AND Isactive = 'Y'";
                                        int CostingValuesN2_ID = DB.getSQLValue(this.get_TrxName(), sqlTP_Vn2, pro.get_ID(), kmAcu, kmAcu, type);
                                        if (CostingValuesN2_ID > 0) {
                                            cvaluesN2 = new X_TP_CostingValues(this.getCtx(), CostingValuesN2_ID, this.get_TrxName());
                                            costoTotal = kmHR.multiply(cvaluesN2.getAmt());
                                        } else {
                                            return "SubLinea sin rango de valores ingresados: Flota " + pro.getName() + " Hoja de Ruta(ID) " + move.get_ID() + " Linea(ID) " + line.get_ID();
                                        }
                                    }
                                    if (!lineaunica) {
                                        line.set_CustomColumn("Cost", costoTotal);
                                    }
                                    line.set_CustomColumn("KMAcu", kmAcu);
                                    line.set_CustomColumn("VolAcu", volAcu);
                                    if (line.getMovementQty().equals(Env.ZERO) | line.getMovementQty() == null) {
                                        line.setMovementQty(Env.ONE);
                                    }
                                    line.save();
                                } else if (TP_TypeValue.equalsIgnoreCase("K") && TP_DestinationRef_ID < 1 && !validLine) {
                                    kmnew = new BigDecimal("0.0");
                                    try {
                                        kmnew = (BigDecimal)cvalues3.get_Value("MaxType");
                                        if (kmnew != null && kmHR.compareTo(kmnew) > 0 && kmnew.compareTo(Env.ZERO) > 0) {
                                            kmHR = kmnew;
                                        }
                                    }
                                    catch (Exception e) {
                                        this.log.log(Level.SEVERE, e.getMessage(), e);
                                    }
                                    sqlTP_Vn2 = "SELECT MAX(TP_CostingValues_ID) FROM TP_CostingValues WHERE C_ProjectOFB_ID = ? AND TP_CostingType = 'D' AND TP_TypeValue = 'K' AND MinQty <= ? AND MaxQty >= ? AND TP_Type = ? AND Isactive = 'Y' ";
                                    int CostingValuesN2_ID = DB.getSQLValue(this.get_TrxName(), sqlTP_Vn2, pro.get_ID(), kmAcu, kmAcu, type);
                                    if (CostingValuesN2_ID <= 0) {
                                        return "SubLinea sin rango de valores ingresados: Flota " + pro.getName() + " Hoja de Ruta(ID) " + move.get_ID() + " Linea(ID) " + line.get_ID();
                                    }
                                    cvaluesN2 = new X_TP_CostingValues(this.getCtx(), CostingValuesN2_ID, this.get_TrxName());
                                    costoTotal = kmHR.multiply(cvaluesN2.getAmt());
                                    if (!lineaunica) {
                                        line.set_CustomColumn("Cost", costoTotal);
                                    }
                                    line.set_CustomColumn("KMAcu", kmAcu);
                                    line.set_CustomColumn("VolAcu", volAcu);
                                    if (line.getMovementQty().equals(Env.ZERO) | line.getMovementQty() == null) {
                                        line.setMovementQty(Env.ONE);
                                    }
                                    line.save();
                                } else if (TP_TypeValue.equalsIgnoreCase("V") && !validLine) {
                                    volnew = new BigDecimal("0.0");
                                    try {
                                        volnew = (BigDecimal)cvalues3.get_Value("MaxType");
                                        if (volnew != null && volHR.compareTo(volnew) > 0 && volnew.compareTo(Env.ZERO) > 0) {
                                            volHR = volnew;
                                        }
                                    }
                                    catch (Exception e) {
                                        this.log.log(Level.SEVERE, e.getMessage(), e);
                                    }
                                    if (cvalues3.getAmt().compareTo(Env.ZERO) > 0) {
                                        costoTotal = volHR.multiply(cvalues3.getAmt());
                                    } else {
                                        sqlTP_Vn2 = "SELECT MAX(TP_CostingValues_ID) FROM TP_CostingValues WHERE C_ProjectOFB_ID = ? AND TP_CostingType = 'D' AND TP_TypeValue = 'V' AND MinQty <= ? AND MaxQty >= ? AND TP_Type = ? AND Isactive = 'Y'";
                                        int CostingValuesN2_ID = DB.getSQLValue(this.get_TrxName(), sqlTP_Vn2, pro.get_ID(), volAcu, volAcu, type);
                                        if (CostingValuesN2_ID > 0) {
                                            cvaluesN2 = new X_TP_CostingValues(this.getCtx(), CostingValuesN2_ID, this.get_TrxName());
                                            costoTotal = volHR.multiply(cvaluesN2.getAmt());
                                        } else {
                                            return "SubLinea sin rango de valores ingresados: Flota " + pro.getName() + " Hoja de Ruta(ID) " + move.get_ID() + " Linea(ID) " + line.get_ID();
                                        }
                                    }
                                    if (!lineaunica) {
                                        line.set_CustomColumn("Cost", costoTotal);
                                    }
                                    line.set_CustomColumn("KMAcu", kmAcu);
                                    line.set_CustomColumn("VolAcu", volAcu);
                                    if (line.getMovementQty().equals(Env.ZERO) | line.getMovementQty() == null) {
                                        line.setMovementQty(Env.ONE);
                                    }
                                    line.save();
                                }
                            }
                        }
                        if (CTC.equalsIgnoreCase("P")) {
                            X_TP_Destination tpDes2;
                            String TP_TypeValue = "";
                            TP_DestinationRef_ID = 0;
                            X_TP_CostingValues cvalues4 = null;
                            boolean ISM3 = false;
                            boolean ISDN4 = false;
                            boolean ISValid = false;
                            validLine = false;
                            sqlTP_V = "SELECT MAX(TP_CostingValues_ID) FROM TP_CostingValues WHERE C_ProjectOFB_ID = ? AND TP_CostingType = 'P' AND Isactive = 'Y' AND TP_Destination_ID = ? AND TP_DestinationRef_ID = ? AND (TP_Type = ?  OR TP_Type Is null)  ";
                            int CostingValues_ID4 = DB.getSQLValue(this.get_TrxName(), sqlTP_V, pro.get_ID(), line.get_ValueAsInt("TP_Destination_ID"), String.valueOf(idOrigen), type);
                            if (CostingValues_ID4 > 0) {
                                cvalues4 = new X_TP_CostingValues(this.getCtx(), CostingValues_ID4, this.get_TrxName());
                                TP_TypeValue = cvalues4.getTP_TypeValue();
                                TP_DestinationRef_ID = cvalues4.get_ValueAsInt("TP_Destination_ID");
                                ISM3 = cvalues4.get_ValueAsBoolean("ExistM3");
                                ISDN4 = cvalues4.get_ValueAsBoolean("ExistDN");
                                ISValid = cvalues4.get_ValueAsBoolean("ValidDocument");
                            } else {
                                String sqlTP_Valid = "SELECT MAX(TP_CostingValues_ID) FROM TP_CostingValues WHERE C_ProjectOFB_ID = ? AND TP_CostingType = 'P' AND Isactive = 'Y' AND TP_Destination_ID > 0 ";
                                int CostingValuesValid_ID = DB.getSQLValue(this.get_TrxName(), sqlTP_Valid, pro.get_ID());
                                if (CostingValuesValid_ID > 0) {
                                    cvalues4 = new X_TP_CostingValues(this.getCtx(), CostingValuesValid_ID, this.get_TrxName());
                                    ISM3 = cvalues4.get_ValueAsBoolean("ExistM3");
                                    ISDN4 = cvalues4.get_ValueAsBoolean("ExistDN");
                                    ISValid = cvalues4.get_ValueAsBoolean("ValidDocument");
                                } else {
                                    return "No se Pueden setear parametros de validacion: Flota " + pro.getName() + " Hoja de Ruta(ID) " + move.get_ID() + " Linea(ID) " + line.get_ID();
                                }
                            }
                            if (ISValid) {
                                String sqlValidDM = "SELECT  count(1) FROM M_MovementLine mml INNER JOIN M_Movement mm ON (mml.M_Movement_ID = mm.M_Movement_ID) WHERE C_ProjectOFB_ID = ? AND mml.POReference like ? AND M_MovementLine_ID <> ? and mml.cost > 0";
                                int cantSQL1 = DB.getSQLValue(this.get_TrxName(), sqlValidDM, move.get_ValueAsInt("C_ProjectOFB_ID"), line.get_ValueAsString("POReference"), line.get_ID());
                                if (cantSQL1 > 0) {
                                    validLine = true;
                                }
                            }
                            if (ISM3) {
                                String sqlExM3 = "SELECT count(1) FROM M_MovementLine mml INNER JOIN M_Movement mm ON (mml.M_Movement_ID = mm.M_Movement_ID) WHERE mm.M_Movement_ID = ? AND mml.TP_VolM3 > 0 ";
                                int cantSQL2 = DB.getSQLValue(this.get_TrxName(), sqlExM3, move.get_ID());
                                if (cantSQL2 == 0) {
                                    validLine = true;
                                }
                            }
                            if (ISDN4) {
                                String sqlExDN = "SELECT count(1) FROM M_MovementLine mml INNER JOIN M_Movement mm ON (mml.M_Movement_ID = mm.M_Movement_ID) WHERE mm.M_Movement_ID = ? AND mml.POReference IS NOT NULL ";
                                int cantSQL3 = DB.getSQLValue(this.get_TrxName(), sqlExDN, move.get_ID());
                                if (cantSQL3 == 0) {
                                    validLine = true;
                                }
                            }
                            boolean ValidNull = pro.get_ValueAsBoolean("ValidNull");
                            int TP_DesValid = line.get_ValueAsInt("TP_Destination_ID");
                            if (TP_DesValid < 1 & !ValidNull) {
                                validLine = true;
                            }
                            sqlTP_Cant = "SELECT COUNT(TP_CostingValues_ID) FROM TP_CostingValues WHERE C_ProjectOFB_ID = ? AND TP_CostingType = 'P' AND Isactive = 'Y' AND TP_Destination_ID = ? AND TP_DestinationRef_ID = ?AND (TP_Type = ?  OR TP_Type Is null)";
                            cant = DB.getSQLValue(this.get_TrxName(), sqlTP_Cant, pro.get_ID(), line.get_ValueAsInt("TP_Destination_ID"), String.valueOf(idOrigen), type);
                            if (cant > 1) {
                                SumCosto = new BigDecimal("0.0");
                                sqlCiclo = "SELECT TP_CostingValues_ID FROM TP_CostingValues WHERE C_ProjectOFB_ID = ? AND TP_CostingType = 'P' AND Isactive = 'Y' AND TP_Destination_ID = ? AND TP_DestinationRef_ID = ? AND (TP_Type = ?  OR TP_Type Is null)";
                                try {
                                    CPreparedStatement pstmtC = null;
                                    pstmtC = DB.prepareStatement(sqlCiclo, this.get_TrxName());
                                    pstmtC.setInt(1, pro.get_ID());
                                    pstmtC.setInt(2, line.get_ValueAsInt("TP_Destination_ID"));
                                    pstmtC.setString(3, String.valueOf(idOrigen));
                                    pstmtC.setString(4, type);
                                    rsC = pstmtC.executeQuery();
                                    while (rsC.next()) {
                                        CVAlueIDC = new X_TP_CostingValues(this.getCtx(), rsC.getInt("TP_CostingValues_ID"), this.get_TrxName());
                                        if (CVAlueIDC.getTP_TypeValue().equalsIgnoreCase("F") && !validLine) {
                                            SumCosto = SumCosto.add(CVAlueIDC.getAmt());
                                            continue;
                                        }
                                        if (CVAlueIDC.getTP_TypeValue().equalsIgnoreCase("K") && !validLine) {
                                            kmnew2 = new BigDecimal("0.0");
                                            try {
                                                kmnew2 = (BigDecimal)CVAlueIDC.get_Value("MaxType");
                                                if (kmnew2 != null && kmHR.compareTo(kmnew2) > 0 && kmnew2.compareTo(Env.ZERO) > 0) {
                                                    kmHR = kmnew2;
                                                }
                                            }
                                            catch (Exception e) {
                                                this.log.log(Level.SEVERE, e.getMessage(), e);
                                            }
                                            if (CVAlueIDC.getAmt().compareTo(Env.ZERO) > 0) {
                                                SumCosto = SumCosto.add(kmHR.multiply(CVAlueIDC.getAmt()));
                                                continue;
                                            }
                                            sqlTP_KMC = "SELECT MAX(TP_CostingValues_ID) FROM TP_CostingValues WHERE C_ProjectOFB_ID = ? AND TP_CostingType = 'P' AND TP_TypeValue = 'K' AND MinQty <= ? AND MaxQty >= ? AND (TP_Type = ?  OR TP_Type Is null) AND Isactive = 'Y'";
                                            CostingValuesCicloK_ID = DB.getSQLValue(this.get_TrxName(), sqlTP_KMC, pro.get_ID(), kmAcu, kmAcu, type);
                                            if (CostingValuesCicloK_ID > 0) {
                                                CVAlueIDCK = new X_TP_CostingValues(this.getCtx(), CostingValuesCicloK_ID, this.get_TrxName());
                                                SumCosto = SumCosto.add(kmHR.multiply(CVAlueIDCK.getAmt()));
                                                continue;
                                            }
                                            return "SubLinea sin rango de valores ingresados: Flota " + pro.getName() + " Hoja de Ruta(ID) " + move.get_ID() + " Linea(ID) " + line.get_ID();
                                        }
                                        if (!CVAlueIDC.getTP_TypeValue().equalsIgnoreCase("V") || validLine) continue;
                                        volnew2 = new BigDecimal("0.0");
                                        try {
                                            volnew2 = (BigDecimal)CVAlueIDC.get_Value("MaxType");
                                            if (volnew2 != null && volHR.compareTo(volnew2) > 0 && volnew2.compareTo(Env.ZERO) > 0) {
                                                volHR = volnew2;
                                            }
                                        }
                                        catch (Exception e) {
                                            this.log.log(Level.SEVERE, e.getMessage(), e);
                                        }
                                        if (CVAlueIDC.getAmt().compareTo(Env.ZERO) > 0) {
                                            SumCosto = SumCosto.add(kmHR.multiply(CVAlueIDC.getAmt()));
                                            continue;
                                        }
                                        sqlTP_KMC = "SELECT MAX(TP_CostingValues_ID) FROM TP_CostingValues WHERE C_ProjectOFB_ID = ? AND TP_CostingType = 'D' AND TP_TypeValue = 'V' AND MinQty <= ? AND MaxQty >= ? AND (TP_Type = ?  OR TP_Type Is null) AND Isactive = 'Y'";
                                        CostingValuesCicloK_ID = DB.getSQLValue(this.get_TrxName(), sqlTP_KMC, pro.get_ID(), volAcu, volAcu, type);
                                        if (CostingValuesCicloK_ID > 0) {
                                            CVAlueIDCK = new X_TP_CostingValues(this.getCtx(), CostingValuesCicloK_ID, this.get_TrxName());
                                            SumCosto = SumCosto.add(kmHR.multiply(CVAlueIDCK.getAmt()));
                                            continue;
                                        }
                                        return "SubLinea sin rango de valores ingresados: Flota " + pro.getName() + " Hoja de Ruta(ID) " + move.get_ID() + " Linea(ID) " + line.get_ID();
                                    }
                                    if (!lineaunica) {
                                        line.set_CustomColumn("Cost", SumCosto);
                                    }
                                    line.set_CustomColumn("KMAcu", kmAcu);
                                    line.set_CustomColumn("VolAcu", volAcu);
                                    if (line.getMovementQty().equals(Env.ZERO) | line.getMovementQty() == null) {
                                        line.setMovementQty(Env.ONE);
                                    }
                                    line.save();
                                    rsC.close();
                                    pstmtC.close();
                                }
                                catch (Exception e) {
                                    this.log.log(Level.SEVERE, e.getMessage(), e);
                                }
                            } else {
                                if (TP_TypeValue.equalsIgnoreCase("F") && !validLine) {
                                    if (TP_DestinationRef_ID <= 0) {
                                        return "SubLinea sin rango de valores ingresados: Flota " + pro.getName() + " Hoja de Ruta(ID) " + move.get_ID() + " Linea(ID) " + line.get_ID();
                                    }
                                    costoTotal = cvalues4.getAmt();
                                    if (!lineaunica) {
                                        line.set_CustomColumn("Cost", costoTotal);
                                    }
                                    line.set_CustomColumn("KMAcu", kmAcu);
                                    line.set_CustomColumn("VolAcu", volAcu);
                                    if (line.getMovementQty().equals(Env.ZERO) | line.getMovementQty() == null) {
                                        line.setMovementQty(Env.ONE);
                                    }
                                    line.save();
                                }
                                if (TP_TypeValue.equalsIgnoreCase("U") && !validLine) {
                                    costoTotal = cvalues4.getAmt();
                                    if (!lineaunica) {
                                        line.set_CustomColumn("Cost", costoTotal);
                                    }
                                    line.set_CustomColumn("KMAcu", kmAcu);
                                    line.set_CustomColumn("VolAcu", volAcu);
                                    if (line.getMovementQty().equals(Env.ZERO) | line.getMovementQty() == null) {
                                        line.setMovementQty(Env.ONE);
                                    }
                                    line.save();
                                    lineaunica = true;
                                    sqlLN = "UPDATE M_MovementLine SET Cost=0 WHERE M_Movement_ID =" + line.getM_Movement_ID() + " AND M_MovementLine_ID <> " + line.getM_MovementLine_ID();
                                    DB.executeUpdate(sqlLN, this.get_TrxName());
                                } else if (TP_TypeValue.equalsIgnoreCase("K") && TP_DestinationRef_ID > 0 && !validLine) {
                                    kmnew = new BigDecimal("0.0");
                                    try {
                                        kmnew = (BigDecimal)cvalues4.get_Value("MaxType");
                                        if (kmnew != null && kmHR.compareTo(kmnew) > 0 && kmnew.compareTo(Env.ZERO) > 0) {
                                            kmHR = kmnew;
                                        }
                                    }
                                    catch (Exception e) {
                                        this.log.log(Level.SEVERE, e.getMessage(), e);
                                    }
                                    if (cvalues4.getAmt().compareTo(Env.ZERO) > 0) {
                                        costoTotal = kmHR.multiply(cvalues4.getAmt());
                                    } else {
                                        sqlTP_Vn2 = "SELECT MAX(TP_CostingValues_ID) FROM TP_CostingValues WHERE C_ProjectOFB_ID = ? AND TP_CostingType = 'D' AND TP_TypeValue = 'K' AND MinQty <= ? AND MaxQty >= ? AND TP_Type = ? AND Isactive = 'Y'";
                                        int CostingValuesN2_ID = DB.getSQLValue(this.get_TrxName(), sqlTP_Vn2, pro.get_ID(), kmAcu, kmAcu, type);
                                        if (CostingValuesN2_ID > 0) {
                                            cvaluesN2 = new X_TP_CostingValues(this.getCtx(), CostingValuesN2_ID, this.get_TrxName());
                                            costoTotal = kmHR.multiply(cvaluesN2.getAmt());
                                        } else {
                                            return "SubLinea sin rango de valores ingresados: Flota " + pro.getName() + " Hoja de Ruta(ID) " + move.get_ID() + " Linea(ID) " + line.get_ID();
                                        }
                                    }
                                    if (!lineaunica) {
                                        line.set_CustomColumn("Cost", costoTotal);
                                    }
                                    line.set_CustomColumn("KMAcu", kmAcu);
                                    line.set_CustomColumn("VolAcu", volAcu);
                                    if (line.getMovementQty().equals(Env.ZERO) | line.getMovementQty() == null) {
                                        line.setMovementQty(Env.ONE);
                                    }
                                    line.save();
                                } else if (TP_TypeValue.equalsIgnoreCase("V") && !validLine) {
                                    volnew = new BigDecimal("0.0");
                                    try {
                                        volnew = (BigDecimal)cvalues4.get_Value("MaxType");
                                        if (volnew != null && volHR.compareTo(volnew) > 0 && volnew.compareTo(Env.ZERO) > 0) {
                                            volHR = volnew;
                                        }
                                    }
                                    catch (Exception e) {
                                        this.log.log(Level.SEVERE, e.getMessage(), e);
                                    }
                                    if (cvalues4.getAmt().compareTo(Env.ZERO) > 0) {
                                        costoTotal = volHR.multiply(cvalues4.getAmt());
                                    } else {
                                        sqlTP_Vn2 = "SELECT MAX(TP_CostingValues_ID) FROM TP_CostingValues WHERE C_ProjectOFB_ID = ? AND TP_CostingType = 'D' AND TP_TypeValue = 'V' AND MinQty <= ? AND MaxQty >= ? AND TP_Type = ? AND Isactive = 'Y'";
                                        int CostingValuesN2_ID = DB.getSQLValue(this.get_TrxName(), sqlTP_Vn2, pro.get_ID(), volAcu, volAcu, type);
                                        if (CostingValuesN2_ID > 0) {
                                            cvaluesN2 = new X_TP_CostingValues(this.getCtx(), CostingValuesN2_ID, this.get_TrxName());
                                            costoTotal = volHR.multiply(cvaluesN2.getAmt());
                                        } else {
                                            return "SubLinea sin rango de valores ingresados: Flota " + pro.getName() + " Hoja de Ruta(ID) " + move.get_ID() + " Linea(ID) " + line.get_ID();
                                        }
                                    }
                                    if (!lineaunica) {
                                        line.set_CustomColumn("Cost", costoTotal);
                                    }
                                    line.set_CustomColumn("KMAcu", kmAcu);
                                    line.set_CustomColumn("VolAcu", volAcu);
                                    if (line.getMovementQty().equals(Env.ZERO) | line.getMovementQty() == null) {
                                        line.setMovementQty(Env.ONE);
                                    }
                                    line.save();
                                }
                            }
                            if (line.get_ValueAsInt("TP_Destination_ID") > 0 && (tpDes2 = new X_TP_Destination(this.getCtx(), line.get_ValueAsInt("TP_Destination_ID"), this.get_TrxName())).get_ValueAsBoolean("IsSource")) {
                                idOrigen = line.get_ValueAsInt("TP_Destination_ID");
                            }
                        }
                    }
                    ++i;
                }
                move.set_CustomColumn("Costed", true);
                move.save();
                ++contador;
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return "Se han costeado " + contador + " Hojas de Ruta";
    }
}

