/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCity;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrg;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MTax;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Client;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_M_InOut;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.ofb.process.ExportDTEInvoiceCG;
import org.ofb.process.ExportDTEInvoiceCGBaskakow;
import org.ofb.process.ExportDTEInvoiceCGGemV2;
import org.ofb.process.ExportDTEInvoiceCGProvectis;
import org.ofb.process.ExportDTEInvoiceFOL;
import org.ofb.process.ExportDTEInvoiceFOLCGGem;
import org.ofb.process.ExportDTEInvoiceFOLNGem;
import org.ofb.process.ExportDTEInvoiceFOLPA;
import org.ofb.process.ExportDTEInvoiceFOLQDC;
import org.ofb.process.ExportDTEInvoiceITSA;
import org.ofb.process.ExportDTEInvoiceNBaskakow;
import org.ofb.process.ExportDTEInvoiceNGem;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ModelXMLInvoice
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelXMLInvoice.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Invoice", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MInvoice.Table_ID) {
            MInvoice inv = (MInvoice)po;
            X_AD_Client client = new X_AD_Client(po.getCtx(), inv.getAD_Client_ID(), po.get_TrxName());
            String DTEType2 = "";
            try {
                DTEType2 = client.get_ValueAsString("invoiceDTEType");
            }
            catch (Exception e) {
                DTEType2 = "";
                log.log(Level.SEVERE, "No se pudo setear variable invoiceDTEType", e);
            }
            try {
                if (DTEType2.compareToIgnoreCase("N") == 0) {
                    this.CreateXML(inv);
                } else if (DTEType2.compareToIgnoreCase("CGN") == 0) {
                    ExportDTEInvoiceCG cg = new ExportDTEInvoiceCG();
                    cg.CreateXMLCG(inv);
                } else if (DTEType2.compareToIgnoreCase("NGEM") == 0) {
                    ExportDTEInvoiceNGem cg = new ExportDTEInvoiceNGem();
                    cg.CreateXML(inv);
                } else if (DTEType2.compareToIgnoreCase("CGGEM") == 0) {
                    ExportDTEInvoiceCGGemV2 cg = new ExportDTEInvoiceCGGemV2();
                    cg.CreateXML(inv);
                } else if (DTEType2.compareToIgnoreCase("CGPRO") == 0) {
                    ExportDTEInvoiceCGProvectis cg = new ExportDTEInvoiceCGProvectis();
                    cg.CreateXMLCG(inv);
                } else if (DTEType2.compareToIgnoreCase("NBK") == 0) {
                    ExportDTEInvoiceNBaskakow cg = new ExportDTEInvoiceNBaskakow();
                    cg.CreateXML(inv);
                } else if (DTEType2.compareToIgnoreCase("CGBK") == 0) {
                    ExportDTEInvoiceCGBaskakow cg = new ExportDTEInvoiceCGBaskakow();
                    cg.CreateXMLCG(inv);
                } else if (DTEType2.compareToIgnoreCase("FELQDC") == 0) {
                    ExportDTEInvoiceFOLQDC cg = new ExportDTEInvoiceFOLQDC();
                    if (inv.getC_DocTypeTarget().getName().toLowerCase().contains("boleta")) {
                        cg.CreateXMLCGBoleta(inv);
                    } else {
                        cg.CreateXMLCG(inv);
                    }
                } else if (DTEType2.compareToIgnoreCase("FELNG") == 0) {
                    ExportDTEInvoiceFOLNGem cg = new ExportDTEInvoiceFOLNGem();
                    cg.CreateXMLCG(inv);
                } else if (DTEType2.compareToIgnoreCase("FELCGG") == 0) {
                    ExportDTEInvoiceFOLCGGem cg = new ExportDTEInvoiceFOLCGGem();
                    cg.CreateXMLCG(inv);
                } else if (DTEType2.compareToIgnoreCase("ITSA") == 0) {
                    ExportDTEInvoiceITSA cg = new ExportDTEInvoiceITSA();
                    cg.CreateXMLCGITSA(inv);
                } else if (DTEType2.compareToIgnoreCase("FELN") == 0) {
                    ExportDTEInvoiceFOL cg = new ExportDTEInvoiceFOL();
                    if (inv.getC_DocTypeTarget().getName().toLowerCase().contains("boleta")) {
                        cg.CreateXMLCGBoleta(inv);
                    } else {
                        cg.CreateXMLCG(inv);
                    }
                } else if (DTEType2.compareToIgnoreCase("FELPA") == 0) {
                    ExportDTEInvoiceFOLPA cg = new ExportDTEInvoiceFOLPA();
                    if (inv.getC_DocTypeTarget().getName().toLowerCase().contains("boleta")) {
                        cg.CreateXMLBoleta(inv);
                    } else {
                        cg.CreateXML(inv);
                    }
                }
            }
            catch (Exception e) {
                log.config("Error al tratar de generar xml: " + e.toString());
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }

    public String CreateXML(MInvoice inv) {
        MDocType doc = new MDocType(inv.getCtx(), inv.getC_DocTypeTarget_ID(), inv.get_TrxName());
        if (doc.get_Value("CreateXML") == null) {
            return "";
        }
        if (!((Boolean)doc.get_Value("CreateXML")).booleanValue()) {
            return "";
        }
        int typeDoc = Integer.parseInt((String)doc.get_Value("DocumentNo"));
        if (typeDoc == 0) {
            return "";
        }
        String mylog = new String();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            PO refdoc;
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation implementation = builder.getDOMImplementation();
            Document document = implementation.createDocument(null, "DTE", null);
            document.setXmlVersion("1.0");
            Element Documento2 = document.createElement("Documento");
            document.getDocumentElement().appendChild(Documento2);
            Documento2.setAttribute("ID", "DTE-" + inv.getDocumentNo());
            Element Encabezado2 = document.createElement("Encabezado");
            Documento2.appendChild(Encabezado2);
            Element IdDoc2 = document.createElement("IdDoc");
            Encabezado2.appendChild(IdDoc2);
            mylog = "IdDoc";
            Element TipoDTE = document.createElement("TipoDTE");
            Text text = document.createTextNode(Integer.toString(typeDoc));
            TipoDTE.appendChild(text);
            IdDoc2.appendChild(TipoDTE);
            Element Folio = document.createElement("Folio");
            Text fo = document.createTextNode(inv.getDocumentNo());
            Folio.appendChild(fo);
            IdDoc2.appendChild(Folio);
            Element FchEmis = document.createElement("FchEmis");
            Text emis = document.createTextNode(inv.getDateInvoiced().toString().substring(0, 10));
            FchEmis.appendChild(emis);
            IdDoc2.appendChild(FchEmis);
            Element FchCancel = document.createElement("FchCancel");
            Text cancel = document.createTextNode(inv.getDateInvoiced().toString().substring(0, 10));
            FchCancel.appendChild(cancel);
            IdDoc2.appendChild(FchCancel);
            Element FchVenc = document.createElement("FchVenc");
            Text venc = document.createTextNode(inv.getDateInvoiced().toString().substring(0, 10));
            FchVenc.appendChild(venc);
            IdDoc2.appendChild(FchVenc);
            MPaymentTerm pterm = new MPaymentTerm(inv.getCtx(), inv.getC_PaymentTerm_ID(), inv.get_TrxName());
            Element PayTerm = document.createElement("PayTerm");
            Text term = document.createTextNode(pterm.getName());
            PayTerm.appendChild(term);
            IdDoc2.appendChild(PayTerm);
            MUser salesUser = new MUser(inv.getCtx(), inv.getSalesRep_ID(), inv.get_TrxName());
            Element SalesRep = document.createElement("SalesRep");
            Text sales = document.createTextNode(salesUser.getName());
            SalesRep.appendChild(sales);
            IdDoc2.appendChild(SalesRep);
            Element HDescription = document.createElement("HeaderDescription");
            Text Hdesc = document.createTextNode(inv.getDescription() == null ? " " : inv.getDescription());
            HDescription.appendChild(Hdesc);
            IdDoc2.appendChild(HDescription);
            Element Emisor2 = document.createElement("Emisor");
            Encabezado2.appendChild(Emisor2);
            mylog = "Emisor";
            MOrg company = MOrg.get(inv.getCtx(), inv.getAD_Org_ID());
            Element Rut = document.createElement("RUTEmisor");
            Text rut = document.createTextNode((String)company.get_Value("Rut"));
            Rut.appendChild(rut);
            Emisor2.appendChild(Rut);
            String nameRzn = company.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = company.getName();
            }
            Element RznSoc = document.createElement("RznSoc");
            Text rzn = document.createTextNode(nameRzn);
            RznSoc.appendChild(rzn);
            Emisor2.appendChild(RznSoc);
            Element GiroEmis = document.createElement("GiroEmis");
            Text gi = document.createTextNode((String)company.get_Value("Giro"));
            GiroEmis.appendChild(gi);
            Emisor2.appendChild(GiroEmis);
            Element Acteco = document.createElement("Acteco");
            Text teco = document.createTextNode((String)company.get_Value("Acteco"));
            Acteco.appendChild(teco);
            Emisor2.appendChild(Acteco);
            Element DirOrigen = document.createElement("DirOrigen");
            Text dir = document.createTextNode((String)company.get_Value("Address1"));
            DirOrigen.appendChild(dir);
            Emisor2.appendChild(DirOrigen);
            Element CmnaOrigen = document.createElement("CmnaOrigen");
            Text com = document.createTextNode((String)company.get_Value("Comuna"));
            CmnaOrigen.appendChild(com);
            Emisor2.appendChild(CmnaOrigen);
            Element CiudadOrigen = document.createElement("CiudadOrigen");
            Text city = document.createTextNode((String)company.get_Value("City"));
            CiudadOrigen.appendChild(city);
            Emisor2.appendChild(CiudadOrigen);
            mylog = "receptor";
            MBPartner BP = new MBPartner(inv.getCtx(), inv.getC_BPartner_ID(), inv.get_TrxName());
            MBPartnerLocation bloc = new MBPartnerLocation(inv.getCtx(), inv.getC_BPartner_Location_ID(), inv.get_TrxName());
            Element Receptor2 = document.createElement("Receptor");
            Encabezado2.appendChild(Receptor2);
            Element RUTRecep = document.createElement("RUTRecep");
            Text rutc = document.createTextNode(BP.getValue() + "-" + BP.get_ValueAsString("Digito"));
            RUTRecep.appendChild(rutc);
            Receptor2.appendChild(RUTRecep);
            Element RznSocRecep = document.createElement("RznSocRecep");
            Text RznSocR = document.createTextNode(BP.getName());
            RznSocRecep.appendChild(RznSocR);
            Receptor2.appendChild(RznSocRecep);
            Element GiroRecep = document.createElement("GiroRecep");
            Text giro = document.createTextNode((String)BP.get_Value("Giro"));
            GiroRecep.appendChild(giro);
            Receptor2.appendChild(GiroRecep);
            Element ContactoRecep = document.createElement("Contacto");
            Text contacto = document.createTextNode(inv.getAD_User_ID() > 0 ? inv.getAD_User().getName() : " ");
            ContactoRecep.appendChild(contacto);
            Receptor2.appendChild(ContactoRecep);
            Element CorreoRecep = document.createElement("CorreoRecep");
            Text corrRecep = document.createTextNode(inv.getAD_User().getEMail() == null ? " " : inv.getAD_User().getEMail());
            CorreoRecep.appendChild(corrRecep);
            Receptor2.appendChild(CorreoRecep);
            Element DirRecep = document.createElement("DirRecep");
            Text dirr = document.createTextNode(bloc.getLocation(true).getAddress1());
            DirRecep.appendChild(dirr);
            Receptor2.appendChild(DirRecep);
            if (bloc.getLocation(true).getAddress2() != null && bloc.getLocation(true).getAddress2().length() > 0) {
                Element CmnaRecep = document.createElement("CmnaRecep");
                Text Cmna = document.createTextNode(bloc.getLocation(true).getAddress2());
                CmnaRecep.appendChild(Cmna);
                Receptor2.appendChild(CmnaRecep);
            }
            Element CiudadRecep = document.createElement("CiudadRecep");
            Text reg = document.createTextNode(bloc.getLocation(true).getC_City_ID() > 0 ? MCity.get(inv.getCtx(), bloc.getLocation(true).getC_City_ID()).getName() : "Santiago");
            CiudadRecep.appendChild(reg);
            Receptor2.appendChild(CiudadRecep);
            mylog = "Totales";
            Element Totales2 = document.createElement("Totales");
            Encabezado2.appendChild(Totales2);
            BigDecimal amountex = DB.getSQLValueBD(inv.get_TrxName(), "select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='Y' and il.C_Invoice_ID=" + inv.getC_Invoice_ID(), new Object[0]);
            BigDecimal amountNeto = DB.getSQLValueBD(inv.get_TrxName(), "select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='N' and il.C_Invoice_ID=" + inv.getC_Invoice_ID(), new Object[0]);
            Element MntNeto = document.createElement("MntNeto");
            Text neto = document.createTextNode(amountNeto != null ? amountNeto.toString() : "0");
            MntNeto.appendChild(neto);
            Totales2.appendChild(MntNeto);
            Element MntExe = document.createElement("MntExe");
            Text exe = document.createTextNode(amountex != null ? amountex.toString() : "0");
            MntExe.appendChild(exe);
            Totales2.appendChild(MntExe);
            if (amountNeto.signum() > 0) {
                Element TasaIVA = document.createElement("TasaIVA");
                Text tiva = document.createTextNode("19");
                TasaIVA.appendChild(tiva);
                Totales2.appendChild(TasaIVA);
            }
            Element IVA = document.createElement("IVA");
            BigDecimal ivaamt = Env.ZERO;
            if (amountex.intValue() != inv.getGrandTotal().intValue()) {
                ivaamt = inv.getGrandTotal().subtract(inv.getTotalLines()).setScale(0, 4);
            }
            Text iva = document.createTextNode(ivaamt.toString());
            IVA.appendChild(iva);
            Totales2.appendChild(IVA);
            Element MntTotal = document.createElement("MntTotal");
            Text total = document.createTextNode(inv.getGrandTotal().setScale(0, 4).toString());
            MntTotal.appendChild(total);
            Totales2.appendChild(MntTotal);
            mylog = "detalle";
            MInvoiceLine[] iLines = inv.getLines(false);
            int i = 0;
            while (i < iLines.length) {
                MInvoiceLine iLine = iLines[i];
                if (iLine.getM_Product_ID() != 0 || iLine.getC_Charge_ID() != 0) {
                    Element Detalle2 = document.createElement("Detalle");
                    Documento2.appendChild(Detalle2);
                    MTax tax = new MTax(inv.getCtx(), iLine.getC_Tax_ID(), inv.get_TrxName());
                    if (tax.isTaxExempt()) {
                        Element IndEx = document.createElement("IndExe");
                        Text lineE = document.createTextNode("1");
                        IndEx.appendChild(lineE);
                        Detalle2.appendChild(IndEx);
                    }
                    Element NroLinDet = document.createElement("NroLinDet");
                    Text line = document.createTextNode(Integer.toString(iLine.getLine() / 10));
                    NroLinDet.appendChild(line);
                    Detalle2.appendChild(NroLinDet);
                    Element NmbItem = document.createElement("NmbItem");
                    String pname = "";
                    pname = iLine.getProduct() != null ? iLine.getProduct().getName() : iLine.getC_Charge().getName();
                    Text Item = document.createTextNode(pname);
                    NmbItem.appendChild(Item);
                    Detalle2.appendChild(NmbItem);
                    Element DscItem = document.createElement("DscItem");
                    Text desc = document.createTextNode(iLine.getDescription() == null ? " " : iLine.getDescription());
                    DscItem.appendChild(desc);
                    Detalle2.appendChild(DscItem);
                    Element QtyRef = document.createElement("QtyRef");
                    Text qty = document.createTextNode(iLine.getQtyEntered().toString());
                    QtyRef.appendChild(qty);
                    Detalle2.appendChild(QtyRef);
                    Element PrcRef = document.createElement("PrcRef");
                    Text pl = document.createTextNode(iLine.getPriceList().toString());
                    PrcRef.appendChild(pl);
                    Detalle2.appendChild(PrcRef);
                    Element QtyItem = document.createElement("QtyItem");
                    Text qt = document.createTextNode(iLine.getQtyInvoiced().toString());
                    QtyItem.appendChild(qt);
                    Detalle2.appendChild(QtyItem);
                    Element PrcItem = document.createElement("PrcItem");
                    Text pa = document.createTextNode(iLine.getPriceActual().setScale(0, 4).toString());
                    PrcItem.appendChild(pa);
                    Detalle2.appendChild(PrcItem);
                    Element MontoItem = document.createElement("MontoItem");
                    Text tl = document.createTextNode(iLine.getLineNetAmt().setScale(0, 4).toString());
                    MontoItem.appendChild(tl);
                    Detalle2.appendChild(MontoItem);
                }
                ++i;
            }
            mylog = "referencia";
            String tiporeferencia = new String();
            String folioreferencia = new String();
            String fechareferencia = new String();
            int tipo_Ref = 0;
            if (inv.get_Value("C_RefDoc_ID") != null && (Integer)inv.get_Value("C_RefDoc_ID") > 0) {
                mylog = "referencia:invoice";
                refdoc = new MInvoice(inv.getCtx(), (int)((Integer)inv.get_Value("C_RefDoc_ID")), inv.get_TrxName());
                MDocType Refdoctype = new MDocType(inv.getCtx(), ((X_C_Invoice)refdoc).getC_DocType_ID(), inv.get_TrxName());
                tiporeferencia = (String)Refdoctype.get_Value("DocumentNo");
                folioreferencia = ((X_C_Invoice)refdoc).getDocumentNo();
                fechareferencia = ((X_C_Invoice)refdoc).getDateInvoiced().toString().substring(0, 10);
                tipo_Ref = 1;
            }
            if (inv.getPOReference() != null && inv.getPOReference().length() > 0) {
                mylog = "referencia:order";
                tiporeferencia = "801";
                folioreferencia = inv.getPOReference();
                fechareferencia = inv.getDateOrdered().toString().substring(0, 10);
                tipo_Ref = 2;
            }
            if (inv.get_Value("C_RefInOut_ID") != null && (Integer)inv.get_Value("C_RefInOut_ID") > 0) {
                mylog = "referencia:despacho";
                refdoc = new MInOut(inv.getCtx(), (int)((Integer)inv.get_Value("C_RefInOut_ID")), inv.get_TrxName());
                tiporeferencia = "52";
                folioreferencia = ((X_M_InOut)refdoc).getDocumentNo();
                fechareferencia = ((X_M_InOut)refdoc).getMovementDate().toString().substring(0, 10);
                tipo_Ref = 3;
            }
            if (tipo_Ref > 0) {
                Element Referencia2 = document.createElement("Referencia");
                Documento2.appendChild(Referencia2);
                Element NroLinRef = document.createElement("NroLinRef");
                Text Nro = document.createTextNode("1");
                NroLinRef.appendChild(Nro);
                Referencia2.appendChild(NroLinRef);
                Element TpoDocRef = document.createElement("TpoDocRef");
                Text tpo = document.createTextNode(tiporeferencia);
                TpoDocRef.appendChild(tpo);
                Referencia2.appendChild(TpoDocRef);
                Element FolioRef = document.createElement("FolioRef");
                Text ref = document.createTextNode(folioreferencia);
                FolioRef.appendChild(ref);
                Referencia2.appendChild(FolioRef);
                Element FchRef = document.createElement("FchRef");
                Text fchref = document.createTextNode(fechareferencia);
                FchRef.appendChild(fchref);
                Referencia2.appendChild(FchRef);
                Element CodRef = document.createElement("CodRef");
                Text codref = document.createTextNode(inv.get_ValueAsString("CodRef"));
                CodRef.appendChild(codref);
                Referencia2.appendChild(CodRef);
            }
            mylog = "firma";
            Element Firma = document.createElement("TmstFirma");
            Timestamp today = new Timestamp(TimeUtil.getToday().getTimeInMillis());
            Text Ftext = document.createTextNode(today.toString().substring(0, 10) + "T" + today.toString().substring(11, 19));
            Firma.appendChild(Ftext);
            Documento2.appendChild(Firma);
            mylog = "archivo";
            String ExportDir = (String)company.get_Value("ExportDir");
            try {
                File theDir = new File(ExportDir);
                if (!theDir.exists()) {
                    ExportDir = (String)company.get_Value("ExportDir2");
                }
            }
            catch (Exception e) {
                throw new AdempiereException("no existe directorio");
            }
            ExportDir = ExportDir.replace("\\", "/");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(ExportDir, inv.getDocumentNo() + ".xml"));
            StreamResult console = new StreamResult(System.out);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.transform(source, result);
            transformer.transform(source, console);
        }
        catch (Exception e) {
            log.severe("CreateXML: " + mylog + "--" + e.getMessage());
            return "CreateXML: " + mylog + "--" + e.getMessage();
        }
        return "XML Generated";
    }
}

