/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ModelOFBVallidRequisitionStock
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelOFBVallidRequisitionStock.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("M_Requisition", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MRequisition req;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MRequisition.Table_ID && (req = (MRequisition)po).getDocBase().equals("RRC") && !req.isSOTrx()) {
            MRequisitionLine[] lines;
            MRequisitionLine[] mRequisitionLineArray = lines = req.getLines();
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                BigDecimal found;
                MRequisitionLine line = mRequisitionLineArray[n2];
                if (line.getM_Product_ID() > 0 && (found = this.getQtyOnHand(line.getM_AttributeSetInstance_ID(), line.getM_Product_ID(), line.getParent().getM_Warehouse_ID())).compareTo(line.getQty()) < 0) {
                    return "No existe Stock para Producto " + line.getM_Product().getName() + " linea " + line.getLine() + " encontrado :" + found.intValue();
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }

    private BigDecimal getQtyOnHand(int M_AttributeSetInstance_ID, int M_Product_ID, int M_Warehouse_ID) {
        log.config("M_Warehouse_ID: " + M_Warehouse_ID + "M_Product_ID: " + M_Product_ID + " M_AttributeSetInstance_ID: " + M_AttributeSetInstance_ID);
        BigDecimal bd = null;
        String sql = "SELECT sum(s.QtyOnHand) FROM M_Storage s  INNER JOIN M_Locator l on (l.M_Locator_ID=s.M_locator_ID) WHERE s.M_Product_ID=? AND l.M_Warehouse_ID=?";
        if (M_AttributeSetInstance_ID > 0) {
            sql = "SELECT sum(s.QtyOnHand) FROM M_Storage s  INNER JOIN M_Locator l on (l.M_Locator_ID=s.M_locator_ID) WHERE s.M_Product_ID=? AND l.M_Warehouse_ID=? AND s.M_AttributeSetInstance_ID=?";
        }
        try {
            ResultSet rs;
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, M_Product_ID);
            pstmt.setInt(2, M_Warehouse_ID);
            if (M_AttributeSetInstance_ID > 0) {
                pstmt.setInt(3, M_AttributeSetInstance_ID);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                bd = rs.getBigDecimal(1);
                log.config("QtyOnHand: " + bd);
                if (bd != null) {
                    return bd;
                }
            } else {
                return new BigDecimal(0);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
            return new BigDecimal(0);
        }
        return new BigDecimal(0);
    }
}

