/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MCash;
import org.compiere.model.MCashLine;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_C_BankStatement;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelOFBSpecialDocs
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelOFBSpecialDocs.class);
    private int m_AD_Client_ID = -1;
    String m_processMsg;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Invoice", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MInvoice inv;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MInvoice.Table_ID) {
            inv = (MInvoice)po;
            this.updateSpecialDocs(inv);
        }
        if (timing == 10 && po.get_Table_ID() == MInvoice.Table_ID) {
            inv = (MInvoice)po;
            if (inv.getDocBase().equals("PTK") && this.isBankReverse(inv)) {
                return "Existe un Movimiento Bancario de Reversa que debe ser Anulado Primero";
            }
            this.voidSpecialDocs(inv);
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }

    public void voidSpecialDocs(MInvoice inv) {
        if (inv.getDocBase().equals("PTK")) {
            String mysql = "Update C_Payment set IsProtested='N', C_InvoiceLine_ID=null  Where C_Payment_ID IN (select C_Payment_ID from C_InvoiceLine where C_Invoice_ID=" + inv.getC_Invoice_ID() + ")";
            DB.executeUpdate(mysql, inv.get_TrxName());
        } else if (inv.getDocBase().equals("CDC") || inv.getDocBase().equals("VDC")) {
            MInvoiceLine[] iLines = inv.getLines(false);
            String mysql = "Update C_Payment set Custodio=null, C_InvoiceLine_ID=" + iLines[0].getC_InvoiceLine_ID() + " Where C_Payment_ID IN (select C_Payment_ID from C_InvoiceLine where C_Invoice_ID=" + inv.getC_Invoice_ID() + ")";
            log.config("update cdc vdc");
            DB.executeUpdate(mysql, inv.get_TrxName());
            String mysqlIn = "Update C_Invoice set IsPaid = 'N' Where C_Invoice_ID IN (select C_Invoicefac_ID from C_InvoiceLine where C_Invoice_ID=" + inv.getC_Invoice_ID() + ")";
            log.config("update cdc vdc");
            DB.executeUpdate(mysqlIn, inv.get_TrxName());
        } else if (inv.getDocBase().equals("FAT") && inv.isSOTrx()) {
            MInvoiceLine[] iLines = inv.getLines(false);
            String mysql = "Update C_Payment set Custodio=null, C_InvoiceLine_ID=" + iLines[0].getC_InvoiceLine_ID() + " Where C_Payment_ID IN (select C_Payment_ID from C_InvoiceLine where C_Invoice_ID=" + inv.getC_Invoice_ID() + ")";
            log.config("update fac");
            DB.executeUpdate(mysql, inv.get_TrxName());
            mysql = "Update C_Invoice set ISFACTORING='N', ispaid='N'  Where C_Invoice_ID IN (select C_InvoiceFac_ID from C_InvoiceLine where C_Invoice_ID=" + inv.getC_Invoice_ID() + ")";
            log.config("update fac");
            DB.executeUpdate(mysql, inv.get_TrxName());
        } else if (inv.getDocBase().equals("FAT") && !inv.isSOTrx()) {
            MInvoiceLine[] iLines = inv.getLines(false);
            String mysql = "Update C_Payment set Custodio='F', C_InvoiceLine_ID=" + iLines[0].getC_InvoiceLine_ID() + " Where C_Payment_ID IN (select C_Payment_ID from C_InvoiceLine where C_Invoice_ID=" + inv.getC_Invoice_ID() + ")";
            log.config("update fac");
            DB.executeUpdate(mysql, inv.get_TrxName());
            mysql = "Update C_Invoice set ISFACTORING='Y'  Where C_Invoice_ID IN (select C_InvoiceFac_ID from C_InvoiceLine where C_Invoice_ID=" + inv.getC_Invoice_ID() + ")";
            log.config("update fac");
            DB.executeUpdate(mysql, inv.get_TrxName());
        }
    }

    public boolean voidCashBook(MInvoice inv) {
        block6: {
            MCash mycash;
            block7: {
                int cash_id = DB.getSQLValue(inv.get_TrxName(), "select c_cash_id from c_cashline where c_invoice_id=" + inv.getC_Invoice_ID());
                if (cash_id <= 0) break block6;
                mycash = new MCash(inv.getCtx(), cash_id, inv.get_TrxName());
                if (!mycash.getDocStatus().equals(DOCSTATUS_Drafted)) break block7;
                MCashLine[] lines = mycash.getLines(true);
                int i = 0;
                while (i < lines.length) {
                    if (lines[i].getC_Invoice_ID() == inv.getC_Invoice_ID()) {
                        lines[i].setAmount(Env.ZERO);
                        lines[i].setDescription("**Anulada");
                        lines[i].save();
                    }
                    ++i;
                }
                break block6;
            }
            if (!mycash.getDocStatus().equals(DOCSTATUS_Completed)) break block6;
            MCash currentCash = MCash.getDefault(inv.getCtx(), this.getAD_Client_ID(), mycash.getC_CashBook_ID(), inv.get_TrxName());
            if (currentCash == null) {
                this.m_processMsg = "@No existe un libro de efectivo Activo Actualmente@";
                return false;
            }
            MCashLine[] lines = mycash.getLines(true);
            int i = 0;
            while (i < lines.length) {
                if (lines[i].getC_Invoice_ID() == inv.getC_Invoice_ID()) {
                    MCashLine newline = new MCashLine(currentCash);
                    newline.setC_Invoice_ID(lines[i].getC_Invoice_ID());
                    newline.setDescription("Descuento por Anulacion Factura:" + inv.getDocumentNo());
                    newline.setCashType(lines[i].getCashType());
                    newline.setAmount(lines[i].getAmount().negate());
                    if (!newline.save()) {
                        this.m_processMsg = "@No se puede descontar la Factura en la caja actual@";
                    }
                }
                ++i;
            }
        }
        return true;
    }

    public void updateSpecialDocs(MInvoice inv) {
        block16: {
            block19: {
                block18: {
                    String docbase;
                    block17: {
                        MInvoiceLine[] iLines;
                        block15: {
                            log.config("docbase");
                            docbase = inv.getDocBase();
                            if (!docbase.equals("PTK")) break block15;
                            MInvoiceLine[] iLines2 = inv.getLines(false);
                            String mysql = "Update C_Payment set IsProtested='Y', C_InvoiceLine_ID=" + iLines2[0].getC_InvoiceLine_ID() + " Where C_Payment_ID IN (select C_Payment_ID from C_InvoiceLine where C_Invoice_ID=" + inv.getC_Invoice_ID() + ")";
                            log.config("update ptk");
                            DB.executeUpdate(mysql, inv.get_TrxName());
                            MDocType docPtk = new MDocType(inv.getCtx(), inv.getC_DocTypeTarget_ID(), inv.get_TrxName());
                            String valuePTK = "BA";
                            Boolean generateBS = true;
                            try {
                                valuePTK = docPtk.get_ValueAsString("ptkType");
                                String genBSTxt = docPtk.get_ValueAsString("generateBS");
                                generateBS = genBSTxt != null && genBSTxt.compareTo("N") == 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
                            }
                            catch (Exception e) {
                                valuePTK = "BA";
                                generateBS = true;
                                log.log(Level.SEVERE, "No se pudo setear variable ptkType", e);
                                log.log(Level.SEVERE, "No se pudo setear variable generateBS", e);
                            }
                            if (valuePTK.compareToIgnoreCase("NB") == 0) {
                                String mysqlUPPtkNB = "Update C_Payment set IsReconciled = 'Y'  Where C_Payment_ID IN (select C_Payment_ID from C_InvoiceLine where C_Invoice_ID=" + inv.getC_Invoice_ID() + ")";
                                log.config("update ptk NB");
                                DB.executeUpdate(mysqlUPPtkNB, inv.get_TrxName());
                            } else if (!generateBS.booleanValue()) {
                                String mysqlUPPtkB = "Update C_Payment set IsReconciled = 'Y'  Where C_Payment_ID IN (select C_Payment_ID from C_InvoiceLine where C_Invoice_ID=" + inv.getC_Invoice_ID() + ")";
                                log.config("update ptk Bancario");
                                DB.executeUpdate(mysqlUPPtkB, inv.get_TrxName());
                            } else if (generateBS.booleanValue()) {
                                this.reverseBank(inv);
                            } else {
                                this.reverseBank(inv);
                            }
                            break block16;
                        }
                        if (!docbase.equals("CDC") && !docbase.equals("VDC")) break block17;
                        MInvoiceLine[] generateBS = iLines = inv.getLines(false);
                        int valuePTK = iLines.length;
                        int docPtk = 0;
                        while (docPtk < valuePTK) {
                            String mysql;
                            MInvoiceLine il = generateBS[docPtk];
                            if (il.get_ValueAsInt("C_Payment_ID") > 0) {
                                mysql = "Update C_Payment set Custodio='C', C_InvoiceLine_ID=" + il.getC_InvoiceLine_ID() + " Where C_Payment_ID =" + il.get_ValueAsInt("C_Payment_ID");
                                log.config("update cdc vdc");
                                DB.executeUpdate(mysql, inv.get_TrxName());
                            }
                            if (il.get_ValueAsInt("C_InvoiceFac_ID") > 0) {
                                mysql = "Update C_Invoice set isPaid='Y'  Where C_Invoice_ID=" + il.get_ValueAsInt("C_InvoiceFac_ID");
                                log.config("update cdc vdc");
                                DB.executeUpdate(mysql, inv.get_TrxName());
                            }
                            ++docPtk;
                        }
                        break block16;
                    }
                    if (!docbase.equals("FAT")) break block16;
                    if (!inv.get_ValueAsBoolean("PutInFactoring")) break block18;
                    MInvoiceLine[] iLines = inv.getLines(false);
                    String mysql = "Update C_Payment set Custodio='F', C_InvoiceLine_ID=" + iLines[0].getC_InvoiceLine_ID() + " Where C_Payment_ID IN (select C_Payment_ID from C_InvoiceLine where C_Invoice_ID=" + inv.getC_Invoice_ID() + ")";
                    log.config("update fac");
                    DB.executeUpdate(mysql, inv.get_TrxName());
                    mysql = "Update C_Invoice set ISFACTORING='Y', ispaid='Y'  Where C_Invoice_ID IN (select C_InvoiceFac_ID from C_InvoiceLine where C_Invoice_ID=" + inv.getC_Invoice_ID() + ")";
                    log.config("update fac");
                    DB.executeUpdate(mysql, inv.get_TrxName());
                    break block16;
                }
                if (inv.get_ValueAsBoolean("Extinguir") || inv.get_ValueAsBoolean("PutInFactoring")) break block19;
                MInvoiceLine[] iLines = inv.getLines(false);
                String mysql = "";
                String sqlCantRef = "SELECT COUNT(1) FROM AD_Ref_List WHERE AD_Reference_ID=1000006 AND value = 'D'";
                int cantRef = DB.getSQLValue(inv.get_TrxName(), sqlCantRef);
                if (cantRef > 0) {
                    mysql = "Update C_Payment set Custodio='D', C_InvoiceLine_ID=" + iLines[0].getC_InvoiceLine_ID() + " Where C_Payment_ID IN (select C_Payment_ID from C_InvoiceLine where C_Invoice_ID=" + inv.getC_Invoice_ID() + ")";
                    log.config("update fac");
                    DB.executeUpdate(mysql, inv.get_TrxName());
                } else {
                    mysql = "Update C_Payment set Custodio=null, C_InvoiceLine_ID=" + iLines[0].getC_InvoiceLine_ID() + " Where C_Payment_ID IN (select C_Payment_ID from C_InvoiceLine where C_Invoice_ID=" + inv.getC_Invoice_ID() + ")";
                    log.config("update fac");
                    DB.executeUpdate(mysql, inv.get_TrxName());
                }
                mysql = "Update C_Invoice set ISFACTORING='N', ispaid='N'  Where C_Invoice_ID IN (select C_InvoiceFac_ID from C_InvoiceLine where C_Invoice_ID=" + inv.getC_Invoice_ID() + ")";
                log.config("update fac");
                DB.executeUpdate(mysql, inv.get_TrxName());
                break block16;
            }
            if (!inv.get_ValueAsBoolean("Extinguir") || inv.get_ValueAsBoolean("PutInFactoring")) break block16;
            MInvoiceLine[] iLines = inv.getLines(false);
            String mysql = "Update C_Payment set Custodio='E', C_InvoiceLine_ID=" + iLines[0].getC_InvoiceLine_ID() + " Where C_Payment_ID IN (select C_Payment_ID from C_InvoiceLine where C_Invoice_ID=" + inv.getC_Invoice_ID() + ")";
            log.config("update fac");
            DB.executeUpdate(mysql, inv.get_TrxName());
            mysql = "Update C_Invoice set Extinta='Y'  Where C_Invoice_ID IN (select C_InvoiceFac_ID from C_InvoiceLine where C_Invoice_ID=" + inv.getC_Invoice_ID() + ")";
            log.config("update fac");
            DB.executeUpdate(mysql, inv.get_TrxName());
            mysql = "Update C_Invoice set Extinta='Y'  Where C_Invoice_ID=" + inv.getC_Invoice_ID();
            log.config("update fac2");
            DB.executeUpdate(mysql, inv.get_TrxName());
            int i = 0;
            while (i < iLines.length) {
                if (iLines[i].get_ValueAsInt("C_InvoiceFac_ID") != 0) {
                    MInvoice inv2 = new MInvoice(inv.getCtx(), iLines[i].get_ValueAsInt("C_InvoiceFac_ID"), inv.get_TrxName());
                    MBPartner bp = new MBPartner(inv.getCtx(), inv2.getC_BPartner_ID(), inv.get_TrxName());
                    bp.setTotalOpenBalance();
                    bp.save();
                }
                ++i;
            }
        }
    }

    public boolean reverseBank(MInvoice inv) {
        if (!inv.getDocBase().equals("PTK")) {
            return true;
        }
        boolean result = false;
        String mysql = "select p.c_payment_id,p.c_bankaccount_id,p.payamt from C_payment p inner join C_Invoiceline il on (p.C_Payment_ID=il.C_Payment_ID)  and il.C_Invoice_ID=? order by p.c_bankaccount_id";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(mysql, inv.get_TrxName());
            pstmt.setInt(1, inv.getC_Invoice_ID());
            ResultSet rs = pstmt.executeQuery();
            X_C_BankStatement bankstmt = null;
            int currentaccount = 0;
            while (rs.next()) {
                if (currentaccount != rs.getInt(2)) {
                    currentaccount = rs.getInt(2);
                    if (bankstmt != null) {
                        bankstmt.setDocAction(DOCSTATUS_Completed);
                        ((MBankStatement)bankstmt).processIt(DOCSTATUS_Completed);
                        bankstmt.save();
                    }
                    bankstmt = new MBankStatement(inv.getCtx(), 0, inv.get_TrxName());
                    bankstmt.setC_BankAccount_ID(rs.getInt(2));
                    bankstmt.setName("Reverso por Protesto de Documento:" + inv.getDocumentNo());
                    bankstmt.setDescription("Reverso Protesto");
                    bankstmt.set_CustomColumn("C_Invoice_ID", inv.get_ID());
                    bankstmt.setAD_Org_ID(inv.getAD_Org_ID());
                    bankstmt.save();
                }
                MBankStatementLine line = new MBankStatementLine((MBankStatement)bankstmt);
                line.setPayment(new MPayment(inv.getCtx(), rs.getInt(1), inv.get_TrxName()));
                line.setTrxAmt(line.getTrxAmt().negate());
                line.setStmtAmt(line.getStmtAmt().negate());
                line.setAD_Org_ID(inv.getAD_Org_ID());
                line.save();
            }
            if (currentaccount != 0) {
                bankstmt.setDocAction(DOCSTATUS_Completed);
                ((MBankStatement)bankstmt).processIt(DOCSTATUS_Completed);
                bankstmt.save();
            }
            result = true;
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            return false;
        }
        return result;
    }

    public boolean isBankReverse(MInvoice inv) {
        int banks = DB.getSQLValue(inv.get_TrxName(), "select count(1) from c_bankstatement where docstatus<>'VO' and c_invoice_id=" + inv.getC_Invoice_ID());
        return banks > 0;
    }
}

