/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInOutLineMA;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MTable;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_StorageReservation;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelOFBSchemaReserved
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelOFBSchemaReserved.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", this);
        engine.addDocValidate("M_InOut", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MInOut ship;
        BigDecimal reserved;
        BigDecimal ordered;
        MProduct product;
        BigDecimal difference;
        MOrderLine line;
        int i;
        boolean isSOTrx;
        MOrderLine[] lines;
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MOrder.Table_ID) {
            order = (MOrder)po;
            lines = order.getLines(true, "M_Product_ID");
            isSOTrx = order.isSOTrx();
            i = 0;
            while (i < lines.length) {
                line = lines[i];
                difference = line.getQtyOrdered().subtract(line.getQtyDelivered());
                product = line.getProduct();
                if (product != null && product.isStocked()) {
                    ordered = isSOTrx ? Env.ZERO : difference;
                    BigDecimal bigDecimal = reserved = isSOTrx ? difference : Env.ZERO;
                    if (this.existReservationTable(po)) {
                        this.OFBReservation(line.getM_Warehouse_ID(), line.getM_Product_ID(), ordered, reserved, po);
                    }
                }
                ++i;
            }
        }
        if (timing == 4 && po.get_Table_ID() == MOrder.Table_ID) {
            order = (MOrder)po;
            lines = order.getLines(true, "M_Product_ID");
            isSOTrx = order.isSOTrx();
            i = 0;
            while (i < lines.length) {
                line = lines[i];
                difference = Env.ZERO.subtract(line.getQtyReserved());
                product = line.getProduct();
                if (product != null && product.isStocked()) {
                    ordered = isSOTrx ? Env.ZERO : difference;
                    BigDecimal bigDecimal = reserved = isSOTrx ? difference : Env.ZERO;
                    if (this.existReservationTable(po)) {
                        this.OFBReservation(line.getM_Warehouse_ID(), line.getM_Product_ID(), ordered, reserved, po);
                    }
                }
                ++i;
            }
        }
        if (timing == 2 && po.get_Table_ID() == MOrder.Table_ID) {
            order = (MOrder)po;
            int cant = DB.getSQLValue(po.get_TrxName(), "SELECT COUNT(1) FROM M_InOut WHERE IsActive = 'Y' AND DocStatus IN ('CO','CL') AND C_Order_ID = " + order.get_ID());
            if (cant > 0) {
                if (order.isSOTrx()) {
                    return "ERROR: No es posible anular nota de venta. Debe anular despacho primero";
                }
                return "ERROR: No es posible anular OC. Debe anular recibo primero";
            }
            MOrderLine[] lines2 = order.getLines(true, "M_Product_ID");
            boolean isSOTrx2 = order.isSOTrx();
            int i2 = 0;
            while (i2 < lines2.length) {
                MOrderLine line2 = lines2[i2];
                BigDecimal difference2 = Env.ZERO.subtract(line2.getQtyReserved());
                MProduct product2 = line2.getProduct();
                if (product2 != null && product2.isStocked()) {
                    BigDecimal reserved2;
                    BigDecimal ordered2 = isSOTrx2 ? Env.ZERO : difference2;
                    BigDecimal bigDecimal = reserved2 = isSOTrx2 ? difference2 : Env.ZERO;
                    if (this.existReservationTable(po)) {
                        this.OFBReservation(line2.getM_Warehouse_ID(), line2.getM_Product_ID(), ordered2, reserved2, po);
                    }
                }
                ++i2;
            }
        }
        if (timing == 3 && po.get_Table_ID() == MOrder.Table_ID) {
            order = (MOrder)po;
            MOrderLine[] lines3 = order.getLines(true, "M_Product_ID");
            boolean isSOTrx3 = order.isSOTrx();
            i = 0;
            while (i < lines3.length) {
                MOrderLine line3 = lines3[i];
                difference = Env.ZERO.subtract(line3.getQtyOrdered().subtract(line3.getQtyDelivered()));
                product = line3.getProduct();
                if (product != null && product.isStocked()) {
                    ordered = isSOTrx3 ? Env.ZERO : difference;
                    BigDecimal bigDecimal = reserved = isSOTrx3 ? difference : Env.ZERO;
                    if (this.existReservationTable(po)) {
                        this.OFBReservation(line3.getM_Warehouse_ID(), line3.getM_Product_ID(), ordered, reserved, po);
                    }
                }
                ++i;
            }
        }
        if (timing == 9 && po.get_Table_ID() == MInOut.Table_ID && (ship = (MInOut)po).getM_RMA_ID() <= 0) {
            MInOutLine[] lines4 = ship.getLines(false);
            int lineIndex = 0;
            while (lineIndex < lines4.length) {
                MInOutLine sLine = lines4[lineIndex];
                MProduct product3 = sLine.getProduct();
                String MovementType = ship.getMovementType();
                BigDecimal Qty = sLine.getMovementQty();
                if (MovementType.charAt(1) == '-') {
                    Qty = Qty.negate();
                }
                BigDecimal QtySO = Env.ZERO;
                BigDecimal QtyPO = Env.ZERO;
                MOrderLine oLine = null;
                if (sLine.getC_OrderLine_ID() != 0) {
                    oLine = new MOrderLine(po.getCtx(), sLine.getC_OrderLine_ID(), po.get_TrxName());
                    log.fine("OrderLine - Reserved=" + oLine.getQtyReserved() + ", Delivered=" + oLine.getQtyDelivered());
                    if (ship.isSOTrx()) {
                        QtySO = sLine.getMovementQty();
                    } else {
                        QtyPO = sLine.getMovementQty();
                    }
                }
                if (product3 != null && product3.isStocked()) {
                    boolean sameWarehouse = true;
                    if (oLine != null) {
                        boolean bl = sameWarehouse = oLine.getM_Warehouse_ID() == ship.getM_Warehouse_ID();
                    }
                    if (sLine.getM_AttributeSetInstance_ID() == 0) {
                        MInOutLineMA[] mas = this.get(sLine.getM_InOutLine_ID(), po);
                        int j = 0;
                        while (j < mas.length) {
                            MInOutLineMA ma = mas[j];
                            BigDecimal QtyMA = ma.getMovementQty();
                            if (MovementType.charAt(1) == '-') {
                                QtyMA = QtyMA.negate();
                            }
                            BigDecimal reservedDiff = Env.ZERO;
                            BigDecimal orderedDiff = Env.ZERO;
                            if (sLine.getC_OrderLine_ID() != 0) {
                                if (ship.isSOTrx()) {
                                    reservedDiff = ma.getMovementQty().negate();
                                } else {
                                    orderedDiff = ma.getMovementQty().negate();
                                }
                            }
                            if (ship.getMovementType().equals("C+")) {
                                reservedDiff = Env.ZERO;
                            }
                            if (!ship.isSOTrx() && QtyPO.compareTo(orderedDiff) < 0) {
                                orderedDiff = QtyPO;
                            }
                            if (this.existReservationTable(po)) {
                                this.OFBReservation(oLine.getM_Warehouse_ID(), sLine.getM_Product_ID(), orderedDiff, reservedDiff, po);
                            }
                            ++j;
                        }
                    } else {
                        BigDecimal orderedDiff;
                        BigDecimal reservedDiff = sameWarehouse ? QtySO.negate() : Env.ZERO;
                        BigDecimal bigDecimal = orderedDiff = sameWarehouse ? QtyPO.negate() : Env.ZERO;
                        if (this.existReservationTable(po) && oLine != null) {
                            this.OFBReservation(oLine.getM_Warehouse_ID(), sLine.getM_Product_ID(), orderedDiff, reservedDiff, po);
                        }
                    }
                }
                ++lineIndex;
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }

    public boolean existReservationTable(PO po) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean val = false;
        String mysql = "SELECT count(1) from M_StorageReservation";
        if (!DB.isOracle()) {
            mysql = "select count(1) from AD_Table where tablename='M_StorageReservation'";
        }
        try {
            pstmt = DB.prepareStatement(mysql, po.get_TrxName());
            rs = pstmt.executeQuery();
            if (rs.next() && rs.getInt(1) > 0) {
                val = true;
            }
        }
        catch (Exception e) {
            val = false;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return val;
    }

    public void OFBReservation(int M_WareHouse_ID, int M_Product_ID, BigDecimal ordered, BigDecimal reserved, PO po) {
        CPreparedStatement pstmt = null;
        String mysql = "SELECT * from M_StorageReservation where M_WareHouse_ID = ? and M_Product_ID = ?";
        try {
            pstmt = DB.prepareStatement(mysql, po.get_TrxName());
            pstmt.setInt(1, M_WareHouse_ID);
            pstmt.setInt(2, M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                X_M_StorageReservation storage = new X_M_StorageReservation(po.getCtx(), rs, po.get_TrxName());
                storage.setQtyReserved(storage.getQtyReserved().add(reserved));
                storage.setQtyOrdered(storage.getQtyOrdered().add(ordered));
                if (storage.getQtyOrdered().signum() < 0) {
                    storage.setQtyOrdered(Env.ZERO);
                }
                if (storage.getQtyReserved().signum() < 0) {
                    storage.setQtyReserved(Env.ZERO);
                }
                storage.save();
            } else {
                X_M_StorageReservation storage = new X_M_StorageReservation(po.getCtx(), 0, po.get_TrxName());
                storage.setQtyReserved(reserved);
                storage.setQtyOrdered(ordered);
                storage.setM_Product_ID(M_Product_ID);
                storage.setM_Warehouse_ID(M_WareHouse_ID);
                storage.save();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public MInOutLineMA[] get(int M_InOutLine_ID, PO po) {
        Query query = MTable.get(po.getCtx(), "M_InOutLineMA").createQuery("M_InOutLine_ID=?", po.get_TrxName());
        query.setParameters(M_InOutLine_ID);
        List<MInOutLineMA> list = query.list();
        MInOutLineMA[] retValue = new MInOutLineMA[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    private boolean reserveStock(MDocType dt, MOrderLine[] lines, PO po, MOrder order) {
        boolean binding;
        if (dt == null) {
            dt = MDocType.get(po.getCtx(), order.getC_DocType_ID());
        }
        if ("RM".equals(dt.getDocSubTypeSO())) {
            return true;
        }
        boolean bl = binding = !dt.isProposal();
        if (DOCSTATUS_Voided.equals(order.getDocAction()) || "OB".equals(dt.getDocSubTypeSO()) && "CL".equals(order.getDocAction())) {
            binding = false;
        }
        boolean isSOTrx = order.isSOTrx();
        int i = 0;
        while (i < lines.length) {
            MProduct product;
            MOrderLine line = lines[i];
            BigDecimal target = binding ? line.getQtyOrdered() : Env.ZERO;
            BigDecimal difference = target.subtract(line.getQtyDelivered());
            if ("RE".equals(order.getDocAction())) {
                difference = difference.negate();
            }
            if ((product = line.getProduct()) != null && product.isStocked()) {
                BigDecimal reserved;
                BigDecimal ordered = isSOTrx ? Env.ZERO : difference;
                BigDecimal bigDecimal = reserved = isSOTrx ? difference : Env.ZERO;
                if (this.existReservationTable(po)) {
                    this.OFBReservation(line.getM_Warehouse_ID(), line.getM_Product_ID(), ordered, reserved, po);
                }
            }
            ++i;
        }
        return true;
    }
}

