/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_C_Payment;
import org.compiere.model.X_C_PaymentRequest;
import org.compiere.model.X_C_PaymentRequestLine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelOFBPaymentRequest
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelOFBPaymentRequest.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_PaymentRequestLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 5 || type == 4 || type == 6) && po.get_Table_ID() == X_C_PaymentRequestLine.Table_ID) {
            X_C_PaymentRequestLine line = (X_C_PaymentRequestLine)po;
            BigDecimal total = DB.getSQLValueBD(po.get_TrxName(), "select sum(amt) from C_PaymentRequestLine where isactive='Y' and C_PaymentRequest_ID=" + line.getC_PaymentRequest_ID(), new Object[0]);
            X_C_PaymentRequest hr2 = new X_C_PaymentRequest(po.getCtx(), line.getC_PaymentRequest_ID(), po.get_TrxName());
            hr2.setPayAmt(total == null ? Env.ZERO : total);
            hr2.save();
        }
        if (type == 5 && po.get_Table_ID() == X_C_Payment.Table_ID) {
            MAllocationHdr hdr;
            ResultSet rs;
            X_C_Payment pay = (X_C_Payment)po;
            CPreparedStatement pstmt = null;
            String mySql = "select distinct C_AllocationHdr_ID FROM C_AllocationLine WHERE C_Payment_ID = ?";
            if (pay.getDocStatus() == DOCSTATUS_Completed) {
                try {
                    pstmt = DB.prepareStatement(mySql, po.get_TrxName());
                    pstmt.setInt(1, pay.get_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next() && ((hdr = new MAllocationHdr(po.getCtx(), rs.getInt("C_AllocationHdr_ID"), po.get_TrxName())).getDocStatus().compareTo(DOCSTATUS_Drafted) == 0 || hdr.getDocStatus().compareTo(DOCSTATUS_InProgress) == 0)) {
                        hdr.setDocStatus(hdr.completeIt());
                        hdr.save();
                        log.info("Allocation: " + hdr.get_ID() + " Completed");
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            if (pay.getDocStatus().compareTo(DOCSTATUS_Voided) == 0) {
                try {
                    pstmt = DB.prepareStatement(mySql, po.get_TrxName());
                    pstmt.setInt(1, pay.get_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next() && (hdr = new MAllocationHdr(po.getCtx(), rs.getInt("C_AllocationHdr_ID"), po.get_TrxName())).getDocStatus().compareTo(DOCSTATUS_Completed) == 0 && hdr.voidIt()) {
                        hdr.save();
                        log.info("Allocation: " + hdr.get_ID() + " Voided");
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

