/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_M_Cost;
import org.compiere.model.X_M_CostDetail;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelOFBCostQty
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelOFBCostQty.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("M_Cost", this);
        engine.addModelChange("M_CostDetail", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        BigDecimal qty;
        String sqlqty;
        PO cost;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 4 || type == 5) && po.get_Table_ID() == MCost.Table_ID) {
            cost = (MCost)po;
            sqlqty = "SELECT SUM(qtyonhand) from m_storage where m_product_id = " + ((X_M_Cost)cost).getM_Product_ID() + "AND AD_Client_ID = ?";
            qty = DB.getSQLValueBD(po.get_TrxName(), sqlqty, cost.getAD_Client_ID());
            if (qty != null) {
                String sqlmax = "SELECT coalesce(currentqty,0) from m_costdetail where m_product_id =  " + ((X_M_Cost)cost).getM_Product_ID() + " and m_costdetail_id in " + "(SELECT max(m_costdetail_id) from m_Costdetail where processed='Y' and m_product_id = " + ((X_M_Cost)cost).getM_Product_ID() + " and ad_client_id = ?)";
                BigDecimal qty2 = DB.getSQLValueBD(po.get_TrxName(), sqlmax, cost.getAD_Client_ID());
                if (qty2 == null) {
                    qty2 = Env.ZERO;
                }
                DB.executeUpdate("UPDATE M_Cost set currentqty = " + qty2 + ", cumulatedqty = " + qty2 + ", cumulatedamt = " + qty2.multiply(((X_M_Cost)cost).getCurrentCostPrice()) + " WHERE AD_Client_ID = " + cost.getAD_Client_ID() + " AND m_product_id = " + ((X_M_Cost)cost).getM_Product_ID(), po.get_TrxName());
            }
        }
        if ((type == 4 || type == 5) && po.get_Table_ID() == MCostDetail.Table_ID) {
            cost = (MCostDetail)po;
            sqlqty = "SELECT SUM(qtyonhand) from m_storage where m_product_id = " + ((X_M_CostDetail)cost).getM_Product_ID() + "AND AD_Client_ID = ?";
            qty = DB.getSQLValueBD(po.get_TrxName(), sqlqty, cost.getAD_Client_ID());
            if (qty != null) {
                if (((X_M_CostDetail)cost).getM_MovementLine_ID() == 0 || ((X_M_CostDetail)cost).getM_InventoryLine_ID() == 0) {
                    DB.executeUpdate("UPDATE M_Costdetail set currentqty = " + qty + ", cumulatedqty = " + qty + ", cumulatedamt = " + qty.multiply(((X_M_CostDetail)cost).getCurrentCostPrice()) + " WHERE M_CostDetail_ID = " + cost.get_ID(), po.get_TrxName());
                } else {
                    DB.executeUpdate("UPDATE M_Costdetail set currentqty = " + qty + ", cumulatedqty = " + qty + ", currentcostprice = " + ((X_M_CostDetail)cost).getAmt().divide(((X_M_CostDetail)cost).getQty()).abs() + ",  cumulatedamt = " + qty.multiply(((X_M_CostDetail)cost).getAmt().divide(((X_M_CostDetail)cost).getQty()).abs()) + " WHERE M_CostDetail_ID = " + cost.get_ID(), po.get_TrxName());
                }
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

