/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentAllocate;
import org.compiere.model.MProductPricing;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.ofb.model.OFBForward;

public class ModelOFB
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelOFB.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Payment", this);
        engine.addModelChange("C_Invoice", this);
        engine.addModelChange("C_OrderLine", this);
        engine.addModelChange("C_PaymentAllocate", this);
        engine.addDocValidate("M_Requisition", this);
        engine.addDocValidate("C_Invoice", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        MOrderLine oLine;
        MInvoice inv;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 5 && po.get_Table_ID() == MPayment.Table_ID) {
            MAllocationHdr hdr;
            ResultSet rs;
            MPayment pay = (MPayment)po;
            CPreparedStatement pstmt = null;
            String mySql = "select distinct C_AllocationHdr_ID FROM C_AllocationLine WHERE C_Payment_ID = ?";
            if (pay.getDocStatus() == DOCSTATUS_Completed) {
                try {
                    pstmt = DB.prepareStatement(mySql, po.get_TrxName());
                    pstmt.setInt(1, pay.get_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next() && ((hdr = new MAllocationHdr(po.getCtx(), rs.getInt("C_AllocationHdr_ID"), po.get_TrxName())).getDocStatus().compareTo(DOCSTATUS_Drafted) == 0 || hdr.getDocStatus().compareTo(DOCSTATUS_InProgress) == 0)) {
                        hdr.setDocStatus(hdr.completeIt());
                        hdr.save();
                        log.info("Allocation: " + hdr.get_ID() + " Completed");
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            if (pay.getDocStatus().compareTo(DOCSTATUS_Voided) == 0) {
                try {
                    pstmt = DB.prepareStatement(mySql, po.get_TrxName());
                    pstmt.setInt(1, pay.get_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next() && (hdr = new MAllocationHdr(po.getCtx(), rs.getInt("C_AllocationHdr_ID"), po.get_TrxName())).getDocStatus().compareTo(DOCSTATUS_Completed) == 0 && hdr.voidIt()) {
                        hdr.save();
                        log.info("Allocation: " + hdr.get_ID() + " Voided");
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        if ((type == 2 || type == 1) && po.get_Table_ID() == MInvoice.Table_ID && (inv = (MInvoice)po).isSOTrx()) {
            int cant = 0;
            cant = DB.getSQLValue(po.get_TrxName(), "SELECT COUNT(1) FROM C_Invoice WHERE C_DocTypeTarget_ID = " + inv.getC_DocTypeTarget_ID() + " " + "AND DocumentNo = '" + inv.getDocumentNo() + "' AND C_Invoice_ID <> " + inv.get_ID());
            if (cant > 0) {
                return "Ya existe una factura con mismo Numero y Tipo de Documento";
            }
        }
        if ((type == 4 || type == 6) && po.get_Table_ID() == MOrderLine.Table_ID && (oLine = (MOrderLine)po).get_ValueAsInt("M_RequisitionLine_ID") > 0) {
            MRequisitionLine line = new MRequisitionLine(po.getCtx(), oLine.get_ValueAsInt("M_RequisitionLine_ID"), po.get_TrxName());
            String sqlUpRL = "SELECT SUM(QTYENTERED) FROM C_OrderLine col INNER JOIN C_Order co ON (col.C_Order_ID = co.C_Order_ID)  WHERE M_RequisitionLine_ID = " + oLine.get_ValueAsInt("M_RequisitionLine_ID") + " AND co.DocStatus IN ('DR','IP','CO','CL')";
            BigDecimal amt = DB.getSQLValueBD(po.get_TrxName(), sqlUpRL, new Object[0]);
            if (amt != null && amt.compareTo(Env.ZERO) > 0) {
                line.set_CustomColumn("QtyUsed", amt);
                line.save();
            }
        }
        if ((type == 4 || type == 5 || type == 6) && po.get_Table_ID() == MPaymentAllocate.Table_ID) {
            MPaymentAllocate pAll = (MPaymentAllocate)po;
            MPayment pay = new MPayment(po.getCtx(), pAll.getC_Payment_ID(), po.get_TrxName());
            BigDecimal Amount = DB.getSQLValueBD(po.get_TrxName(), "SELECT SUM(Amount) FROM C_PaymentAllocate WHERE IsActive = 'Y' AND C_Payment_ID = " + pay.get_ID(), new Object[0]);
            pay.setPayAmt(Amount);
            pay.save();
        }
        if (!(type != 1 && type != 2 || po.get_Table_ID() != MOrderLine.Table_ID || OFBForward.InvalidPriceLimit())) {
            oLine = (MOrderLine)po;
            MOrder order = new MOrder(po.getCtx(), oLine.getC_Order_ID(), po.get_TrxName());
            if ((order.getDocStatus().compareTo(DOCSTATUS_Drafted) == 0 || order.getDocStatus().compareTo(DOCSTATUS_InProgress) == 0 || order.getDocStatus().compareTo("IN") == 0) && oLine.getC_Order().isSOTrx() && oLine.getM_Product_ID() > 0) {
                MProductPricing pp = new MProductPricing(oLine.getM_Product_ID(), oLine.getC_Order().getC_BPartner_ID(), oLine.getQtyEntered(), oLine.getC_Order().isSOTrx());
                pp.setM_PriceList_ID(oLine.getC_Order().getM_PriceList_ID());
                pp.setM_PriceList_Version_ID(this.getPriceListVersion(oLine.getC_Order().getM_PriceList_ID(), oLine.getC_Order().getDateOrdered()));
                pp.setPriceDate(oLine.getC_Order().getDateOrdered());
                if (pp.getPriceLimit() != null && pp.getPriceLimit().compareTo(Env.ZERO) > 0 && oLine.getPriceEntered().compareTo(pp.getPriceLimit()) < 0) {
                    return "ERROR: Precio bajo precio limite";
                }
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MRequisition.Table_ID) {
            MRequisition req = (MRequisition)po;
            MUser userApro = new MUser(po.getCtx(), Env.getAD_User_ID(po.getCtx()), po.get_TrxName());
            BigDecimal amtToCmp = (BigDecimal)userApro.get_Value("AmtApproval");
            if (amtToCmp == null) {
                amtToCmp = Env.ZERO;
            }
            if (amtToCmp.compareTo(Env.ZERO) > 0 && amtToCmp.compareTo(req.getTotalLines()) < 0) {
                return "Monto solicitud sobrepasa monto de usuario";
            }
        }
        if (timing == 7 && po.get_Table_ID() == MInvoice.Table_ID) {
            MInvoice inv = (MInvoice)po;
            log.config("docbase");
            String docbase = inv.getDocBase();
            log.config("before update correlativo");
            if (docbase.equals("API") || docbase.equals("APC")) {
                if (!inv.isSOTrx()) {
                    int nextcorr;
                    String date1 = inv.getDateAcct().toString().substring(0, 10);
                    String mysql = "Select nvl(max(I.correlativo),0) FROM C_INVOICE I  WHere i.AD_CLIENT_ID=" + inv.getAD_Client_ID() + " AND " + " TRIM(TO_Char(i.DATEacct,'mm'))= '" + date1.substring(5, 7) + "'" + " AND\ti.ISSOTRX='N' AND TRIM(TO_Char(i.DATEacct,'yyyy'))= '" + date1.substring(0, 4) + "'" + " AND i.DOCSTATUS IN ('CO','CL') and Isactive='Y' ";
                    if (OFBForward.UseCorrelativeAPForDocType()) {
                        mysql = String.valueOf(mysql) + "AND C_DocType_ID = " + inv.getC_DocTypeTarget_ID();
                    }
                    if ((nextcorr = DB.getSQLValue("C_Invoice", mysql)) == 0) {
                        DB.executeUpdate("update c_invoice set correlativo=1 where c_invoice_id=" + inv.get_ID(), po.get_TrxName());
                    } else {
                        DB.executeUpdate("update c_invoice set correlativo=" + ++nextcorr + " where c_invoice_id=" + inv.get_ID(), po.get_TrxName());
                    }
                }
            } else {
                DB.executeUpdate("update c_invoice set correlativo=0 where c_invoice_id=" + inv.get_ID(), po.get_TrxName());
            }
            log.config("after update correlativo");
        }
        return null;
    }

    private int getPriceListVersion(int pList_ID, Timestamp dateOrdered) {
        int valor = 0;
        String sql = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList pl,C_Currency c,M_PriceList_Version plv WHERE pl.C_Currency_ID=c.C_Currency_ID AND pl.M_PriceList_ID=plv.M_PriceList_ID AND pl.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, pList_ID);
            pstmt.setTimestamp(2, dateOrdered);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next() && rs.getInt(1) > 0) {
                valor = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        return valor;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

