/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.math.BigDecimal;
import org.compiere.acct.FactLine;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModBaskakowAcctReceipt
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModBaskakowAcctReceipt.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("Fact_Acct", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        MInOut ship;
        FactLine fLine;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 5 || type == 4) && po.get_Table_ID() == FactLine.Table_ID && (fLine = (FactLine)po).getAD_Table_ID() == MInOut.Table_ID && (ship = new MInOut(po.getCtx(), fLine.getRecord_ID(), po.get_TrxName())).isSOTrx() && fLine.getM_Product_ID() > 0) {
            MInOutLine[] lines = ship.getLines(false);
            int i = 0;
            while (i < lines.length) {
                BigDecimal amt;
                MInOutLine line = lines[i];
                BigDecimal buyM3 = (BigDecimal)line.get_Value("buy_m3");
                if (buyM3 == null) {
                    buyM3 = Env.ZERO;
                }
                if (line.getM_Product_ID() == fLine.getM_Product_ID() && fLine.getLine_ID() == line.get_ID() && fLine.getQty().compareTo(Env.ZERO) > 0) {
                    amt = DB.getSQLValueBD(po.get_TrxName(), "(SELECT mppo.pricelist   from m_inoutline miol JOIN c_orderbp cobp ON miol.c_orderbp_id = cobp.c_orderbp_id  JOIN c_bplocatorprice mppo ON miol.m_product_id = mppo.m_product_id AND  mppo.c_bpartner_location_id = cobp.c_bpartner_location_id WHERE miol.M_InOutLine_ID = ?)", line.get_ID());
                    if (amt != null && (amt = amt.multiply(buyM3)).signum() > 0) {
                        DB.executeUpdateEx("UPDATE Fact_Acct SET amtsourcedr = " + amt + ", amtacctdr = " + amt + " WHERE fact_acct_id = " + fLine.get_ID(), po.get_TrxName());
                    }
                } else if (line.getM_Product_ID() == fLine.getM_Product_ID() && fLine.getLine_ID() == line.get_ID() && fLine.getQty().compareTo(Env.ZERO) <= 0 && (amt = DB.getSQLValueBD(po.get_TrxName(), "(SELECT mppo.pricelist   from m_inoutline miol JOIN c_orderbp cobp ON miol.c_orderbp_id = cobp.c_orderbp_id  JOIN c_bplocatorprice mppo ON miol.m_product_id = mppo.m_product_id AND  mppo.c_bpartner_location_id = cobp.c_bpartner_location_id WHERE miol.M_InOutLine_ID = ?)", line.get_ID())) != null && (amt = amt.multiply(buyM3)).signum() > 0) {
                    DB.executeUpdateEx("UPDATE Fact_Acct SET amtsourcecr = " + amt + ", amtacctcr = " + amt + " WHERE fact_acct_id = " + fLine.get_ID(), po.get_TrxName());
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

