/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Ref_List;
import org.compiere.model.X_C_Payment;
import org.compiere.model.X_C_PaymentRequest;
import org.compiere.model.X_C_PaymentRequestLine;
import org.compiere.model.X_C_Project;
import org.compiere.model.X_C_ProjectLine;
import org.compiere.model.X_C_ProjectSchedule;
import org.compiere.model.X_DM_Document;
import org.compiere.model.X_DM_DocumentLine;
import org.compiere.model.X_DM_DocumentReception;
import org.compiere.model.X_DM_MandateAgreement;
import org.compiere.model.X_DM_MandateAgreementLine;
import org.compiere.model.X_PM_ProjectPay;
import org.compiere.model.X_PM_Supervision;
import org.compiere.model.X_PM_SupervisionObs;
import org.compiere.model.X_PM_Tender;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class ManAgreementValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ManAgreementValidator.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("DM_MandateAgreement", this);
        engine.addModelChange("C_ProjectSchedule", this);
        engine.addModelChange("DM_DocumentLine", this);
        engine.addModelChange("DM_Document", this);
        engine.addModelChange("C_PaymentRequestLine", this);
        engine.addModelChange("C_Payment", this);
        engine.addModelChange("PM_Tender", this);
        engine.addModelChange("PM_SupervisionObs", this);
        engine.addModelChange("C_Project", this);
        engine.addModelChange("C_ProjectLine", this);
        engine.addModelChange("DM_DocumentReception", this);
        engine.addModelChange("AD_Ref_List", this);
        engine.addModelChange("C_Invoice", this);
        engine.addModelChange("C_InvoiceLine", this);
        engine.addModelChange("PM_ProjectPay", this);
        engine.addModelChange("PM_Supervision", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        X_DM_Document doc;
        X_PM_ProjectPay ppay;
        String sql;
        int cant;
        MInvoice inv;
        String sqlNext;
        int next;
        X_DM_Document dm;
        PO hr2;
        PO line;
        X_DM_MandateAgreementLine cml;
        MProjectLine line2;
        int n;
        int n2;
        MProjectLine[] mProjectLineArray;
        MProjectLine[] lines;
        X_DM_MandateAgreement cm;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 4 && po.get_Table_ID() == X_DM_MandateAgreement.Table_ID) {
            cm = (X_DM_MandateAgreement)po;
            MProject pj = new MProject(po.getCtx(), cm.getC_Project_ID(), po.get_TrxName());
            cm.setAmt(pj.getCommittedAmt());
            cm.set_CustomColumn("Code", pj.get_Value("POReference"));
            cm.set_CustomColumn("C_BPartner_ID", pj.get_Value("C_BPartner_ID"));
            cm.set_CustomColumn("C_BPartnerC_ID", pj.get_Value("C_BPartnerC_ID"));
            cm.set_CustomColumn("C_BPartnerA_ID", pj.get_Value("C_BPartnerA_ID"));
            cm.set_CustomColumn("Name", pj.getName());
            cm.save();
            lines = pj.getLines();
            int ii = 10;
            mProjectLineArray = lines;
            n2 = lines.length;
            n = 0;
            while (n < n2) {
                line2 = mProjectLineArray[n];
                cml = new X_DM_MandateAgreementLine(Env.getCtx(), 0, po.get_TrxName());
                cml.setDM_MandateAgreement_ID(cm.getDM_MandateAgreement_ID());
                cml.setAD_Org_ID(line2.getAD_Org_ID());
                cml.setAmt(line2.getCommittedAmt());
                cml.setLine(ii);
                cml.setDatePromised(new Timestamp(TimeUtil.getToday().getTimeInMillis()));
                cml.setDescription(line2.getDescription());
                cml.set_CustomColumn("M_Product_ID", line2.getM_Product_ID());
                cml.saveEx();
                ii += 10;
                ++n;
            }
        }
        if (type == 5 && po.get_Table_ID() == X_C_Payment.Table_ID) {
            MAllocationHdr hdr;
            X_C_Payment pay = (X_C_Payment)po;
            CPreparedStatement pstmt = null;
            String mySql = "select distinct C_AllocationHdr_ID FROM C_AllocationLine WHERE C_Payment_ID = ?";
            if (pay.getDocStatus() == DOCSTATUS_Completed) {
                try {
                    pstmt = DB.prepareStatement(mySql, po.get_TrxName());
                    pstmt.setInt(1, pay.get_ID());
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next() && ((hdr = new MAllocationHdr(po.getCtx(), rs.getInt("C_AllocationHdr_ID"), po.get_TrxName())).getDocStatus().compareTo(DOCSTATUS_Drafted) == 0 || hdr.getDocStatus().compareTo(DOCSTATUS_InProgress) == 0)) {
                        hdr.setDocStatus(hdr.completeIt());
                        hdr.save();
                        log.info("Allocation: " + hdr.get_ID() + " Completed");
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            if (pay.getDocStatus().compareTo(DOCSTATUS_Voided) == 0) {
                try {
                    pstmt = DB.prepareStatement(mySql, po.get_TrxName());
                    pstmt.setInt(1, pay.get_ID());
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next() && (hdr = new MAllocationHdr(po.getCtx(), rs.getInt("C_AllocationHdr_ID"), po.get_TrxName())).getDocStatus().compareTo(DOCSTATUS_Completed) == 0 && hdr.voidIt()) {
                        hdr.save();
                        log.info("Allocation: " + hdr.get_ID() + " Voided");
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        if ((type == 5 || type == 4 || type == 6) && po.get_Table_ID() == X_DM_DocumentLine.Table_ID) {
            line = (X_DM_DocumentLine)po;
            BigDecimal total = DB.getSQLValueBD(po.get_TrxName(), "select sum(amt) from DM_DocumentLine where isactive='Y' and DM_Document_ID=" + ((X_DM_DocumentLine)line).getDM_Document_ID(), new Object[0]);
            hr2 = new X_DM_Document(po.getCtx(), ((X_DM_DocumentLine)line).getDM_Document_ID(), po.get_TrxName());
            ((X_DM_Document)hr2).setAmt(total == null ? Env.ZERO : total);
            hr2.save();
        }
        if ((type == 5 || type == 4) && po.get_Table_ID() == X_DM_Document.Table_ID) {
            X_DM_Document doc2 = (X_DM_Document)po;
            int cant2 = 0;
            cant2 = DB.getSQLValue(po.get_TrxName(), "select count(1) from DM_Document where resolutionnumber = ? and DM_Document_ID <> ?", doc2.get_ValueAsString("ResolutionNumber"), doc2.get_ID());
            if (cant2 > 0) {
                return "N\u00famero de Resoluci\u00f3n ya usado";
            }
        }
        if ((type == 5 || type == 4 || type == 6) && po.get_Table_ID() == X_C_PaymentRequestLine.Table_ID) {
            line = (X_C_PaymentRequestLine)po;
            BigDecimal total = DB.getSQLValueBD(po.get_TrxName(), "select sum(amt) from C_PaymentRequestLine where isactive='Y' and C_PaymentRequest_ID=" + ((X_C_PaymentRequestLine)line).getC_PaymentRequest_ID(), new Object[0]);
            hr2 = new X_C_PaymentRequest(po.getCtx(), ((X_C_PaymentRequestLine)line).getC_PaymentRequest_ID(), po.get_TrxName());
            ((X_C_PaymentRequest)hr2).setPayAmt(total == null ? Env.ZERO : total);
            hr2.save();
        }
        if ((type == 2 || type == 1) && po.get_Table_ID() == X_DM_Document.Table_ID && (dm = (X_DM_Document)po).getC_Project_ID() > 0 && dm.get_ValueAsString("DM_DocumentType").equals("AP")) {
            MProject pj = new MProject(po.getCtx(), dm.getC_Project_ID(), po.get_TrxName());
            dm.setDescription(String.valueOf(pj.getPOReference()) + "-" + pj.getName());
        }
        if (type == 2 && po.get_Table_ID() == X_DM_MandateAgreement.Table_ID && po.is_ValueChanged("C_Project_ID")) {
            cm = (X_DM_MandateAgreement)po;
            DB.executeUpdate("delete from DM_MandateAgreementLine where DM_MandateAgreement_ID=" + cm.getDM_MandateAgreement_ID(), po.get_TrxName());
            MProject pj = new MProject(po.getCtx(), cm.getC_Project_ID(), po.get_TrxName());
            cm.setAmt(pj.getCommittedAmt());
            cm.set_CustomColumn("Code", pj.get_Value("POReference"));
            cm.set_CustomColumn("C_BPartner_ID", pj.get_Value("C_BPartner_ID"));
            cm.set_CustomColumn("C_BPartnerC_ID", pj.get_Value("C_BPartnerC_ID"));
            cm.set_CustomColumn("C_BPartnerA_ID", pj.get_Value("C_BPartnerA_ID"));
            lines = pj.getLines();
            int ii = 10;
            mProjectLineArray = lines;
            n2 = lines.length;
            n = 0;
            while (n < n2) {
                line2 = mProjectLineArray[n];
                cml = new X_DM_MandateAgreementLine(Env.getCtx(), 0, po.get_TrxName());
                cml.setDM_MandateAgreement_ID(cm.getDM_MandateAgreement_ID());
                cml.setAD_Org_ID(line2.getAD_Org_ID());
                cml.setAmt(line2.getCommittedAmt());
                cml.setLine(ii);
                cml.setDatePromised(new Timestamp(TimeUtil.getToday().getTimeInMillis()));
                cml.setDescription(line2.getDescription());
                cml.set_CustomColumn("M_Product_ID", line2.getM_Product_ID());
                cml.saveEx();
                ii += 10;
                ++n;
            }
        }
        if ((type == 2 || type == 1) && po.get_Table_ID() == X_C_ProjectSchedule.Table_ID) {
            X_C_ProjectSchedule ps = (X_C_ProjectSchedule)po;
            BigDecimal total = DB.getSQLValueBD(po.get_TrxName(), "select sum(dueamt) from c_projectschedule where isactive='Y' and c_project_id=" + ps.getC_Project_ID(), new Object[0]);
            if (total == null) {
                total = Env.ZERO;
            }
            if (type == 2) {
                total = total.subtract((BigDecimal)ps.get_ValueOld("DueAmt"));
            }
            if ((total = total.add(ps.getDueAmt())).compareTo(ps.getC_Project().getCommittedAmt()) > 0) {
                return "Cuota Supera el Monto Aprobado";
            }
        }
        if ((type == 2 || type == 1) && po.get_Table_ID() == X_PM_Tender.Table_ID) {
            int yearM6;
            int yearM5;
            int yearM4;
            int yearM3;
            int yearM2;
            int yearM1;
            X_PM_Tender td2 = (X_PM_Tender)po;
            Timestamp mi1 = td2.getMilestone1();
            Timestamp mi2 = td2.getMilestone2();
            Timestamp mi3 = td2.getMilestone3();
            Timestamp mi4 = td2.getMilestone4();
            Timestamp mi5 = td2.getMilestone5();
            Timestamp mi6 = td2.getMilestone6();
            Date date = new Date();
            Timestamp actual = new Timestamp(date.getTime());
            Calendar startCal = Calendar.getInstance();
            startCal.setTime(actual);
            int year = actual.getYear();
            if (mi1 != null && (yearM1 = mi1.getYear()) < --year) {
                return "Verificar fechas. Hay intervalos de fechas no v\u00e1lidos";
            }
            if (mi2 != null && (yearM2 = mi2.getYear()) < year) {
                return "Verificar fechas. Hay intervalos de fechas no v\u00e1lidos";
            }
            if (mi3 != null && (yearM3 = mi3.getYear()) < year) {
                return "Verificar fechas. Hay intervalos de fechas no v\u00e1lidos";
            }
            if (mi4 != null && (yearM4 = mi4.getYear()) < year) {
                return "Verificar fechas. Hay intervalos de fechas no v\u00e1lidos";
            }
            if (mi5 != null && (yearM5 = mi5.getYear()) < year) {
                return "Verificar fechas. Hay intervalos de fechas no v\u00e1lidos";
            }
            if (mi6 != null && (yearM6 = mi6.getYear()) < year) {
                return "Verificar fechas. Hay intervalos de fechas no v\u00e1lidos";
            }
            if (mi2 != null && mi1 != null && mi2.compareTo(mi1) < 0) {
                return "Verificar fechas. Hay intervalos de fechas no v\u00e1lidos";
            }
            if (mi3 != null && mi2 != null && mi3.compareTo(mi2) <= 0) {
                return "Verificar fechas. Hay intervalos de fechas no v\u00e1lidos";
            }
            if (mi4 != null && mi3 != null && mi4.compareTo(mi3) <= 0) {
                return "Verificar fechas. Hay intervalos de fechas no v\u00e1lidos";
            }
            if (mi5 != null && mi4 != null && mi5.compareTo(mi4) <= 0) {
                return "Verificar fechas. Hay intervalos de fechas no v\u00e1lidos";
            }
            if (mi6 != null && mi5 != null && mi6.compareTo(mi5) <= 0) {
                return "Verificar fechas. Hay intervalos de fechas no v\u00e1lidos";
            }
        }
        if ((type == 2 || type == 1) && po.get_Table_ID() == X_PM_SupervisionObs.Table_ID) {
            X_PM_SupervisionObs SuO = (X_PM_SupervisionObs)po;
            X_PM_Supervision Su = new X_PM_Supervision(po.getCtx(), SuO.getPM_Supervision_ID(), po.get_TrxName());
            String sqlVA = "SELECT MAX(c_bpartnerp_id) FROM DM_Document WHERE DM_DocumentType = '02' AND C_Project_ID = ?";
            int BPCon = DB.getSQLValue(po.get_TrxName(), sqlVA, Su.getC_Project_ID());
            if (BPCon > 0) {
                SuO.setC_BPartnerCon_ID(BPCon);
            }
        }
        if ((type == 2 || type == 1) && po.get_Table_ID() == X_C_Project.Table_ID) {
            int qty;
            MProject pro = (MProject)po;
            if (pro.get_ValueAsBoolean("PM_Gore_UT")) {
                pro.set_CustomColumn("C_BPartnerA_ID", 1000234);
            }
            if (pro.get_ValueAsString("ProyectStage").equalsIgnoreCase("6") && pro.get_ValueAsInt("C_ProjectType_ID") == 1000000) {
                pro.set_CustomColumn("IsSupervised", true);
            } else {
                pro.set_CustomColumn("IsSupervised", false);
            }
            String sqlVal = "Select count(1) from c_project where POreference = ? and ProyectStage = ?";
            if (pro.getC_Project_ID() > 0) {
                sqlVal = String.valueOf(sqlVal) + " and C_Project_ID<>" + pro.getC_Project_ID();
            }
            if ((qty = DB.getSQLValue(po.get_TrxName(), sqlVal, pro.getPOReference(), pro.get_ValueAsString("ProyectStage"))) > 0) {
                return "No se pudo guardar. Codigo BIP ya ingresado con misma Etapa";
            }
        }
        if (type == 4 && po.get_Table_ID() == X_DM_DocumentReception.Table_ID) {
            int year = 1900;
            X_DM_DocumentReception dr = (X_DM_DocumentReception)po;
            year += dr.getDateTrx().getYear();
            int next2 = 0;
            if (dr.get_ValueAsString("WinType").equalsIgnoreCase("O")) {
                String sql2 = "Select MAX(EntryNo) from DM_DocumentReception where WinType = 'O' and extract(year from datetrx) = ? ";
                String EntryNo = DB.getSQLValueString(po.get_TrxName(), sql2, year);
                next2 = EntryNo == null ? 0 : Integer.parseInt(EntryNo);
                dr.setEntryNo(Integer.toString(++next2));
            } else if (dr.get_ValueAsString("WinType").equalsIgnoreCase("S")) {
                String sql2 = "Select MAX(EntryNo) from DM_DocumentReception where extract(year from datetrx) = ? and WinType = 'S' and ad_org_id = ?";
                String EntryNo2 = DB.getSQLValueString(po.get_TrxName(), sql2, year, dr.getAD_Org_ID());
                next2 = EntryNo2 == null ? 0 : Integer.parseInt(EntryNo2);
                dr.setEntryNo(Integer.toString(++next2));
            }
            dr.save();
        }
        if ((type == 5 || type == 4) && po.get_Table_ID() == X_AD_Ref_List.Table_ID) {
            X_AD_Ref_List list = (X_AD_Ref_List)po;
            int Acount_ID = list.get_ValueAsInt("C_Account_Acct");
            int Client_ID = list.getAD_Client_ID();
            String typeL = list.getValue();
            if (Client_ID == 1000000) {
                String sqlUp = "UPDATE AD_Ref_List SET C_Account_Acct = " + Acount_ID + " WHERE AD_Reference_ID = 1000077 " + " AND value like '" + typeL + "'";
                DB.executeUpdate(sqlUp, po.get_TrxName());
            }
        }
        if (po.get_TableName().equals("DM_DocumentReception") && (type == 2 || type == 1) && po.get_ValueAsString("WinType").equalsIgnoreCase("O") && po.get_ValueAsInt("C_DocType_ID") > 0 && (next = DB.getSQLValue(null, sqlNext = "select Currentnext from AD_Sequence seq inner join C_DocType doc on (seq.AD_Sequence_ID = doc.DocNoSequence_ID) where C_DocType_ID=? ", po.get_ValueAsInt("C_DocType_ID"))) == po.get_ValueAsInt("DocumentNo")) {
            int nextID = po.get_ValueAsInt("DocumentNo") + 1;
            String sqlUp = "UPDATE AD_Sequence SET Currentnext = " + nextID + " WHERE AD_Sequence_ID IN " + " (select AD_Sequence_ID from AD_Sequence seq inner join C_DocType doc on (seq.AD_Sequence_ID = doc.DocNoSequence_ID) " + "where C_DocType_ID= " + po.get_ValueAsInt("C_DocType_ID") + ")";
            DB.executeUpdate(sqlUp, null);
        }
        if ((type == 2 || type == 1) && po.get_Table_ID() == MInvoice.Table_ID && (inv = (MInvoice)po).getDocBase().equalsIgnoreCase("APB") && (cant = DB.getSQLValue(null, sql = "SELECT COUNT(1) FROM C_InvoiceTax WHERE C_Invoice_ID = ? AND C_Tax_ID <> 1000002", inv.get_ID())) > 0) {
            return "Impuesto No Valido";
        }
        if ((type == 2 || type == 1) && po.get_Table_ID() == MInvoiceLine.Table_ID) {
            MInvoiceLine invL = (MInvoiceLine)po;
            MInvoice inv2 = new MInvoice(po.getCtx(), invL.getC_Invoice_ID(), po.get_TrxName());
            if (inv2.getDocBase().equalsIgnoreCase("APB") && invL.getC_Tax_ID() != 1000002) {
                return "Impuesto No Valido";
            }
        }
        if ((type == 1 || type == 7) && po.get_Table_ID() == X_C_Payment.Table_ID) {
            X_C_Payment pay = (X_C_Payment)po;
            pay.set_CustomColumn("Correlative", 0);
        }
        if ((type == 5 || type == 4) && po.get_Table_ID() == X_PM_ProjectPay.Table_ID && (ppay = (X_PM_ProjectPay)po).getPay_Type().equalsIgnoreCase("D1")) {
            BigDecimal newAmt = ppay.getAmtM().compareTo(Env.ZERO) > 0 ? ppay.getAmtM().negate() : ppay.getAmtM();
            String sqlUpdate = "UPDATE PM_ProjectPay SET amt = " + newAmt.toString() + " WHERE PM_ProjectPay_ID = " + ppay.get_ID();
            DB.executeUpdate(sqlUpdate, po.get_TrxName());
        }
        if (type == 3 && po.get_Table_ID() == X_C_ProjectLine.Table_ID) {
            MProjectLine prol = (MProjectLine)po;
            String sqlValid = "SELECT COUNT(1) FROM DM_Document WHERE dm_documenttype = '02' AND C_ProjectLine_ID = ?";
            cant = DB.getSQLValue(po.get_TrxName(), sqlValid, prol.get_ID());
            if (cant > 0) {
                return "No est\u00e1 permitido borrar este SUBITEM debido a que tiene datos ya ingresados en un COMPROMISO";
            }
        }
        if (type == 3 && po.get_Table_ID() == X_DM_Document.Table_ID && (doc = (X_DM_Document)po).get_ValueAsString("DM_DocumentType").equals("02")) {
            String sqlValid = "SELECT COUNT(1) FROM C_ProjectSchedule WHERE DM_Document_ID=?";
            cant = DB.getSQLValue(doc.get_TrxName(), sqlValid, doc.get_ID());
            if (cant > 0) {
                return "No est\u00e1 permitido borrar este COMPROMISO debido a que tiene datos ya ingresados en EL PROGRAMA DE PAGO";
            }
        }
        if (type == 3 && po.get_Table_ID() == X_C_ProjectSchedule.Table_ID) {
            X_C_ProjectSchedule ps = (X_C_ProjectSchedule)po;
            String sqlValid = "SELECT COUNT(1) FROM PM_ProjectPay WHERE C_ProjectSchedule_ID=?";
            cant = DB.getSQLValue(ps.get_TrxName(), sqlValid, ps.get_ID());
            if (cant > 0) {
                return "No est\u00e1 permitido borrar este PROGRAMA DE PAGO debido a que tiene datos ya ingresados en LA RENDICION DE PAGO";
            }
        }
        if (type == 3 && po.get_Table_ID() == X_PM_Supervision.Table_ID) {
            X_PM_Supervision pms = (X_PM_Supervision)po;
            String sqlValid = "SELECT COUNT(1) FROM PM_SupervisionObs WHERE PM_Supervision_ID=?";
            cant = DB.getSQLValue(pms.get_TrxName(), sqlValid, pms.get_ID());
            if (cant > 0) {
                return "No est\u00e1 permitido borrar esta FISCALIZACI\u00d3N debido a que tiene datos ya ingresados en EL INFORME FISCALIZACI\u00d3N";
            }
        }
        if ((type == 4 || type == 5) && po.get_Table_ID() == X_C_Payment.Table_ID) {
            X_C_Payment pay = (X_C_Payment)po;
            String sqlCant = "SELECT COUNT(1) FROM C_Payment WHERE C_BankAccount_ID = ? AND Correlative = ? AND DocStatus NOT IN ('VO') AND C_Payment_ID <> ?";
            cant = DB.getSQLValue(pay.get_TrxName(), sqlCant, pay.getC_BankAccount_ID(), pay.get_ValueAsInt("Correlative"), pay.get_ID());
            if (cant > 0 && pay.get_ValueAsInt("Correlative") != 0) {
                return "No esta permitido tener documentos con la misma CUENTA BANCARIA y N\u00b0 INGRESO/EGRESO";
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

