/*
 * Decompiled with CFR 0.152.
 */
package org.movix.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MDocType;
import org.compiere.model.MGLCategory;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPeriod;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.ofb.utils.DateUtils;

public class GenJournalOtherCurrency
extends SvrProcess {
    private Timestamp p_dateAcct;
    private Timestamp p_dateAcctTo;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DateAcct")) {
                this.p_dateAcct = para[i].getParameterAsTimestamp();
                this.p_dateAcctTo = para[i].getParameterToAsTimestamp();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        String sqlJournal = "SELECT C_Currency_ID,TotalDR,DateAcct,AD_Org_ID FROM GL_Journal  WHERE DocStatus IN ('CO','CL') AND AD_Client_ID = " + Env.getAD_Client_ID(this.getCtx()) + " AND C_Currency_ID <> 228 AND Description NOT LIKE '%Diferencia moneda%' AND DateAcct BETWEEN ? AND ? ";
        this.log.config("sqljournal " + sqlJournal);
        CPreparedStatement pstmt = DB.prepareStatement(sqlJournal, this.get_TrxName());
        pstmt.setTimestamp(1, this.p_dateAcct);
        pstmt.setTimestamp(2, this.p_dateAcctTo);
        ResultSet rs = pstmt.executeQuery();
        BigDecimal amtDif = Env.ZERO;
        BigDecimal amtAux = Env.ZERO;
        BigDecimal amtAcum = Env.ZERO;
        BigDecimal MRate = Env.ZERO;
        BigDecimal MRateToday = Env.ZERO;
        while (rs.next()) {
            MRate = MConversionRate.getRate(rs.getInt("C_Currency_ID"), 228, rs.getTimestamp("DateAcct"), 114, Env.getAD_Client_ID(Env.getCtx()), rs.getInt("AD_Org_ID"));
            if (MRate == null) {
                MRate = Env.ZERO;
            }
            amtDif = rs.getBigDecimal("TotalDR").multiply(MRate);
            MRateToday = MConversionRate.getRate(rs.getInt("C_Currency_ID"), 228, DateUtils.today(), 114, Env.getAD_Client_ID(Env.getCtx()), rs.getInt("AD_Org_ID"));
            if (MRateToday == null) {
                MRateToday = Env.ZERO;
            }
            amtAux = rs.getBigDecimal("TotalDR").multiply(MRateToday);
            amtDif = amtDif.subtract(amtAux);
            amtAcum = amtAcum.add(amtDif);
        }
        if (amtAcum.compareTo(Env.ZERO) != 0) {
            MJournalBatch batch = new MJournalBatch(this.getCtx(), 0, this.get_TrxName());
            batch.setAD_Org_ID(Env.getAD_Org_ID(this.getCtx()));
            batch.setDescription("Diferencia moneda : " + DateUtils.today());
            batch.setPostingType("A");
            batch.setC_DocType_ID(MDocType.getOfDocBaseType(this.getCtx(), "GLJ")[0].getC_DocType_ID());
            batch.setGL_Category_ID(MGLCategory.getDefault(this.getCtx(), "M").getGL_Category_ID());
            batch.setDateAcct(DateUtils.today());
            batch.setDateDoc(DateUtils.today());
            batch.setC_Period_ID(MPeriod.getC_Period_ID(this.getCtx(), DateUtils.today(), Env.getAD_Org_ID(this.getCtx())));
            MClient client = MClient.get(this.getCtx(), Env.getAD_Client_ID(this.getCtx()));
            batch.setC_Currency_ID(client.getC_Currency_ID());
            batch.save(this.get_TrxName());
            MJournal journal = new MJournal(batch);
            journal.setDescription("Diferencia moneda : " + DateUtils.today());
            journal.setC_AcctSchema_ID(MAcctSchema.getClientAcctSchema(this.getCtx(), Env.getAD_Client_ID(this.getCtx()))[0].getC_AcctSchema_ID());
            journal.setGL_Category_ID(MGLCategory.getDefault(this.getCtx(), "D").getGL_Category_ID());
            journal.setC_ConversionType_ID(114);
            journal.save(this.get_TrxName());
            int ID_Debito = DB.getSQLValue(this.get_TrxName(), "SELECT PJ_Asset_Acct FROM C_AcctSchema_Default WHERE AD_Client_ID = " + Env.getAD_Client_ID(this.getCtx()));
            int ID_Credito = DB.getSQLValue(this.get_TrxName(), "SELECT PJ_WIP_Acct FROM C_AcctSchema_Default WHERE AD_Client_ID =" + Env.getAD_Client_ID(this.getCtx()));
            MJournalLine line1 = new MJournalLine(journal);
            line1.setAmtSourceDr(amtAcum.abs());
            line1.setAmtSourceCr(Env.ZERO);
            line1.setAmtAcct(amtAcum.abs(), Env.ZERO);
            line1.setC_ValidCombination_ID(ID_Debito);
            line1.save();
            MJournalLine line2 = new MJournalLine(journal);
            line2.setAmtSourceDr(Env.ZERO);
            line2.setAmtSourceCr(amtAcum.abs());
            line2.setAmtAcct(Env.ZERO, amtAcum.abs());
            line2.setC_ValidCombination_ID(ID_Credito);
            line2.save();
        }
        return "Procesado";
    }
}

