/*
 * Decompiled with CFR 0.152.
 */
package org.movix.model;

import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ModelMovixOrder
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelMovixOrder.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_OrderLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        MOrderLine oLine;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 4 && po.get_Table_ID() == MOrderLine.Table_ID) {
            oLine = (MOrderLine)po;
            MOrder order = oLine.getParent();
            if (oLine.get_ValueAsInt("M_RequisitionLine_ID") > 0 && !order.isSOTrx()) {
                MRequisitionLine rLine = new MRequisitionLine(po.getCtx(), oLine.get_ValueAsInt("M_RequisitionLine_ID"), po.get_TrxName());
                MRequisition req = new MRequisition(po.getCtx(), rLine.getM_Requisition_ID(), po.get_TrxName());
                if (req.get_ValueAsInt("C_Bpartner_ID") > 0) {
                    order.setBPartner(new MBPartner(po.getCtx(), req.get_ValueAsInt("C_Bpartner_ID"), po.get_TrxName()));
                    order.save(po.get_TrxName());
                }
                if (req.getM_PriceList_ID() > 0) {
                    order.setM_PriceList_ID(req.getM_PriceList_ID());
                    order.save(po.get_TrxName());
                }
            }
        }
        if ((type == 1 || type == 2) && po.get_Table_ID() == MOrderLine.Table_ID && (oLine = (MOrderLine)po).getPriceEntered().compareTo(Env.ZERO) <= 0) {
            return "ERROR: No puede ingresar un valor negativo";
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

