/*
 * Decompiled with CFR 0.152.
 */
package org.movix.model;

import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.ofb.utils.DateUtils;

public class ModelMovixInvoice
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelMovixInvoice.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Invoice", this);
        engine.addModelChange("C_InvoiceLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        MInvoiceLine iLine;
        MInvoice inv;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == MInvoice.Table_ID && (inv = (MInvoice)po).isSOTrx()) {
            if (inv.getDateInvoiced().compareTo(DateUtils.nextDay(DateUtils.today())) > 0) {
                return "ERROR: Fecha no puede ser superior a hoy";
            }
            if (inv.getDateAcct().compareTo(DateUtils.nextDay(DateUtils.today())) > 0) {
                return "ERROR: Fecha no puede ser superior a hoy";
            }
        }
        if ((type == 1 || type == 2) && po.get_Table_ID() == MInvoiceLine.Table_ID && (iLine = (MInvoiceLine)po).getPriceEntered().compareTo(Env.ZERO) <= 0) {
            return "ERROR: No puede ingresar un valor negativo";
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

