/*
 * Decompiled with CFR 0.152.
 */
package org.mop.model;

import org.compiere.model.MClient;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;

public class ModMOPValidateTransferAsset
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMOPValidateTransferAsset.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_Invoice", this);
        engine.addModelChange("C_InvoiceLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == MInvoiceLine.Table_ID) {
            MInvoiceLine invl = (MInvoiceLine)po;
            int doctype_id = invl.getC_Invoice().getC_DocTypeTarget_ID();
            if (doctype_id == 2000163) {
                int oldprovince = invl.get_ValueAsInt("C_Province_ID");
                log.config("old province " + oldprovince);
                int newprovince = invl.get_ValueAsInt("C_NewProvince_ID");
                log.config("new province " + newprovince);
                int oldorg = invl.get_ValueAsInt("AD_Org_ID");
                log.config("old org " + oldorg);
                int neworg = invl.get_ValueAsInt("AD_NewOrg_ID");
                log.config("new org " + neworg);
                if (oldprovince == newprovince && neworg == oldorg) {
                    return "Para el tipo INT, al menos debe cambiar la provincia o el servicio";
                }
            } else if (doctype_id == 2000164) {
                int oldoffice = invl.get_ValueAsInt("S_ResourceRef_ID");
                log.config("old office " + oldoffice);
                int newoffice = invl.get_ValueAsInt("S_NewResourceRef_ID");
                log.config("new office " + newoffice);
                if (oldoffice == newoffice) {
                    return "Para el tipo CNN, al menos debe cambiar la oficina";
                }
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

