/*
 * Decompiled with CFR 0.152.
 */
package org.minsal.process;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.json.JSONArray;
import org.json.JSONObject;

public class ProcessMINSALChileCompraStatusOrder
extends SvrProcess {
    private String p_DocNo;
    private String p_Token;
    private String p_Status;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DocNo")) {
                    this.p_DocNo = para[i].getParameterAsString();
                } else if (name.equals("Token")) {
                    this.p_Token = para[i].getParameterAsString();
                } else if (name.equals("Status")) {
                    this.p_Status = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        String sql = "SELECT count(1) from c_order where documentno like '" + this.p_DocNo + "' and isactive='Y' " + " AND issotrx='N'";
        int val = DB.getSQLValue(this.get_TrxName(), sql);
        if (val > 0) {
            return "La orden " + this.p_DocNo + " ya se encuentra en el sistema";
        }
        this.log.config("TOKEN = " + this.p_Token);
        this.log.config("ORDEN = " + this.p_DocNo);
        this.log.config("STATUS = " + this.p_Status);
        JSONObject json = null;
        JSONArray jsonarr = null;
        String codigoestado = null;
        MOrder ord = null;
        String jsonText = null;
        String website = null;
        website = "https://api.mercadopublico.cl/servicios/v1/publico/ordenesdecompra.json?codigo=" + this.p_DocNo + "&ticket=" + this.p_Token;
        InputStream is = null;
        this.log.config("websitepre = " + website);
        int validator = 0;
        try {
            is = new URL(website).openStream();
        }
        catch (Exception e2) {
            this.log.config(" msg " + e2.toString());
            validator = 1;
            Object e2 = null;
            return "No se encuentra la orden ingresada";
        }
        this.log.config("websitepost = " + website);
        this.log.config("validator " + validator);
        BufferedReader rd = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
        StringBuilder sb = new StringBuilder();
        int counter = 0;
        while ((counter = rd.read()) != -1) {
            sb.append((char)counter);
        }
        jsonText = sb.toString();
        this.log.config("jsonText = " + jsonText);
        json = new JSONObject(jsonText);
        jsonarr = json.getJSONArray("Listado");
        codigoestado = null;
        try {
            codigoestado = jsonarr.getJSONObject(0).get("CodigoEstado").toString();
        }
        catch (Exception e) {
            this.log.config("errormsg = " + e.toString());
            return "No se encuentra Orden";
        }
        String Codigo = jsonarr.getJSONObject(0).get("Codigo").toString();
        String Nombre = jsonarr.getJSONObject(0).get("Nombre").toString();
        String Descripcion = jsonarr.getJSONObject(0).get("Descripcion").toString();
        ord = new MOrder(this.getCtx(), 0, this.get_TrxName());
        ord.setDocumentNo(this.p_DocNo);
        ord.setC_DocTypeTarget_ID(2000108);
        ord.setIsSOTrx(false);
        ord.setDocAction("CO");
        ord.setAD_Org_ID(2000344);
        String Proveedor = jsonarr.getJSONObject(0).get("Proveedor").toString();
        this.log.config("Proveedor " + Proveedor);
        JSONObject Prov = new JSONObject(jsonarr.getJSONObject(0).get("Proveedor").toString());
        String Nombre2 = Prov.getString("Nombre");
        String Rut = Prov.getString("RutSucursal");
        codigoestado = jsonarr.getJSONObject(0).get("CodigoEstado").toString();
        String Rut2 = Rut.replace(".", "");
        Rut2 = Rut2.substring(0, Rut2.length() - 2);
        this.log.config("Proveedor " + Proveedor);
        this.log.config("Proveedor " + Nombre2);
        this.log.config("Rut Proveedor " + Rut2);
        sql = "SELECT coalesce(max(c_bpartner_id),0) from c_bpartner WHERE value like '" + Rut2 + "'";
        int bp = DB.getSQLValue(this.get_TrxName(), sql);
        int direccion = 0;
        if (bp == 0) {
            MBPartner mbp = new MBPartner(this.getCtx(), 0, this.get_TrxName());
            mbp.setValue(Rut2);
            mbp.setName(Nombre2);
            mbp.setName2(Nombre2);
            mbp.set_CustomColumn("PartnerType", "J");
            mbp.setC_BP_Group_ID(2000002);
            mbp.setIsVendor(true);
            mbp.setIsCustomer(true);
            mbp.save();
            bp = mbp.get_ID();
            MBPartnerLocation bploc = new MBPartnerLocation(this.getCtx(), 0, this.get_TrxName());
            MLocation loc = new MLocation(this.getCtx(), 0, this.get_TrxName());
            loc.setAddress1(Prov.getString("Direccion"));
            loc.setAddress2(Prov.getString("Comuna"));
            loc.setAddress3(Prov.getString("Comuna"));
            loc.setAddress4(Prov.getString("Comuna"));
            loc.setCity(Prov.getString("Region"));
            loc.setC_Country_ID(152);
            loc.save();
            bploc.setC_BPartner_ID(bp);
            bploc.setC_Location_ID(loc.get_ID());
            bploc.setName("DireccionProveedor");
            bploc.save();
            direccion = bploc.get_ID();
        }
        ord.setC_BPartner_ID(bp);
        if (direccion > 0) {
            ord.setC_BPartner_Location_ID(direccion);
        }
        ord.set_CustomColumn("StatusCC", codigoestado);
        ord.save();
        JSONObject line = new JSONObject(jsonarr.getJSONObject(0).get("Items").toString());
        JSONArray jsonarrline = line.getJSONArray("Listado");
        BigDecimal PrecioNeto = Env.ZERO;
        String Producto = null;
        String EspProveedor = null;
        String CodProd = null;
        BigDecimal Cantidad = Env.ZERO;
        int prod = 0;
        int i = 0;
        while (i < jsonarrline.length()) {
            prod = 0;
            PrecioNeto = new BigDecimal(jsonarrline.getJSONObject(i).get("PrecioNeto").toString());
            Producto = jsonarrline.getJSONObject(i).get("Producto").toString();
            EspProveedor = jsonarrline.getJSONObject(i).get("EspecificacionProveedor").toString();
            CodProd = jsonarrline.getJSONObject(i).get("CodigoProducto").toString();
            Cantidad = new BigDecimal(jsonarrline.getJSONObject(i).get("Cantidad").toString());
            this.log.config("Precio neto " + PrecioNeto);
            this.log.config("Producto " + Producto);
            this.log.config("EspProveedor " + EspProveedor);
            MOrderLine omc = new MOrderLine(this.getCtx(), 0, this.get_TrxName());
            omc.setAD_Org_ID(2000006);
            omc.setDescription("Producto: ".concat(Producto.concat(" \n- ").concat(Descripcion)));
            omc.setQtyEntered(Cantidad);
            omc.setQtyOrdered(Cantidad);
            omc.setPriceEntered(PrecioNeto);
            omc.setPriceActual(PrecioNeto);
            sql = "SELECT coalesce(max(m_product_id),0) from m_product where value like '" + CodProd + "' and isactive='Y' AND " + " AD_Client_ID = " + Env.getAD_Client_ID(this.getCtx());
            prod = DB.getSQLValue(this.get_TrxName(), sql);
            if (prod > 0) {
                omc.setM_Product_ID(prod);
            } else {
                sql = "SELECT coalesce(max(m_product_id),0) from c_bpartner_product where vendorproductno like '" + CodProd + "'";
                prod = DB.getSQLValue(this.get_TrxName(), sql);
                if (prod > 0) {
                    omc.setM_Product_ID(prod);
                } else {
                    sql = "SELECT coalesce(max(m_product_id),0) from m_product where value like '%AUX%'";
                    prod = DB.getSQLValue(this.get_TrxName(), sql);
                    omc.setM_Product_ID(prod);
                }
            }
            omc.setC_BPartner_ID(bp);
            omc.setC_Order_ID(ord.get_ID());
            omc.set_CustomColumn("ProductValueMP", CodProd);
            omc.set_CustomColumn("ProductNameMP", Producto);
            omc.setC_UOM_ID(100);
            omc.setC_Tax_ID(2000003);
            omc.save();
            ++i;
        }
        ord.save();
        return " Orden generada ";
    }
}

