/*
 * Decompiled with CFR 0.152.
 */
package org.minsal.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProductPrice;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.ofb.utils.DateUtils;

public class GenerateAveragePrice
extends SvrProcess {
    private Timestamp p_DateTrx;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DateTrx")) {
                this.p_DateTrx = para[i].getParameterAsTimestamp();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        MPriceList pList = null;
        int cant = 0;
        int cantUp = 0;
        Timestamp startDate = new Timestamp(this.p_DateTrx.getTime());
        startDate.setMonth(this.p_DateTrx.getMonth() - 2);
        startDate.setDate(1);
        Timestamp endDate = DateUtils.today();
        int ID_PList = 0;
        ID_PList = DB.getSQLValue(this.get_TrxName(), "SELECT M_PriceList_ID FROM M_PriceList  WHERE IsActive = 'Y' AND NAME like '%Precios Promedios%'");
        if (ID_PList > 0) {
            pList = new MPriceList(this.getCtx(), ID_PList, this.get_TrxName());
        } else {
            pList = new MPriceList(this.getCtx(), 0, this.get_TrxName());
            pList.setAD_Org_ID(0);
            pList.setName("Precios Promedios");
            pList.setC_Currency_ID(228);
            pList.setPricePrecision(2);
            pList.saveEx(this.get_TrxName());
        }
        MPriceListVersion plVersion = null;
        int ID_PListversion = 0;
        ID_PListversion = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(M_PriceList_Version_ID) FROM M_PriceList_Version  WHERE IsActive = 'Y' AND NAME like '%Precios Promedio%'");
        if (ID_PListversion > 0) {
            plVersion = new MPriceListVersion(this.getCtx(), ID_PListversion, this.get_TrxName());
        } else {
            plVersion = new MPriceListVersion(pList);
            plVersion.setName("Precios Promedio " + this.p_DateTrx.toString());
            plVersion.setValidFrom(this.p_DateTrx);
            plVersion.setM_DiscountSchema_ID(DB.getSQLValue(this.get_TrxName(), "SELECT MAX(M_DiscountSchema_ID)  FROM M_DiscountSchema WHERE IsActive = 'Y'"));
            plVersion.saveEx(this.get_TrxName());
        }
        String sqlProd = "SELECT M_Product_ID FROM M_Product  WHERE IsActive = 'Y' AND IsPurchased = 'Y'";
        BigDecimal AmtPP = Env.ZERO;
        CPreparedStatement pstmt = DB.prepareStatement(sqlProd, this.get_TrxName());
        ResultSet rs = pstmt.executeQuery();
        int flag = 0;
        while (rs.next()) {
            MProductPrice pp;
            AmtPP = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(ol.PriceEntered*iol.QtyEntered)/SUM(iol.QtyEntered)  FROM M_InOutLine iol INNER JOIN M_InOut io ON (iol.M_InOut_ID = io.M_InOut_ID) INNER JOIN C_DocType dt ON (io.C_DocType_ID = dt.C_DocType_ID) INNER JOIN C_OrderLine ol ON (iol.C_OrderLine_ID = ol.C_OrderLine_ID) WHERE io.DocStatus IN ('CO','CL') AND io.IsSoTrx = 'N' AND dt.DocBaseType IN ('MMR') AND iol.QtyEntered > 0  AND iol.M_Product_ID= " + rs.getInt("M_Product_ID") + " AND movementdate BETWEEN ? AND ?", startDate, endDate);
            if (AmtPP == null) {
                AmtPP = Env.ZERO;
            }
            if ((flag = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM M_ProductPrice WHERE M_Product_ID=" + rs.getInt("M_Product_ID") + " AND IsActive='Y' AND M_PriceList_Version_ID=" + plVersion.get_ID())) > 0) {
                pp.setPrices(AmtPP, AmtPP, (pp = MProductPrice.get(this.getCtx(), plVersion.get_ID(), rs.getInt("M_Product_ID"), this.get_TrxName())).getPriceLimit() == null ? Env.ZERO : pp.getPriceLimit());
                pp.saveEx(this.get_TrxName());
                ++cantUp;
                continue;
            }
            pp = new MProductPrice(this.getCtx(), plVersion.get_ID(), rs.getInt("M_Product_ID"), this.get_TrxName());
            pp.setPrices(AmtPP, AmtPP, AmtPP);
            pp.saveEx(this.get_TrxName());
            ++cant;
        }
        return "Se han actualizado " + cantUp + " precios y se han generado " + cant + " precios ";
    }
}

