/*
 * Decompiled with CFR 0.152.
 */
package org.minsal.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MClient;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_M_Inventory;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModWarehouseRequest
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModWarehouseRequest.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("M_Requisition", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MRequisition req;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MRequisition.Table_ID && (req = (MRequisition)po).getC_DocType().getDocBaseType().equals("RRC")) {
            MRequisitionLine[] lines = req.getLines();
            X_M_Inventory inv = null;
            MWarehouse wh = MWarehouse.get(req.getCtx(), req.getM_Warehouse_ID(), req.get_TrxName());
            Object pstmt = null;
            Object rs = null;
            int i = 0;
            while (i < lines.length) {
                block42: {
                    MRequisitionLine line = lines[i];
                    if (line.getQty().compareTo(Env.ZERO) != 0 && line.getM_Product_ID() > 0) {
                        ResultSet rsDet;
                        CPreparedStatement pstmtDet;
                        BigDecimal cantLine;
                        BigDecimal canTPend;
                        String sqlLocator;
                        if (inv == null) {
                            inv = new MInventory(req.getCtx(), 0, req.get_TrxName());
                            inv.setAD_Org_ID(req.getAD_Org_ID());
                            inv.setM_Warehouse_ID(req.getM_Warehouse_ID());
                            inv.setC_DocType_ID(2000188);
                            inv.setDescription(req.getDescription());
                            inv.save();
                            try {
                                inv.set_CustomColumn("M_Requisition_ID", req.get_ID());
                                inv.save();
                            }
                            catch (Exception e) {
                                log.log(Level.SEVERE, "No se pudo asignar la variable M_Requisition_ID en M_Inventory", e);
                            }
                        }
                        if (req.get_ValueAsInt("M_Locator_ID") > 0) {
                            sqlLocator = " SELECT ms.qtyonhand,ms.m_attributesetinstance_ID\tFROM m_storage ms WHERE M_Product_ID=" + line.getM_Product_ID() + " AND M_Locator_ID=" + req.get_ValueAsInt("M_Locator_ID") + " AND qtyOnHand > 0" + " ORDER BY ms.qtyonhand ASC";
                            if (line.getM_Product().getM_AttributeSet().isGuaranteeDate()) {
                                sqlLocator = "SELECT ms.qtyonhand,ma.m_attributesetinstance_ID FROM m_storage ms INNER JOIN m_attributesetinstance ma  ON (ms.m_attributesetinstance_ID = ma.m_attributesetinstance_ID) WHERE M_Product_ID= " + line.getM_Product_ID() + " AND M_Locator_ID= " + req.get_ValueAsInt("M_Locator_ID") + " AND qtyOnHand > 0" + " AND guaranteedate > now() " + " ORDER BY guaranteedate ASC";
                            }
                            canTPend = line.getQty();
                            cantLine = Env.ZERO;
                            pstmtDet = DB.prepareStatement(sqlLocator, po.get_TrxName());
                            rsDet = null;
                            try {
                                try {
                                    rsDet = pstmtDet.executeQuery();
                                    while (rsDet.next() && canTPend.compareTo(Env.ZERO) > 0) {
                                        cantLine = Env.ZERO;
                                        cantLine = rsDet.getBigDecimal("qtyonhand").compareTo(canTPend) < 0 ? rsDet.getBigDecimal("qtyonhand") : canTPend;
                                        MInventoryLine il = new MInventoryLine(req.getCtx(), 0, req.get_TrxName());
                                        il.setM_Inventory_ID(inv.getM_Inventory_ID());
                                        il.setAD_Org_ID(line.getAD_Org_ID());
                                        il.setM_Product_ID(line.getM_Product_ID());
                                        il.setM_Locator_ID(req.get_ValueAsInt("M_Locator_ID"));
                                        il.setQtyInternalUse(cantLine);
                                        int ID_Charge = -1;
                                        try {
                                            ID_Charge = req.get_ValueAsInt("C_Charge_ID");
                                        }
                                        catch (Exception e) {
                                            log.log(Level.SEVERE, "No se pudo asignar la variable M_Inventory_ID en M_Requisition", e);
                                            ID_Charge = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(C_Charge_ID)  FROM C_Charge WHERE IsActive = 'Y' AND AD_Client_ID = " + Env.getAD_Client_ID(po.getCtx()));
                                        }
                                        if (ID_Charge <= 0) {
                                            ID_Charge = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(C_Charge_ID)  FROM C_Charge WHERE IsActive = 'Y' AND AD_Client_ID = " + Env.getAD_Client_ID(po.getCtx()));
                                        }
                                        if (ID_Charge > 0) {
                                            il.setC_Charge_ID(req.get_ValueAsInt("C_Charge_ID"));
                                        } else {
                                            il.setC_Charge_ID(2000000);
                                        }
                                        il.setDescription(line.getDescription());
                                        il.set_CustomColumn("M_RequisitionLine_ID", line.getM_RequisitionLine_ID());
                                        if (rsDet.getInt("M_Attributesetinstance_ID") > 0) {
                                            il.setM_AttributeSetInstance_ID(rsDet.getInt("M_Attributesetinstance_ID"));
                                        }
                                        il.set_CustomColumn("qtyTotal", line.getQty());
                                        il.save();
                                        canTPend = canTPend.subtract(cantLine);
                                    }
                                    rsDet.close();
                                    pstmtDet.close();
                                    break block42;
                                }
                                catch (SQLException e) {
                                    throw new DBException(e, sqlLocator);
                                }
                            }
                            finally {
                                DB.close(rsDet, pstmtDet);
                                rsDet = null;
                                pstmtDet = null;
                            }
                        }
                        sqlLocator = " SELECT ms.qtyonhand,ms.m_attributesetinstance_ID,ms.M_Locator_ID\tFROM m_storage ms INNER JOIN m_locator ml ON (ms.m_locator_id = ml.m_locator_id) WHERE M_Product_ID=" + line.getM_Product_ID() + " AND M_Warehouse_ID =" + req.getM_Warehouse_ID() + " AND qtyOnHand > 0" + " ORDER BY ms.qtyonhand ASC";
                        if (line.getM_Product().getM_AttributeSet().isGuaranteeDate()) {
                            sqlLocator = "SELECT ms.qtyonhand,ma.m_attributesetinstance_ID,ms.m_locator_id FROM m_storage ms INNER JOIN m_attributesetinstance ma  ON (ms.m_attributesetinstance_ID = ma.m_attributesetinstance_ID) INNER JOIN m_locator ml ON (ms.m_locator_id = ml.m_locator_id) WHERE M_Product_ID= " + line.getM_Product_ID() + " AND M_Warehouse_ID= " + req.getM_Warehouse_ID() + " AND qtyOnHand > 0" + " AND guaranteedate > now() " + " ORDER BY guaranteedate ASC";
                        }
                        canTPend = line.getQty();
                        cantLine = Env.ZERO;
                        pstmtDet = DB.prepareStatement(sqlLocator, po.get_TrxName());
                        rsDet = null;
                        int IDlastMLocator = 0;
                        try {
                            try {
                                rsDet = pstmtDet.executeQuery();
                                while (rsDet.next() && canTPend.compareTo(Env.ZERO) > 0) {
                                    cantLine = Env.ZERO;
                                    cantLine = rsDet.getBigDecimal("qtyonhand").compareTo(canTPend) < 0 ? rsDet.getBigDecimal("qtyonhand") : canTPend;
                                    MInventoryLine il = new MInventoryLine(req.getCtx(), 0, req.get_TrxName());
                                    il.setM_Inventory_ID(inv.getM_Inventory_ID());
                                    il.setAD_Org_ID(line.getAD_Org_ID());
                                    il.setM_Product_ID(line.getM_Product_ID());
                                    il.setM_Locator_ID(rsDet.getInt("M_Locator_ID"));
                                    il.setQtyInternalUse(cantLine);
                                    int ID_Charge = -1;
                                    try {
                                        ID_Charge = req.get_ValueAsInt("C_Charge_ID");
                                    }
                                    catch (Exception e) {
                                        log.log(Level.SEVERE, "No se pudo asignar la variable M_Inventory_ID en M_Requisition", e);
                                        ID_Charge = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(C_Charge_ID)  FROM C_Charge WHERE IsActive = 'Y' AND AD_Client_ID = " + Env.getAD_Client_ID(po.getCtx()));
                                    }
                                    if (ID_Charge <= 0) {
                                        ID_Charge = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(C_Charge_ID)  FROM C_Charge WHERE IsActive = 'Y' AND AD_Client_ID = " + Env.getAD_Client_ID(po.getCtx()));
                                    }
                                    if (ID_Charge > 0) {
                                        il.setC_Charge_ID(req.get_ValueAsInt("C_Charge_ID"));
                                    } else {
                                        il.setC_Charge_ID(2000000);
                                    }
                                    il.setDescription(line.getDescription());
                                    il.set_CustomColumn("M_RequisitionLine_ID", line.getM_RequisitionLine_ID());
                                    if (rsDet.getInt("M_AttributeSetInstance_ID") > 0) {
                                        il.setM_AttributeSetInstance_ID(rsDet.getInt("M_AttributeSetInstance_ID"));
                                    }
                                    il.set_CustomColumn("qtyTotal", line.getQty());
                                    il.save();
                                    canTPend = canTPend.subtract(cantLine);
                                    IDlastMLocator = rsDet.getInt("M_Locator_ID");
                                }
                                rsDet.close();
                                pstmtDet.close();
                                if (canTPend.compareTo(Env.ZERO) <= 0) break block42;
                                int attr_Old = DB.getSQLValue(po.get_TrxName(), "SELECT MIN(ms.m_attributesetinstance_ID)\tFROM m_storage ms INNER JOIN m_locator ml ON (ms.m_locator_id = ml.m_locator_id) WHERE M_Product_ID=" + line.getM_Product_ID() + " AND M_Warehouse_ID =" + req.getM_Warehouse_ID() + " AND m_attributesetinstance_ID > 0");
                                MInventoryLine il = new MInventoryLine(req.getCtx(), 0, req.get_TrxName());
                                il.setM_Inventory_ID(inv.getM_Inventory_ID());
                                il.setAD_Org_ID(line.getAD_Org_ID());
                                il.setM_Product_ID(line.getM_Product_ID());
                                log.config(" prod " + line.getM_Product_ID());
                                il.setM_Locator_ID(IDlastMLocator);
                                il.setQtyInternalUse(canTPend);
                                int ID_Charge = -1;
                                try {
                                    ID_Charge = req.get_ValueAsInt("C_Charge_ID");
                                }
                                catch (Exception e) {
                                    log.log(Level.SEVERE, "No se pudo asignar la variable M_Inventory_ID en M_Requisition", e);
                                    ID_Charge = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(C_Charge_ID)  FROM C_Charge WHERE IsActive = 'Y' AND AD_Client_ID = " + Env.getAD_Client_ID(po.getCtx()));
                                }
                                if (ID_Charge <= 0) {
                                    ID_Charge = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(C_Charge_ID)  FROM C_Charge WHERE IsActive = 'Y' AND AD_Client_ID = " + Env.getAD_Client_ID(po.getCtx()));
                                }
                                if (ID_Charge > 0) {
                                    il.setC_Charge_ID(req.get_ValueAsInt("C_Charge_ID"));
                                } else {
                                    il.setC_Charge_ID(2000000);
                                }
                                il.setDescription(line.getDescription());
                                il.set_CustomColumn("M_RequisitionLine_ID", line.getM_RequisitionLine_ID());
                                if (attr_Old > 0) {
                                    il.setM_AttributeSetInstance_ID(attr_Old);
                                }
                                il.set_CustomColumn("qtyTotal", line.getQty());
                                il.save();
                            }
                            catch (SQLException e) {
                                throw new DBException(e, sqlLocator);
                            }
                        }
                        finally {
                            DB.close(rsDet, pstmtDet);
                            rsDet = null;
                            pstmtDet = null;
                        }
                    }
                }
                ++i;
            }
            if (inv != null) {
                try {
                    req.set_CustomColumn("M_Inventory_ID", inv.getM_Inventory_ID());
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "No se pudo asignar la variable M_Inventory_ID en M_Requisition", e);
                }
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

