/*
 * Decompiled with CFR 0.152.
 */
package org.minsal.model;

import org.compiere.model.MClient;
import org.compiere.model.MInventory;
import org.compiere.model.MRequisition;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;

public class ModVoidInventory
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModVoidInventory.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("M_Inventory", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MRequisition req;
        MInventory inv;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if ((timing == 10 || timing == 13) && po.get_Table_ID() == MInventory.Table_ID && (inv = (MInventory)po).get_ValueAsInt("M_Requisition_ID") > 0 && (req = new MRequisition(po.getCtx(), inv.get_ValueAsInt("M_Requisition_ID"), po.get_TrxName())).getDocStatus().compareTo("VO") != 0) {
            req.processIt("VO");
            req.saveEx(po.get_TrxName());
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

