/*
 * Decompiled with CFR 0.152.
 */
package org.minsal.model;

import org.compiere.model.MClient;
import org.compiere.model.MInventory;
import org.compiere.model.MRequisition;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;

public class ModUpdateADUserReq
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModUpdateADUserReq.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("M_Requisition", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MRequisition req;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MRequisition.Table_ID && (req = (MRequisition)po).getC_DocType().getName().contains("Consumo")) {
            log.config("Inventory = " + req.get_Value("M_Inventory_ID").toString());
            MInventory inv = new MInventory(po.getCtx(), (Integer)req.get_Value("M_Inventory_ID"), po.get_TrxName());
            log.config("User_ID = " + req.getAD_User_ID());
            inv.set_ValueOfColumn("AD_User_ID", (Object)req.getAD_User_ID());
            inv.save();
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }
}

